/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import java.util.Objects;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.CorrelationSupport;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzer;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.SqlParser;

public class StatementAnalyzerFactory {
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;

    public StatementAnalyzerFactory(Metadata metadata, SqlParser sqlParser, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "plannerContext is null");
        this.sqlParser = sqlParser;
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public StatementAnalyzerFactory withSpecializedAccessControl(AccessControl accessControl) {
        return new StatementAnalyzerFactory(this.metadata, this.sqlParser, accessControl);
    }

    public StatementAnalyzer createStatementAnalyzer(Analysis analysis, MPPQueryContext context, SessionInfo session, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        return new StatementAnalyzer(this, analysis, context, this.accessControl, warningCollector, session, this.metadata, correlationSupport);
    }

    public static StatementAnalyzerFactory createTestingStatementAnalyzerFactory(Metadata metadata, AccessControl accessControl) {
        return new StatementAnalyzerFactory(metadata, new SqlParser(), accessControl);
    }
}

