/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.CorrelationSupport;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzer;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzerFactory;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Parameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeEnriched;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WrappedInsertStatement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.rewrite.StatementRewrite;

public class Analyzer {
    private final StatementAnalyzerFactory statementAnalyzerFactory;
    private final MPPQueryContext context;
    private final SessionInfo session;
    private final List<Expression> parameters;
    private final Map<NodeRef<Parameter>, Expression> parameterLookup;
    private final StatementRewrite statementRewrite;
    private final WarningCollector warningCollector;

    public Analyzer(MPPQueryContext context, SessionInfo session, StatementAnalyzerFactory statementAnalyzerFactory, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, StatementRewrite statementRewrite, WarningCollector warningCollector) {
        this.context = context;
        this.session = Objects.requireNonNull(session, "session is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.parameters = parameters;
        this.parameterLookup = parameterLookup;
        this.statementRewrite = statementRewrite;
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Analysis analyze(Statement statement) {
        Statement innerStatement;
        Statement rewrittenStatement = this.statementRewrite.rewrite(this.statementAnalyzerFactory, this.session, statement, this.parameters, this.parameterLookup, this.warningCollector);
        Analysis analysis = new Analysis(rewrittenStatement, this.parameterLookup);
        Statement statement2 = innerStatement = rewrittenStatement instanceof PipeEnriched ? ((PipeEnriched)rewrittenStatement).getInnerStatement() : rewrittenStatement;
        if (innerStatement instanceof WrappedInsertStatement) {
            WrappedInsertStatement insertStatement = (WrappedInsertStatement)innerStatement;
            if (insertStatement.getDatabase() != null) {
                analysis.setDatabaseName(insertStatement.getDatabase());
            } else {
                if (!this.session.getDatabaseName().isPresent()) throw new SemanticException("database is not specified for insert:" + statement);
                analysis.setDatabaseName(this.session.getDatabaseName().get());
            }
        } else if (this.session.getDatabaseName().isPresent()) {
            analysis.setDatabaseName(this.session.getDatabaseName().get());
        }
        long startTime = System.nanoTime();
        StatementAnalyzer analyzer = this.statementAnalyzerFactory.createStatementAnalyzer(analysis, this.context, this.session, this.warningCollector, CorrelationSupport.ALLOWED);
        analyzer.analyze(rewrittenStatement);
        if (!analysis.isQuery()) return analysis;
        long analyzeCost = System.nanoTime() - startTime;
        QueryPlanCostMetricSet.getInstance().recordPlanCost("table", "analyzer", analyzeCost);
        this.context.setAnalyzeCost(analyzeCost);
        return analysis;
    }
}

