/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.commons.udf.UDFType;
import org.apache.iotdb.commons.udf.builtin.BuiltinAggregationFunction;
import org.apache.iotdb.commons.udf.builtin.BuiltinScalarFunction;
import org.apache.iotdb.commons.udf.builtin.BuiltinTimeSeriesGeneratingFunction;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinAggregationFunction;
import org.apache.iotdb.commons.udf.builtin.relational.TableBuiltinScalarFunction;
import org.apache.iotdb.commons.udf.utils.TableUDFUtils;
import org.apache.iotdb.commons.udf.utils.TreeUDFUtils;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;

public class ShowFunctionsTask
implements IConfigTask {
    private static final Map<String, Binary> BINARY_MAP = new HashMap<String, Binary>();
    private final Model model;

    public ShowFunctionsTask(Model model) {
        this.model = model;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) {
        return configTaskExecutor.showFunctions(this.model);
    }

    public static void buildTsBlock(Model model, List<ByteBuffer> allUDFInformation, SettableFuture<ConfigTaskResult> future) {
        if (Model.TREE.equals((Object)model)) {
            ShowFunctionsTask.buildTreeModelTsBlock(allUDFInformation, future);
        } else {
            ShowFunctionsTask.buildTableModelTsBlock(allUDFInformation, future);
        }
    }

    private static void buildTableModelTsBlock(List<ByteBuffer> allUDFInformation, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showFunctionsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        ArrayList<UDFInformation> udfInformations = new ArrayList<UDFInformation>();
        if (allUDFInformation != null && !allUDFInformation.isEmpty()) {
            for (ByteBuffer udfInformationByteBuffer : allUDFInformation) {
                UDFInformation udfInformation = UDFInformation.deserialize((ByteBuffer)udfInformationByteBuffer);
                udfInformations.add(udfInformation);
            }
        }
        udfInformations.sort(Comparator.comparing(UDFInformation::getFunctionName));
        for (UDFInformation udfInformation : udfInformations) {
            ShowFunctionsTask.appendUDFInformation(builder, udfInformation);
        }
        ShowFunctionsTask.appendFunctions(builder, TableBuiltinScalarFunction.getBuiltInScalarFunctionName(), BINARY_MAP.get("built-in scalar function"), BINARY_MAP.get("AVAILABLE"));
        ShowFunctionsTask.appendFunctions(builder, TableBuiltinAggregationFunction.getBuiltInAggregateFunctionName(), BINARY_MAP.get("built-in aggregate function"), BINARY_MAP.get("AVAILABLE"));
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowFunctionsHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    private static void buildTreeModelTsBlock(List<ByteBuffer> allUDFInformation, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showFunctionsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        ArrayList<UDFInformation> udfInformations = new ArrayList<UDFInformation>();
        if (allUDFInformation != null && !allUDFInformation.isEmpty()) {
            for (ByteBuffer udfInformationByteBuffer : allUDFInformation) {
                UDFInformation udfInformation = UDFInformation.deserialize((ByteBuffer)udfInformationByteBuffer);
                udfInformations.add(udfInformation);
            }
        }
        udfInformations.sort(Comparator.comparing(UDFInformation::getFunctionName));
        ShowFunctionsTask.appendBuiltInTimeSeriesGeneratingFunctions(builder);
        for (UDFInformation udfInformation : udfInformations) {
            ShowFunctionsTask.appendUDFInformation(builder, udfInformation);
        }
        ShowFunctionsTask.appendBuiltInAggregationFunctions(builder);
        ShowFunctionsTask.appendBuiltInScalarFunctions(builder);
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowFunctionsHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    private static void appendUDFInformation(TsBlockBuilder builder, UDFInformation udfInformation) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)udfInformation.getFunctionName()));
        builder.getColumnBuilder(1).writeBinary(ShowFunctionsTask.getFunctionType(udfInformation));
        builder.getColumnBuilder(2).writeBinary(BytesUtils.valueOf((String)udfInformation.getClassName()));
        builder.getColumnBuilder(3).writeBinary(ShowFunctionsTask.getFunctionState(udfInformation));
        builder.declarePosition();
    }

    private static void appendFunctions(TsBlockBuilder builder, Collection<String> functionNames, Binary functionType, Binary functionState) {
        Binary className = BINARY_MAP.get("");
        for (String functionName : functionNames) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)functionName.toUpperCase()));
            builder.getColumnBuilder(1).writeBinary(functionType);
            builder.getColumnBuilder(2).writeBinary(className);
            builder.getColumnBuilder(3).writeBinary(functionState);
            builder.declarePosition();
        }
    }

    private static void appendBuiltInTimeSeriesGeneratingFunctions(TsBlockBuilder builder) {
        Binary functionType = BINARY_MAP.get("built-in UDTF");
        Binary functionState = BINARY_MAP.get("AVAILABLE");
        for (BuiltinTimeSeriesGeneratingFunction function : BuiltinTimeSeriesGeneratingFunction.values()) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)function.getFunctionName().toUpperCase()));
            builder.getColumnBuilder(1).writeBinary(functionType);
            builder.getColumnBuilder(2).writeBinary(BytesUtils.valueOf((String)function.getClassName()));
            builder.getColumnBuilder(3).writeBinary(functionState);
            builder.declarePosition();
        }
    }

    private static void appendBuiltInAggregationFunctions(TsBlockBuilder builder) {
        Binary functionType = BINARY_MAP.get("native");
        Binary functionState = BINARY_MAP.get("AVAILABLE");
        Binary className = BINARY_MAP.get("");
        for (String functionName : BuiltinAggregationFunction.getNativeFunctionNames()) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)functionName.toUpperCase()));
            builder.getColumnBuilder(1).writeBinary(functionType);
            builder.getColumnBuilder(2).writeBinary(className);
            builder.getColumnBuilder(3).writeBinary(functionState);
            builder.declarePosition();
        }
    }

    private static void appendBuiltInScalarFunctions(TsBlockBuilder builder) {
        Binary functionType = BINARY_MAP.get("built-in scalar");
        Binary functionState = BINARY_MAP.get("AVAILABLE");
        Binary className = BINARY_MAP.get("");
        for (String functionName : BuiltinScalarFunction.getNativeFunctionNames()) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)functionName.toUpperCase()));
            builder.getColumnBuilder(1).writeBinary(functionType);
            builder.getColumnBuilder(2).writeBinary(className);
            builder.getColumnBuilder(3).writeBinary(functionState);
            builder.declarePosition();
        }
    }

    private static Binary getFunctionType(UDFInformation udfInformation) {
        UDFType type = udfInformation.getUdfType();
        if (udfInformation.isAvailable()) {
            if (type.isTreeModel()) {
                if (TreeUDFUtils.isUDTF((String)udfInformation.getFunctionName())) {
                    return BINARY_MAP.get("external UDTF");
                }
                if (TreeUDFUtils.isUDAF((String)udfInformation.getFunctionName())) {
                    return BINARY_MAP.get("external UDAF");
                }
            } else {
                if (TableUDFUtils.isScalarFunction((String)udfInformation.getFunctionName())) {
                    return BINARY_MAP.get("user-defined scalar function");
                }
                if (TableUDFUtils.isAggregateFunction((String)udfInformation.getFunctionName())) {
                    return BINARY_MAP.get("user-defined aggregate function");
                }
                if (TableUDFUtils.isTableFunction((String)udfInformation.getFunctionName())) {
                    return BINARY_MAP.get("user-defined table function");
                }
            }
        }
        return BINARY_MAP.get("UNKNOWN");
    }

    private static Binary getFunctionState(UDFInformation udfInformation) {
        if (udfInformation.isAvailable()) {
            return BINARY_MAP.get("AVAILABLE");
        }
        return BINARY_MAP.get("UNAVAILABLE");
    }

    static {
        BINARY_MAP.put("native", BytesUtils.valueOf((String)"native"));
        BINARY_MAP.put("built-in UDTF", BytesUtils.valueOf((String)"built-in UDTF"));
        BINARY_MAP.put("external UDTF", BytesUtils.valueOf((String)"external UDTF"));
        BINARY_MAP.put("external UDAF", BytesUtils.valueOf((String)"external UDAF"));
        BINARY_MAP.put("built-in scalar", BytesUtils.valueOf((String)"built-in scalar"));
        BINARY_MAP.put("built-in scalar function", BytesUtils.valueOf((String)"built-in scalar function"));
        BINARY_MAP.put("built-in aggregate function", BytesUtils.valueOf((String)"built-in aggregate function"));
        BINARY_MAP.put("built-in table function", BytesUtils.valueOf((String)"built-in table function"));
        BINARY_MAP.put("user-defined scalar function", BytesUtils.valueOf((String)"user-defined scalar function"));
        BINARY_MAP.put("user-defined aggregate function", BytesUtils.valueOf((String)"user-defined aggregate function"));
        BINARY_MAP.put("user-defined table function", BytesUtils.valueOf((String)"user-defined table function"));
        BINARY_MAP.put("UNKNOWN", BytesUtils.valueOf((String)"UNKNOWN"));
        BINARY_MAP.put("AVAILABLE", BytesUtils.valueOf((String)"AVAILABLE"));
        BINARY_MAP.put("UNAVAILABLE", BytesUtils.valueOf((String)"UNAVAILABLE"));
        BINARY_MAP.put("", BytesUtils.valueOf((String)""));
    }
}

