/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.load;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.exception.load.LoadAnalyzeException;
import org.apache.iotdb.db.exception.load.LoadEmptyFileException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.analyze.load.LoadTsFileAnalyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.load.LoadTsFileTableSchemaCache;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.TableConfigTaskVisitor;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateDBTask;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.utils.TsFileResourceUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.EncryptUtils;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.read.TsFileSequenceReaderTimeseriesMetadataIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileToTableModelAnalyzer
extends LoadTsFileAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileToTableModelAnalyzer.class);
    private final Metadata metadata;
    private final LoadTsFileTableSchemaCache schemaCache;

    public LoadTsFileToTableModelAnalyzer(LoadTsFileStatement loadTsFileStatement, boolean isGeneratedByPipe, Metadata metadata, MPPQueryContext context) {
        super(loadTsFileStatement, isGeneratedByPipe, context);
        this.metadata = metadata;
        this.schemaCache = new LoadTsFileTableSchemaCache(metadata, context);
    }

    public LoadTsFileToTableModelAnalyzer(LoadTsFile loadTsFileTableStatement, boolean isGeneratedByPipe, Metadata metadata, MPPQueryContext context) {
        super(loadTsFileTableStatement, isGeneratedByPipe, context);
        this.metadata = metadata;
        this.schemaCache = new LoadTsFileTableSchemaCache(metadata, context);
    }

    @Override
    public IAnalysis analyzeFileByFile(IAnalysis analysis) {
        this.checkBeforeAnalyzeFileByFile(analysis);
        if (analysis.isFinishQueryAfterAnalyze()) {
            return analysis;
        }
        try {
            this.autoCreateDatabaseIfAbsent(this.database);
        }
        catch (LoadAnalyzeException e) {
            LOGGER.warn("Auto create database failed: {}", (Object)this.database, (Object)e);
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.LOAD_FILE_ERROR, (String)e.getMessage()));
            return analysis;
        }
        if (!this.doAnalyzeFileByFile(analysis)) {
            return analysis;
        }
        LOGGER.info("Load - Analysis Stage: all tsfiles have been analyzed.");
        this.setRealStatement(analysis);
        return analysis;
    }

    @Override
    protected void analyzeSingleTsFile(File tsFile) throws IOException, LoadAnalyzeException {
        block14: {
            try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFile.getAbsolutePath());){
                TsFileSequenceReaderTimeseriesMetadataIterator timeseriesMetadataIterator = new TsFileSequenceReaderTimeseriesMetadataIterator(reader, true, 1);
                Map tableSchemaMap = reader.getTableSchemaMap();
                if (!timeseriesMetadataIterator.hasNext()) {
                    throw new LoadEmptyFileException(tsFile.getAbsolutePath());
                }
                if (Objects.isNull(tableSchemaMap) || tableSchemaMap.isEmpty()) {
                    throw new SemanticException("Attempted to load a tree-model TsFile into table-model.");
                }
                EncryptParameter param = reader.getEncryptParam();
                if (!Objects.equals(param.getType(), EncryptUtils.encryptParam.getType()) || !Arrays.equals(param.getKey(), EncryptUtils.encryptParam.getKey())) {
                    throw new SemanticException("The encryption way of the TsFile is not supported.");
                }
                TsFileResource tsFileResource = this.constructTsFileResource(reader, tsFile);
                this.schemaCache.setDatabase(this.database);
                this.schemaCache.setCurrentModificationsAndTimeIndex(tsFileResource, reader);
                for (Map.Entry name2Schema : tableSchemaMap.entrySet()) {
                    org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema fileSchema = org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema.fromTsFileTableSchema((String)name2Schema.getKey(), (TableSchema)name2Schema.getValue());
                    this.schemaCache.createTable(fileSchema, this.context, this.metadata);
                }
                long writePointCount = 0L;
                while (timeseriesMetadataIterator.hasNext()) {
                    Map device2TimeseriesMetadata = timeseriesMetadataIterator.next();
                    for (IDeviceID deviceId : device2TimeseriesMetadata.keySet()) {
                        this.schemaCache.autoCreateAndVerify(deviceId);
                    }
                    if (!tsFileResource.resourceFileExists()) {
                        TsFileResourceUtils.updateTsFileResource(device2TimeseriesMetadata, tsFileResource);
                    }
                    writePointCount += this.getWritePointCount(device2TimeseriesMetadata);
                }
                TimestampPrecisionUtils.checkTimestampPrecision(tsFileResource.getFileEndTime());
                tsFileResource.setStatus(TsFileResourceStatus.NORMAL);
                this.addTsFileResource(tsFileResource);
                this.addWritePointCount(writePointCount);
                this.schemaCache.flush();
                this.schemaCache.clearIdColumnMapper();
            }
            catch (LoadEmptyFileException loadEmptyFileException) {
                LOGGER.warn("Failed to load empty file: {}", (Object)tsFile.getAbsolutePath());
                if (!this.isDeleteAfterLoad) break block14;
                FileUtils.deleteQuietly((File)tsFile);
            }
        }
    }

    private void autoCreateDatabaseIfAbsent(String database) throws LoadAnalyzeException {
        TableConfigTaskVisitor.validateDatabaseName(database);
        if (DataNodeTableCache.getInstance().isDatabaseExist(database)) {
            return;
        }
        CreateDBTask task = new CreateDBTask(new TDatabaseSchema(database).setIsTableModel(true), true);
        try {
            ListenableFuture<ConfigTaskResult> future = task.execute(ClusterConfigTaskExecutor.getInstance());
            ConfigTaskResult result = (ConfigTaskResult)future.get();
            if (result.getStatusCode().getStatusCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new LoadAnalyzeException(String.format("Auto create database failed: %s, status code: %s", database, result.getStatusCode()));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new LoadAnalyzeException("Auto create database failed because: " + e.getMessage());
        }
    }

    @Override
    public void close() throws Exception {
        this.schemaCache.close();
    }
}

