/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Delete;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TimeRange;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.schemaengine.table.InformationSchemaUtils;
import org.apache.iotdb.db.storageengine.dataregion.modification.DeletionPredicate;
import org.apache.iotdb.db.storageengine.dataregion.modification.IDPredicate;
import org.apache.iotdb.db.storageengine.dataregion.modification.TableDeletionEntry;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeUtils {
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzeUtils.class);

    private AnalyzeUtils() {
    }

    public static InsertBaseStatement analyzeInsert(MPPQueryContext context, InsertBaseStatement insertBaseStatement, Runnable schemaValidation, DataPartitionQueryFunc partitionFetcher, DataPartitionQueryParamComputation partitionQueryParamComputation, IAnalysis analysis, boolean removeLogicalView) {
        InsertBaseStatement realStatement;
        context.setQueryType(QueryType.WRITE);
        insertBaseStatement.semanticCheck();
        AnalyzeUtils.validateSchema(analysis, insertBaseStatement, schemaValidation);
        InsertBaseStatement insertBaseStatement2 = realStatement = removeLogicalView ? AnalyzeUtils.removeLogicalView(analysis, insertBaseStatement) : insertBaseStatement;
        if (analysis.isFinishQueryAfterAnalyze()) {
            return realStatement;
        }
        analysis.setRealStatement(realStatement);
        AnalyzeUtils.analyzeDataPartition(analysis, partitionQueryParamComputation.compute(realStatement, context), context.getSession().getUserName(), partitionFetcher);
        return realStatement;
    }

    public static String getDatabaseName(InsertBaseStatement statement, MPPQueryContext context) {
        if (statement.getDatabaseName().isPresent()) {
            return statement.getDatabaseName().get();
        }
        if (context != null && context.getDatabaseName().isPresent()) {
            return context.getDatabaseName().get();
        }
        return null;
    }

    public static List<DataPartitionQueryParam> computeTableDataPartitionParams(InsertBaseStatement statement, MPPQueryContext context) {
        if (statement instanceof InsertTabletStatement) {
            InsertTabletStatement insertTabletStatement = (InsertTabletStatement)statement;
            HashMap<IDeviceID, Set<TTimePartitionSlot>> timePartitionSlotMap = new HashMap<IDeviceID, Set<TTimePartitionSlot>>();
            for (int i = 0; i < insertTabletStatement.getRowCount(); ++i) {
                timePartitionSlotMap.computeIfAbsent(insertTabletStatement.getTableDeviceID(i), id -> new HashSet()).add(insertTabletStatement.getTimePartitionSlot(i));
            }
            return AnalyzeUtils.computeDataPartitionParams(timePartitionSlotMap, AnalyzeUtils.getDatabaseName(statement, context));
        }
        if (statement instanceof InsertMultiTabletsStatement) {
            InsertMultiTabletsStatement insertMultiTabletsStatement = (InsertMultiTabletsStatement)statement;
            HashMap<IDeviceID, Set<TTimePartitionSlot>> timePartitionSlotMap = new HashMap<IDeviceID, Set<TTimePartitionSlot>>();
            for (InsertTabletStatement insertTabletStatement : insertMultiTabletsStatement.getInsertTabletStatementList()) {
                for (int i = 0; i < insertTabletStatement.getRowCount(); ++i) {
                    timePartitionSlotMap.computeIfAbsent(insertTabletStatement.getTableDeviceID(i), id -> new HashSet()).add(insertTabletStatement.getTimePartitionSlot(i));
                }
            }
            return AnalyzeUtils.computeDataPartitionParams(timePartitionSlotMap, AnalyzeUtils.getDatabaseName(statement, context));
        }
        if (statement instanceof InsertRowStatement) {
            InsertRowStatement insertRowStatement = (InsertRowStatement)statement;
            return AnalyzeUtils.computeDataPartitionParams(Collections.singletonMap(insertRowStatement.getTableDeviceID(), Collections.singleton(insertRowStatement.getTimePartitionSlot())), AnalyzeUtils.getDatabaseName(statement, context));
        }
        if (statement instanceof InsertRowsStatement) {
            InsertRowsStatement insertRowsStatement = (InsertRowsStatement)statement;
            HashMap<IDeviceID, Set<TTimePartitionSlot>> timePartitionSlotMap = new HashMap<IDeviceID, Set<TTimePartitionSlot>>();
            for (InsertRowStatement insertRowStatement : insertRowsStatement.getInsertRowStatementList()) {
                timePartitionSlotMap.computeIfAbsent(insertRowStatement.getTableDeviceID(), id -> new HashSet()).add(insertRowStatement.getTimePartitionSlot());
            }
            return AnalyzeUtils.computeDataPartitionParams(timePartitionSlotMap, AnalyzeUtils.getDatabaseName(statement, context));
        }
        throw new UnsupportedOperationException("computeDataPartitionParams for " + statement);
    }

    public static List<DataPartitionQueryParam> computeTreeDataPartitionParams(InsertBaseStatement statement, MPPQueryContext context) {
        if (statement instanceof InsertTabletStatement) {
            DataPartitionQueryParam dataPartitionQueryParam = AnalyzeUtils.getTreeDataPartitionQueryParam((InsertTabletStatement)statement, context);
            return Collections.singletonList(dataPartitionQueryParam);
        }
        if (statement instanceof InsertMultiTabletsStatement) {
            InsertMultiTabletsStatement insertMultiTabletsStatement = (InsertMultiTabletsStatement)statement;
            HashMap<IDeviceID, Set<TTimePartitionSlot>> dataPartitionQueryParamMap = new HashMap<IDeviceID, Set<TTimePartitionSlot>>();
            for (InsertTabletStatement insertTabletStatement : insertMultiTabletsStatement.getInsertTabletStatementList()) {
                Set timePartitionSlotSet = dataPartitionQueryParamMap.computeIfAbsent(insertTabletStatement.getDevicePath().getIDeviceIDAsFullDevice(), k -> new HashSet());
                timePartitionSlotSet.addAll(insertTabletStatement.getTimePartitionSlots());
            }
            return AnalyzeUtils.computeDataPartitionParams(dataPartitionQueryParamMap, AnalyzeUtils.getDatabaseName(statement, context));
        }
        if (statement instanceof InsertRowsStatement) {
            InsertRowsStatement insertRowsStatement = (InsertRowsStatement)statement;
            HashMap<IDeviceID, Set<TTimePartitionSlot>> dataPartitionQueryParamMap = new HashMap<IDeviceID, Set<TTimePartitionSlot>>();
            for (InsertRowStatement insertRowStatement : insertRowsStatement.getInsertRowStatementList()) {
                Set timePartitionSlotSet = dataPartitionQueryParamMap.computeIfAbsent(insertRowStatement.getDevicePath().getIDeviceIDAsFullDevice(), k -> new HashSet());
                timePartitionSlotSet.add(insertRowStatement.getTimePartitionSlot());
            }
            return AnalyzeUtils.computeDataPartitionParams(dataPartitionQueryParamMap, AnalyzeUtils.getDatabaseName(statement, context));
        }
        throw new UnsupportedOperationException("computeDataPartitionParams for " + statement);
    }

    private static DataPartitionQueryParam getTreeDataPartitionQueryParam(InsertTabletStatement statement, MPPQueryContext context) {
        DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
        dataPartitionQueryParam.setDeviceID(statement.getDevicePath().getIDeviceIDAsFullDevice());
        dataPartitionQueryParam.setTimePartitionSlotList(statement.getTimePartitionSlots());
        dataPartitionQueryParam.setDatabaseName(AnalyzeUtils.getDatabaseName(statement, context));
        return dataPartitionQueryParam;
    }

    public static List<DataPartitionQueryParam> computeDataPartitionParams(Map<IDeviceID, Set<TTimePartitionSlot>> dataPartitionQueryParamMap, String databaseName) {
        ArrayList<DataPartitionQueryParam> dataPartitionQueryParams = new ArrayList<DataPartitionQueryParam>();
        for (Map.Entry<IDeviceID, Set<TTimePartitionSlot>> entry : dataPartitionQueryParamMap.entrySet()) {
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDeviceID(entry.getKey());
            dataPartitionQueryParam.setTimePartitionSlotList(new ArrayList(entry.getValue()));
            dataPartitionQueryParam.setDatabaseName(databaseName);
            dataPartitionQueryParams.add(dataPartitionQueryParam);
        }
        return dataPartitionQueryParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateSchema(IAnalysis analysis, InsertBaseStatement insertStatement, Runnable schemaValidation) {
        long startTime = System.nanoTime();
        try {
            schemaValidation.run();
        }
        catch (SemanticException e) {
            analysis.setFinishQueryAfterAnalyze(true);
            if (e.getCause() instanceof IoTDBException) {
                IoTDBException exception = (IoTDBException)e.getCause();
                analysis.setFailStatus(RpcUtils.getStatus((int)exception.getErrorCode(), (String)exception.getMessage()));
            } else if (e.getErrorCode() != TSStatusCode.SEMANTIC_ERROR.getStatusCode()) {
                analysis.setFailStatus(RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            } else {
                analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.METADATA_ERROR.getStatusCode(), (String)e.getMessage()));
            }
        }
        finally {
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleSchemaValidateCost(System.nanoTime() - startTime);
        }
        boolean hasFailedMeasurement = insertStatement.hasFailedMeasurements();
        if (hasFailedMeasurement) {
            String partialInsertMessage = String.format("Fail to insert measurements %s caused by %s", insertStatement.getFailedMeasurements(), insertStatement.getFailedMessages());
            LOGGER.warn(partialInsertMessage);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.METADATA_ERROR.getStatusCode(), (String)partialInsertMessage));
        }
    }

    public static InsertBaseStatement removeLogicalView(IAnalysis analysis, InsertBaseStatement insertBaseStatement) {
        try {
            return insertBaseStatement.removeLogicalView();
        }
        catch (SemanticException e) {
            analysis.setFinishQueryAfterAnalyze(true);
            if (e.getCause() instanceof IoTDBException) {
                IoTDBException exception = (IoTDBException)e.getCause();
                analysis.setFailStatus(RpcUtils.getStatus((int)exception.getErrorCode(), (String)exception.getMessage()));
            } else {
                analysis.setFailStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)e.getMessage()));
            }
            return insertBaseStatement;
        }
    }

    public static void analyzeDataPartition(IAnalysis analysis, List<DataPartitionQueryParam> dataPartitionQueryParams, String userName, DataPartitionQueryFunc partitionQueryFunc) {
        DataPartition dataPartition = partitionQueryFunc.queryDataPartition(dataPartitionQueryParams, userName);
        if (dataPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            analysis.setFailStatus(RpcUtils.getStatus((int)TSStatusCode.DATABASE_NOT_EXIST.getStatusCode(), (String)"Database not exists and failed to create automatically because enable_auto_create_schema is FALSE."));
        }
        analysis.setDataPartitionInfo(dataPartition);
    }

    public static void analyzeDelete(Delete node, MPPQueryContext queryContext) {
        queryContext.setQueryType(QueryType.WRITE);
        AnalyzeUtils.validateSchema(node, queryContext);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TRegionRouteMapResp latestRegionRouteMap = configNodeClient.getLatestRegionRouteMap();
            HashSet<TRegionReplicaSet> replicaSets = new HashSet<TRegionReplicaSet>();
            latestRegionRouteMap.getRegionRouteMap().entrySet().stream().filter(e -> ((TConsensusGroupId)e.getKey()).getType() == TConsensusGroupType.DataRegion).forEach(e -> replicaSets.add((TRegionReplicaSet)e.getValue()));
            node.setReplicaSets(replicaSets);
        }
        catch (Exception e2) {
            throw new IoTDBRuntimeException((Throwable)e2, TSStatusCode.CAN_NOT_CONNECT_CONFIGNODE.getStatusCode());
        }
    }

    private static void validateSchema(Delete node, MPPQueryContext queryContext) {
        String databaseName;
        String tableName = node.getTable().getName().getSuffix();
        if (node.getTable().getName().getPrefix().isPresent()) {
            databaseName = node.getTable().getName().getPrefix().get().toString();
        } else if (queryContext.getDatabaseName().isPresent()) {
            databaseName = queryContext.getDatabaseName().get();
        } else {
            throw new SemanticException("database is not specified");
        }
        InformationSchemaUtils.checkDBNameInWrite(databaseName);
        node.setDatabaseName(databaseName);
        TsTable table = DataNodeTableCache.getInstance().getTable(databaseName, tableName);
        if (table == null) {
            throw new SemanticException("Table " + tableName + " not found");
        }
        node.setTableDeletionEntries(AnalyzeUtils.parseExpressions2ModEntries(node.getWhere().orElse(null), table));
    }

    public static List<TableDeletionEntry> parseExpressions2ModEntries(Expression expression, TsTable table) {
        return AnalyzeUtils.toDisjunctiveNormalForms(expression).stream().map(disjunctiveNormalForm -> AnalyzeUtils.parsePredicate(disjunctiveNormalForm, table)).collect(Collectors.toList());
    }

    public static List<Expression> toDisjunctiveNormalForms(Expression expression) {
        if (!(expression instanceof LogicalExpression)) {
            return Collections.singletonList(expression);
        }
        LogicalExpression logicalExpression = (LogicalExpression)expression;
        if (logicalExpression.getOperator() == LogicalExpression.Operator.AND) {
            List<Expression> results = null;
            for (Expression term : logicalExpression.getTerms()) {
                if (results == null) {
                    results = AnalyzeUtils.toDisjunctiveNormalForms(term);
                    continue;
                }
                results = AnalyzeUtils.crossProductOfDisjunctiveNormalForms(results, AnalyzeUtils.toDisjunctiveNormalForms(term), LogicalExpression.Operator.AND);
            }
            return results;
        }
        if (logicalExpression.getOperator() == LogicalExpression.Operator.OR) {
            ArrayList<Expression> results = new ArrayList<Expression>();
            for (Expression term : logicalExpression.getTerms()) {
                results.addAll(AnalyzeUtils.toDisjunctiveNormalForms(term));
            }
            return results;
        }
        throw new SemanticException("Unsupported operator: " + (Object)((Object)logicalExpression.getOperator()));
    }

    private static List<Expression> crossProductOfDisjunctiveNormalForms(List<Expression> leftList, List<Expression> rightList, LogicalExpression.Operator operator) {
        ArrayList<Expression> results = new ArrayList<Expression>();
        for (Expression leftExp : leftList) {
            for (Expression rightExp : rightList) {
                ArrayList<Expression> terms = new ArrayList<Expression>();
                if (leftExp instanceof LogicalExpression) {
                    terms.addAll(((LogicalExpression)leftExp).getTerms());
                } else {
                    terms.add(leftExp);
                }
                if (rightExp instanceof LogicalExpression) {
                    terms.addAll(((LogicalExpression)rightExp).getTerms());
                } else {
                    terms.add(rightExp);
                }
                results.add(new LogicalExpression(operator, terms));
            }
        }
        return results;
    }

    private static TableDeletionEntry parsePredicate(Expression expression, TsTable table) {
        if (expression == null) {
            return new TableDeletionEntry(new DeletionPredicate(table.getTableName()), new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE, true).toTsFileTimeRange());
        }
        LinkedList<Expression> expressionQueue = new LinkedList<Expression>();
        expressionQueue.add(expression);
        DeletionPredicate predicate = new DeletionPredicate(table.getTableName());
        IDPredicate idPredicate = null;
        TimeRange timeRange = new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE, true);
        while (!expressionQueue.isEmpty()) {
            Expression currExp = (Expression)expressionQueue.remove();
            if (currExp instanceof LogicalExpression) {
                AnalyzeUtils.parseAndPredicate((LogicalExpression)currExp, expressionQueue);
                continue;
            }
            if (currExp instanceof ComparisonExpression) {
                idPredicate = AnalyzeUtils.parseComparison((ComparisonExpression)currExp, timeRange, idPredicate, table);
                continue;
            }
            if (currExp instanceof IsNullPredicate) {
                idPredicate = AnalyzeUtils.parseIsNull((IsNullPredicate)currExp, idPredicate, table);
                continue;
            }
            throw new SemanticException("Unsupported expression: " + currExp + " in " + expression);
        }
        if (idPredicate != null) {
            predicate.setIdPredicate(idPredicate);
        }
        if (timeRange.getStartTime() > timeRange.getEndTime()) {
            throw new SemanticException(String.format("Start time %d is greater than end time %d", timeRange.getStartTime(), timeRange.getEndTime()));
        }
        return new TableDeletionEntry(predicate, timeRange.toTsFileTimeRange());
    }

    private static void parseAndPredicate(LogicalExpression expression, Queue<Expression> expressionQueue) {
        if (expression.getOperator() != LogicalExpression.Operator.AND) {
            throw new SemanticException("Only support AND operator in deletion");
        }
        expressionQueue.addAll(expression.getTerms());
    }

    private static IDPredicate parseIsNull(IsNullPredicate isNullPredicate, IDPredicate oldPredicate, TsTable table) {
        Expression leftHandExp = isNullPredicate.getValue();
        if (!(leftHandExp instanceof Identifier)) {
            throw new SemanticException("Left hand expression is not an identifier: " + leftHandExp);
        }
        String columnName = ((Identifier)leftHandExp).getValue();
        int idColumnOrdinal = table.getIdColumnOrdinal(columnName);
        if (idColumnOrdinal == -1) {
            throw new SemanticException("The column '" + columnName + "' does not exist or is not a tag column");
        }
        IDPredicate.SegmentExactMatch newPredicate = new IDPredicate.SegmentExactMatch(null, idColumnOrdinal + 1);
        return AnalyzeUtils.combinePredicates(oldPredicate, newPredicate);
    }

    private static IDPredicate combinePredicates(IDPredicate oldPredicate, IDPredicate newPredicate) {
        if (oldPredicate == null) {
            return newPredicate;
        }
        if (oldPredicate instanceof IDPredicate.And) {
            ((IDPredicate.And)oldPredicate).add(newPredicate);
            return oldPredicate;
        }
        return new IDPredicate.And(oldPredicate, newPredicate);
    }

    private static IDPredicate parseComparison(ComparisonExpression comparisonExpression, TimeRange timeRange, IDPredicate oldPredicate, TsTable table) {
        Expression left = comparisonExpression.getLeft();
        Expression right = comparisonExpression.getRight();
        if (!(left instanceof Identifier)) {
            throw new SemanticException("The left hand value must be an identifier: " + left);
        }
        Identifier identifier = (Identifier)left;
        if (identifier.getValue().equalsIgnoreCase("time")) {
            if (!(right instanceof LongLiteral)) {
                throw new SemanticException("The right hand value of time predicate must be a long: " + right);
            }
            long rightHandValue = ((LongLiteral)right).getParsedValue();
            switch (comparisonExpression.getOperator()) {
                case LESS_THAN: {
                    timeRange.setEndTime(Math.min(timeRange.getEndTime(), rightHandValue - 1L));
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    timeRange.setEndTime(Math.min(timeRange.getEndTime(), rightHandValue));
                    break;
                }
                case GREATER_THAN: {
                    timeRange.setStartTime(Math.max(timeRange.getStartTime(), rightHandValue + 1L));
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    timeRange.setStartTime(Math.max(timeRange.getStartTime(), rightHandValue));
                    break;
                }
                case EQUAL: {
                    timeRange.setStartTime(rightHandValue);
                    timeRange.setEndTime(rightHandValue);
                    break;
                }
                default: {
                    throw new SemanticException("The operator of time predicate must be <, <=, >, or >=: " + right);
                }
            }
            return oldPredicate;
        }
        String columnName = identifier.getValue();
        int idColumnOrdinal = table.getIdColumnOrdinal(columnName);
        if (idColumnOrdinal == -1) {
            throw new SemanticException("The column '" + columnName + "' does not exist or is not a tag column");
        }
        IDPredicate newPredicate = AnalyzeUtils.getIdPredicate(comparisonExpression, right, idColumnOrdinal);
        return AnalyzeUtils.combinePredicates(oldPredicate, newPredicate);
    }

    private static IDPredicate getIdPredicate(ComparisonExpression comparisonExpression, Expression right, int idColumnOrdinal) {
        if (comparisonExpression.getOperator() != ComparisonExpression.Operator.EQUAL) {
            throw new SemanticException("The operator of tag predicate must be '=' for " + right);
        }
        if (!(right instanceof StringLiteral)) {
            if (right instanceof NullLiteral) {
                throw new SemanticException("The right hand value of tag predicate cannot be null with '=' operator, please use 'IS NULL' instead");
            }
            throw new SemanticException("The right hand value of tag predicate must be a string: " + right);
        }
        String rightHandValue = ((StringLiteral)right).getValue();
        return new IDPredicate.SegmentExactMatch(rightHandValue, idColumnOrdinal + 1);
    }

    public static interface DataPartitionQueryParamComputation {
        public List<DataPartitionQueryParam> compute(InsertBaseStatement var1, MPPQueryContext var2);
    }

    public static interface DataPartitionQueryFunc {
        public DataPartition queryDataPartition(List<DataPartitionQueryParam> var1, String var2);
    }
}

