/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.CombineHashFunction;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.FlatHashStrategy;
import org.apache.iotdb.db.queryengine.plan.relational.utils.TypeUtil;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class HashStrategy
implements FlatHashStrategy {
    private final boolean isAnyVariableWidth;
    private final int totalFlatFixedLength;
    private final List<KeyField> keyFields;

    public HashStrategy(List<Type> types) {
        this.isAnyVariableWidth = types.stream().anyMatch(TypeUtil::isFlatVariableWidth);
        int fixedOffset = 0;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < types.size(); ++i) {
            Type type = types.get(i);
            builder.add((Object)new KeyField(i, type, fixedOffset));
            fixedOffset += 1 + TypeUtil.getFlatFixedSize(type);
        }
        this.keyFields = builder.build();
        this.totalFlatFixedLength = fixedOffset;
    }

    @Override
    public boolean isAnyVariableWidth() {
        return this.isAnyVariableWidth;
    }

    @Override
    public int getTotalFlatFixedLength() {
        return this.totalFlatFixedLength;
    }

    @Override
    public int getTotalVariableWidth(Column[] columns, int position) {
        int result = 0;
        for (int i = 0; i < columns.length; ++i) {
            result += TypeUtil.getFlatVariableWidthSize(this.keyFields.get(i).type, columns[i], position);
        }
        return result;
    }

    @Override
    public void readFlat(byte[] fixedChunk, int fixedOffset, byte[] variableChunk, ColumnBuilder[] columnBuilders) {
        for (int i = 0; i < columnBuilders.length; ++i) {
            KeyField keyField = this.keyFields.get(i);
            if (fixedChunk[fixedOffset + keyField.fieldIsNullOffset] != 0) {
                columnBuilders[i].appendNull();
                continue;
            }
            TypeUtil.readFlat(keyField.type, fixedChunk, fixedOffset + keyField.fieldFixedOffset, variableChunk, columnBuilders[i]);
        }
    }

    @Override
    public void writeFlat(Column[] columns, int position, byte[] fixedChunk, int fixedOffset, byte[] variableChunk, int variableOffset) {
        for (int i = 0; i < columns.length; ++i) {
            KeyField keyField = this.keyFields.get(i);
            if (columns[i].isNull(position)) {
                fixedChunk[fixedOffset + ((KeyField)keyField).fieldIsNullOffset] = 1;
                continue;
            }
            TypeUtil.writeFlat(keyField.getType(), columns[i], position, fixedChunk, fixedOffset + keyField.fieldFixedOffset, variableChunk, variableOffset);
            variableOffset += TypeUtil.getFlatVariableWidthSize(keyField.type, columns[i], position);
        }
    }

    @Override
    public boolean valueNotDistinctFrom(byte[] leftFixedChunk, int leftFixedOffset, byte[] leftVariableChunk, Column[] rightColumns, int rightPosition) {
        for (int i = 0; i < rightColumns.length; ++i) {
            boolean rightIsNull;
            KeyField keyField = this.keyFields.get(i);
            boolean leftIsNull = leftFixedChunk[leftFixedOffset + keyField.fieldIsNullOffset] != 0;
            if (leftIsNull != (rightIsNull = rightColumns[i].isNull(rightPosition))) {
                return false;
            }
            if (leftIsNull || TypeUtil.notDistinctFrom(keyField.type, leftFixedChunk, leftFixedOffset + keyField.fieldFixedOffset, leftVariableChunk, rightColumns[i], rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long hash(Column[] columns, int position) {
        long result = 0L;
        for (int i = 0; i < columns.length; ++i) {
            long hash = columns[i].isNull(position) ? 0L : TypeUtil.hash(this.keyFields.get(i).type, columns[i], position);
            result = CombineHashFunction.getHash(result, hash);
        }
        return result;
    }

    @Override
    public long hash(byte[] fixedChunk, int fixedOffset, byte[] variableChunk) {
        long result = 0L;
        for (int i = 0; i < this.keyFields.size(); ++i) {
            long hash = fixedChunk[fixedOffset + this.keyFields.get(i).fieldIsNullOffset] != 0 ? 0L : TypeUtil.hash(this.keyFields.get(i).getType(), fixedChunk, fixedOffset + this.keyFields.get(i).fieldFixedOffset, variableChunk);
            result = CombineHashFunction.getHash(result, hash);
        }
        return result;
    }

    @Override
    public void hashBatched(Column[] columns, long[] hashes, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            hashes[i] = this.hash(columns, i);
        }
    }

    private static class KeyField {
        private final int index;
        private final Type type;
        private final int fieldIsNullOffset;
        private final int fieldFixedOffset;

        KeyField(int index, Type type, int fieldIsNullOffset) {
            this.index = index;
            this.type = type;
            this.fieldIsNullOffset = fieldIsNullOffset;
            this.fieldFixedOffset = fieldIsNullOffset + 1;
        }

        public int getIndex() {
            return this.index;
        }

        public Type getType() {
            return this.type;
        }

        public int getFieldIsNullOffset() {
            return this.fieldIsNullOffset;
        }

        public int getFieldFixedOffset() {
            return this.fieldFixedOffset;
        }
    }
}

