/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BinaryBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.BooleanBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.DoubleBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.FloatBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.IntBigArray;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.LongBigArray;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class GroupedMinAccumulator
implements GroupedAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(GroupedMinAccumulator.class);
    private final TSDataType seriesDataType;
    private final BooleanBigArray inits = new BooleanBigArray();
    private LongBigArray longValues;
    private IntBigArray intValues;
    private FloatBigArray floatValues;
    private DoubleBigArray doubleValues;
    private BinaryBigArray binaryValues;
    private BooleanBigArray booleanValues;

    public GroupedMinAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        switch (seriesDataType) {
            case INT32: 
            case DATE: {
                this.intValues = new IntBigArray(Integer.MAX_VALUE);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longValues = new LongBigArray(Long.MAX_VALUE);
                return;
            }
            case FLOAT: {
                this.floatValues = new FloatBigArray(Float.MAX_VALUE);
                return;
            }
            case DOUBLE: {
                this.doubleValues = new DoubleBigArray(Double.MAX_VALUE);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.binaryValues = new BinaryBigArray();
                return;
            }
            case BOOLEAN: {
                this.booleanValues = new BooleanBigArray();
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", seriesDataType));
    }

    @Override
    public long getEstimatedSize() {
        long valuesSize = 0L;
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                valuesSize += this.intValues.sizeOf();
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                valuesSize += this.longValues.sizeOf();
                break;
            }
            case FLOAT: {
                valuesSize += this.floatValues.sizeOf();
                break;
            }
            case DOUBLE: {
                valuesSize += this.doubleValues.sizeOf();
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                valuesSize += this.binaryValues.sizeOf();
                break;
            }
            case BOOLEAN: {
                valuesSize += this.booleanValues.sizeOf();
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in : %s", this.seriesDataType));
            }
        }
        return INSTANCE_SIZE + valuesSize + this.inits.sizeOf();
    }

    @Override
    public void setGroupCount(long groupCount) {
        this.inits.ensureCapacity(groupCount);
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.intValues.ensureCapacity(groupCount);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longValues.ensureCapacity(groupCount);
                return;
            }
            case FLOAT: {
                this.floatValues.ensureCapacity(groupCount);
                return;
            }
            case DOUBLE: {
                this.doubleValues.ensureCapacity(groupCount);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.binaryValues.ensureCapacity(groupCount);
                return;
            }
            case BOOLEAN: {
                this.booleanValues.ensureCapacity(groupCount);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in : %s", this.seriesDataType));
    }

    @Override
    public void addInput(int[] groupIds, Column[] arguments) {
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(groupIds, arguments[0]);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(groupIds, arguments[0]);
                return;
            }
            case FLOAT: {
                this.addFloatInput(groupIds, arguments[0]);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(groupIds, arguments[0]);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.addBinaryInput(groupIds, arguments[0]);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(groupIds, arguments[0]);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(int[] groupIds, Column argument) {
        block8: for (int i = 0; i < groupIds.length; ++i) {
            if (argument.isNull(i)) continue;
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    this.updateIntValue(groupIds[i], argument.getInt(i));
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.updateLongValue(groupIds[i], argument.getLong(i));
                    continue block8;
                }
                case FLOAT: {
                    this.updateFloatValue(groupIds[i], argument.getFloat(i));
                    continue block8;
                }
                case DOUBLE: {
                    this.updateDoubleValue(groupIds[i], argument.getDouble(i));
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    this.updateBinaryValue(groupIds[i], argument.getBinary(i));
                    continue block8;
                }
                case BOOLEAN: {
                    this.updateBooleanValue(groupIds[i], argument.getBoolean(i));
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void evaluateIntermediate(int groupId, ColumnBuilder columnBuilder) {
        if (!this.inits.get(groupId)) {
            columnBuilder.appendNull();
        } else {
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    columnBuilder.writeInt(this.intValues.get(groupId));
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    columnBuilder.writeLong(this.longValues.get(groupId));
                    break;
                }
                case FLOAT: {
                    columnBuilder.writeFloat(this.floatValues.get(groupId));
                    break;
                }
                case DOUBLE: {
                    columnBuilder.writeDouble(this.doubleValues.get(groupId));
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    columnBuilder.writeBinary(this.binaryValues.get(groupId));
                    break;
                }
                case BOOLEAN: {
                    columnBuilder.writeBoolean(this.booleanValues.get(groupId));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void evaluateFinal(int groupId, ColumnBuilder columnBuilder) {
        if (!this.inits.get(groupId)) {
            columnBuilder.appendNull();
        } else {
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    columnBuilder.writeInt(this.intValues.get(groupId));
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    columnBuilder.writeLong(this.longValues.get(groupId));
                    break;
                }
                case FLOAT: {
                    columnBuilder.writeFloat(this.floatValues.get(groupId));
                    break;
                }
                case DOUBLE: {
                    columnBuilder.writeDouble(this.doubleValues.get(groupId));
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    columnBuilder.writeBinary(this.binaryValues.get(groupId));
                    break;
                }
                case BOOLEAN: {
                    columnBuilder.writeBoolean(this.booleanValues.get(groupId));
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void prepareFinal() {
    }

    @Override
    public void reset() {
        this.inits.reset();
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.intValues.reset();
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.longValues.reset();
                return;
            }
            case FLOAT: {
                this.floatValues.reset();
                return;
            }
            case DOUBLE: {
                this.doubleValues.reset();
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.binaryValues.reset();
                return;
            }
            case BOOLEAN: {
                this.booleanValues.reset();
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type : %s", this.seriesDataType));
    }

    private void addIntInput(int[] groupIds, Column valueColumn) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateIntValue(groupIds[i], valueColumn.getInt(i));
        }
    }

    protected void updateIntValue(int groupId, int value) {
        int min = this.intValues.get(groupId);
        if (value <= min) {
            this.inits.set(groupId, true);
            this.intValues.set(groupId, value);
        }
    }

    private void addLongInput(int[] groupIds, Column valueColumn) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateLongValue(groupIds[i], valueColumn.getLong(i));
        }
    }

    protected void updateLongValue(int groupId, long value) {
        long min = this.longValues.get(groupId);
        if (value <= min) {
            this.inits.set(groupId, true);
            this.longValues.set(groupId, value);
        }
    }

    private void addFloatInput(int[] groupIds, Column valueColumn) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateFloatValue(groupIds[i], valueColumn.getFloat(i));
        }
    }

    protected void updateFloatValue(int groupId, float value) {
        float min = this.floatValues.get(groupId);
        if (value <= min) {
            this.inits.set(groupId, true);
            this.floatValues.set(groupId, value);
        }
    }

    private void addDoubleInput(int[] groupIds, Column valueColumn) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateDoubleValue(groupIds[i], valueColumn.getDouble(i));
        }
    }

    protected void updateDoubleValue(int groupId, double value) {
        double min = this.doubleValues.get(groupId);
        if (value <= min) {
            this.inits.set(groupId, true);
            this.doubleValues.set(groupId, value);
        }
    }

    private void addBinaryInput(int[] groupIds, Column valueColumn) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateBinaryValue(groupIds[i], valueColumn.getBinary(i));
        }
    }

    protected void updateBinaryValue(int groupId, Binary value) {
        Binary min = this.binaryValues.get(groupId);
        if (!this.inits.get(groupId) || value.compareTo(min) < 0) {
            this.inits.set(groupId, true);
            this.binaryValues.set(groupId, value);
        }
    }

    private void addBooleanInput(int[] groupIds, Column valueColumn) {
        for (int i = 0; i < groupIds.length; ++i) {
            if (valueColumn.isNull(i)) continue;
            this.updateBooleanValue(groupIds[i], valueColumn.getBoolean(i));
        }
    }

    protected void updateBooleanValue(int groupId, boolean value) {
        if (!this.inits.get(groupId) || !value) {
            this.inits.set(groupId, true);
            this.booleanValues.set(groupId, value);
        }
    }
}

