/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.GroupedAccumulator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public class GroupedAggregator {
    private final GroupedAccumulator accumulator;
    private final AggregationNode.Step step;
    private final TSDataType outputType;
    private final int[] inputChannels;
    private final OptionalInt maskChannel;

    public GroupedAggregator(GroupedAccumulator accumulator, AggregationNode.Step step, TSDataType outputType, List<Integer> inputChannels, OptionalInt maskChannel) {
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator is null");
        this.step = Objects.requireNonNull(step, "step is null");
        this.outputType = Objects.requireNonNull(outputType, "intermediateType is null");
        this.inputChannels = Ints.toArray((Collection)Objects.requireNonNull(inputChannels, "inputChannels is null"));
        this.maskChannel = Objects.requireNonNull(maskChannel, "maskChannel is null");
        Preconditions.checkArgument((step.isInputRaw() || inputChannels.size() == 1 ? 1 : 0) != 0, (Object)"expected 1 input channel for intermediate aggregation");
    }

    public TSDataType getType() {
        return this.outputType;
    }

    public void processBlock(int groupCount, int[] groupIds, TsBlock block) {
        this.accumulator.setGroupCount(groupCount);
        Column[] arguments = block.getColumns(this.inputChannels);
        if (arguments.length == 0) {
            arguments = new Column[]{new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, block.getPositionCount())};
        }
        if (this.step.isInputRaw()) {
            this.accumulator.addInput(groupIds, arguments);
        } else {
            this.accumulator.addIntermediate(groupIds, arguments[0]);
        }
    }

    public void evaluate(int groupId, ColumnBuilder columnBuilder) {
        if (this.step.isOutputPartial()) {
            this.accumulator.evaluateIntermediate(groupId, columnBuilder);
        } else {
            this.accumulator.evaluateFinal(groupId, columnBuilder);
        }
    }

    public void prepareFinal() {
        this.accumulator.prepareFinal();
    }

    public void reset() {
        this.accumulator.reset();
    }

    public long getEstimatedSize() {
        return this.accumulator.getEstimatedSize();
    }

    public void close() {
        this.accumulator.close();
    }
}

