/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.aggregation.VarianceAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class TableVarianceAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TableVarianceAccumulator.class);
    private final TSDataType seriesDataType;
    private final VarianceAccumulator.VarianceType varianceType;
    private long count;
    private double mean;
    private double m2;

    public TableVarianceAccumulator(TSDataType seriesDataType, VarianceAccumulator.VarianceType varianceType) {
        this.seriesDataType = seriesDataType;
        this.varianceType = varianceType;
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new TableVarianceAccumulator(this.seriesDataType, this.varianceType);
    }

    @Override
    public void addInput(Column[] arguments) {
        switch (this.seriesDataType) {
            case INT32: {
                this.addIntInput(arguments[0]);
                return;
            }
            case INT64: {
                this.addLongInput(arguments[0]);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0]);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0]);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation variance : %s", this.seriesDataType));
    }

    @Override
    public void removeInput(Column[] arguments) {
        switch (this.seriesDataType) {
            case INT32: {
                this.removeIntInput(arguments[0]);
                return;
            }
            case INT64: {
                this.removeLongInput(arguments[0]);
                return;
            }
            case FLOAT: {
                this.removeFloatInput(arguments[0]);
                return;
            }
            case DOUBLE: {
                this.removeDoubleInput(arguments[0]);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation variance : %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output should be BinaryColumn");
        for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            byte[] bytes = argument.getBinary(i).getValues();
            long intermediateCount = BytesUtils.bytesToLong((byte[])bytes, (int)8);
            double intermediateMean = BytesUtils.bytesToDouble((byte[])bytes, (int)8);
            double intermediateM2 = BytesUtils.bytesToDouble((byte[])bytes, (int)16);
            long newCount = this.count + intermediateCount;
            double newMean = ((double)intermediateCount * intermediateMean + (double)this.count * this.mean) / (double)newCount;
            double delta = intermediateMean - this.mean;
            this.m2 = this.m2 + intermediateM2 + delta * delta * (double)intermediateCount * (double)this.count / (double)newCount;
            this.count = newCount;
            this.mean = newMean;
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output should be BinaryColumn");
        if (this.count == 0L) {
            columnBuilder.appendNull();
        } else {
            byte[] bytes = new byte[24];
            BytesUtils.longToBytes((long)this.count, (byte[])bytes, (int)0);
            BytesUtils.doubleToBytes((double)this.mean, (byte[])bytes, (int)8);
            BytesUtils.doubleToBytes((double)this.m2, (byte[])bytes, (int)16);
            columnBuilder.writeBinary(new Binary(bytes));
        }
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        switch (this.varianceType) {
            case STDDEV_POP: {
                if (this.count == 0L) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeDouble(Math.sqrt(this.m2 / (double)this.count));
                break;
            }
            case STDDEV_SAMP: {
                if (this.count < 2L) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeDouble(Math.sqrt(this.m2 / (double)(this.count - 1L)));
                break;
            }
            case VAR_POP: {
                if (this.count == 0L) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeDouble(this.m2 / (double)this.count);
                break;
            }
            case VAR_SAMP: {
                if (this.count < 2L) {
                    columnBuilder.appendNull();
                    break;
                }
                columnBuilder.writeDouble(this.m2 / (double)(this.count - 1L));
                break;
            }
            default: {
                throw new EnumConstantNotPresentException(VarianceAccumulator.VarianceType.class, this.varianceType.name());
            }
        }
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void reset() {
        this.count = 0L;
        this.mean = 0.0;
        this.m2 = 0.0;
    }

    @Override
    public boolean removable() {
        return true;
    }

    private void addIntInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (column.isNull(i)) continue;
            int value = column.getInt(i);
            ++this.count;
            double delta = (double)value - this.mean;
            this.mean += delta / (double)this.count;
            this.m2 += delta * ((double)value - this.mean);
        }
    }

    private void addLongInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (column.isNull(i)) continue;
            long value = column.getLong(i);
            ++this.count;
            double delta = (double)value - this.mean;
            this.mean += delta / (double)this.count;
            this.m2 += delta * ((double)value - this.mean);
        }
    }

    private void addFloatInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (column.isNull(i)) continue;
            float value = column.getFloat(i);
            ++this.count;
            double delta = (double)value - this.mean;
            this.mean += delta / (double)this.count;
            this.m2 += delta * ((double)value - this.mean);
        }
    }

    private void addDoubleInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (column.isNull(i)) continue;
            double value = column.getDouble(i);
            ++this.count;
            double delta = value - this.mean;
            this.mean += delta / (double)this.count;
            this.m2 += delta * (value - this.mean);
        }
    }

    private void removeIntInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (column.isNull(i)) continue;
            int value = column.getInt(i);
            this.updateStateByRemove(value);
        }
    }

    private void removeLongInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (column.isNull(i)) continue;
            long value = column.getLong(i);
            this.updateStateByRemove(value);
        }
    }

    private void removeFloatInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (column.isNull(i)) continue;
            float value = column.getFloat(i);
            this.updateStateByRemove(value);
        }
    }

    private void removeDoubleInput(Column column) {
        for (int i = 0; i < column.getPositionCount(); ++i) {
            if (column.isNull(i)) continue;
            double value = column.getDouble(i);
            this.updateStateByRemove(value);
        }
    }

    private void updateStateByRemove(double value) {
        long newCount = this.count - 1L;
        double newMean = ((double)this.count * this.mean - value) / (double)newCount;
        double delta = value - this.mean;
        this.m2 -= delta * delta * (double)this.count / (double)newCount;
        this.count = newCount;
        this.mean = newMean;
    }
}

