/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class SumAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SumAccumulator.class);
    private final TSDataType argumentDataType;
    private double sumValue = 0.0;
    private boolean initResult = false;

    public SumAccumulator(TSDataType argumentDataType) {
        this.argumentDataType = argumentDataType;
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new SumAccumulator(this.argumentDataType);
    }

    @Override
    public void addInput(Column[] arguments) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of Sum should be one column");
        switch (this.argumentDataType) {
            case INT32: {
                this.addIntInput(arguments[0]);
                return;
            }
            case INT64: {
                this.addLongInput(arguments[0]);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0]);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0]);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation Sum : %s", this.argumentDataType));
    }

    @Override
    public void removeInput(Column[] arguments) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of Sum should be one column");
        switch (this.argumentDataType) {
            case INT32: {
                this.removeIntInput(arguments[0]);
                return;
            }
            case INT64: {
                this.removeLongInput(arguments[0]);
                return;
            }
            case FLOAT: {
                this.removeFloatInput(arguments[0]);
                return;
            }
            case DOUBLE: {
                this.removeDoubleInput(arguments[0]);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation Sum : %s", this.argumentDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            this.initResult = true;
            this.sumValue += argument.getDouble(i);
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeDouble(this.sumValue);
        }
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeDouble(this.sumValue);
        }
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        if (statistics == null || statistics[0] == null) {
            return;
        }
        this.initResult = true;
        this.sumValue = statistics[0] instanceof IntegerStatistics ? (this.sumValue += (double)statistics[0].getSumLongValue()) : (this.sumValue += statistics[0].getSumDoubleValue());
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.sumValue = 0.0;
    }

    @Override
    public boolean removable() {
        return true;
    }

    private void addIntInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.initResult = true;
            this.sumValue += (double)column.getInt(i);
        }
    }

    private void addLongInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.initResult = true;
            this.sumValue += (double)column.getLong(i);
        }
    }

    private void addFloatInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.initResult = true;
            this.sumValue += (double)column.getFloat(i);
        }
    }

    private void addDoubleInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.initResult = true;
            this.sumValue += column.getDouble(i);
        }
    }

    private void removeIntInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.sumValue -= (double)column.getInt(i);
        }
    }

    private void removeLongInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.sumValue -= (double)column.getLong(i);
        }
    }

    private void removeFloatInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.sumValue -= (double)column.getFloat(i);
        }
    }

    private void removeDoubleInput(Column column) {
        int count = column.getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (column.isNull(i)) continue;
            this.sumValue -= column.getDouble(i);
        }
    }
}

