/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.iotdb.commons.exception.runtime.SchemaExecutionException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.impl.DeviceFilterUtil;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DevicePredicateFilter;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class TableDeviceQuerySource
implements ISchemaSource<IDeviceSchemaInfo> {
    private final String database;
    private final String tableName;
    private final List<List<SchemaFilter>> idDeterminedPredicateList;
    private final List<ColumnHeader> columnHeaderList;
    private final DevicePredicateFilter filter;

    public TableDeviceQuerySource(String database, String tableName, List<List<SchemaFilter>> idDeterminedPredicateList, List<ColumnHeader> columnHeaderList, DevicePredicateFilter filter) {
        this.database = database;
        this.tableName = tableName;
        this.idDeterminedPredicateList = idDeterminedPredicateList;
        this.columnHeaderList = columnHeaderList;
        this.filter = filter;
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getSchemaReader(final ISchemaRegion schemaRegion) {
        final List<PartialPath> devicePatternList = TableDeviceQuerySource.getDevicePatternList(this.database, this.tableName, this.idDeterminedPredicateList);
        return new ISchemaReader<IDeviceSchemaInfo>(){
            private ISchemaReader<IDeviceSchemaInfo> deviceReader;
            private Throwable throwable;
            private int index = 0;
            private IDeviceSchemaInfo next;

            @Override
            public boolean isSuccess() {
                return this.throwable == null && (this.deviceReader == null || this.deviceReader.isSuccess());
            }

            @Override
            public Throwable getFailure() {
                if (this.throwable != null) {
                    return this.throwable;
                }
                if (this.deviceReader != null) {
                    return this.deviceReader.getFailure();
                }
                return null;
            }

            @Override
            public ListenableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            @Override
            public boolean hasNext() {
                if (Objects.nonNull(this.next)) {
                    return true;
                }
                if (Objects.isNull(TableDeviceQuerySource.this.filter)) {
                    if (this.innerHasNext()) {
                        this.next = this.deviceReader.next();
                        return true;
                    }
                    return false;
                }
                if (TableDeviceQuerySource.this.filter.hasNext()) {
                    this.next = TableDeviceQuerySource.this.filter.next();
                    return true;
                }
                while (this.innerHasNext() && !TableDeviceQuerySource.this.filter.hasNext()) {
                    TableDeviceQuerySource.this.filter.addBatch(this.deviceReader.next());
                }
                if (!TableDeviceQuerySource.this.filter.hasNext()) {
                    TableDeviceQuerySource.this.filter.prepareBatchResult();
                }
                if (TableDeviceQuerySource.this.filter.hasNext()) {
                    this.next = TableDeviceQuerySource.this.filter.next();
                    return true;
                }
                return false;
            }

            private boolean innerHasNext() {
                try {
                    if (this.throwable != null) {
                        return false;
                    }
                    if (this.deviceReader != null) {
                        if (this.deviceReader.hasNext()) {
                            return true;
                        }
                        this.deviceReader.close();
                        if (!this.deviceReader.isSuccess()) {
                            this.throwable = this.deviceReader.getFailure();
                            return false;
                        }
                    }
                    while (this.index < devicePatternList.size()) {
                        this.deviceReader = schemaRegion.getTableDeviceReader((PartialPath)devicePatternList.get(this.index));
                        ++this.index;
                        if (this.deviceReader.hasNext()) {
                            return true;
                        }
                        this.deviceReader.close();
                    }
                    return false;
                }
                catch (Exception e) {
                    throw new SchemaExecutionException(e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public IDeviceSchemaInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IDeviceSchemaInfo result = this.next;
                this.next = null;
                return result;
            }

            @Override
            public void close() throws Exception {
                if (Objects.nonNull(this.deviceReader)) {
                    this.deviceReader.close();
                }
                if (Objects.nonNull(TableDeviceQuerySource.this.filter)) {
                    TableDeviceQuerySource.this.filter.close();
                }
            }
        };
    }

    public static List<PartialPath> getDevicePatternList(String database, String tableName, List<List<SchemaFilter>> idDeterminedPredicateList) {
        if (Objects.isNull(DataNodeTableCache.getInstance().getTable(database, tableName))) {
            TableMetadataImpl.throwTableNotExistsException(database, tableName);
        }
        return DeviceFilterUtil.convertToDevicePattern((String)database, (String)tableName, (int)DataNodeTableCache.getInstance().getTable(database, tableName).getIdNums(), idDeterminedPredicateList);
    }

    @Override
    public List<ColumnHeader> getInfoQueryColumnHeaders() {
        return this.columnHeaderList;
    }

    @Override
    public void transformToTsBlockColumns(IDeviceSchemaInfo schemaInfo, TsBlockBuilder builder, String database) {
        TableDeviceQuerySource.transformToTsBlockColumns(schemaInfo, builder, database, this.tableName, this.columnHeaderList, 3);
    }

    public static void transformToTsBlockColumns(IDeviceSchemaInfo schemaInfo, TsBlockBuilder builder, String database, String tableName, List<ColumnHeader> columnHeaderList, int idIndex) {
        builder.getTimeColumnBuilder().writeLong(0L);
        int resultIndex = 0;
        String[] pathNodes = schemaInfo.getRawNodes();
        TsTable table = DataNodeTableCache.getInstance().getTable(database, tableName);
        for (ColumnHeader columnHeader : columnHeaderList) {
            TsTableColumnSchema columnSchema = table.getColumnSchema(columnHeader.getColumnName());
            if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.TAG)) {
                if (pathNodes.length <= idIndex || pathNodes[idIndex] == null) {
                    builder.getColumnBuilder(resultIndex).appendNull();
                } else {
                    builder.getColumnBuilder(resultIndex).writeBinary(new Binary(pathNodes[idIndex], TSFileConfig.STRING_CHARSET));
                }
                ++idIndex;
            } else if (columnSchema.getColumnCategory().equals((Object)TsTableColumnCategory.ATTRIBUTE)) {
                Binary attributeValue = schemaInfo.getAttributeValue(columnHeader.getColumnName());
                if (attributeValue == null) {
                    builder.getColumnBuilder(resultIndex).appendNull();
                } else {
                    builder.getColumnBuilder(resultIndex).writeBinary(attributeValue);
                }
            }
            ++resultIndex;
        }
        builder.declarePosition();
    }

    @Override
    public boolean hasSchemaStatistic(ISchemaRegion schemaRegion) {
        return (Objects.isNull(this.idDeterminedPredicateList) || this.idDeterminedPredicateList.isEmpty() || this.idDeterminedPredicateList.stream().allMatch(List::isEmpty)) && Objects.isNull(this.filter);
    }

    @Override
    public long getSchemaStatistic(ISchemaRegion schemaRegion) {
        return schemaRegion.getSchemaRegionStatistics().getTableDevicesNumber(this.tableName);
    }
}

