/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResource;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceSegmentLock;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileResourceManager.class);
    private final Map<String, PipeTsFileResource> hardlinkOrCopiedFileToPipeTsFileResourceMap = new ConcurrentHashMap<String, PipeTsFileResource>();
    private final PipeTsFileResourceSegmentLock segmentLock = new PipeTsFileResourceSegmentLock();

    public PipeTsFileResourceManager() {
        PipeDataNodeAgent.runtime().registerPeriodicalJob("PipeTsFileResourceManager#ttlCheck()", this::tryTtlCheck, Math.max(20L, 1L));
    }

    private void tryTtlCheck() {
        try {
            this.ttlCheck();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("failed to try lock when checking TTL because of interruption", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.warn("failed to check TTL of PipeTsFileResource: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ttlCheck() throws InterruptedException {
        Iterator<Map.Entry<String, PipeTsFileResource>> iterator = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.entrySet().iterator();
        long timeout = PipeConfig.getInstance().getPipeSubtaskExecutorCronHeartbeatEventIntervalSeconds() >> 1;
        Optional logger = PipeDataNodeResourceManager.log().schedule(PipeTsFileResourceManager.class, PipeConfig.getInstance().getPipeTsFilePinMaxLogNumPerRound(), PipeConfig.getInstance().getPipeTsFilePinMaxLogIntervalRounds(), this.hardlinkOrCopiedFileToPipeTsFileResourceMap.size());
        StringBuilder logBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            Map.Entry<String, PipeTsFileResource> entry = iterator.next();
            String hardlinkOrCopiedFile = entry.getKey();
            if (!this.segmentLock.tryLock(new File(hardlinkOrCopiedFile), timeout, TimeUnit.SECONDS)) {
                LOGGER.warn("failed to try lock when checking TTL for file {} because of timeout ({}s)", (Object)hardlinkOrCopiedFile, (Object)timeout);
                continue;
            }
            try {
                if (entry.getValue().closeIfOutOfTimeToLive()) {
                    iterator.remove();
                    continue;
                }
                logBuilder.append(String.format("<%s , %d times, %d bytes> ", entry.getKey(), entry.getValue().getReferenceCount(), entry.getValue().getFileSize()));
            }
            catch (IOException e) {
                LOGGER.warn("failed to close PipeTsFileResource when checking TTL: ", (Throwable)e);
            }
            finally {
                this.segmentLock.unlock(new File(hardlinkOrCopiedFile));
            }
        }
        if (logBuilder.length() > 0) {
            logger.ifPresent(l -> l.info("Pipe file {}are still referenced", (Object)logBuilder));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File increaseFileReference(File file, boolean isTsFile, TsFileResource tsFileResource) throws IOException {
        this.segmentLock.lock(file);
        try {
            if (this.increaseReferenceIfExists(file)) {
                File file2 = file;
                return file2;
            }
        }
        finally {
            this.segmentLock.unlock(file);
        }
        File hardlinkOrCopiedFile = PipeTsFileResourceManager.getHardlinkOrCopiedFileInPipeDir(file);
        this.segmentLock.lock(hardlinkOrCopiedFile);
        try {
            if (this.increaseReferenceIfExists(hardlinkOrCopiedFile)) {
                File file3 = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(hardlinkOrCopiedFile.getPath()).getFile();
                return file3;
            }
            File resultFile = isTsFile ? FileUtils.createHardLink((File)file, (File)hardlinkOrCopiedFile) : FileUtils.copyFile((File)file, (File)hardlinkOrCopiedFile);
            this.hardlinkOrCopiedFileToPipeTsFileResourceMap.put(resultFile.getPath(), new PipeTsFileResource(resultFile, isTsFile, tsFileResource));
            File file4 = resultFile;
            return file4;
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedFile);
        }
    }

    private boolean increaseReferenceIfExists(File file) {
        PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(file.getPath());
        if (resource != null) {
            resource.increaseAndGetReference();
            return true;
        }
        return false;
    }

    public static File getHardlinkOrCopiedFileInPipeDir(File file) throws IOException {
        try {
            return new File(PipeTsFileResourceManager.getPipeTsFileDirPath(file), PipeTsFileResourceManager.getRelativeFilePath(file));
        }
        catch (Exception e) {
            throw new IOException(String.format("failed to get hardlink or copied file in pipe dir for file %s, it is not a tsfile, mod file or resource file", file.getPath()), e);
        }
    }

    private static String getPipeTsFileDirPath(File file) throws IOException {
        while (!file.getName().equals("sequence") && !file.getName().equals("unsequence")) {
            file = file.getParentFile();
        }
        return file.getParentFile().getCanonicalPath() + File.separator + PipeConfig.getInstance().getPipeHardlinkBaseDirName() + File.separator + PipeConfig.getInstance().getPipeHardlinkTsFileDirName();
    }

    private static String getRelativeFilePath(File file) {
        StringBuilder builder = new StringBuilder(file.getName());
        while (!file.getName().equals("sequence") && !file.getName().equals("unsequence")) {
            file = file.getParentFile();
            builder = new StringBuilder(file.getName()).append("-").append((CharSequence)builder);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseFileReference(File hardlinkOrCopiedFile) {
        this.segmentLock.lock(hardlinkOrCopiedFile);
        try {
            String filePath = hardlinkOrCopiedFile.getPath();
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(filePath);
            if (resource != null) {
                resource.decreaseAndGetReference();
            }
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileReferenceCount(File hardlinkOrCopiedFile) {
        this.segmentLock.lock(hardlinkOrCopiedFile);
        try {
            String filePath = hardlinkOrCopiedFile.getPath();
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(filePath);
            int n = resource != null ? resource.getReferenceCount() : 0;
            return n;
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cacheObjectsIfAbsent(File hardlinkOrCopiedTsFile) throws IOException {
        this.segmentLock.lock(hardlinkOrCopiedTsFile);
        try {
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(hardlinkOrCopiedTsFile.getPath());
            boolean bl = resource != null && resource.cacheObjectsIfAbsent();
            return bl;
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedTsFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IDeviceID, List<String>> getDeviceMeasurementsMapFromCache(File hardlinkOrCopiedTsFile) throws IOException {
        this.segmentLock.lock(hardlinkOrCopiedTsFile);
        try {
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(hardlinkOrCopiedTsFile.getPath());
            Map<IDeviceID, List<String>> map = resource == null ? null : resource.tryGetDeviceMeasurementsMap();
            return map;
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedTsFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IDeviceID, Boolean> getDeviceIsAlignedMapFromCache(File hardlinkOrCopiedTsFile, boolean cacheOtherMetadata) throws IOException {
        this.segmentLock.lock(hardlinkOrCopiedTsFile);
        try {
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(hardlinkOrCopiedTsFile.getPath());
            Map<IDeviceID, Boolean> map = resource == null ? null : resource.tryGetDeviceIsAlignedMap(cacheOtherMetadata);
            return map;
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedTsFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TSDataType> getMeasurementDataTypeMapFromCache(File hardlinkOrCopiedTsFile) throws IOException {
        this.segmentLock.lock(hardlinkOrCopiedTsFile);
        try {
            PipeTsFileResource resource = this.hardlinkOrCopiedFileToPipeTsFileResourceMap.get(hardlinkOrCopiedTsFile.getPath());
            Map<String, TSDataType> map = resource == null ? null : resource.tryGetMeasurementDataTypeMap();
            return map;
        }
        finally {
            this.segmentLock.unlock(hardlinkOrCopiedTsFile);
        }
    }

    public void pinTsFileResource(TsFileResource resource, boolean withMods) throws IOException {
        this.increaseFileReference(resource.getTsFile(), true, resource);
        if (withMods && resource.getExclusiveModFile().exists()) {
            this.increaseFileReference(resource.getExclusiveModFile().getFile(), false, null);
        }
    }

    public void unpinTsFileResource(TsFileResource resource) throws IOException {
        File pinnedFile = PipeTsFileResourceManager.getHardlinkOrCopiedFileInPipeDir(resource.getTsFile());
        this.decreaseFileReference(pinnedFile);
        if (resource.sharedModFileExists()) {
            this.decreaseFileReference(resource.getSharedModFile().getFile());
        }
    }

    public int getLinkedTsfileCount() {
        return this.hardlinkOrCopiedFileToPipeTsFileResourceMap.size();
    }

    public long getTotalLinkedButDeletedTsfileSize() {
        try {
            return this.hardlinkOrCopiedFileToPipeTsFileResourceMap.values().parallelStream().filter(PipeTsFileResource::isOriginalTsFileDeleted).mapToLong(resource -> {
                try {
                    return resource.getFileSize();
                }
                catch (Exception e) {
                    LOGGER.warn("failed to get file size of linked but deleted TsFile {}: ", resource, (Object)e);
                    return 0L;
                }
            }).sum();
        }
        catch (Exception e) {
            LOGGER.warn("failed to get total size of linked but deleted TsFiles: ", (Throwable)e);
            return 0L;
        }
    }

    public long getTotalLinkedButDeletedTsfileResourceRamSize() {
        long totalLinkedButDeletedTsfileResourceRamSize = 0L;
        try {
            for (Map.Entry<String, PipeTsFileResource> resourceEntry : this.hardlinkOrCopiedFileToPipeTsFileResourceMap.entrySet()) {
                PipeTsFileResource pipeTsFileResource = resourceEntry.getValue();
                if (!pipeTsFileResource.isOriginalTsFileDeleted()) continue;
                totalLinkedButDeletedTsfileResourceRamSize += pipeTsFileResource.getTsFileResourceSize();
            }
            return totalLinkedButDeletedTsfileResourceRamSize;
        }
        catch (Exception e) {
            LOGGER.warn("failed to get total size of linked but deleted TsFiles resource ram size: ", (Throwable)e);
            return totalLinkedButDeletedTsfileResourceRamSize;
        }
    }
}

