/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.memory;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.event.common.row.PipeRow;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class PipeMemoryWeightUtil {
    public static long memoryOfIDeviceId2Bool(Map<IDeviceID, Boolean> map) {
        long usageInBytes = 0L;
        for (Map.Entry<IDeviceID, Boolean> entry : map.entrySet()) {
            usageInBytes = usageInBytes + entry.getKey().ramBytesUsed() + 1L;
        }
        return usageInBytes + 16L;
    }

    public static long memoryOfStr2TSDataType(Map<String, TSDataType> map) {
        long usageInBytes = 0L;
        for (Map.Entry<String, TSDataType> entry : map.entrySet()) {
            usageInBytes = usageInBytes + MemUtils.getStringMem(entry.getKey()) + 4L;
        }
        return usageInBytes + 16L;
    }

    public static long memoryOfIDeviceID2StrList(Map<IDeviceID, List<String>> map) {
        long usageInBytes = 0L;
        for (Map.Entry<IDeviceID, List<String>> entry : map.entrySet()) {
            usageInBytes += entry.getKey().ramBytesUsed();
            for (String str : entry.getValue()) {
                usageInBytes += MemUtils.getStringMem(str);
            }
        }
        return usageInBytes + 16L;
    }

    public static Pair<Integer, Integer> calculateTabletRowCountAndMemory(RowRecord row) {
        int totalSizeInBytes = 0;
        totalSizeInBytes = (int)((long)totalSizeInBytes + 8L);
        List fields = row.getFields();
        int schemaCount = 0;
        if (fields != null) {
            schemaCount = fields.size();
            for (Field field : fields) {
                TSDataType tsDataType;
                if (field == null || (tsDataType = field.getDataType()) == null) continue;
                if (tsDataType.isBinary()) {
                    Binary binary = field.getBinaryV();
                    totalSizeInBytes += binary == null ? 0 : binary.getLength();
                    continue;
                }
                totalSizeInBytes += tsDataType.getDataTypeSize();
            }
        }
        return PipeMemoryWeightUtil.calculateTabletRowCountAndMemoryBySize(totalSizeInBytes, schemaCount);
    }

    public static Pair<Integer, Integer> calculateTabletRowCountAndMemory(BatchData batchData) {
        int totalSizeInBytes = 0;
        int schemaCount = 0;
        totalSizeInBytes = (int)((long)totalSizeInBytes + 8L);
        TSDataType type = batchData.getDataType();
        if (type != null) {
            if (type == TSDataType.VECTOR && batchData.getVector() != null) {
                schemaCount = batchData.getVector().length;
                for (int i = 0; i < schemaCount; ++i) {
                    TsPrimitiveType primitiveType = batchData.getVector()[i];
                    if (primitiveType == null || primitiveType.getDataType() == null) continue;
                    if (primitiveType.getDataType().isBinary()) {
                        Binary binary = primitiveType.getBinary();
                        totalSizeInBytes += binary == null ? 0 : binary.getLength();
                        continue;
                    }
                    totalSizeInBytes += primitiveType.getDataType().getDataTypeSize();
                }
            } else {
                Binary binary;
                schemaCount = 1;
                totalSizeInBytes = type.isBinary() ? (totalSizeInBytes += (binary = batchData.getBinary()) == null ? 0 : binary.getLength()) : (totalSizeInBytes += type.getDataTypeSize());
            }
        }
        return PipeMemoryWeightUtil.calculateTabletRowCountAndMemoryBySize(totalSizeInBytes, schemaCount);
    }

    public static Pair<Integer, Integer> calculateTabletRowCountAndMemory(PipeRow row) {
        return PipeMemoryWeightUtil.calculateTabletRowCountAndMemoryBySize(row.getCurrentRowSize(), row.size());
    }

    private static Pair<Integer, Integer> calculateTabletRowCountAndMemoryBySize(int rowSize, int schemaCount) {
        if (rowSize <= 0) {
            return new Pair((Object)1, (Object)0);
        }
        int rowNumber = 8 * (PipeConfig.getInstance().getPipeDataStructureTabletSizeInBytes() - 100) / (8 * rowSize + schemaCount);
        if ((rowNumber = Math.max(1, rowNumber)) > PipeConfig.getInstance().getPipeDataStructureTabletRowSize()) {
            return new Pair((Object)PipeConfig.getInstance().getPipeDataStructureTabletRowSize(), (Object)(rowSize * PipeConfig.getInstance().getPipeDataStructureTabletRowSize()));
        }
        return new Pair((Object)rowNumber, (Object)PipeConfig.getInstance().getPipeDataStructureTabletSizeInBytes());
    }

    public static long calculateTabletSizeInBytes(Tablet tablet) {
        BitMap[] bitMaps;
        List timeseries;
        long totalSizeInBytes = 0L;
        if (tablet == null) {
            return totalSizeInBytes;
        }
        long[] timestamps = tablet.getTimestamps();
        Object[] tabletValues = tablet.getValues();
        if (timestamps != null) {
            totalSizeInBytes += (long)timestamps.length * 8L;
        }
        if ((timeseries = tablet.getSchemas()) != null) {
            for (int column = 0; column < timeseries.size(); ++column) {
                TSDataType tsDataType;
                IMeasurementSchema measurementSchema = (IMeasurementSchema)timeseries.get(column);
                if (measurementSchema == null || (tsDataType = measurementSchema.getType()) == null) continue;
                if (tsDataType.isBinary()) {
                    Binary[] values;
                    if (tabletValues == null || tabletValues.length <= column || (values = (Binary[])tabletValues[column]) == null) continue;
                    for (Binary value : values) {
                        totalSizeInBytes += value == null ? 0L : (long)(value.getLength() == -1 ? 0 : value.getLength());
                    }
                    continue;
                }
                totalSizeInBytes += (long)timestamps.length * (long)tsDataType.getDataTypeSize();
            }
        }
        if ((bitMaps = tablet.getBitMaps()) != null) {
            for (int i = 0; i < bitMaps.length; ++i) {
                totalSizeInBytes += bitMaps[i] == null ? 0L : (long)bitMaps[i].getSize();
            }
        }
        return totalSizeInBytes += 100L;
    }
}

