/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.visitor;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.ActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.BatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.CreateAlignedTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.CreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.CreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.InternalBatchActivateTemplateNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.InternalCreateMultiTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.InternalCreateTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.MeasurementGroup;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metadata.write.view.CreateLogicalViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;

public class PipePlanToStatementVisitor
extends PlanVisitor<Statement, Void> {
    @Override
    public Statement visitPlan(PlanNode node, Void context) {
        throw new UnsupportedOperationException(String.format("PipePlanToStatementVisitor does not support visiting general plan, PlanNode: %s", node));
    }

    @Override
    public InsertRowStatement visitInsertRow(InsertRowNode node, Void context) {
        InsertRowStatement statement = new InsertRowStatement();
        statement.setDevicePath(node.getTargetPath());
        statement.setTime(node.getTime());
        statement.setMeasurements(node.getMeasurements());
        statement.setDataTypes(node.getDataTypes());
        statement.setValues(node.getValues());
        statement.setNeedInferType(node.isNeedInferType());
        statement.setAligned(node.isAligned());
        statement.setMeasurementSchemas(node.getMeasurementSchemas());
        statement.setColumnCategories(node.getColumnCategories());
        return statement;
    }

    @Override
    public Statement visitRelationalInsertTablet(RelationalInsertTabletNode node, Void context) {
        return new InsertTabletStatement(node);
    }

    @Override
    public InsertTabletStatement visitInsertTablet(InsertTabletNode node, Void context) {
        return new InsertTabletStatement(node);
    }

    @Override
    public InsertRowsStatement visitInsertRows(InsertRowsNode node, Void context) {
        InsertRowsStatement statement = new InsertRowsStatement();
        statement.setInsertRowStatementList(node.getInsertRowNodeList().stream().map(insertRowNode -> this.visitInsertRow((InsertRowNode)insertRowNode, context)).collect(Collectors.toList()));
        return statement;
    }

    @Override
    public CreateTimeSeriesStatement visitCreateTimeSeries(CreateTimeSeriesNode node, Void context) {
        CreateTimeSeriesStatement statement = new CreateTimeSeriesStatement();
        statement.setPath(node.getPath());
        statement.setDataType(node.getDataType());
        statement.setEncoding(node.getEncoding());
        statement.setCompressor(node.getCompressor());
        statement.setProps(node.getProps());
        statement.setAttributes(node.getAttributes());
        statement.setAlias(node.getAlias());
        statement.setTags(node.getTags());
        return statement;
    }

    @Override
    public CreateAlignedTimeSeriesStatement visitCreateAlignedTimeSeries(CreateAlignedTimeSeriesNode node, Void context) {
        CreateAlignedTimeSeriesStatement statement = new CreateAlignedTimeSeriesStatement();
        statement.setDataTypes(node.getDataTypes());
        statement.setCompressors(node.getCompressors());
        statement.setEncodings(node.getEncodings());
        statement.setAttributesList(node.getAttributesList());
        statement.setAliasList(node.getAliasList());
        statement.setDevicePath(node.getDevicePath());
        statement.setMeasurements(node.getMeasurements());
        statement.setTagsList(node.getTagsList());
        return statement;
    }

    @Override
    public CreateMultiTimeSeriesStatement visitCreateMultiTimeSeries(CreateMultiTimeSeriesNode node, Void context) {
        CreateMultiTimeSeriesStatement statement = new CreateMultiTimeSeriesStatement();
        ArrayList<MeasurementPath> paths = new ArrayList<MeasurementPath>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        ArrayList<Map<String, String>> propsList = new ArrayList<Map<String, String>>();
        ArrayList<String> aliasList = new ArrayList<String>();
        ArrayList<Map<String, String>> tagsList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> attributesList = new ArrayList<Map<String, String>>();
        for (Map.Entry<PartialPath, MeasurementGroup> path2Group : node.getMeasurementGroupMap().entrySet()) {
            MeasurementGroup group = path2Group.getValue();
            dataTypes.addAll(Objects.nonNull(group.getDataTypes()) ? group.getDataTypes() : new ArrayList());
            encodings.addAll(Objects.nonNull(group.getEncodings()) ? group.getEncodings() : new ArrayList());
            compressors.addAll(Objects.nonNull(group.getCompressors()) ? group.getCompressors() : new ArrayList());
            propsList.addAll(Objects.nonNull(group.getPropsList()) ? group.getPropsList() : new ArrayList());
            aliasList.addAll(Objects.nonNull(group.getAliasList()) ? group.getAliasList() : new ArrayList());
            tagsList.addAll(Objects.nonNull(group.getTagsList()) ? group.getTagsList() : new ArrayList());
            attributesList.addAll(Objects.nonNull(group.getAttributesList()) ? group.getAttributesList() : new ArrayList());
            if (!Objects.nonNull(group.getMeasurements())) continue;
            for (int i = 0; i < group.getMeasurements().size(); ++i) {
                paths.add(path2Group.getKey().concatAsMeasurementPath(group.getMeasurements().get(i)));
            }
        }
        statement.setPaths(paths);
        statement.setDataTypes(dataTypes);
        statement.setEncodings(encodings);
        statement.setCompressors(compressors);
        statement.setPropsList(propsList.isEmpty() ? null : propsList);
        statement.setAliasList(aliasList.isEmpty() ? null : aliasList);
        statement.setTagsList(tagsList.isEmpty() ? null : tagsList);
        statement.setAttributesList(attributesList.isEmpty() ? null : attributesList);
        return statement;
    }

    @Override
    public AlterTimeSeriesStatement visitAlterTimeSeries(AlterTimeSeriesNode node, Void context) {
        AlterTimeSeriesStatement statement = new AlterTimeSeriesStatement();
        statement.setAlterMap(node.getAlterMap());
        statement.setAlterType(node.getAlterType());
        statement.setAttributesMap(node.getAttributesMap());
        statement.setAlias(node.getAlias());
        statement.setTagsMap(node.getTagsMap());
        statement.setPath(node.getPath());
        return statement;
    }

    @Override
    public InternalCreateTimeSeriesStatement visitInternalCreateTimeSeries(InternalCreateTimeSeriesNode node, Void context) {
        return new InternalCreateTimeSeriesStatement(node.getDevicePath(), node.getMeasurementGroup().getMeasurements(), node.getMeasurementGroup().getDataTypes(), node.getMeasurementGroup().getEncodings(), node.getMeasurementGroup().getCompressors(), node.isAligned());
    }

    @Override
    public ActivateTemplateStatement visitActivateTemplate(ActivateTemplateNode node, Void context) {
        ActivateTemplateStatement statement = new ActivateTemplateStatement();
        statement.setPath(node.getActivatePath());
        return statement;
    }

    @Override
    public BatchActivateTemplateStatement visitInternalBatchActivateTemplate(InternalBatchActivateTemplateNode node, Void context) {
        return new BatchActivateTemplateStatement(new ArrayList<PartialPath>(node.getTemplateActivationMap().keySet()));
    }

    @Override
    public InternalCreateMultiTimeSeriesStatement visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesNode node, Void context) {
        return new InternalCreateMultiTimeSeriesStatement(node.getDeviceMap());
    }

    @Override
    public BatchActivateTemplateStatement visitBatchActivateTemplate(BatchActivateTemplateNode node, Void context) {
        return new BatchActivateTemplateStatement(new ArrayList<PartialPath>(node.getTemplateActivationMap().keySet()));
    }

    @Override
    public CreateLogicalViewStatement visitCreateLogicalView(CreateLogicalViewNode node, Void context) {
        CreateLogicalViewStatement statement = new CreateLogicalViewStatement();
        statement.setTargetFullPaths(node.getViewPathList());
        statement.setViewExpressions(new ArrayList<ViewExpression>(node.getViewPathToSourceExpressionMap().values()));
        return statement;
    }

    @Override
    public DeleteDataStatement visitDeleteData(DeleteDataNode node, Void context) {
        DeleteDataStatement statement = new DeleteDataStatement();
        statement.setDeleteEndTime(node.getDeleteEndTime());
        statement.setDeleteStartTime(node.getDeleteStartTime());
        statement.setPathList(node.getPathList());
        return statement;
    }
}

