/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.parser.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.read.ReadProcessException;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.query.executor.TableQueryExecutor;
import org.apache.tsfile.read.reader.block.TsBlockReader;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class TsFileInsertionEventTableParserTabletIterator
implements Iterator<Tablet> {
    private final String tableName;
    private final long startTime;
    private final long endTime;
    private final List<IMeasurementSchema> columnSchemas;
    private final List<Tablet.ColumnCategory> columnTypes;
    private final List<String> columnNames;
    private final TsBlockReader tsBlockReader;

    public TsFileInsertionEventTableParserTabletIterator(TableQueryExecutor tableQueryExecutor, String tableName, TableSchema tableSchema, long startTime, long endTime) {
        this.tableName = tableName;
        this.startTime = startTime;
        this.endTime = endTime;
        this.columnSchemas = new ArrayList<IMeasurementSchema>();
        this.columnTypes = new ArrayList<Tablet.ColumnCategory>();
        this.columnNames = new ArrayList<String>();
        try {
            int size = tableSchema.getColumnSchemas().size();
            for (int i = 0; i < size; ++i) {
                IMeasurementSchema schema = (IMeasurementSchema)tableSchema.getColumnSchemas().get(i);
                if (schema.getMeasurementName() == null || schema.getMeasurementName().isEmpty()) continue;
                this.columnSchemas.add(schema);
                this.columnTypes.add((Tablet.ColumnCategory)tableSchema.getColumnTypes().get(i));
                this.columnNames.add(schema.getMeasurementName());
            }
            this.tsBlockReader = tableQueryExecutor.query(tableName, this.columnNames, null, null, null);
        }
        catch (ReadProcessException e) {
            throw new PipeException("Failed to build query data set", (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.tsBlockReader.hasNext();
    }

    @Override
    public Tablet next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return this.buildNextTablet();
        }
        catch (IOException e) {
            throw new PipeException("Failed to build tablet", (Throwable)e);
        }
    }

    private Tablet buildNextTablet() throws IOException {
        TsBlock tsBlock = this.tsBlockReader.next();
        ArrayList measurementList = new ArrayList(this.columnSchemas.size());
        ArrayList dataTypeList = new ArrayList(this.columnSchemas.size());
        this.columnSchemas.forEach(columnSchema -> {
            measurementList.add(columnSchema.getMeasurementName());
            dataTypeList.add(columnSchema.getType());
        });
        Tablet tablet = new Tablet(this.tableName, measurementList, dataTypeList, this.columnTypes, tsBlock.getPositionCount());
        tablet.initBitMaps();
        boolean isAllNull = true;
        TsBlock.TsBlockRowIterator rowIterator = tsBlock.getTsBlockRowIterator();
        while (rowIterator.hasNext()) {
            Object[] row = rowIterator.next();
            long timestamp = (Long)row[row.length - 1];
            if (timestamp < this.startTime || timestamp > this.endTime) continue;
            int rowIndex = tablet.getRowSize();
            tablet.addTimestamp(rowIndex, timestamp);
            int fieldSize = row.length - 1;
            for (int i = 0; i < fieldSize; ++i) {
                Object value = this.columnSchemas.get(i).getType() != TSDataType.DATE || row[i] == null ? row[i] : DateUtils.parseIntToLocalDate((int)((Integer)row[i]));
                tablet.addValue(this.columnNames.get(i), rowIndex, value);
                if (value == null || this.columnTypes.get(i) != Tablet.ColumnCategory.FIELD) continue;
                isAllNull = false;
            }
        }
        if (isAllNull) {
            tablet.setRowSize(0);
        }
        return tablet;
    }
}

