/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.parser;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.TsFileInsertionEventParser;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.query.TsFileInsertionEventQueryParser;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.scan.TsFileInsertionEventScanParser;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.table.TsFileInsertionEventTableParser;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.tsfile.file.metadata.IDeviceID;

public class TsFileInsertionEventParserProvider {
    private final File tsFile;
    private final TreePattern treePattern;
    private final TablePattern tablePattern;
    private final long startTime;
    private final long endTime;
    protected final PipeTaskMeta pipeTaskMeta;
    protected final PipeTsFileInsertionEvent sourceEvent;

    public TsFileInsertionEventParserProvider(File tsFile, TreePattern treePattern, TablePattern tablePattern, long startTime, long endTime, PipeTaskMeta pipeTaskMeta, PipeTsFileInsertionEvent sourceEvent) {
        this.tsFile = tsFile;
        this.treePattern = treePattern;
        this.tablePattern = tablePattern;
        this.startTime = startTime;
        this.endTime = endTime;
        this.pipeTaskMeta = pipeTaskMeta;
        this.sourceEvent = sourceEvent;
    }

    public TsFileInsertionEventParser provide() throws IOException {
        if (this.sourceEvent.isTableModelEvent()) {
            return new TsFileInsertionEventTableParser(this.tsFile, this.tablePattern, this.startTime, this.endTime, this.pipeTaskMeta, (PipeInsertionEvent)this.sourceEvent);
        }
        if (this.startTime != Long.MIN_VALUE || this.endTime != Long.MAX_VALUE || this.treePattern instanceof IoTDBTreePattern && !((IoTDBTreePattern)this.treePattern).mayMatchMultipleTimeSeriesInOneDevice()) {
            return new TsFileInsertionEventQueryParser(this.tsFile, this.treePattern, this.startTime, this.endTime, this.pipeTaskMeta, (PipeInsertionEvent)this.sourceEvent);
        }
        Map<IDeviceID, Boolean> deviceIsAlignedMap = PipeDataNodeResourceManager.tsfile().getDeviceIsAlignedMapFromCache(this.tsFile, false);
        if (Objects.isNull(deviceIsAlignedMap)) {
            return new TsFileInsertionEventScanParser(this.tsFile, this.treePattern, this.startTime, this.endTime, this.pipeTaskMeta, (PipeInsertionEvent)this.sourceEvent);
        }
        int originalSize = deviceIsAlignedMap.size();
        Map<IDeviceID, Boolean> filteredDeviceIsAlignedMap = this.filterDeviceIsAlignedMapByPattern(deviceIsAlignedMap);
        return (double)filteredDeviceIsAlignedMap.size() / (double)originalSize > PipeConfig.getInstance().getPipeTsFileScanParsingThreshold() ? new TsFileInsertionEventScanParser(this.tsFile, this.treePattern, this.startTime, this.endTime, this.pipeTaskMeta, (PipeInsertionEvent)this.sourceEvent) : new TsFileInsertionEventQueryParser(this.tsFile, this.treePattern, this.startTime, this.endTime, this.pipeTaskMeta, this.sourceEvent, filteredDeviceIsAlignedMap);
    }

    private Map<IDeviceID, Boolean> filterDeviceIsAlignedMapByPattern(Map<IDeviceID, Boolean> deviceIsAlignedMap) {
        if (Objects.isNull(this.treePattern) || this.treePattern.isRoot()) {
            return deviceIsAlignedMap;
        }
        return deviceIsAlignedMap.entrySet().stream().filter(entry -> {
            IDeviceID deviceId = (IDeviceID)entry.getKey();
            return this.treePattern.coversDevice(deviceId) || this.treePattern.mayOverlapWithDevice(deviceId);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

