/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.resource.ref.PipePhantomReferenceManager;
import org.apache.iotdb.db.pipe.event.ReferenceTrackableEvent;
import org.apache.iotdb.db.pipe.event.common.PipeInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.aggregator.TsFileInsertionPointCounter;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.TsFileInsertionEventParser;
import org.apache.iotdb.db.pipe.event.common.tsfile.parser.TsFileInsertionEventParserProvider;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.assigner.PipeTimePartitionProgressIndexKeeper;
import org.apache.iotdb.db.pipe.metric.PipeDataNodeRemainingEventAndTimeMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.iotdb.db.pipe.resource.tsfile.PipeTsFileResourceManager;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTsFileInsertionEvent
extends PipeInsertionEvent
implements TsFileInsertionEvent,
ReferenceTrackableEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTsFileInsertionEvent.class);
    private static final String TREE_MODEL_EVENT_TABLE_NAME_PREFIX = "root.";
    private final TsFileResource resource;
    private File tsFile;
    private boolean isWithMod;
    private File modFile;
    private File sharedModFile;
    private final boolean isLoaded;
    private final boolean isGeneratedByPipe;
    private final boolean isGeneratedByPipeConsensus;
    private final boolean isGeneratedByHistoricalExtractor;
    private final AtomicBoolean isClosed;
    private TsFileInsertionEventParser eventParser;
    private long flushPointCount = -1L;
    private volatile ProgressIndex overridingProgressIndex;

    public PipeTsFileInsertionEvent(String databaseName, TsFileResource resource, boolean isLoaded, boolean isGeneratedByPipe, boolean isGeneratedByHistoricalExtractor) {
        this(null, databaseName, resource, true, isLoaded, isGeneratedByPipe, isGeneratedByHistoricalExtractor, null, 0L, null, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PipeTsFileInsertionEvent(Boolean isTableModelEvent, String databaseName, TsFileResource resource, boolean isWithMod, boolean isLoaded, boolean isGeneratedByPipe, boolean isGeneratedByHistoricalExtractor, String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, long startTime, long endTime) {
        super(pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, startTime, endTime, isTableModelEvent, databaseName);
        TsFileProcessor processor;
        this.resource = resource;
        this.tsFile = resource.getTsFile();
        this.isWithMod = isWithMod && resource.anyModFileExists();
        this.modFile = this.isWithMod ? resource.getExclusiveModFile().getFile() : null;
        this.sharedModFile = resource.getSharedModFile() != null ? resource.getSharedModFile().getFile() : null;
        this.isLoaded = isLoaded;
        this.isGeneratedByPipe = isGeneratedByPipe;
        this.isGeneratedByPipeConsensus = resource.isGeneratedByPipeConsensus();
        this.isGeneratedByHistoricalExtractor = isGeneratedByHistoricalExtractor;
        this.isClosed = new AtomicBoolean(resource.isClosed());
        if (!this.isClosed.get() && (processor = resource.getProcessor()) != null) {
            processor.addCloseFileListener(o -> {
                AtomicBoolean atomicBoolean = this.isClosed;
                synchronized (atomicBoolean) {
                    this.isClosed.set(true);
                    this.isClosed.notifyAll();
                    this.flushPointCount = processor.getMemTableFlushPointCount();
                }
            });
        }
        this.isClosed.set(resource.isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTsFileClose() throws InterruptedException {
        if (!this.isClosed.get()) {
            this.isClosed.set(this.resource.isClosed());
            AtomicBoolean atomicBoolean = this.isClosed;
            synchronized (atomicBoolean) {
                while (!this.isClosed.get()) {
                    this.isClosed.wait(100L);
                    boolean isClosedNow = this.resource.isClosed();
                    if (!isClosedNow) continue;
                    this.isClosed.set(true);
                    this.isClosed.notifyAll();
                    TsFileProcessor processor = this.resource.getProcessor();
                    if (processor == null) break;
                    this.flushPointCount = processor.getMemTableFlushPointCount();
                    break;
                }
            }
        }
        return !this.resource.isEmpty();
    }

    public File getTsFile() {
        return this.tsFile;
    }

    public File getModFile() {
        return this.modFile;
    }

    public File getSharedModFile() {
        return this.sharedModFile;
    }

    public boolean isWithMod() {
        return this.isWithMod;
    }

    public void disableMod4NonTransferPipes(boolean isWithMod) {
        this.isWithMod = isWithMod && this.isWithMod;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public long getFileStartTime() {
        return this.resource.getFileStartTime();
    }

    public long getFlushPointCount() {
        return this.flushPointCount;
    }

    public long getTimePartitionId() {
        return this.resource.getTimePartition();
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        try {
            this.tsFile = PipeDataNodeResourceManager.tsfile().increaseFileReference(this.tsFile, true, this.resource);
            if (this.isWithMod) {
                this.modFile = PipeDataNodeResourceManager.tsfile().increaseFileReference(this.modFile, false, null);
            }
            if (Objects.nonNull(this.pipeName)) {
                PipeDataNodeRemainingEventAndTimeMetrics.getInstance().increaseTsFileEventCount(this.pipeName, this.creationTime);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Increase reference count for TsFile %s or modFile %s error. Holder Message: %s", this.tsFile, this.modFile, holderMessage), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        try {
            PipeDataNodeResourceManager.tsfile().decreaseFileReference(this.tsFile);
            if (this.isWithMod) {
                PipeDataNodeResourceManager.tsfile().decreaseFileReference(this.modFile);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Decrease reference count for TsFile %s error. Holder Message: %s", this.tsFile.getPath(), holderMessage), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (Objects.nonNull(this.pipeName)) {
                PipeDataNodeRemainingEventAndTimeMetrics.getInstance().decreaseTsFileEventCount(this.pipeName, this.creationTime);
            }
        }
    }

    public void bindProgressIndex(ProgressIndex overridingProgressIndex) {
        this.overridingProgressIndex = overridingProgressIndex;
    }

    public ProgressIndex getProgressIndex() {
        try {
            if (!this.waitForTsFileClose()) {
                LOGGER.warn("Skipping temporary TsFile {}'s progressIndex, will report MinimumProgressIndex", (Object)this.tsFile);
                return MinimumProgressIndex.INSTANCE;
            }
            if (Objects.nonNull(this.overridingProgressIndex)) {
                return this.overridingProgressIndex;
            }
            return this.resource.getMaxProgressIndexAfterClose();
        }
        catch (InterruptedException e) {
            LOGGER.warn(String.format("Interrupted when waiting for closing TsFile %s.", this.resource.getTsFilePath()));
            Thread.currentThread().interrupt();
            return MinimumProgressIndex.INSTANCE;
        }
    }

    protected void reportProgress() {
        super.reportProgress();
        this.eliminateProgressIndex();
    }

    public void eliminateProgressIndex() {
        if (Objects.isNull(this.overridingProgressIndex)) {
            PipeTimePartitionProgressIndexKeeper.getInstance().eliminateProgressIndex(this.resource.getDataRegionId(), this.resource.getTimePartition(), this.resource.getMaxProgressIndexAfterClose());
        }
    }

    public PipeTsFileInsertionEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, long startTime, long endTime) {
        return new PipeTsFileInsertionEvent(this.getRawIsTableModelEvent(), this.getTreeModelDatabaseName(), this.resource, this.isWithMod, this.isLoaded, this.isGeneratedByPipe, this.isGeneratedByHistoricalExtractor, pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, startTime, endTime);
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        return this.isClosed.get() ? this.startTime <= this.resource.getFileEndTime() && this.resource.getFileStartTime() <= this.endTime : this.resource.getFileStartTime() <= this.endTime;
    }

    public boolean mayEventPathsOverlappedWithPattern() {
        if (!this.resource.isClosed()) {
            return true;
        }
        try {
            Map<IDeviceID, Boolean> deviceIsAlignedMap = PipeDataNodeResourceManager.tsfile().getDeviceIsAlignedMapFromCache(PipeTsFileResourceManager.getHardlinkOrCopiedFileInPipeDir(this.resource.getTsFile()), false);
            Set<IDeviceID> deviceSet = Objects.nonNull(deviceIsAlignedMap) ? deviceIsAlignedMap.keySet() : this.resource.getDevices();
            return deviceSet.stream().anyMatch(deviceID -> {
                if (deviceID instanceof PlainDeviceID || deviceID.getTableName().startsWith(TREE_MODEL_EVENT_TABLE_NAME_PREFIX) || deviceID.getTableName().equals("root")) {
                    this.markAsTreeModelEvent();
                    return this.treePattern.mayOverlapWithDevice(deviceID);
                }
                this.markAsTableModelEvent();
                return true;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Pipe {}: failed to get devices from TsFile {}, extract it anyway", new Object[]{this.pipeName, this.resource.getTsFilePath(), e});
            return true;
        }
    }

    @Override
    public boolean isTableModelEvent() {
        if (this.getRawIsTableModelEvent() == null) {
            try {
                Map<IDeviceID, Boolean> deviceIsAlignedMap = PipeDataNodeResourceManager.tsfile().getDeviceIsAlignedMapFromCache(PipeTsFileResourceManager.getHardlinkOrCopiedFileInPipeDir(this.resource.getTsFile()), false);
                Set<IDeviceID> deviceSet = Objects.nonNull(deviceIsAlignedMap) ? deviceIsAlignedMap.keySet() : this.resource.getDevices();
                Iterator<IDeviceID> iterator = deviceSet.iterator();
                if (iterator.hasNext()) {
                    IDeviceID deviceID = iterator.next();
                    if (deviceID instanceof PlainDeviceID || deviceID.getTableName().startsWith(TREE_MODEL_EVENT_TABLE_NAME_PREFIX) || deviceID.getTableName().equals("root")) {
                        this.markAsTreeModelEvent();
                    } else {
                        this.markAsTableModelEvent();
                    }
                }
            }
            catch (Exception e) {
                throw new PipeException(String.format("Pipe %s: failed to judge whether TsFile %s is table model or tree model", this.pipeName, this.resource.getTsFilePath()), (Throwable)e);
            }
        }
        return this.getRawIsTableModelEvent();
    }

    public Iterable<TabletInsertionEvent> toTabletInsertionEvents() throws PipeException {
        return this.toTabletInsertionEvents(Long.MAX_VALUE);
    }

    public Iterable<TabletInsertionEvent> toTabletInsertionEvents(long timeoutMs) throws PipeException {
        try {
            if (!this.waitForTsFileClose()) {
                LOGGER.warn("Pipe skipping temporary TsFile's parsing which shouldn't be transferred: {}", (Object)this.tsFile);
                return Collections.emptyList();
            }
            this.waitForResourceEnough4Parsing(timeoutMs);
            return this.initEventParser().toTabletInsertionEvents();
        }
        catch (Exception e) {
            this.close();
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String errorMsg = e instanceof InterruptedException ? String.format("Interrupted when waiting for closing TsFile %s.", this.resource.getTsFilePath()) : String.format("Parse TsFile %s error. Because: %s", this.resource.getTsFilePath(), e.getMessage());
            LOGGER.warn(errorMsg, (Throwable)e);
            throw new PipeException(errorMsg);
        }
    }

    private void waitForResourceEnough4Parsing(long timeoutMs) throws InterruptedException {
        long currentTime;
        long startTime;
        PipeMemoryManager memoryManager = PipeDataNodeResourceManager.memory();
        if (memoryManager.isEnough4TabletParsing()) {
            return;
        }
        long lastRecordTime = startTime = System.currentTimeMillis();
        long memoryCheckIntervalMs = PipeConfig.getInstance().getPipeTsFileParserCheckMemoryEnoughIntervalMs();
        while (!memoryManager.isEnough4TabletParsing()) {
            Thread.sleep(memoryCheckIntervalMs);
            currentTime = System.currentTimeMillis();
            double elapsedRecordTimeSeconds = (double)(currentTime - lastRecordTime) / 1000.0;
            double waitTimeSeconds = (double)(currentTime - startTime) / 1000.0;
            if (elapsedRecordTimeSeconds > 10.0) {
                LOGGER.info("Wait for resource enough for parsing {} for {} seconds.", (Object)(this.resource != null ? this.resource.getTsFilePath() : "tsfile"), (Object)waitTimeSeconds);
                lastRecordTime = currentTime;
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Wait for resource enough for parsing {} for {} seconds.", (Object)(this.resource != null ? this.resource.getTsFilePath() : "tsfile"), (Object)waitTimeSeconds);
            }
            if (!(waitTimeSeconds * 1000.0 > (double)timeoutMs)) continue;
            throw new PipeException(String.format("TimeoutException: Waited %s seconds", waitTimeSeconds));
        }
        currentTime = System.currentTimeMillis();
        double waitTimeSeconds = (double)(currentTime - startTime) / 1000.0;
        LOGGER.info("Wait for resource enough for parsing {} for {} seconds.", (Object)(this.resource != null ? this.resource.getTsFilePath() : "tsfile"), (Object)waitTimeSeconds);
    }

    public boolean isGeneratedByPipeConsensus() {
        return this.isGeneratedByPipeConsensus;
    }

    public boolean isGeneratedByHistoricalExtractor() {
        return this.isGeneratedByHistoricalExtractor;
    }

    private TsFileInsertionEventParser initEventParser() {
        try {
            if (this.eventParser == null) {
                this.eventParser = new TsFileInsertionEventParserProvider(this.tsFile, this.treePattern, this.tablePattern, this.startTime, this.endTime, this.pipeTaskMeta, this).provide();
            }
            return this.eventParser;
        }
        catch (IOException e) {
            this.close();
            String errorMsg = String.format("Read TsFile %s error.", this.resource.getTsFilePath());
            LOGGER.warn(errorMsg, (Throwable)e);
            throw new PipeException(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(boolean skipReportOnCommit) throws IOException {
        long count = 0L;
        if (this.shouldParseTime()) {
            try {
                for (TabletInsertionEvent event : this.toTabletInsertionEvents()) {
                    PipeRawTabletInsertionEvent rawEvent = (PipeRawTabletInsertionEvent)event;
                    count += rawEvent.count();
                    if (!skipReportOnCommit) continue;
                    rawEvent.skipReportOnCommit();
                }
                long l = count;
                return l;
            }
            finally {
                this.close();
            }
        }
        try (TsFileInsertionPointCounter counter = new TsFileInsertionPointCounter(this.tsFile, this.treePattern);){
            long l = counter.count();
            return l;
        }
    }

    public void close() {
        if (this.eventParser != null) {
            this.eventParser.close();
            this.eventParser = null;
        }
    }

    public String toString() {
        return String.format("PipeTsFileInsertionEvent{resource=%s, tsFile=%s, isLoaded=%s, isGeneratedByPipe=%s, isClosed=%s, eventParser=%s}", this.resource, this.tsFile, this.isLoaded, this.isGeneratedByPipe, this.isClosed.get(), this.eventParser) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeTsFileInsertionEvent{resource=%s, tsFile=%s, isLoaded=%s, isGeneratedByPipe=%s, isClosed=%s}", this.resource, this.tsFile, this.isLoaded, this.isGeneratedByPipe, this.isClosed.get()) + " - " + super.coreReportMessage();
    }

    public void trackResource() {
        PipeDataNodeResourceManager.ref().trackPipeEventResource((EnrichedEvent)this, this.eventResourceBuilder());
    }

    @Override
    public PipePhantomReferenceManager.PipeEventResource eventResourceBuilder() {
        return new PipeTsFileInsertionEventResource(this.isReleased, this.referenceCount, this.tsFile, this.isWithMod, this.modFile, this.sharedModFile);
    }

    private static class PipeTsFileInsertionEventResource
    extends PipePhantomReferenceManager.PipeEventResource {
        private final File tsFile;
        private final boolean isWithMod;
        private final File modFile;
        private final File sharedModFile;

        private PipeTsFileInsertionEventResource(AtomicBoolean isReleased, AtomicInteger referenceCount, File tsFile, boolean isWithMod, File modFile, File sharedModFile) {
            super(isReleased, referenceCount);
            this.tsFile = tsFile;
            this.isWithMod = isWithMod;
            this.modFile = modFile;
            this.sharedModFile = sharedModFile;
        }

        protected void finalizeResource() {
            try {
                PipeDataNodeResourceManager.tsfile().decreaseFileReference(this.tsFile);
                if (this.isWithMod) {
                    PipeDataNodeResourceManager.tsfile().decreaseFileReference(this.modFile);
                }
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Decrease reference count for TsFile %s error.", this.tsFile.getPath()), (Throwable)e);
            }
        }
    }
}

