/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.deletion;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.SerializableEvent;
import org.apache.iotdb.db.pipe.consensus.deletion.DeletionResource;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.AbstractDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeDeleteDataNodeEvent
extends EnrichedEvent
implements SerializableEvent {
    private AbstractDeleteDataNode deleteDataNode;
    private DeletionResource deletionResource;
    private boolean isGeneratedByPipe;
    private ProgressIndex progressIndex;

    public PipeDeleteDataNodeEvent() {
        this(null, false);
    }

    public PipeDeleteDataNodeEvent(AbstractDeleteDataNode deleteDataNode, boolean isGeneratedByPipe) {
        this(deleteDataNode, null, 0L, null, null, null, isGeneratedByPipe);
    }

    public PipeDeleteDataNodeEvent(AbstractDeleteDataNode deleteDataNode, String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, boolean isGeneratedByPipe) {
        super(pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, Long.MIN_VALUE, Long.MAX_VALUE);
        this.isGeneratedByPipe = isGeneratedByPipe;
        this.deleteDataNode = deleteDataNode;
        Optional.ofNullable(deleteDataNode).ifPresent(node -> {
            this.progressIndex = deleteDataNode.getProgressIndex();
        });
    }

    public AbstractDeleteDataNode getDeleteDataNode() {
        return this.deleteDataNode;
    }

    public DeletionResource getDeletionResource() {
        return this.deletionResource;
    }

    public void setDeletionResource(DeletionResource deletionResource) {
        this.deletionResource = deletionResource;
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        return true;
    }

    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        return true;
    }

    public void onCommitted() {
        super.onCommitted();
        if (this.deletionResource != null) {
            this.deletionResource.decreaseReference();
        }
    }

    public ProgressIndex getProgressIndex() {
        return this.progressIndex == null ? MinimumProgressIndex.INSTANCE : this.progressIndex;
    }

    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, long startTime, long endTime) {
        return new PipeDeleteDataNodeEvent(this.deleteDataNode, pipeName, creationTime, pipeTaskMeta, treePattern, tablePattern, this.isGeneratedByPipe);
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        return true;
    }

    public boolean mayEventPathsOverlappedWithPattern() {
        return true;
    }

    public ByteBuffer serializeToByteBuffer() {
        ByteBuffer planBuffer = this.deleteDataNode.serializeToByteBuffer();
        ByteBuffer result = ByteBuffer.allocate(1 + planBuffer.limit());
        ReadWriteIOUtils.write((Boolean)this.isGeneratedByPipe, (ByteBuffer)result);
        result.put(planBuffer);
        return result;
    }

    public void deserializeFromByteBuffer(ByteBuffer buffer) {
        this.isGeneratedByPipe = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        this.deleteDataNode = (DeleteDataNode)PlanNodeType.deserialize(buffer);
        this.progressIndex = this.deleteDataNode.getProgressIndex();
    }

    public static PipeDeleteDataNodeEvent deserialize(ByteBuffer buffer) {
        PipeDeleteDataNodeEvent event = new PipeDeleteDataNodeEvent();
        event.deserializeFromByteBuffer(buffer);
        return event;
    }

    public String toString() {
        return String.format("PipDeleteDataNodeEvent{progressIndex=%s, isGeneratedByPipe=%s}", this.progressIndex, this.isGeneratedByPipe) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeDeleteDataNodeEvent{progressIndex=%s, isGeneratedByPipe=%s}", this.progressIndex, this.isGeneratedByPipe) + " - " + super.coreReportMessage();
    }
}

