/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.util.sorter;

import java.time.LocalDate;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class PipeTabletEventSorter {
    public static Object reorderValueList(int deduplicatedSize, Object valueList, TSDataType dataType, Integer[] index) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                boolean[] deduplicatedBoolValues = new boolean[boolValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedBoolValues[i] = boolValues[index[i]];
                }
                return deduplicatedBoolValues;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                int[] deduplicatedIntValues = new int[intValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedIntValues[i] = intValues[index[i]];
                }
                return deduplicatedIntValues;
            }
            case DATE: {
                LocalDate[] dateValues = (LocalDate[])valueList;
                LocalDate[] deduplicatedDateValues = new LocalDate[dateValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedDateValues[i] = dateValues[index[i]];
                }
                return deduplicatedDateValues;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longValues = (long[])valueList;
                long[] deduplicatedLongValues = new long[longValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedLongValues[i] = longValues[index[i]];
                }
                return deduplicatedLongValues;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                float[] deduplicatedFloatValues = new float[floatValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedFloatValues[i] = floatValues[index[i]];
                }
                return deduplicatedFloatValues;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                double[] deduplicatedDoubleValues = new double[doubleValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedDoubleValues[i] = doubleValues[index[i]];
                }
                return deduplicatedDoubleValues;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])valueList;
                Binary[] deduplicatedBinaryValues = new Binary[binaryValues.length];
                for (int i = 0; i < deduplicatedSize; ++i) {
                    deduplicatedBinaryValues[i] = binaryValues[index[i]];
                }
                return deduplicatedBinaryValues;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
    }

    public static BitMap reorderBitMap(int deduplicatedSize, BitMap bitMap, Integer[] index) {
        BitMap deduplicatedBitMap = new BitMap(bitMap.getSize());
        for (int i = 0; i < deduplicatedSize; ++i) {
            if (!bitMap.isMarked(index[i].intValue())) continue;
            deduplicatedBitMap.mark(i);
        }
        return deduplicatedBitMap;
    }
}

