/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.opcua;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.config.constant.PipeConnectorConstant;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.pipe.connector.protocol.opcua.OpcUaNameSpace;
import org.apache.iotdb.db.pipe.connector.protocol.opcua.OpcUaServerBuilder;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcUaConnector
implements PipeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcUaConnector.class);
    private static final Map<String, Pair<AtomicInteger, OpcUaNameSpace>> SERVER_KEY_TO_REFERENCE_COUNT_AND_NAME_SPACE_MAP = new ConcurrentHashMap<String, Pair<AtomicInteger, OpcUaNameSpace>>();
    private String serverKey;
    private OpcUaNameSpace nameSpace;

    public void validate(PipeParameterValidator validator) throws Exception {
        validator.validateAttributeValueRange("connector.opcua.model", true, new String[]{"client-server", "pub-sub"}).validateAttributeValueRange("sink.opcua.model", true, new String[]{"client-server", "pub-sub"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        int tcpBindPort = parameters.getIntOrDefault(Arrays.asList("connector.opcua.tcp.port", "sink.opcua.tcp.port"), 12686);
        int httpsBindPort = parameters.getIntOrDefault(Arrays.asList("connector.opcua.https.port", "sink.opcua.https.port"), 8443);
        String user = parameters.getStringOrDefault(Arrays.asList("connector.user", "sink.user", "connector.username", "sink.username"), "root");
        String password = parameters.getStringOrDefault(Arrays.asList("connector.password", "sink.password"), "root");
        String securityDir = IoTDBConfig.addDataHomeDir(parameters.getStringOrDefault(Arrays.asList("connector.opcua.security.dir", "sink.opcua.security.dir"), PipeConnectorConstant.CONNECTOR_OPC_UA_SECURITY_DIR_DEFAULT_VALUE + File.separatorChar + httpsBindPort + "_" + tcpBindPort));
        boolean enableAnonymousAccess = parameters.getBooleanOrDefault(Arrays.asList("connector.opcua.enable-anonymous-access", "sink.opcua.enable-anonymous-access"), true);
        String placeHolder = parameters.getStringOrDefault(Arrays.asList("connector.opcua.placeholder", "sink.opcua.placeholder"), "null");
        Map<String, Pair<AtomicInteger, OpcUaNameSpace>> map = SERVER_KEY_TO_REFERENCE_COUNT_AND_NAME_SPACE_MAP;
        synchronized (map) {
            this.serverKey = httpsBindPort + ":" + tcpBindPort;
            this.nameSpace = (OpcUaNameSpace)((Object)SERVER_KEY_TO_REFERENCE_COUNT_AND_NAME_SPACE_MAP.compute(this.serverKey, (key, oldValue) -> {
                try {
                    if (Objects.isNull(oldValue)) {
                        OpcUaServerBuilder builder = new OpcUaServerBuilder().setTcpBindPort(tcpBindPort).setHttpsBindPort(httpsBindPort).setUser(user).setPassword(password).setSecurityDir(securityDir).setEnableAnonymousAccess(enableAnonymousAccess);
                        OpcUaServer newServer = builder.build();
                        DataRegion region = StorageEngine.getInstance().getDataRegion(new DataRegionId(configuration.getRuntimeEnvironment().getRegionId()));
                        this.nameSpace = new OpcUaNameSpace(newServer, parameters.getStringOrDefault(Arrays.asList("connector.opcua.model", "sink.opcua.model"), "pub-sub").equals("client-server"), builder, Objects.nonNull(region) ? region.getDatabaseName() : "root.__temp_db", placeHolder);
                        this.nameSpace.startup();
                        newServer.startup().get();
                        return new Pair((Object)new AtomicInteger(0), (Object)this.nameSpace);
                    }
                    ((OpcUaNameSpace)((Object)((Object)oldValue.getRight()))).checkEquals(user, password, securityDir, enableAnonymousAccess);
                    return oldValue;
                }
                catch (PipeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PipeException("Failed to build and startup OpcUaServer", (Throwable)e);
                }
            }).getRight());
            ((AtomicInteger)SERVER_KEY_TO_REFERENCE_COUNT_AND_NAME_SPACE_MAP.get(this.serverKey).getLeft()).incrementAndGet();
        }
    }

    public void handshake() throws Exception {
    }

    public void heartbeat() throws Exception {
    }

    public void transfer(Event event) throws Exception {
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("OpcUaConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Ignore {}.", (Object)tabletInsertionEvent);
            return;
        }
        if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            this.transferTabletWrapper((PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent);
        } else {
            this.transferTabletWrapper((PipeRawTabletInsertionEvent)tabletInsertionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferTabletWrapper(PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent) throws UaException {
        if (!pipeInsertNodeTabletInsertionEvent.increaseReferenceCount(OpcUaConnector.class.getName())) {
            return;
        }
        try {
            for (Tablet tablet : pipeInsertNodeTabletInsertionEvent.convertToTablets()) {
                this.nameSpace.transfer(tablet, pipeInsertNodeTabletInsertionEvent.isTableModelEvent());
            }
        }
        finally {
            pipeInsertNodeTabletInsertionEvent.decreaseReferenceCount(OpcUaConnector.class.getName(), false);
        }
    }

    private void transferTabletWrapper(PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent) throws UaException {
        if (!pipeRawTabletInsertionEvent.increaseReferenceCount(OpcUaConnector.class.getName())) {
            return;
        }
        try {
            this.nameSpace.transfer(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isTableModelEvent());
        }
        finally {
            pipeRawTabletInsertionEvent.decreaseReferenceCount(OpcUaConnector.class.getName(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (this.serverKey == null) {
            return;
        }
        Map<String, Pair<AtomicInteger, OpcUaNameSpace>> map = SERVER_KEY_TO_REFERENCE_COUNT_AND_NAME_SPACE_MAP;
        synchronized (map) {
            Pair<AtomicInteger, OpcUaNameSpace> pair = SERVER_KEY_TO_REFERENCE_COUNT_AND_NAME_SPACE_MAP.get(this.serverKey);
            if (pair == null) {
                return;
            }
            if (((AtomicInteger)pair.getLeft()).decrementAndGet() <= 0) {
                try {
                    ((OpcUaNameSpace)((Object)pair.getRight())).shutdown();
                }
                finally {
                    SERVER_KEY_TO_REFERENCE_COUNT_AND_NAME_SPACE_MAP.remove(this.serverKey);
                }
            }
        }
    }
}

