/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.batch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.batch.PipeTabletEventBatch;
import org.apache.iotdb.db.pipe.connector.util.builder.PipeTableModeTsFileBuilder;
import org.apache.iotdb.db.pipe.connector.util.builder.PipeTreeModelTsFileBuilder;
import org.apache.iotdb.db.pipe.connector.util.builder.PipeTsFileBuilder;
import org.apache.iotdb.db.pipe.connector.util.sorter.PipeTableModelTabletEventSorter;
import org.apache.iotdb.db.pipe.connector.util.sorter.PipeTreeModelTabletEventSorter;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryWeightUtil;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTabletEventTsFileBatch
extends PipeTabletEventBatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTabletEventTsFileBatch.class);
    private static final AtomicLong BATCH_ID_GENERATOR = new AtomicLong(0L);
    private final AtomicLong currentBatchId = new AtomicLong(BATCH_ID_GENERATOR.incrementAndGet());
    private final long maxSizeInBytes;
    private final PipeTsFileBuilder treeModeTsFileBuilder;
    private final PipeTsFileBuilder tableModeTsFileBuilder;
    private final Map<Pair<String, Long>, Double> pipeName2WeightMap = new HashMap<Pair<String, Long>, Double>();

    public PipeTabletEventTsFileBatch(int maxDelayInMs, long requestMaxBatchSizeInBytes) {
        super(maxDelayInMs);
        this.maxSizeInBytes = requestMaxBatchSizeInBytes;
        AtomicLong tsFileIdGenerator = new AtomicLong(0L);
        this.treeModeTsFileBuilder = new PipeTreeModelTsFileBuilder(this.currentBatchId, tsFileIdGenerator);
        this.tableModeTsFileBuilder = new PipeTableModeTsFileBuilder(this.currentBatchId, tsFileIdGenerator);
    }

    @Override
    protected boolean constructBatch(TabletInsertionEvent event) {
        if (event instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent insertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)event;
            boolean isTableModel = insertNodeTabletInsertionEvent.isTableModelEvent();
            List<Tablet> tablets = insertNodeTabletInsertionEvent.convertToTablets();
            for (int i = 0; i < tablets.size(); ++i) {
                Tablet tablet = tablets.get(i);
                if (tablet.getRowSize() == 0) continue;
                if (isTableModel) {
                    this.bufferTableModelTablet(insertNodeTabletInsertionEvent.getPipeName(), insertNodeTabletInsertionEvent.getCreationTime(), tablet, insertNodeTabletInsertionEvent.getTableModelDatabaseName());
                    continue;
                }
                this.bufferTreeModelTablet(insertNodeTabletInsertionEvent.getPipeName(), insertNodeTabletInsertionEvent.getCreationTime(), tablet, insertNodeTabletInsertionEvent.isAligned(i));
            }
        } else if (event instanceof PipeRawTabletInsertionEvent) {
            PipeRawTabletInsertionEvent rawTabletInsertionEvent = (PipeRawTabletInsertionEvent)event;
            Tablet tablet = rawTabletInsertionEvent.convertToTablet();
            if (tablet.getRowSize() == 0) {
                return true;
            }
            if (rawTabletInsertionEvent.isTableModelEvent()) {
                this.bufferTableModelTablet(rawTabletInsertionEvent.getPipeName(), rawTabletInsertionEvent.getCreationTime(), tablet, rawTabletInsertionEvent.getTableModelDatabaseName());
            } else {
                this.bufferTreeModelTablet(rawTabletInsertionEvent.getPipeName(), rawTabletInsertionEvent.getCreationTime(), tablet, rawTabletInsertionEvent.isAligned());
            }
        } else {
            LOGGER.warn("Batch id = {}: Unsupported event {} type {} when constructing tsfile batch", new Object[]{this.currentBatchId.get(), event, event.getClass()});
        }
        return true;
    }

    private void bufferTreeModelTablet(String pipeName, long creationTime, Tablet tablet, boolean isAligned) {
        new PipeTreeModelTabletEventSorter(tablet).deduplicateAndSortTimestampsIfNecessary();
        this.totalBufferSize += PipeMemoryWeightUtil.calculateTabletSizeInBytes(tablet);
        this.pipeName2WeightMap.compute((Pair<String, Long>)new Pair((Object)pipeName, (Object)creationTime), (pipe, weight) -> {
            double d;
            if (Objects.nonNull(weight)) {
                weight = weight + 1.0;
                d = weight;
            } else {
                d = 1.0;
            }
            return d;
        });
        this.treeModeTsFileBuilder.bufferTreeModelTablet(tablet, isAligned);
    }

    private void bufferTableModelTablet(String pipeName, long creationTime, Tablet tablet, String dataBase) {
        new PipeTableModelTabletEventSorter(tablet).sortAndDeduplicateByDevIdTimestamp();
        this.totalBufferSize += PipeMemoryWeightUtil.calculateTabletSizeInBytes(tablet);
        this.pipeName2WeightMap.compute((Pair<String, Long>)new Pair((Object)pipeName, (Object)creationTime), (pipe, weight) -> {
            double d;
            if (Objects.nonNull(weight)) {
                weight = weight + 1.0;
                d = weight;
            } else {
                d = 1.0;
            }
            return d;
        });
        this.tableModeTsFileBuilder.bufferTableModelTablet(dataBase, tablet);
    }

    public Map<Pair<String, Long>, Double> deepCopyPipe2WeightMap() {
        double sum = this.pipeName2WeightMap.values().stream().reduce(Double::sum).orElse(0.0);
        if (sum == 0.0) {
            return Collections.emptyMap();
        }
        this.pipeName2WeightMap.entrySet().forEach(entry -> entry.setValue((Double)entry.getValue() / sum));
        return new HashMap<Pair<String, Long>, Double>(this.pipeName2WeightMap);
    }

    public synchronized List<Pair<String, File>> sealTsFiles() throws IOException, WriteProcessException {
        if (this.isClosed) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, File>> list = new ArrayList<Pair<String, File>>();
        if (!this.treeModeTsFileBuilder.isEmpty()) {
            list.addAll(this.treeModeTsFileBuilder.convertTabletToTsFileWithDBInfo());
        }
        if (!this.tableModeTsFileBuilder.isEmpty()) {
            list.addAll(this.tableModeTsFileBuilder.convertTabletToTsFileWithDBInfo());
        }
        return list;
    }

    @Override
    protected long getMaxBatchSizeInBytes() {
        return this.maxSizeInBytes;
    }

    @Override
    public synchronized void onSuccess() {
        super.onSuccess();
        this.pipeName2WeightMap.clear();
        this.tableModeTsFileBuilder.onSuccess();
        this.treeModeTsFileBuilder.onSuccess();
    }

    @Override
    public synchronized void close() {
        super.close();
        this.pipeName2WeightMap.clear();
        this.tableModeTsFileBuilder.close();
        this.treeModeTsFileBuilder.close();
    }
}

