/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task.subtask.connector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.config.constant.PipeConnectorConstant;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskConnectorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.agent.task.execution.PipeConnectorSubtaskExecutor;
import org.apache.iotdb.db.pipe.agent.task.subtask.connector.PipeConnectorSubtask;
import org.apache.iotdb.db.pipe.agent.task.subtask.connector.PipeConnectorSubtaskLifeCycle;
import org.apache.iotdb.db.pipe.agent.task.subtask.connector.PipeRealtimePriorityBlockingQueue;
import org.apache.iotdb.db.pipe.metric.PipeDataRegionEventCounter;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConnectorSubtaskManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConnectorSubtaskManager.class);
    private static final String FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE = "Failed to deregister PipeConnectorSubtask. No such subtask: ";
    private final Map<String, List<PipeConnectorSubtaskLifeCycle>> attributeSortedString2SubtaskLifeCycleMap = new HashMap<String, List<PipeConnectorSubtaskLifeCycle>>();

    public synchronized String register(PipeConnectorSubtaskExecutor executor, PipeParameters pipeConnectorParameters, PipeTaskConnectorRuntimeEnvironment environment) {
        int connectorNum;
        String connectorKey = pipeConnectorParameters.getStringOrDefault(Arrays.asList("connector", "sink"), BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName()).toLowerCase();
        PipeEventCommitManager.getInstance().register(environment.getPipeName(), environment.getCreationTime(), environment.getRegionId(), connectorKey);
        boolean isDataRegionConnector = StorageEngine.getInstance().getAllDataRegionIds().contains(new DataRegionId(environment.getRegionId()));
        boolean realTimeFirst = false;
        String attributeSortedString = this.generateAttributeSortedString(pipeConnectorParameters);
        if (isDataRegionConnector) {
            connectorNum = pipeConnectorParameters.getIntOrDefault(Arrays.asList("connector.parallel.tasks", "sink.parallel.tasks"), PipeConnectorConstant.CONNECTOR_IOTDB_PARALLEL_TASKS_DEFAULT_VALUE);
            realTimeFirst = pipeConnectorParameters.getBooleanOrDefault(Arrays.asList("connector.realtime-first", "sink.realtime-first"), true);
            attributeSortedString = "data_" + attributeSortedString;
        } else {
            connectorNum = 1;
            attributeSortedString = "schema_" + attributeSortedString;
        }
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            ArrayList<PipeConnectorSubtaskLifeCycle> pipeConnectorSubtaskLifeCycleList = new ArrayList<PipeConnectorSubtaskLifeCycle>(connectorNum);
            PipeRealtimePriorityBlockingQueue pendingQueue = realTimeFirst ? new PipeRealtimePriorityBlockingQueue() : new UnboundedBlockingPendingQueue((PipeEventCounter)new PipeDataRegionEventCounter());
            for (int connectorIndex = 0; connectorIndex < connectorNum; ++connectorIndex) {
                PipeConnector pipeConnector = isDataRegionConnector ? PipeDataNodeAgent.plugin().dataRegion().reflectConnector(pipeConnectorParameters) : PipeDataNodeAgent.plugin().schemaRegion().reflectConnector(pipeConnectorParameters);
                try {
                    pipeConnector.validate(new PipeParameterValidator(pipeConnectorParameters));
                    pipeConnector.customize(pipeConnectorParameters, (PipeConnectorRuntimeConfiguration)new PipeTaskRuntimeConfiguration((PipeRuntimeEnvironment)environment));
                    pipeConnector.handshake();
                }
                catch (Exception e) {
                    try {
                        pipeConnector.close();
                    }
                    catch (Exception closeException) {
                        LOGGER.warn("Failed to close connector after failed to initialize connector. Ignore this exception.", (Throwable)closeException);
                    }
                    throw new PipeException("Failed to construct PipeConnector, because of " + e.getMessage(), (Throwable)e);
                }
                PipeConnectorSubtask pipeConnectorSubtask = new PipeConnectorSubtask(String.format("%s_%s_%s", attributeSortedString, environment.getCreationTime(), connectorIndex), environment.getCreationTime(), attributeSortedString, connectorIndex, pendingQueue, pipeConnector);
                PipeConnectorSubtaskLifeCycle pipeConnectorSubtaskLifeCycle = new PipeConnectorSubtaskLifeCycle(executor, pipeConnectorSubtask, pendingQueue);
                pipeConnectorSubtaskLifeCycleList.add(pipeConnectorSubtaskLifeCycle);
            }
            this.attributeSortedString2SubtaskLifeCycleMap.put(attributeSortedString, pipeConnectorSubtaskLifeCycleList);
        }
        for (PipeConnectorSubtaskLifeCycle lifeCycle : this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString)) {
            lifeCycle.register();
        }
        return attributeSortedString;
    }

    public synchronized void deregister(String pipeName, long creationTime, int regionId, String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        List<PipeConnectorSubtaskLifeCycle> lifeCycles = this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString);
        lifeCycles.removeIf(o -> o.deregister(pipeName, regionId));
        if (lifeCycles.isEmpty()) {
            this.attributeSortedString2SubtaskLifeCycleMap.remove(attributeSortedString);
        }
        PipeEventCommitManager.getInstance().deregister(pipeName, creationTime, regionId);
    }

    public synchronized void start(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        for (PipeConnectorSubtaskLifeCycle lifeCycle : this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString)) {
            lifeCycle.start();
        }
    }

    public synchronized void stop(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        for (PipeConnectorSubtaskLifeCycle lifeCycle : this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString)) {
            lifeCycle.stop();
        }
    }

    public UnboundedBlockingPendingQueue<Event> getPipeConnectorPendingQueue(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException("Failed to get PendingQueue. No such subtask: " + attributeSortedString);
        }
        return this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString).get(0).getPendingQueue();
    }

    private String generateAttributeSortedString(PipeParameters pipeConnectorParameters) {
        TreeMap sortedStringSourceMap = new TreeMap(pipeConnectorParameters.getAttribute());
        sortedStringSourceMap.remove("__system.restart");
        return sortedStringSourceMap.toString();
    }

    private PipeConnectorSubtaskManager() {
    }

    public static PipeConnectorSubtaskManager instance() {
        return PipeSubtaskManagerHolder.INSTANCE;
    }

    private static class PipeSubtaskManagerHolder {
        private static final PipeConnectorSubtaskManager INSTANCE = new PipeConnectorSubtaskManager();

        private PipeSubtaskManagerHolder() {
        }
    }
}

