/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.confignode.rpc.thrift.TAuthizedPatternTreeResp;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerResp;
import org.apache.iotdb.confignode.rpc.thrift.TCheckUserPrivilegesReq;
import org.apache.iotdb.confignode.rpc.thrift.TLoginReq;
import org.apache.iotdb.confignode.rpc.thrift.TPathPrivilege;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.IAuthorCache;
import org.apache.iotdb.db.auth.IAuthorityFetcher;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.statement.AuthorType;
import org.apache.iotdb.db.queryengine.plan.statement.sys.AuthorStatement;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAuthorityFetcher
implements IAuthorityFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterAuthorityFetcher.class);
    private static final CommonConfig CONFIG = CommonDescriptor.getInstance().getConfig();
    private final IAuthorCache iAuthorCache;
    private boolean cacheOutDate = false;
    private long heartBeatTimeStamp = 0L;
    private boolean acceptCache = true;
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();
    private static final String CONNECTERROR = "Failed to connect to config node.";

    public ClusterAuthorityFetcher(IAuthorCache iAuthorCache) {
        this.iAuthorCache = iAuthorCache;
    }

    @Override
    public List<Integer> checkUserPathPrivileges(String username, List<? extends PartialPath> allPath, int permission) {
        this.checkCacheAvailable();
        ArrayList<Integer> posList = new ArrayList<Integer>();
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            if (user.isOpenIdUser()) {
                return posList;
            }
            int pos = 0;
            for (PartialPath partialPath : allPath) {
                if (!user.checkPathPrivilege(partialPath, permission)) {
                    boolean checkFromRole = false;
                    for (String rolename : user.getRoleList()) {
                        Role cachedRole = this.iAuthorCache.getRoleCache(rolename);
                        if (cachedRole == null) {
                            return this.checkPathFromConfigNode(username, allPath, permission);
                        }
                        if (!cachedRole.checkPathPrivilege(partialPath, permission)) continue;
                        checkFromRole = true;
                        break;
                    }
                    if (!checkFromRole) {
                        posList.add(pos);
                    }
                }
                ++pos;
            }
            return posList;
        }
        return this.checkPathFromConfigNode(username, allPath, permission);
    }

    @Override
    public boolean checkUserPrivilegeGrantOpt(String username, List<PartialPath> paths, int permission) {
        this.checkCacheAvailable();
        if (PrivilegeType.values()[permission].isPathRelevant()) {
            return this.checkUserPathPriGrantOpt(username, paths, permission);
        }
        return this.checkUserSysPriGrantOpt(username, permission);
    }

    private boolean checkUserPathPriGrantOpt(String username, List<PartialPath> paths, int permission) {
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            if (user.isOpenIdUser()) {
                return true;
            }
            for (PartialPath path : paths) {
                if (user.checkPathPrivilegeGrantOpt(path, permission)) continue;
                boolean checkFromRole = false;
                for (String roleName : user.getRoleList()) {
                    Role role = this.iAuthorCache.getRoleCache(roleName);
                    if (role == null) {
                        return this.checkUserPrivilegeGrantOptFromConfigNode(username, paths, permission);
                    }
                    if (!role.checkPathPrivilegeGrantOpt(path, permission)) continue;
                    checkFromRole = true;
                    break;
                }
                if (checkFromRole) continue;
                return false;
            }
            return true;
        }
        return this.checkUserPrivilegeGrantOptFromConfigNode(username, paths, permission);
    }

    private boolean checkUserSysPriGrantOpt(String username, int permission) {
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            if (user.isOpenIdUser()) {
                return true;
            }
            if (!user.checkSysPriGrantOpt(permission)) {
                for (String roleName : user.getRoleList()) {
                    Role role = this.iAuthorCache.getRoleCache(roleName);
                    if (role == null) {
                        return this.checkUserPrivilegeGrantOptFromConfigNode(username, Collections.emptyList(), permission);
                    }
                    if (!role.checkSysPriGrantOpt(permission)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return this.checkUserPrivilegeGrantOptFromConfigNode(username, Collections.emptyList(), permission);
    }

    private boolean checkUserPrivilegeGrantOptFromConfigNode(String username, List<PartialPath> paths, int permission) {
        TPermissionInfoResp permissionInfoResp;
        TCheckUserPrivilegesReq req = new TCheckUserPrivilegesReq(username, AuthUtils.serializePartialPathList(paths), permission);
        req.setGrantOpt(true);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            permissionInfoResp = configNodeClient.checkUserPrivilegeGrantOpt(req);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            permissionInfoResp = new TPermissionInfoResp();
            permissionInfoResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
        }
        if (permissionInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (this.acceptCache) {
                this.iAuthorCache.putUserCache(username, this.cacheUser(permissionInfoResp));
            }
            return true;
        }
        return false;
    }

    @Override
    public PathPatternTree getAuthorizedPatternTree(String username, int permission) throws AuthException {
        PathPatternTree patternTree = new PathPatternTree();
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            for (PathPrivilege path : user.getPathPrivilegeList()) {
                if (!path.checkPrivilege(permission)) continue;
                patternTree.appendPathPattern(path.getPath());
            }
            for (String roleName : user.getRoleList()) {
                Role role = this.iAuthorCache.getRoleCache(roleName);
                if (role != null) {
                    for (PathPrivilege path : role.getPathPrivilegeList()) {
                        if (!path.checkPrivilege(permission)) continue;
                        patternTree.appendPathPattern(path.getPath());
                    }
                    continue;
                }
                return this.fetchAuthizedPatternTree(username, permission);
            }
            patternTree.constructTree();
            return patternTree;
        }
        return this.fetchAuthizedPatternTree(username, permission);
    }

    private PathPatternTree fetchAuthizedPatternTree(String username, int permission) throws AuthException {
        TCheckUserPrivilegesReq req = new TCheckUserPrivilegesReq(username, AuthUtils.serializePartialPathList(Collections.emptyList()), permission);
        TAuthizedPatternTreeResp authizedPatternTree = new TAuthizedPatternTreeResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            authizedPatternTree = configNodeClient.fetchAuthizedPatternTree(req);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            authizedPatternTree.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
        }
        if (authizedPatternTree.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (this.acceptCache) {
                this.iAuthorCache.putUserCache(username, this.cacheUser(authizedPatternTree.getPermissionInfo()));
            }
            return PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(authizedPatternTree.getPathPatternTree()));
        }
        throw new AuthException(TSStatusCode.EXECUTE_STATEMENT_ERROR, authizedPatternTree.getStatus().getMessage());
    }

    @Override
    public TSStatus checkUserSysPrivileges(String username, int permission) {
        this.checkCacheAvailable();
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            if (!user.isOpenIdUser() && !user.checkSysPrivilege(permission)) {
                if (user.getRoleList().isEmpty()) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION);
                }
                boolean status = false;
                for (String rolename : user.getRoleList()) {
                    Role cacheRole = this.iAuthorCache.getRoleCache(rolename);
                    if (cacheRole == null) {
                        return this.checkSysPriFromConfigNode(username, permission);
                    }
                    if (!cacheRole.checkSysPrivilege(permission)) continue;
                    status = true;
                    break;
                }
                if (!status) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION);
                }
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        return this.checkSysPriFromConfigNode(username, permission);
    }

    @Override
    public SettableFuture<ConfigTaskResult> operatePermission(AuthorStatement authorStatement) {
        SettableFuture future = SettableFuture.create();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TAuthorizerReq authorizerReq = this.statementToAuthorizerReq(authorStatement);
            TSStatus tsStatus = configNodeClient.operatePermission(authorizerReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                LOGGER.warn("Failed to execute {} in config node, status is {}.", (Object)AuthorType.values()[authorizerReq.getAuthorType()].toString().toLowerCase(Locale.ROOT), (Object)tsStatus);
                future.setException((Throwable)new IoTDBException(tsStatus.message, tsStatus.code));
            } else {
                future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
            }
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            future.setException(e);
        }
        catch (AuthException e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> queryPermission(AuthorStatement authorStatement) {
        SettableFuture future = SettableFuture.create();
        TAuthorizerResp authorizerResp = new TAuthorizerResp();
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TAuthorizerReq authorizerReq = this.statementToAuthorizerReq(authorStatement);
            authorizerResp = configNodeClient.queryPermission(authorizerReq);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != authorizerResp.getStatus().getCode()) {
                LOGGER.error("Failed to execute {} in config node, status is {}.", (Object)AuthorType.values()[authorizerReq.getAuthorType()].toString().toLowerCase(Locale.ROOT), (Object)authorizerResp.getStatus());
                future.setException((Throwable)new IoTDBException(authorizerResp.getStatus().message, authorizerResp.getStatus().code));
            } else {
                AuthorityChecker.buildTSBlock(authorizerResp, (SettableFuture<ConfigTaskResult>)future);
            }
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            authorizerResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
            future.setException((Throwable)new IoTDBException(authorizerResp.getStatus().message, authorizerResp.getStatus().code));
        }
        catch (AuthException e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public IAuthorCache getAuthorCache() {
        return this.iAuthorCache;
    }

    @Override
    public void refreshToken() {
        long currentTime = System.currentTimeMillis();
        if (this.heartBeatTimeStamp == 0L) {
            this.heartBeatTimeStamp = currentTime;
            return;
        }
        if (currentTime - this.heartBeatTimeStamp > CONFIG.getDatanodeTokenTimeoutMS()) {
            this.cacheOutDate = true;
        }
        this.heartBeatTimeStamp = currentTime;
    }

    private void checkCacheAvailable() {
        if (this.cacheOutDate) {
            this.iAuthorCache.invalidAllCache();
        }
        this.cacheOutDate = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSStatus checkUser(String username, String password) {
        this.checkCacheAvailable();
        User user = this.iAuthorCache.getUserCache(username);
        if (user != null) {
            if (user.isOpenIdUser()) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            if (password != null && AuthUtils.validatePassword((String)password, (String)user.getPassword())) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRONG_LOGIN_PASSWORD, (String)"Authentication failed.");
        }
        TLoginReq req = new TLoginReq(username, password);
        TPermissionInfoResp status = null;
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            status = configNodeClient.login(req);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            status = new TPermissionInfoResp();
            status.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
        }
        finally {
            if (status == null) {
                status = new TPermissionInfoResp();
            }
        }
        if (status.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (this.acceptCache) {
                this.iAuthorCache.putUserCache(username, this.cacheUser(status));
            }
            return status.getStatus();
        }
        return status.getStatus();
    }

    @Override
    public boolean checkRole(String userName, String roleName) {
        this.checkCacheAvailable();
        User user = this.iAuthorCache.getUserCache(userName);
        if (user != null) {
            return user.isOpenIdUser() || user.getRoleList().contains(roleName);
        }
        return this.checkRoleFromConfigNode(userName, roleName);
    }

    private TSStatus checkSysPriFromConfigNode(String username, int permission) {
        TPermissionInfoResp permissionInfoResp;
        TCheckUserPrivilegesReq req = new TCheckUserPrivilegesReq(username, AuthUtils.serializePartialPathList(Collections.emptyList()), permission);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            permissionInfoResp = configNodeClient.checkUserPrivileges(req);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            permissionInfoResp = new TPermissionInfoResp();
            permissionInfoResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
        }
        if (permissionInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && this.acceptCache) {
            this.iAuthorCache.putUserCache(username, this.cacheUser(permissionInfoResp));
        }
        return permissionInfoResp.getStatus();
    }

    private List<Integer> checkPathFromConfigNode(String username, List<? extends PartialPath> allPath, int permission) {
        TPermissionInfoResp permissionInfoResp;
        TCheckUserPrivilegesReq req = new TCheckUserPrivilegesReq(username, AuthUtils.serializePartialPathList(allPath), permission);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            permissionInfoResp = configNodeClient.checkUserPrivileges(req);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            permissionInfoResp = new TPermissionInfoResp();
            permissionInfoResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
        }
        if (permissionInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && this.acceptCache) {
            this.iAuthorCache.putUserCache(username, this.cacheUser(permissionInfoResp));
        }
        return permissionInfoResp.getFailPos();
    }

    private boolean checkRoleFromConfigNode(String username, String rolename) {
        TPermissionInfoResp permissionInfoResp;
        TAuthorizerReq req = new TAuthorizerReq();
        req.setAuthorType(0);
        req.setPassword("");
        req.setNewPassword("");
        req.setNodeNameList(AuthUtils.serializePartialPathList(Collections.emptyList()));
        req.setPermissions(Collections.emptySet());
        req.setGrantOpt(false);
        req.setUserName(username);
        req.setRoleName(rolename);
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            permissionInfoResp = configNodeClient.checkRoleOfUser(req);
        }
        catch (ClientManagerException | TException e) {
            LOGGER.error(CONNECTERROR);
            permissionInfoResp = new TPermissionInfoResp();
            permissionInfoResp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)CONNECTERROR));
        }
        if (permissionInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (this.acceptCache) {
                this.iAuthorCache.putUserCache(username, this.cacheUser(permissionInfoResp));
            }
            return true;
        }
        if (permissionInfoResp.getStatus().getCode() == TSStatusCode.USER_NOT_HAS_ROLE.getStatusCode()) {
            if (this.acceptCache) {
                this.iAuthorCache.putUserCache(username, this.cacheUser(permissionInfoResp));
            }
            return false;
        }
        return false;
    }

    public User cacheUser(TPermissionInfoResp tPermissionInfoResp) {
        User user = new User();
        List privilegeList = tPermissionInfoResp.getUserInfo().getPrivilegeList();
        ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
        user.setName(tPermissionInfoResp.getUserInfo().getUsername());
        user.setPassword(tPermissionInfoResp.getUserInfo().getPassword());
        for (TPathPrivilege tPathPrivilege : privilegeList) {
            try {
                PathPrivilege pathPri = new PathPrivilege();
                pathPri.setPath(new PartialPath(tPathPrivilege.getPath()));
                pathPri.setPrivileges(tPathPrivilege.getPriSet());
                pathPri.setGrantOpt(tPathPrivilege.getPriGrantOpt());
                pathPrivilegeList.add(pathPri);
            }
            catch (MetadataException e) {
                LOGGER.error("Failed to parse path {}.", (Object)tPathPrivilege.getPath(), (Object)e);
            }
        }
        user.setOpenIdUser(tPermissionInfoResp.getUserInfo().isIsOpenIdUser());
        user.setPrivilegeList(pathPrivilegeList);
        user.setRoleList(tPermissionInfoResp.getUserInfo().getRoleList());
        user.setSysPrivilegeSet(tPermissionInfoResp.getUserInfo().getSysPriSet());
        user.setSysPriGrantOpt(tPermissionInfoResp.getUserInfo().getSysPriSetGrantOpt());
        for (String roleName : tPermissionInfoResp.getRoleInfo().keySet()) {
            this.iAuthorCache.putRoleCache(roleName, this.cacheRole(roleName, tPermissionInfoResp));
        }
        return user;
    }

    public Role cacheRole(String roleName, TPermissionInfoResp tPermissionInfoResp) {
        Role role = new Role();
        List privilegeList = ((TRoleResp)tPermissionInfoResp.getRoleInfo().get(roleName)).getPrivilegeList();
        ArrayList<PathPrivilege> pathPrivilegeList = new ArrayList<PathPrivilege>();
        role.setName(((TRoleResp)tPermissionInfoResp.getRoleInfo().get(roleName)).getRoleName());
        for (TPathPrivilege tPathPrivilege : privilegeList) {
            try {
                PathPrivilege pathPri = new PathPrivilege();
                pathPri.setPath(new PartialPath(tPathPrivilege.getPath()));
                pathPri.setPrivileges(tPathPrivilege.getPriSet());
                pathPri.setGrantOpt(tPathPrivilege.getPriGrantOpt());
                pathPrivilegeList.add(pathPri);
            }
            catch (MetadataException e) {
                LOGGER.error("Failed to parse path {}.", (Object)tPathPrivilege.getPath(), (Object)e);
            }
        }
        role.setSysPriGrantOpt(((TRoleResp)tPermissionInfoResp.getRoleInfo().get(roleName)).getSysPriSetGrantOpt());
        role.setSysPrivilegeSet(((TRoleResp)tPermissionInfoResp.getRoleInfo().get(roleName)).getSysPriSet());
        role.setPrivilegeList(pathPrivilegeList);
        return role;
    }

    private TAuthorizerReq statementToAuthorizerReq(AuthorStatement authorStatement) throws AuthException {
        if (authorStatement.getAuthorType() == null) {
            authorStatement.setNodeNameList(new ArrayList<PartialPath>());
        }
        return new TAuthorizerReq(authorStatement.getAuthorType().ordinal(), authorStatement.getUserName() == null ? "" : authorStatement.getUserName(), authorStatement.getRoleName() == null ? "" : authorStatement.getRoleName(), authorStatement.getPassWord() == null ? "" : authorStatement.getPassWord(), authorStatement.getNewPassword() == null ? "" : authorStatement.getNewPassword(), AuthUtils.strToPermissions((String[])authorStatement.getPrivilegeList()), authorStatement.getGrantOpt(), AuthUtils.serializePartialPathList(authorStatement.getNodeNameList()));
    }
}

