/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.v4;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tsfile.annotations.TsFileApi;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.IEncryptor;
import org.apache.tsfile.exception.encrypt.EncryptException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.write.chunk.AlignedChunkGroupWriterImpl;
import org.apache.tsfile.write.chunk.IChunkGroupWriter;
import org.apache.tsfile.write.chunk.NonAlignedChunkGroupWriterImpl;
import org.apache.tsfile.write.chunk.TableChunkGroupWriterImpl;
import org.apache.tsfile.write.schema.Schema;
import org.apache.tsfile.write.v4.ITsFileWriter;
import org.apache.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTableModelTsFileWriter
implements ITsFileWriter {
    protected static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractTableModelTsFileWriter.class);
    protected final TsFileIOWriter fileWriter;
    protected EncryptParameter encryptParam;
    protected final int pageSize;
    protected long recordCount = 0L;
    protected Map<IDeviceID, List<String>> flushedMeasurementsInDeviceMap = new HashMap<IDeviceID, List<String>>();
    protected Map<IDeviceID, Long> alignedDeviceLastTimeMap = new HashMap<IDeviceID, Long>();
    protected Map<IDeviceID, Map<String, Long>> nonAlignedTimeseriesLastTimeMap = new HashMap<IDeviceID, Map<String, Long>>();
    protected Map<IDeviceID, IChunkGroupWriter> groupWriters = new TreeMap<IDeviceID, IChunkGroupWriter>();
    protected long recordCountForNextMemCheck = 100L;
    protected long chunkGroupSizeThreshold;

    @TsFileApi
    protected AbstractTableModelTsFileWriter(File file, long chunkGroupSizeThreshold) throws IOException {
        byte[] encryptKey;
        byte[] dataEncryptKey;
        String encryptType;
        String encryptLevel;
        Schema schema = new Schema();
        TSFileConfig conf = TSFileDescriptor.getInstance().getConfig();
        this.fileWriter = new TsFileIOWriter(file);
        this.fileWriter.setSchema(schema);
        this.pageSize = conf.getPageSizeInByte();
        this.chunkGroupSizeThreshold = chunkGroupSizeThreshold;
        if ((long)this.pageSize >= chunkGroupSizeThreshold) {
            LOG.warn("TsFile's page size {} is greater than chunk group size {}, please enlarge the chunk group size or decrease page size. ", (Object)this.pageSize, (Object)chunkGroupSizeThreshold);
        }
        if (config.getEncryptFlag()) {
            encryptLevel = "2";
            encryptType = config.getEncryptType();
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update("IoTDB is the best".getBytes());
                md.update(config.getEncryptKey().getBytes());
                dataEncryptKey = Arrays.copyOfRange(md.digest(), 0, 16);
                encryptKey = IEncryptor.getEncryptor(config.getEncryptType(), config.getEncryptKey().getBytes()).encrypt(dataEncryptKey);
            }
            catch (Exception e) {
                throw new EncryptException("SHA-256 function not found while using SHA-256 to generate data key");
            }
        } else {
            encryptLevel = "0";
            encryptType = "org.apache.tsfile.encrypt.UNENCRYPTED";
            encryptKey = null;
            dataEncryptKey = null;
        }
        this.encryptParam = new EncryptParameter(encryptType, dataEncryptKey);
        if (encryptKey != null) {
            StringBuilder valueStr = new StringBuilder();
            for (byte b : encryptKey) {
                valueStr.append(b).append(",");
            }
            valueStr.deleteCharAt(valueStr.length() - 1);
            String str = valueStr.toString();
            this.fileWriter.setEncryptParam(encryptLevel, encryptType, str);
        } else {
            this.fileWriter.setEncryptParam(encryptLevel, encryptType, "");
        }
    }

    protected IChunkGroupWriter tryToInitialGroupWriter(IDeviceID deviceId, boolean isAligned, boolean isTableModel) {
        IChunkGroupWriter groupWriter = this.groupWriters.get(deviceId);
        if (groupWriter == null) {
            if (isAligned) {
                groupWriter = isTableModel ? new TableChunkGroupWriterImpl(deviceId, this.encryptParam) : new AlignedChunkGroupWriterImpl(deviceId, this.encryptParam);
                ((AlignedChunkGroupWriterImpl)groupWriter).setLastTime(this.alignedDeviceLastTimeMap.get(deviceId));
            } else {
                groupWriter = new NonAlignedChunkGroupWriterImpl(deviceId, this.encryptParam);
                ((NonAlignedChunkGroupWriterImpl)groupWriter).setLastTimeMap(this.nonAlignedTimeseriesLastTimeMap.getOrDefault(deviceId, new HashMap()));
            }
            this.groupWriters.put(deviceId, groupWriter);
        }
        return groupWriter;
    }

    protected long calculateMemSizeForAllGroup() {
        long memTotalSize = 0L;
        for (IChunkGroupWriter group : this.groupWriters.values()) {
            memTotalSize += group.updateMaxGroupMemSize();
        }
        return memTotalSize;
    }

    protected void checkMemorySizeAndMayFlushChunks() throws IOException {
        if (this.recordCount >= this.recordCountForNextMemCheck) {
            long memSize = this.calculateMemSizeForAllGroup();
            if (memSize > this.chunkGroupSizeThreshold) {
                LOG.debug("start to flush chunk groups, memory space occupy:{}", (Object)memSize);
                this.recordCountForNextMemCheck = this.recordCount * this.chunkGroupSizeThreshold / memSize;
                this.flush();
            } else {
                this.recordCountForNextMemCheck = this.recordCount * this.chunkGroupSizeThreshold / memSize;
            }
        }
    }

    @TsFileApi
    protected void flush() throws IOException {
        if (this.recordCount > 0L) {
            for (Map.Entry<IDeviceID, IChunkGroupWriter> entry : this.groupWriters.entrySet()) {
                IDeviceID deviceId = entry.getKey();
                IChunkGroupWriter groupWriter = entry.getValue();
                this.fileWriter.startChunkGroup(deviceId);
                long pos = this.fileWriter.getPos();
                long dataSize = groupWriter.flushToFileWriter(this.fileWriter);
                if (this.fileWriter.getPos() - pos != dataSize) {
                    throw new IOException(String.format("Flushed data size is inconsistent with computation! Estimated: %d, Actual: %d", dataSize, this.fileWriter.getPos() - pos));
                }
                this.fileWriter.endChunkGroup();
                if (groupWriter instanceof AlignedChunkGroupWriterImpl) {
                    List measurementList = this.flushedMeasurementsInDeviceMap.computeIfAbsent(deviceId, p -> new ArrayList());
                    ((AlignedChunkGroupWriterImpl)groupWriter).getMeasurements().forEach(measurementId -> {
                        if (!measurementList.contains(measurementId)) {
                            measurementList.add(measurementId);
                        }
                    });
                    this.alignedDeviceLastTimeMap.put(deviceId, ((AlignedChunkGroupWriterImpl)groupWriter).getLastTime());
                    continue;
                }
                this.nonAlignedTimeseriesLastTimeMap.put(deviceId, ((NonAlignedChunkGroupWriterImpl)groupWriter).getLastTimeMap());
            }
            this.reset();
        }
    }

    protected void reset() {
        this.groupWriters.clear();
        this.recordCount = 0L;
    }

    protected TsFileIOWriter getIOWriter() {
        return this.fileWriter;
    }

    protected Schema getSchema() {
        return this.fileWriter.getSchema();
    }

    @Override
    @TsFileApi
    public void close() {
        LOG.info("start close file");
        try {
            this.flush();
            this.fileWriter.endFile();
        }
        catch (IOException e) {
            LOG.warn("Meet exception when close file writer. ", (Throwable)e);
        }
    }
}

