/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.AttributeColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TagColumnSchema;
import org.apache.tsfile.enums.TSDataType;

public class InformationSchema {
    public static final String INFORMATION_DATABASE = "information_schema";
    private static final Map<String, TsTable> schemaTables = new HashMap<String, TsTable>();
    public static final String QUERIES = "queries";
    public static final String DATABASES = "databases";
    public static final String TABLES = "tables";
    public static final String COLUMNS = "columns";

    public static Map<String, TsTable> getSchemaTables() {
        return schemaTables;
    }

    private InformationSchema() {
    }

    static {
        TsTable queriesTable = new TsTable(QUERIES);
        queriesTable.addColumnSchema(new TagColumnSchema("query_id", TSDataType.STRING));
        queriesTable.addColumnSchema(new AttributeColumnSchema("start_time", TSDataType.TIMESTAMP));
        queriesTable.addColumnSchema(new AttributeColumnSchema("datanode_id", TSDataType.INT32));
        queriesTable.addColumnSchema(new AttributeColumnSchema("elapsed_time", TSDataType.FLOAT));
        queriesTable.addColumnSchema(new AttributeColumnSchema("Statement".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        queriesTable.removeColumnSchema("time");
        schemaTables.put(QUERIES, queriesTable);
        TsTable databaseTable = new TsTable(DATABASES);
        databaseTable.addColumnSchema(new TagColumnSchema("Database".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        databaseTable.addColumnSchema(new AttributeColumnSchema("TTL(ms)".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        databaseTable.addColumnSchema(new AttributeColumnSchema("schema_replication_factor", TSDataType.INT32));
        databaseTable.addColumnSchema(new AttributeColumnSchema("data_replication_factor", TSDataType.INT32));
        databaseTable.addColumnSchema(new AttributeColumnSchema("time_partition_interval", TSDataType.INT64));
        databaseTable.addColumnSchema(new AttributeColumnSchema("schema_region_group_num", TSDataType.INT32));
        databaseTable.addColumnSchema(new AttributeColumnSchema("data_region_group_num", TSDataType.INT32));
        databaseTable.removeColumnSchema("time");
        schemaTables.put(DATABASES, databaseTable);
        TsTable tableTable = new TsTable(TABLES);
        tableTable.addColumnSchema(new TagColumnSchema("Database".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        tableTable.addColumnSchema(new TagColumnSchema("table_name", TSDataType.STRING));
        tableTable.addColumnSchema(new AttributeColumnSchema("TTL(ms)".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        tableTable.addColumnSchema(new AttributeColumnSchema("Status".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        tableTable.removeColumnSchema("time");
        schemaTables.put(TABLES, tableTable);
        TsTable columnTable = new TsTable(COLUMNS);
        columnTable.addColumnSchema(new TagColumnSchema("Database".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        columnTable.addColumnSchema(new TagColumnSchema("table_name", TSDataType.STRING));
        columnTable.addColumnSchema(new TagColumnSchema("column_name", TSDataType.STRING));
        columnTable.addColumnSchema(new AttributeColumnSchema("DataType".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        columnTable.addColumnSchema(new AttributeColumnSchema("Category".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        columnTable.addColumnSchema(new AttributeColumnSchema("Status".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        columnTable.removeColumnSchema("time");
        schemaTables.put(COLUMNS, columnTable);
    }
}

