/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.Arrays;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PrefixTreePattern;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TreePattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreePattern.class);
    protected final boolean isTreeModelDataAllowedToBeCaptured;
    protected final String pattern;

    protected TreePattern(boolean isTreeModelDataAllowedToBeCaptured, String pattern) {
        this.isTreeModelDataAllowedToBeCaptured = isTreeModelDataAllowedToBeCaptured;
        this.pattern = pattern != null ? pattern : this.getDefaultPattern();
    }

    public boolean isTreeModelDataAllowedToBeCaptured() {
        return this.isTreeModelDataAllowedToBeCaptured;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isRoot() {
        return Objects.isNull(this.pattern) || this.pattern.equals(this.getDefaultPattern());
    }

    public static TreePattern parsePipePatternFromSourceParameters(PipeParameters sourceParameters) {
        boolean isTreeModelDataAllowedToBeCaptured = sourceParameters.getBooleanOrDefault(Arrays.asList("extractor.capture.tree", "source.capture.tree"), sourceParameters.getStringOrDefault("__system.sql-dialect", "tree").equals("tree"));
        String path = sourceParameters.getStringByKeys(new String[]{"extractor.path", "source.path"});
        if (path != null) {
            return new IoTDBTreePattern(isTreeModelDataAllowedToBeCaptured, path);
        }
        String pattern = sourceParameters.getStringByKeys(new String[]{"extractor.pattern", "source.pattern"});
        if (pattern != null) {
            String patternFormat = sourceParameters.getStringByKeys(new String[]{"extractor.pattern.format", "source.pattern.format"});
            if (patternFormat == null) {
                return new PrefixTreePattern(isTreeModelDataAllowedToBeCaptured, pattern);
            }
            switch (patternFormat.toLowerCase()) {
                case "iotdb": {
                    return new IoTDBTreePattern(isTreeModelDataAllowedToBeCaptured, pattern);
                }
                case "prefix": {
                    return new PrefixTreePattern(isTreeModelDataAllowedToBeCaptured, pattern);
                }
            }
            LOGGER.info("Unknown pattern format: {}, use prefix matching format by default.", (Object)patternFormat);
            return new PrefixTreePattern(isTreeModelDataAllowedToBeCaptured, pattern);
        }
        return new IoTDBTreePattern(isTreeModelDataAllowedToBeCaptured, null);
    }

    public abstract String getDefaultPattern();

    public abstract boolean isLegal();

    public abstract boolean coversDb(String var1);

    public abstract boolean coversDevice(IDeviceID var1);

    public abstract boolean mayOverlapWithDb(String var1);

    public abstract boolean mayOverlapWithDevice(IDeviceID var1);

    public abstract boolean matchesMeasurement(IDeviceID var1, String var2);

    public String toString() {
        return "{pattern='" + this.pattern + "', isTreeModelDataAllowedToBeCaptured=" + this.isTreeModelDataAllowedToBeCaptured + '}';
    }
}

