/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.client;

import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBClientManager.class);
    protected final List<TEndPoint> endPointList;
    protected long currentClientIndex = 0L;
    protected final boolean useLeaderCache;
    protected final String username;
    protected final String password;
    protected final boolean shouldReceiverConvertOnTypeMismatch;
    protected final String loadTsFileStrategy;
    protected boolean supportModsIfIsDataNodeReceiver = true;
    private static final int MAX_CONNECTION_TIMEOUT_MS = 86400000;
    private static final int FIRST_ADJUSTMENT_TIMEOUT_MS = 21600000;
    protected static final AtomicInteger CONNECTION_TIMEOUT_MS = new AtomicInteger(PipeConfig.getInstance().getPipeConnectorTransferTimeoutMs());

    protected IoTDBClientManager(List<TEndPoint> endPointList, boolean useLeaderCache, String username, String password, boolean shouldReceiverConvertOnTypeMismatch, String loadTsFileStrategy) {
        this.endPointList = endPointList;
        this.useLeaderCache = useLeaderCache;
        this.username = username;
        this.password = password;
        this.shouldReceiverConvertOnTypeMismatch = shouldReceiverConvertOnTypeMismatch;
        this.loadTsFileStrategy = loadTsFileStrategy;
    }

    public boolean supportModsIfIsDataNodeReceiver() {
        return this.supportModsIfIsDataNodeReceiver;
    }

    public void adjustTimeoutIfNecessary(Throwable e) {
        do {
            int newConnectionTimeout;
            if (!(e instanceof SocketTimeoutException) && !(e instanceof TimeoutException)) continue;
            try {
                newConnectionTimeout = Math.min(Math.max(21600000, Math.toIntExact((long)CONNECTION_TIMEOUT_MS.get() * 2L)), 86400000);
            }
            catch (ArithmeticException arithmeticException) {
                newConnectionTimeout = 86400000;
            }
            if (newConnectionTimeout != CONNECTION_TIMEOUT_MS.get()) {
                CONNECTION_TIMEOUT_MS.set(newConnectionTimeout);
                LOGGER.info("Pipe connection timeout is adjusted to {} ms ({} mins)", (Object)newConnectionTimeout, (Object)((double)newConnectionTimeout / 60000.0));
            }
            return;
        } while ((e = e.getCause()) != null);
    }

    public int getConnectionTimeout() {
        return CONNECTION_TIMEOUT_MS.get();
    }
}

