/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index.impl;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.StateProgressIndex;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class HybridProgressIndex
extends ProgressIndex {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(HybridProgressIndex.class) + ProgressIndex.LOCK_SIZE;
    private static final long ENTRY_SIZE = RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY + RamUsageEstimator.alignObjectSize((long)2L);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<Short, ProgressIndex> type2Index;

    private HybridProgressIndex() {
        this(Collections.emptyMap());
    }

    public HybridProgressIndex(ProgressIndex progressIndex) {
        this(Collections.singletonMap(progressIndex.getType().getType(), progressIndex));
    }

    private HybridProgressIndex(Map<Short, ProgressIndex> type2Index) {
        this.type2Index = new HashMap<Short, ProgressIndex>(type2Index);
    }

    public Map<Short, ProgressIndex> getType2Index() {
        return ImmutableMap.copyOf(this.type2Index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ByteBuffer byteBuffer) {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.HYBRID_PROGRESS_INDEX.serialize(byteBuffer);
            ReadWriteIOUtils.write((int)this.type2Index.size(), (ByteBuffer)byteBuffer);
            for (Map.Entry<Short, ProgressIndex> entry : this.type2Index.entrySet()) {
                ReadWriteIOUtils.write((short)entry.getKey(), (ByteBuffer)byteBuffer);
                entry.getValue().serialize(byteBuffer);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(OutputStream stream) throws IOException {
        this.lock.readLock().lock();
        try {
            ProgressIndexType.HYBRID_PROGRESS_INDEX.serialize(stream);
            ReadWriteIOUtils.write((int)this.type2Index.size(), (OutputStream)stream);
            for (Map.Entry<Short, ProgressIndex> entry : this.type2Index.entrySet()) {
                ReadWriteIOUtils.write((short)entry.getKey(), (OutputStream)stream);
                entry.getValue().serialize(stream);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAfter(@Nonnull ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (progressIndex instanceof MinimumProgressIndex) {
                boolean bl = this.type2Index.size() > 1 || !this.type2Index.containsKey(ProgressIndexType.MINIMUM_PROGRESS_INDEX.getType());
                return bl;
            }
            if (!(progressIndex instanceof HybridProgressIndex)) {
                short type = progressIndex.getType().getType();
                boolean bl = this.type2Index.containsKey(type) && this.type2Index.get(type).isAfter(progressIndex);
                return bl;
            }
            HybridProgressIndex thisHybridProgressIndex = this;
            HybridProgressIndex thatHybridProgressIndex = (HybridProgressIndex)progressIndex;
            boolean bl = thatHybridProgressIndex.type2Index.entrySet().stream().noneMatch(entry -> !thisHybridProgressIndex.type2Index.containsKey(entry.getKey()) || !thisHybridProgressIndex.type2Index.get(entry.getKey()).isAfter((ProgressIndex)entry.getValue()));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isGivenProgressIndexAfterSelf(ProgressIndex progressIndex) {
        return this.type2Index.size() == 1 && this.type2Index.containsKey(progressIndex.getType().getType()) && progressIndex.isAfter(this.type2Index.get(progressIndex.getType().getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(ProgressIndex progressIndex) {
        this.lock.readLock().lock();
        try {
            if (!(progressIndex instanceof HybridProgressIndex)) {
                boolean bl = false;
                return bl;
            }
            HybridProgressIndex thisHybridProgressIndex = this;
            HybridProgressIndex thatHybridProgressIndex = (HybridProgressIndex)progressIndex;
            boolean bl = thisHybridProgressIndex.type2Index.size() == thatHybridProgressIndex.type2Index.size() && thatHybridProgressIndex.type2Index.entrySet().stream().allMatch(entry -> thisHybridProgressIndex.type2Index.containsKey(entry.getKey()) && thisHybridProgressIndex.type2Index.get(entry.getKey()).equals((ProgressIndex)entry.getValue()));
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HybridProgressIndex)) {
            return false;
        }
        return this.equals((HybridProgressIndex)obj);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type2Index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgressIndex updateToMinimumEqualOrIsAfterProgressIndex(ProgressIndex progressIndex) {
        this.lock.writeLock().lock();
        try {
            if (progressIndex == null || progressIndex instanceof MinimumProgressIndex) {
                HybridProgressIndex hybridProgressIndex = this;
                return hybridProgressIndex;
            }
            if (progressIndex instanceof StateProgressIndex) {
                ProgressIndex progressIndex2 = progressIndex.updateToMinimumEqualOrIsAfterProgressIndex(this);
                return progressIndex2;
            }
            if (!(progressIndex instanceof HybridProgressIndex)) {
                HashMap<Short, ProgressIndex> type2Index = new HashMap<Short, ProgressIndex>(this.type2Index);
                type2Index.compute(progressIndex.getType().getType(), (thisK, thisV) -> thisV == null ? progressIndex : thisV.updateToMinimumEqualOrIsAfterProgressIndex(progressIndex));
                HybridProgressIndex hybridProgressIndex = new HybridProgressIndex(type2Index);
                return hybridProgressIndex;
            }
            HybridProgressIndex thisHybridProgressIndex = this;
            HybridProgressIndex thatHybridProgressIndex = (HybridProgressIndex)progressIndex;
            HashMap<Short, ProgressIndex> type2Index = new HashMap<Short, ProgressIndex>(thisHybridProgressIndex.type2Index);
            thatHybridProgressIndex.type2Index.forEach((thatK, thatV) -> type2Index.compute((Short)thatK, (thisK, thisV) -> thisV == null ? thatV : thisV.updateToMinimumEqualOrIsAfterProgressIndex((ProgressIndex)thatV)));
            HybridProgressIndex hybridProgressIndex = new HybridProgressIndex(type2Index);
            return hybridProgressIndex;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public ProgressIndexType getType() {
        return ProgressIndexType.HYBRID_PROGRESS_INDEX;
    }

    @Override
    public ProgressIndex.TotalOrderSumTuple getTotalOrderSumTuple() {
        this.lock.readLock().lock();
        try {
            ProgressIndex.TotalOrderSumTuple totalOrderSumTuple = ProgressIndex.TotalOrderSumTuple.sum(this.type2Index.values().stream().map(ProgressIndex::getTotalOrderSumTuple).collect(Collectors.toList()));
            return totalOrderSumTuple;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static HybridProgressIndex deserializeFrom(ByteBuffer byteBuffer) {
        HybridProgressIndex hybridProgressIndex = new HybridProgressIndex();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            short type = ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer);
            ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(byteBuffer);
            hybridProgressIndex.type2Index.put(type, progressIndex);
        }
        return hybridProgressIndex;
    }

    public static HybridProgressIndex deserializeFrom(InputStream stream) throws IOException {
        HybridProgressIndex hybridProgressIndex = new HybridProgressIndex();
        int size = ReadWriteIOUtils.readInt((InputStream)stream);
        for (int i = 0; i < size; ++i) {
            short type = ReadWriteIOUtils.readShort((InputStream)stream);
            ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(stream);
            hybridProgressIndex.type2Index.put(type, progressIndex);
        }
        return hybridProgressIndex;
    }

    public String toString() {
        return "HybridProgressIndex{type2Index=" + this.type2Index + '}';
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + (long)this.type2Index.size() * ENTRY_SIZE + this.type2Index.values().stream().map(Accountable::ramBytesUsed).reduce(0L, Long::sum);
    }
}

