/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.role;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PriPrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.role.IRoleAccessor;
import org.apache.iotdb.commons.auth.role.IRoleManager;
import org.apache.iotdb.commons.auth.role.LocalFileRoleAccessor;
import org.apache.iotdb.commons.concurrent.HashLock;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicRoleManager
implements IRoleManager {
    protected Map<String, Role> roleMap = new HashMap<String, Role>();
    protected IRoleAccessor accessor;
    protected HashLock lock;
    private boolean preVersion = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicRoleManager.class);

    BasicRoleManager(LocalFileRoleAccessor accessor) {
        this.accessor = accessor;
        this.lock = new HashLock();
        this.accessor.reset();
    }

    @Override
    public Role getRole(String rolename) {
        this.lock.readLock(rolename);
        Role role = this.roleMap.get(rolename);
        this.lock.readUnlock(rolename);
        return role;
    }

    @Override
    public boolean createRole(String rolename) throws AuthException {
        Role role = this.getRole(rolename);
        if (role != null) {
            return false;
        }
        this.lock.writeLock(rolename);
        role = new Role(rolename);
        this.roleMap.put(rolename, role);
        this.lock.writeUnlock(rolename);
        return true;
    }

    @Override
    public boolean deleteRole(String rolename) {
        this.lock.writeLock(rolename);
        try {
            boolean bl = this.roleMap.remove(rolename) != null;
            return bl;
        }
        finally {
            this.lock.writeUnlock(rolename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantPrivilegeToRole(String rolename, PartialPath path, int privilegeId, boolean grantOpt) throws AuthException {
        this.lock.writeLock(rolename);
        try {
            Role role = this.getRole(rolename);
            if (role == null) {
                throw new AuthException(TSStatusCode.ROLE_NOT_EXIST, String.format("No such role %s", rolename));
            }
            if (this.preVersion) {
                AuthUtils.validatePath(path);
                if (privilegeId == PriPrivilegeType.ALL.ordinal()) {
                    for (PriPrivilegeType type : PriPrivilegeType.values()) {
                        role.addPathPrivilege(path, type.ordinal(), false);
                    }
                } else {
                    role.addPathPrivilege(path, privilegeId, false);
                }
                if (role.getServiceReady()) {
                    role.setServiceReady(false);
                }
                return;
            }
            if (path != null) {
                AuthUtils.validatePatternPath(path);
                role.addPathPrivilege(path, privilegeId, grantOpt);
            } else {
                role.getSysPrivilege().add(privilegeId);
                if (grantOpt) {
                    role.getSysPriGrantOpt().add(privilegeId);
                }
            }
        }
        finally {
            this.lock.writeUnlock(rolename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean revokePrivilegeFromRole(String rolename, PartialPath path, int privilegeId) throws AuthException {
        this.lock.writeLock(rolename);
        try {
            Role role = this.getRole(rolename);
            if (role == null) {
                throw new AuthException(TSStatusCode.ROLE_NOT_EXIST, String.format("No such role %s", rolename));
            }
            if (this.preVersion) {
                if (!AuthUtils.hasPrivilege(path, privilegeId, role.getPathPrivilegeList())) {
                    boolean bl = false;
                    return bl;
                }
                AuthUtils.removePrivilegePre(path, privilegeId, role.getPathPrivilegeList());
                boolean bl = true;
                return bl;
            }
            if (!role.hasPrivilegeToRevoke(path, privilegeId)) {
                boolean bl = false;
                return bl;
            }
            if (path != null) {
                AuthUtils.validatePatternPath(path);
                role.removePathPrivilege(path, privilegeId);
            } else {
                role.getSysPrivilege().remove(privilegeId);
                role.getSysPriGrantOpt().remove(privilegeId);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(rolename);
        }
    }

    @Override
    public void reset() throws AuthException {
        this.accessor.reset();
        this.roleMap.clear();
        for (String roleName : this.accessor.listAllRoles()) {
            try {
                this.roleMap.put(roleName, this.accessor.loadRole(roleName));
            }
            catch (IOException e) {
                LOGGER.warn("Get exception when load role {}", (Object)roleName);
                throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
            }
        }
    }

    @Override
    public List<String> listAllRoles() {
        ArrayList<String> rtlist = new ArrayList<String>();
        this.roleMap.forEach((name, item) -> rtlist.add((String)name));
        rtlist.sort(null);
        return rtlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceAllRoles(Map<String, Role> roles) throws AuthException {
        BasicRoleManager basicRoleManager = this;
        synchronized (basicRoleManager) {
            this.reset();
            this.roleMap = roles;
            for (Map.Entry<String, Role> entry : this.roleMap.entrySet()) {
                Role role = entry.getValue();
                try {
                    this.accessor.saveRole(role);
                }
                catch (IOException e) {
                    throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setPreVersion(boolean preVersion) {
        this.preVersion = preVersion;
    }

    @Override
    @TestOnly
    public boolean preVersion() {
        return this.preVersion;
    }

    @Override
    public void checkAndRefreshPathPri() {
        this.roleMap.forEach((rolename, user) -> AuthUtils.checkAndRefreshPri(user));
    }
}

