/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.utils.TestOnly;

public enum PriPrivilegeType {
    CREATE_DATABASE(true, PrivilegeType.MANAGE_DATABASE),
    INSERT_TIMESERIES(true, PrivilegeType.WRITE_DATA),
    UPDATE_TIMESERIES(true, PrivilegeType.WRITE_DATA),
    READ_TIMESERIES(true, PrivilegeType.READ_DATA),
    CREATE_TIMESERIES(true, PrivilegeType.WRITE_SCHEMA),
    DELETE_TIMESERIES(true, PrivilegeType.WRITE_SCHEMA),
    CREATE_USER(false, PrivilegeType.MANAGE_USER),
    DELETE_USER(false, PrivilegeType.MANAGE_USER),
    MODIFY_PASSWORD(false),
    LIST_USER(false),
    GRANT_USER_PRIVILEGE(false),
    REVOKE_USER_PRIVILEGE(false),
    GRANT_USER_ROLE(false, PrivilegeType.MANAGE_ROLE),
    REVOKE_USER_ROLE(false, PrivilegeType.MANAGE_ROLE),
    CREATE_ROLE(false, PrivilegeType.MANAGE_ROLE),
    DELETE_ROLE(false, PrivilegeType.MANAGE_ROLE),
    LIST_ROLE(false),
    GRANT_ROLE_PRIVILEGE(false),
    REVOKE_ROLE_PRIVILEGE(false),
    CREATE_FUNCTION(false, PrivilegeType.USE_UDF),
    DROP_FUNCTION(false, PrivilegeType.USE_UDF),
    CREATE_TRIGGER(true, PrivilegeType.USE_TRIGGER),
    DROP_TRIGGER(true, PrivilegeType.USE_TRIGGER),
    START_TRIGGER(true, PrivilegeType.USE_TRIGGER),
    STOP_TRIGGER(true, PrivilegeType.USE_TRIGGER),
    CREATE_CONTINUOUS_QUERY(false, PrivilegeType.USE_CQ),
    DROP_CONTINUOUS_QUERY(false, PrivilegeType.USE_CQ),
    ALL(true, PrivilegeType.USE_PIPE, PrivilegeType.USE_UDF, PrivilegeType.USE_CQ, PrivilegeType.USE_MODEL, PrivilegeType.USE_TRIGGER, PrivilegeType.MANAGE_USER, PrivilegeType.MANAGE_ROLE, PrivilegeType.MANAGE_DATABASE, PrivilegeType.EXTEND_TEMPLATE, PrivilegeType.WRITE_SCHEMA, PrivilegeType.WRITE_DATA, PrivilegeType.READ_DATA, PrivilegeType.READ_SCHEMA, PrivilegeType.MAINTAIN),
    DELETE_DATABASE(true, PrivilegeType.MANAGE_DATABASE),
    ALTER_TIMESERIES(true, PrivilegeType.WRITE_SCHEMA),
    UPDATE_TEMPLATE(false),
    READ_TEMPLATE(false),
    APPLY_TEMPLATE(true, PrivilegeType.WRITE_SCHEMA),
    READ_TEMPLATE_APPLICATION(false),
    SHOW_CONTINUOUS_QUERIES(false),
    CREATE_PIPEPLUGIN(false, PrivilegeType.USE_PIPE),
    DROP_PIPEPLUGIN(false, PrivilegeType.USE_PIPE),
    SHOW_PIPEPLUGINS(false),
    CREATE_PIPE(false, PrivilegeType.USE_PIPE),
    START_PIPE(false, PrivilegeType.USE_PIPE),
    STOP_PIPE(false, PrivilegeType.USE_PIPE),
    DROP_PIPE(false, PrivilegeType.USE_PIPE),
    SHOW_PIPES(false),
    CREATE_VIEW(true, PrivilegeType.WRITE_SCHEMA),
    ALTER_VIEW(true, PrivilegeType.WRITE_SCHEMA),
    RENAME_VIEW(true, PrivilegeType.WRITE_SCHEMA),
    DELETE_VIEW(true, PrivilegeType.WRITE_SCHEMA);

    boolean accept = false;
    private final boolean preIsPathRelevant;
    private final List<PrivilegeType> refPri = new ArrayList<PrivilegeType>();

    private PriPrivilegeType(boolean accept) {
        this.accept = accept;
        this.preIsPathRelevant = false;
    }

    private PriPrivilegeType(boolean preIsPathRelevant, PrivilegeType ... privilegeTypes) {
        this.accept = true;
        this.preIsPathRelevant = preIsPathRelevant;
        this.refPri.addAll(Arrays.asList(privilegeTypes));
    }

    public boolean isAccept() {
        return this.accept;
    }

    @TestOnly
    public boolean isPrePathRelevant() {
        return this.preIsPathRelevant;
    }

    public Set<PrivilegeType> getSubPri() {
        HashSet<PrivilegeType> result = new HashSet<PrivilegeType>();
        for (PrivilegeType peivType : this.refPri) {
            result.add(peivType);
        }
        return result;
    }

    public Set<Integer> getSubPriOrd() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (PrivilegeType peivType : this.refPri) {
            result.add(peivType.ordinal());
        }
        return result;
    }

    public Set<Integer> getSubSysPriOrd() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (PrivilegeType peivType : this.refPri) {
            if (peivType.isPathRelevant()) continue;
            result.add(peivType.ordinal());
        }
        return result;
    }
}

