/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.PreDeleteTablePlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.SchemaUtils;
import org.apache.iotdb.confignode.procedure.impl.schema.table.AbstractAlterOrDropTableProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.DropTableState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteDataOrDevicesForDropTableReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateTableCacheReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTableProcedure
extends AbstractAlterOrDropTableProcedure<DropTableState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropTableProcedure.class);

    public DropTableProcedure() {
    }

    public DropTableProcedure(String database, String tableName, String queryId) {
        super(database, tableName, queryId);
    }

    @Override
    protected String getActionMessage() {
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DropTableState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkAndPreDeleteTable(ConfigNodeProcedureEnv env) {
        TSStatus status = SchemaUtils.executeInConsensusLayer(new PreDeleteTablePlan(this.database, this.tableName), env, LOGGER);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(DropTableState.INVALIDATE_CACHE);
        } else {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    private void invalidateCache(ConfigNodeProcedureEnv env) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.INVALIDATE_TABLE_CACHE, new TInvalidateTableCacheReq(this.database, this.tableName), dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to invalidate schemaEngine cache of table {}.{}", (Object)this.database, (Object)this.tableName);
            this.setFailure(new ProcedureException(new MetadataException("Invalidate schemaEngine cache failed")));
            return;
        }
        this.setNextState(DropTableState.DELETE_DATA);
    }

    private void deleteData(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> relatedDataRegionGroup = env.getConfigManager().getRelatedDataRegionGroup4TableModel(this.database);
        if (!relatedDataRegionGroup.isEmpty()) {
            new AbstractAlterOrDropTableProcedure.TableRegionTaskExecutor<TDeleteDataOrDevicesForDropTableReq>("delete data for drop table", env, relatedDataRegionGroup, CnToDnAsyncRequestType.DELETE_DATA_FOR_DROP_TABLE, (dataNodeLocation, consensusGroupIdList) -> new TDeleteDataOrDevicesForDropTableReq(new ArrayList(consensusGroupIdList), this.tableName)).execute();
        }
        this.setNextState(DropTableState.DELETE_DEVICES);
    }

    private void deleteSchema(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> relatedSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup4TableModel(this.database);
        if (!relatedSchemaRegionGroup.isEmpty()) {
            new AbstractAlterOrDropTableProcedure.TableRegionTaskExecutor<TDeleteDataOrDevicesForDropTableReq>("delete devices for drop table", env, relatedSchemaRegionGroup, CnToDnAsyncRequestType.DELETE_DEVICES_FOR_DROP_TABLE, (dataNodeLocation, consensusGroupIdList) -> new TDeleteDataOrDevicesForDropTableReq(new ArrayList(consensusGroupIdList), this.tableName)).execute();
        }
        this.setNextState(DropTableState.DROP_TABLE);
    }

    private void dropTable(ConfigNodeProcedureEnv env) {
        TSStatus status = SchemaUtils.executeInConsensusLayer(new CommitDeleteTablePlan(this.database, this.tableName), env, LOGGER);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status.getMessage(), status.getCode())));
        }
    }

    @Override
    protected boolean isRollbackSupported(DropTableState state) {
        return false;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv configNodeProcedureEnv, DropTableState dropTableState) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected DropTableState getState(int stateId) {
        return DropTableState.values()[stateId];
    }

    @Override
    protected int getStateId(DropTableState dropTableState) {
        return dropTableState.ordinal();
    }

    @Override
    protected DropTableState getInitialState() {
        return DropTableState.CHECK_AND_INVALIDATE_TABLE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.DROP_TABLE_PROCEDURE.getTypeCode());
        super.serialize(stream);
    }
}

