/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.region;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.KillPoint.KillPoint;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.env.RegionMaintainHandler;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.state.AddRegionPeerState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.mpp.rpc.thrift.TRegionMigrateResult;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddRegionPeerProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, AddRegionPeerState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddRegionPeerProcedure.class);
    private TConsensusGroupId consensusGroupId;
    private TDataNodeLocation coordinator;
    private TDataNodeLocation destDataNode;

    public AddRegionPeerProcedure() {
    }

    public AddRegionPeerProcedure(TConsensusGroupId consensusGroupId, TDataNodeLocation coordinator, TDataNodeLocation destDataNode) {
        this.consensusGroupId = consensusGroupId;
        this.coordinator = coordinator;
        this.destDataNode = destDataNode;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, AddRegionPeerState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        if (this.consensusGroupId == null) {
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        RegionMaintainHandler handler = env.getRegionMaintainHandler();
        try {
            block1 : switch (state) {
                case CREATE_NEW_REGION_PEER: {
                    LOGGER.info("[pid{}][AddRegion] started, {} will be added to DataNode {}.", new Object[]{this.getProcId(), this.consensusGroupId, handler.simplifiedLocation(this.destDataNode)});
                    handler.addRegionLocation(this.consensusGroupId, this.destDataNode);
                    handler.forceUpdateRegionCache(this.consensusGroupId, this.destDataNode, RegionStatus.Adding);
                    TSStatus status = handler.createNewRegionPeer(this.consensusGroupId, this.destDataNode);
                    KillPoint.setKillPoint((Enum)state);
                    if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        return this.warnAndRollBackAndNoMoreState(env, handler, "CREATE_NEW_REGION_PEER fail");
                    }
                    this.setNextState(AddRegionPeerState.DO_ADD_REGION_PEER);
                    break;
                }
                case DO_ADD_REGION_PEER: {
                    handler.forceUpdateRegionCache(this.consensusGroupId, this.destDataNode, RegionStatus.Adding);
                    if (!this.isStateDeserialized()) {
                        TSStatus tsStatus = handler.submitAddRegionPeerTask(this.getProcId(), this.destDataNode, this.consensusGroupId, this.coordinator);
                        KillPoint.setKillPoint((Enum)state);
                        if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            return this.warnAndRollBackAndNoMoreState(env, handler, "submit DO_ADD_REGION_PEER task fail");
                        }
                    }
                    TRegionMigrateResult result = handler.waitTaskFinish(this.getProcId(), this.coordinator);
                    switch (result.getTaskStatus()) {
                        case TASK_NOT_EXIST: 
                        case FAIL: {
                            return this.warnAndRollBackAndNoMoreState(env, handler, String.format("%s result is %s", new Object[]{state, result.getTaskStatus()}));
                        }
                        case PROCESSING: {
                            LOGGER.info("waitTaskFinish() returns PROCESSING, which means the waiting has been interrupted, this procedure will end without rollback");
                            return StateMachineProcedure.Flow.NO_MORE_STATE;
                        }
                        case SUCCESS: {
                            this.setNextState(AddRegionPeerState.UPDATE_REGION_LOCATION_CACHE);
                            break block1;
                        }
                    }
                    return this.warnAndRollBackAndNoMoreState(env, handler, String.format("status %s is unsupported", result.getTaskStatus()));
                }
                case UPDATE_REGION_LOCATION_CACHE: {
                    handler.forceUpdateRegionCache(this.consensusGroupId, this.destDataNode, RegionStatus.Running);
                    KillPoint.setKillPoint((Enum)state);
                    LOGGER.info("[pid{}][AddRegion] state {} complete", (Object)this.getProcId(), (Object)state);
                    LOGGER.info("[pid{}][AddRegion] success, {} has been added to DataNode {}. Procedure took {} (start at {}).", new Object[]{this.getProcId(), this.consensusGroupId, handler.simplifiedLocation(this.destDataNode), CommonDateTimeUtils.convertMillisecondToDurationStr((long)(System.currentTimeMillis() - this.getSubmittedTime())), DateTimeUtils.convertLongToDate((long)this.getSubmittedTime(), (String)"ms")});
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new ProcedureException("Unsupported state: " + state.name());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[pid{}][AddRegion] state {} failed", new Object[]{this.getProcId(), state, e});
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        LOGGER.info("[pid{}][AddRegion] state {} complete", (Object)this.getProcId(), (Object)state);
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private StateMachineProcedure.Flow warnAndRollBackAndNoMoreState(ConfigNodeProcedureEnv env, RegionMaintainHandler handler, String reason) throws ProcedureException {
        return this.warnAndRollBackAndNoMoreState(env, handler, reason, null);
    }

    private StateMachineProcedure.Flow warnAndRollBackAndNoMoreState(ConfigNodeProcedureEnv env, RegionMaintainHandler handler, String reason, Exception e) throws ProcedureException {
        if (e != null) {
            LOGGER.warn("[pid{}][AddRegion] Start to roll back, because: {}", new Object[]{this.getProcId(), reason, e});
        } else {
            LOGGER.warn("[pid{}][AddRegion] Start to roll back, because: {}", (Object)this.getProcId(), (Object)reason);
        }
        handler.removeRegionLocation(this.consensusGroupId, this.destDataNode);
        List correctDataNodeLocations = env.getConfigManager().getPartitionManager().getAllReplicaSets().stream().filter(tRegionReplicaSet -> tRegionReplicaSet.getRegionId().equals(this.consensusGroupId)).findAny().orElseThrow(() -> new ProcedureException("[pid{}][AddRegion] Cannot roll back, because cannot find the correct locations")).getDataNodeLocations();
        if (correctDataNodeLocations.remove(this.destDataNode)) {
            LOGGER.warn("[pid{}][AddRegion] It appears that consensus write has not modified the local partition table. Please verify whether a leader change has occurred during this stage. If this log is triggered without a leader change, it indicates a potential bug in the partition table.", (Object)this.getProcId());
        }
        String correctStr = correctDataNodeLocations.stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList()).toString();
        ArrayList<TDataNodeLocation> relatedDataNodeLocations = new ArrayList<TDataNodeLocation>(correctDataNodeLocations);
        relatedDataNodeLocations.add(this.destDataNode);
        Map<Integer, TDataNodeLocation> relatedDataNodeLocationMap = relatedDataNodeLocations.stream().collect(Collectors.toMap(TDataNodeLocation::getDataNodeId, dataNodeLocation -> dataNodeLocation));
        LOGGER.info("[pid{}][AddRegion] reset peer list: peer list of consensus group {} on DataNode {} will be reset to {}", new Object[]{this.getProcId(), this.consensusGroupId, relatedDataNodeLocationMap.values().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList()), correctStr});
        Map<Integer, TSStatus> resultMap = handler.resetPeerList(this.consensusGroupId, correctDataNodeLocations, relatedDataNodeLocationMap);
        resultMap.forEach((dataNodeId, resetResult) -> {
            if (resetResult.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.info("[pid{}][AddRegion] reset peer list: peer list of consensus group {} on DataNode {} has been successfully reset to {}", new Object[]{this.getProcId(), this.consensusGroupId, dataNodeId, correctStr});
            } else {
                LOGGER.warn("[pid{}][AddRegion] reset peer list: peer list of consensus group {} on DataNode {} failed to reset to {}, you may manually reset it", new Object[]{this.getProcId(), this.consensusGroupId, dataNodeId, correctStr});
            }
        });
        return StateMachineProcedure.Flow.NO_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv configNodeProcedureEnv, AddRegionPeerState addRegionPeerState) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected AddRegionPeerState getState(int stateId) {
        return AddRegionPeerState.values()[stateId];
    }

    @Override
    protected int getStateId(AddRegionPeerState addRegionPeerState) {
        return addRegionPeerState.ordinal();
    }

    @Override
    protected AddRegionPeerState getInitialState() {
        return AddRegionPeerState.CREATE_NEW_REGION_PEER;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.ADD_REGION_PEER_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.consensusGroupId, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.destDataNode, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.coordinator, (DataOutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.consensusGroupId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer);
            this.destDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            this.coordinator = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOGGER.error("Error in deserialize {}", this.getClass(), (Object)e);
        }
    }

    public TConsensusGroupId getConsensusGroupId() {
        return this.consensusGroupId;
    }

    public TDataNodeLocation getCoordinator() {
        return this.coordinator;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddRegionPeerProcedure)) {
            return false;
        }
        AddRegionPeerProcedure procedure = (AddRegionPeerProcedure)obj;
        return this.consensusGroupId.equals(procedure.consensusGroupId) && this.destDataNode.equals(procedure.destDataNode) && this.coordinator.equals(procedure.coordinator);
    }

    public int hashCode() {
        return Objects.hash(this.consensusGroupId, this.destDataNode, this.coordinator);
    }
}

