/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionMaintainTaskStatus;
import org.apache.iotdb.common.rpc.thrift.TRegionMigrateFailedType;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.client.sync.CnToDnSyncRequestType;
import org.apache.iotdb.confignode.client.sync.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.partition.AddRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.RemoveRegionLocationPlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupHeartbeatSample;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.scheduler.LockQueue;
import org.apache.iotdb.mpp.rpc.thrift.TCreatePeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TMaintainPeerReq;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeResp;
import org.apache.iotdb.mpp.rpc.thrift.TRegionMigrateResult;
import org.apache.iotdb.mpp.rpc.thrift.TResetPeerListReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionMaintainHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionMaintainHandler.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final ConfigManager configManager;
    private final LockQueue regionMigrateLock = new LockQueue();
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> dataNodeClientManager;

    public RegionMaintainHandler(ConfigManager configManager) {
        this.configManager = configManager;
        this.dataNodeClientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.SyncDataNodeInternalServiceClientPoolFactory());
    }

    public static String getIdWithRpcEndpoint(TDataNodeLocation location) {
        return String.format("[dataNodeId: %s, clientRpcEndPoint: %s]", location.getDataNodeId(), location.getClientRpcEndPoint());
    }

    public String simplifiedLocation(TDataNodeLocation dataNodeLocation) {
        return dataNodeLocation.getDataNodeId() + "@" + dataNodeLocation.getInternalEndPoint().getIp();
    }

    public TDataNodeLocation findDestDataNode(TConsensusGroupId regionId) {
        List<TDataNodeLocation> regionReplicaNodes = this.findRegionLocations(regionId);
        if (regionReplicaNodes.isEmpty()) {
            LOGGER.warn("Cannot find region replica nodes, region: {}", (Object)regionId);
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Cannot find region replica nodes, region: " + regionId);
            return null;
        }
        Optional<TDataNodeLocation> newNode = this.pickNewReplicaNodeForRegion(regionReplicaNodes);
        if (!newNode.isPresent()) {
            LOGGER.warn("No enough Data node to migrate region: {}", (Object)regionId);
            return null;
        }
        return newNode.get();
    }

    public TSStatus createNewRegionPeer(TConsensusGroupId regionId, TDataNodeLocation destDataNode) {
        List currentPeerNodes;
        List<TDataNodeLocation> regionReplicaNodes = this.findRegionLocations(regionId);
        if (regionReplicaNodes.isEmpty()) {
            LOGGER.warn("{}, Cannot find region replica nodes in createPeer, regionId: {}", (Object)"[REGION_MIGRATE_PROCESS]", (Object)regionId);
            TSStatus status = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            status.setMessage("Not find region replica nodes in createPeer, regionId: " + regionId);
            return status;
        }
        if (TConsensusGroupType.DataRegion.equals((Object)regionId.getType()) && ("org.apache.iotdb.consensus.iot.IoTConsensus".equals(CONF.getDataRegionConsensusProtocolClass()) || "org.apache.iotdb.consensus.iot.IoTConsensusV2".equals(CONF.getDataRegionConsensusProtocolClass()))) {
            currentPeerNodes = new ArrayList<TDataNodeLocation>(regionReplicaNodes);
            currentPeerNodes.add(destDataNode);
        } else {
            currentPeerNodes = Collections.emptyList();
        }
        String database = this.configManager.getPartitionManager().getRegionDatabase(regionId);
        TCreatePeerReq req = new TCreatePeerReq(regionId, currentPeerNodes, database);
        TSStatus status = (TSStatus)SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(destDataNode.getInternalEndPoint(), req, CnToDnSyncRequestType.CREATE_NEW_REGION_PEER);
        if (this.isSucceed(status)) {
            LOGGER.info("{}, Send action createNewRegionPeer finished, regionId: {}, newPeerDataNodeId: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, RegionMaintainHandler.getIdWithRpcEndpoint(destDataNode)});
        } else {
            LOGGER.error("{}, Send action createNewRegionPeer error, regionId: {}, newPeerDataNodeId: {}, result: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, RegionMaintainHandler.getIdWithRpcEndpoint(destDataNode), status});
        }
        return status;
    }

    public TSStatus submitAddRegionPeerTask(long procedureId, TDataNodeLocation destDataNode, TConsensusGroupId regionId, TDataNodeLocation coordinator) {
        TMaintainPeerReq maintainPeerReq = new TMaintainPeerReq(regionId, destDataNode, procedureId);
        TSStatus status = (TSStatus)SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(coordinator.getInternalEndPoint(), maintainPeerReq, CnToDnSyncRequestType.ADD_REGION_PEER);
        LOGGER.info("{}, Send action addRegionPeer finished, regionId: {}, rpcDataNode: {},  destDataNode: {}, status: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, RegionMaintainHandler.getIdWithRpcEndpoint(coordinator), RegionMaintainHandler.getIdWithRpcEndpoint(destDataNode), status});
        return status;
    }

    public TSStatus submitRemoveRegionPeerTask(long procedureId, TDataNodeLocation originalDataNode, TConsensusGroupId regionId, TDataNodeLocation coordinator) {
        TMaintainPeerReq maintainPeerReq = new TMaintainPeerReq(regionId, originalDataNode, procedureId);
        TSStatus status = (TSStatus)SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(coordinator.getInternalEndPoint(), maintainPeerReq, CnToDnSyncRequestType.REMOVE_REGION_PEER);
        LOGGER.info("{}, Send action removeRegionPeer finished, regionId: {}, rpcDataNode: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, RegionMaintainHandler.getIdWithRpcEndpoint(coordinator)});
        return status;
    }

    public TSStatus submitDeleteOldRegionPeerTask(long procedureId, TDataNodeLocation originalDataNode, TConsensusGroupId regionId) {
        TMaintainPeerReq maintainPeerReq = new TMaintainPeerReq(regionId, originalDataNode, procedureId);
        TSStatus status = this.configManager.getLoadManager().getNodeStatus(originalDataNode.getDataNodeId()) == NodeStatus.Unknown ? (TSStatus)SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithGivenRetry(originalDataNode.getInternalEndPoint(), maintainPeerReq, CnToDnSyncRequestType.DELETE_OLD_REGION_PEER, 1) : (TSStatus)SyncDataNodeClientPool.getInstance().sendSyncRequestToDataNodeWithRetry(originalDataNode.getInternalEndPoint(), maintainPeerReq, CnToDnSyncRequestType.DELETE_OLD_REGION_PEER);
        LOGGER.info("{}, Send action deleteOldRegionPeer finished, regionId: {}, dataNodeId: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, originalDataNode.getInternalEndPoint()});
        return status;
    }

    public Map<Integer, TSStatus> resetPeerList(TConsensusGroupId regionId, List<TDataNodeLocation> correctDataNodeLocations, Map<Integer, TDataNodeLocation> dataNodeLocationMap) {
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.RESET_PEER_LIST, new TResetPeerListReq(regionId, correctDataNodeLocations), dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TRegionMigrateResult waitTaskFinish(long taskId, TDataNodeLocation dataNodeLocation) {
        long MAX_DISCONNECTION_TOLERATE_MS = 600000L;
        long INITIAL_DISCONNECTION_TOLERATE_MS = 60000L;
        long startTime = System.nanoTime();
        long lastReportTime = System.nanoTime();
        while (true) {
            try (SyncDataNodeInternalServiceClient dataNodeClient2222 = (SyncDataNodeInternalServiceClient)this.dataNodeClientManager.borrowClient((Object)dataNodeLocation.getInternalEndPoint());){
                TRegionMigrateResult report = dataNodeClient2222.getRegionMaintainResult(taskId);
                lastReportTime = System.nanoTime();
                if (report.getTaskStatus() != TRegionMaintainTaskStatus.PROCESSING) {
                    TRegionMigrateResult tRegionMigrateResult = report;
                    return tRegionMigrateResult;
                }
            }
            catch (Exception dataNodeClient2222) {
                // empty catch block
            }
            long waitTime = Math.min(60000L + TimeUnit.NANOSECONDS.toMillis(lastReportTime - startTime) / 60L, 600000L);
            long disconnectionTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - lastReportTime);
            if (disconnectionTime > waitTime) {
                LOGGER.warn("{} task {} cannot get task report from DataNode {}, last report time is {} ago", new Object[]{"[REGION_MIGRATE_PROCESS]", taskId, dataNodeLocation, CommonDateTimeUtils.convertMillisecondToDurationStr((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - lastReportTime))});
                TRegionMigrateResult report = new TRegionMigrateResult();
                report.setTaskStatus(TRegionMaintainTaskStatus.FAIL);
                report.setFailedNodeAndReason(new HashMap());
                report.getFailedNodeAndReason().put(dataNodeLocation, TRegionMigrateFailedType.Disconnect);
                return report;
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                return new TRegionMigrateResult(TRegionMaintainTaskStatus.PROCESSING);
            }
        }
    }

    public void addRegionLocation(TConsensusGroupId regionId, TDataNodeLocation newLocation) {
        AddRegionLocationPlan req = new AddRegionLocationPlan(regionId, newLocation);
        TSStatus status = this.configManager.getPartitionManager().addRegionLocation(req);
        LOGGER.info("AddRegionLocation finished, add region {} to {}, result is {}", new Object[]{regionId, RegionMaintainHandler.getIdWithRpcEndpoint(newLocation), status});
        this.configManager.getLoadManager().getLoadCache().createRegionCache(regionId, newLocation.getDataNodeId());
    }

    public void forceUpdateRegionCache(TConsensusGroupId regionId, TDataNodeLocation newLocation, RegionStatus regionStatus) {
        this.configManager.getLoadManager().forceUpdateRegionCache(regionId, newLocation.getDataNodeId(), regionStatus);
    }

    public void removeRegionLocation(TConsensusGroupId regionId, TDataNodeLocation deprecatedLocation) {
        RemoveRegionLocationPlan req = new RemoveRegionLocationPlan(regionId, deprecatedLocation);
        TSStatus status = this.configManager.getPartitionManager().removeRegionLocation(req);
        LOGGER.info("RemoveRegionLocation remove region {} from DataNode {}, result is {}", new Object[]{regionId, RegionMaintainHandler.getIdWithRpcEndpoint(deprecatedLocation), status});
        this.configManager.getLoadManager().removeRegionCache(regionId, deprecatedLocation.getDataNodeId());
        this.configManager.getLoadManager().getRouteBalancer().balanceRegionLeaderAndPriority();
    }

    public List<TDataNodeLocation> findRegionLocations(TConsensusGroupId regionId) {
        Optional<TRegionReplicaSet> regionReplicaSet = this.getRegionReplicaSet(regionId);
        if (regionReplicaSet.isPresent()) {
            return regionReplicaSet.get().getDataNodeLocations();
        }
        return Collections.emptyList();
    }

    public Optional<TRegionReplicaSet> getRegionReplicaSet(TConsensusGroupId regionId) {
        return this.configManager.getPartitionManager().getAllReplicaSets().stream().filter(rg -> rg.regionId.equals(regionId)).findAny();
    }

    public String getRegionReplicaSetString(TConsensusGroupId regionId) {
        Optional<TRegionReplicaSet> regionReplicaSet = this.getRegionReplicaSet(regionId);
        if (!regionReplicaSet.isPresent()) {
            return "UNKNOWN!";
        }
        StringBuilder result = new StringBuilder(regionReplicaSet.get().getRegionId() + ": {");
        for (TDataNodeLocation dataNodeLocation : regionReplicaSet.get().getDataNodeLocations()) {
            result.append(this.simplifiedLocation(dataNodeLocation)).append(", ");
        }
        result.append("}");
        return result.toString();
    }

    private Optional<TDataNodeLocation> pickNewReplicaNodeForRegion(List<TDataNodeLocation> regionReplicaNodes) {
        List<TDataNodeConfiguration> dataNodeConfigurations = this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running);
        Collections.shuffle(dataNodeConfigurations);
        return dataNodeConfigurations.stream().map(TDataNodeConfiguration::getLocation).filter(e -> !regionReplicaNodes.contains(e)).findAny();
    }

    public boolean isSucceed(TSStatus status) {
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode();
    }

    public boolean isFailed(TSStatus status) {
        return !this.isSucceed(status);
    }

    public LockQueue getRegionMigrateLock() {
        return this.regionMigrateLock;
    }

    public void transferRegionLeader(TConsensusGroupId regionId, TDataNodeLocation originalDataNode, TDataNodeLocation coodinator) throws ProcedureException, InterruptedException {
        Optional<Object> newLeaderNode = Optional.empty();
        ArrayList<TDataNodeLocation> excludeDataNode = new ArrayList<TDataNodeLocation>();
        excludeDataNode.add(originalDataNode);
        excludeDataNode.add(coodinator);
        newLeaderNode = this.filterDataNodeWithOtherRegionReplica(regionId, excludeDataNode);
        if (!newLeaderNode.isPresent()) {
            newLeaderNode = Optional.of(coodinator);
        }
        long timestamp = System.nanoTime();
        if (TConsensusGroupType.SchemaRegion.equals((Object)regionId.getType()) || TConsensusGroupType.DataRegion.equals((Object)regionId.getType()) && "org.apache.iotdb.consensus.ratis.RatisConsensus".equals(CONF.getDataRegionConsensusProtocolClass())) {
            int MAX_RETRY_TIME = 10;
            int retryTime = 0;
            long sleepTime = (CONF.getSchemaRegionRatisRpcLeaderElectionTimeoutMaxMs() + CONF.getSchemaRegionRatisRpcLeaderElectionTimeoutMinMs()) / 2L;
            Integer leaderId = this.configManager.getLoadManager().getRegionLeaderMap().get(regionId);
            if (leaderId != -1 && originalDataNode.getDataNodeId() != leaderId.intValue()) {
                return;
            }
            while (true) {
                TRegionLeaderChangeResp resp;
                if ((resp = SyncDataNodeClientPool.getInstance().changeRegionLeader(regionId, originalDataNode.getInternalEndPoint(), (TDataNodeLocation)newLeaderNode.get())).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    timestamp = resp.getConsensusLogicalTimestamp();
                    break;
                }
                if (retryTime++ > 10) {
                    LOGGER.warn("[RemoveRegion] Ratis transfer leader fail, but procedure will continue.");
                    return;
                }
                LOGGER.warn("Call changeRegionLeader fail for the {} time, will sleep {} ms", (Object)retryTime, (Object)sleepTime);
                Thread.sleep(sleepTime);
            }
        }
        this.configManager.getLoadManager().forceUpdateConsensusGroupCache(Collections.singletonMap(regionId, new ConsensusGroupHeartbeatSample(timestamp, ((TDataNodeLocation)newLeaderNode.get()).getDataNodeId())));
        this.configManager.getLoadManager().getRouteBalancer().balanceRegionLeaderAndPriority();
        LOGGER.info("{}, Change region leader finished, regionId: {}, newLeaderNode: {}", new Object[]{"[REGION_MIGRATE_PROCESS]", regionId, newLeaderNode});
    }

    public Optional<TDataNodeLocation> filterDataNodeWithOtherRegionReplica(TConsensusGroupId regionId, TDataNodeLocation filterLocation) {
        List<TDataNodeLocation> filterLocations = Collections.singletonList(filterLocation);
        return this.filterDataNodeWithOtherRegionReplica(regionId, filterLocations);
    }

    public Optional<TDataNodeLocation> filterDataNodeWithOtherRegionReplica(TConsensusGroupId regionId, List<TDataNodeLocation> filterLocations) {
        return this.filterDataNodeWithOtherRegionReplica(regionId, filterLocations, NodeStatus.Running, NodeStatus.ReadOnly);
    }

    public Optional<TDataNodeLocation> filterDataNodeWithOtherRegionReplica(TConsensusGroupId regionId, TDataNodeLocation filterLocation, NodeStatus ... allowingStatus) {
        List<TDataNodeLocation> excludeLocations = Collections.singletonList(filterLocation);
        return this.filterDataNodeWithOtherRegionReplica(regionId, excludeLocations, allowingStatus);
    }

    public Optional<TDataNodeLocation> filterDataNodeWithOtherRegionReplica(TConsensusGroupId regionId, List<TDataNodeLocation> excludeLocations, NodeStatus ... allowingStatus) {
        List<TDataNodeLocation> regionLocations = this.findRegionLocations(regionId);
        if (regionLocations.isEmpty()) {
            LOGGER.warn("Cannot find DataNodes contain the given region: {}", (Object)regionId);
            return Optional.empty();
        }
        List aliveDataNodes = this.configManager.getNodeManager().filterDataNodeThroughStatus(allowingStatus).stream().map(TDataNodeConfiguration::getLocation).collect(Collectors.toList());
        Collections.shuffle(aliveDataNodes);
        for (TDataNodeLocation aliveDataNode : aliveDataNodes) {
            if (!regionLocations.contains(aliveDataNode) || excludeLocations.contains(aliveDataNode)) continue;
            return Optional.of(aliveDataNode);
        }
        return Optional.empty();
    }
}

