/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.schema;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.TsTableInternalRPCUtil;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.database.CountDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.database.GetDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.read.table.DescTable4InformationSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.read.table.DescTablePlan;
import org.apache.iotdb.confignode.consensus.request.read.table.FetchTablePlan;
import org.apache.iotdb.confignode.consensus.request.read.table.ShowTable4InformationSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.read.table.ShowTablePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetAllSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetAllTemplateSetInfoPlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetPathsSetTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.read.template.GetTemplateSetInfoPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.AdjustMaxRegionGroupNumPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetDataReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetSchemaReplicationFactorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTimePartitionIntervalPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.AddTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.RenameTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTablePropertiesPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.DropSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.RollbackPreUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.UnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.response.database.CountDatabaseResp;
import org.apache.iotdb.confignode.consensus.response.database.DatabaseSchemaResp;
import org.apache.iotdb.confignode.consensus.response.partition.PathInfoResp;
import org.apache.iotdb.confignode.consensus.response.table.DescTable4InformationSchemaResp;
import org.apache.iotdb.confignode.consensus.response.table.DescTableResp;
import org.apache.iotdb.confignode.consensus.response.table.FetchTableResp;
import org.apache.iotdb.confignode.consensus.response.table.ShowTable4InformationSchemaResp;
import org.apache.iotdb.confignode.consensus.response.table.ShowTableResp;
import org.apache.iotdb.confignode.consensus.response.template.AllTemplateSetInfoResp;
import org.apache.iotdb.confignode.consensus.response.template.TemplateInfoResp;
import org.apache.iotdb.confignode.consensus.response.template.TemplateSetInfoResp;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.partition.PartitionMetrics;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaQuotaStatistics;
import org.apache.iotdb.confignode.persistence.schema.ClusterSchemaInfo;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseInfo;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDescTable4InformationSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TDescTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TFetchTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetPathsSetTemplatesResp;
import org.apache.iotdb.confignode.rpc.thrift.TGetTemplateResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowDatabaseResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowTable4InformationSchemaResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowTableResp;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.TemplateInternalRPCUpdateType;
import org.apache.iotdb.db.schemaengine.template.TemplateInternalRPCUtil;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateExtendInfo;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTemplateReq;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSchemaManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final int SCHEMA_REGION_PER_DATA_NODE = CONF.getSchemaRegionPerDataNode();
    private static final int DATA_REGION_PER_DATA_NODE = CONF.getDataRegionPerDataNode();
    private final IManager configManager;
    private final ClusterSchemaInfo clusterSchemaInfo;
    private final ClusterSchemaQuotaStatistics schemaQuotaStatistics;
    private final ReentrantLock createDatabaseLock = new ReentrantLock();
    private static final String CONSENSUS_READ_ERROR = "Failed in the read API executing the consensus layer due to: ";
    private static final String CONSENSUS_WRITE_ERROR = "Failed in the write API executing the consensus layer due to: ";

    public ClusterSchemaManager(IManager configManager, ClusterSchemaInfo clusterSchemaInfo, ClusterSchemaQuotaStatistics schemaQuotaStatistics) {
        this.configManager = configManager;
        this.clusterSchemaInfo = clusterSchemaInfo;
        this.schemaQuotaStatistics = schemaQuotaStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setDatabase(DatabaseSchemaPlan databaseSchemaPlan, boolean isGeneratedByPipe) {
        TSStatus result;
        TDatabaseSchema schema = databaseSchemaPlan.getSchema();
        if (this.getPartitionManager().isDatabasePreDeleted(schema.getName())) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)String.format("Some other task is deleting database %s", schema.getName()));
        }
        this.createDatabaseLock.lock();
        try {
            this.clusterSchemaInfo.isDatabaseNameValid(schema.getName(), schema.isSetIsTableModel() && schema.isIsTableModel());
            if (!schema.getName().equals("root.__system")) {
                this.clusterSchemaInfo.checkDatabaseLimit();
            }
            result = this.getConsensusManager().write(isGeneratedByPipe ? new PipeEnrichedPlan(databaseSchemaPlan) : databaseSchemaPlan);
            if (schema.isSetTTL()) {
                result = this.configManager.getTTLManager().setTTL(databaseSchemaPlan, isGeneratedByPipe);
            }
            PartitionMetrics.bindDatabaseRelatedMetricsWhenUpdate((AbstractMetricService)MetricService.getInstance(), this.configManager, schema.getName(), schema.getDataReplicationFactor(), schema.getSchemaReplicationFactor());
            this.adjustMaxRegionGroupNum();
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
        }
        catch (MetadataException metadataException) {
            result = new TSStatus(metadataException.getErrorCode());
            result.setMessage(metadataException.getMessage());
        }
        finally {
            this.createDatabaseLock.unlock();
        }
        return result;
    }

    public TSStatus alterDatabase(DatabaseSchemaPlan databaseSchemaPlan, boolean isGeneratedByPipe) {
        TDatabaseSchema databaseSchema = databaseSchemaPlan.getSchema();
        if (!this.isDatabaseExist(databaseSchema.getName())) {
            TSStatus result = new TSStatus(TSStatusCode.DATABASE_NOT_EXIST.getStatusCode());
            result.setMessage("Failed to alter database. The Database " + databaseSchema.getName() + " doesn't exist.");
            return result;
        }
        if (databaseSchema.isSetMinSchemaRegionGroupNum()) {
            int minSchemaRegionGroupNum = this.getMinRegionGroupNum(databaseSchema.getName(), TConsensusGroupType.SchemaRegion);
            if (databaseSchema.getMinSchemaRegionGroupNum() <= minSchemaRegionGroupNum) {
                TSStatus result = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode());
                result.setMessage(String.format("Failed to alter database. The SchemaRegionGroupNum could only be increased. Current SchemaRegionGroupNum: %d, Alter SchemaRegionGroupNum: %d", minSchemaRegionGroupNum, databaseSchema.getMinSchemaRegionGroupNum()));
                return result;
            }
        }
        if (databaseSchema.isSetMinDataRegionGroupNum()) {
            int minDataRegionGroupNum = this.getMinRegionGroupNum(databaseSchema.getName(), TConsensusGroupType.DataRegion);
            if (databaseSchema.getMinDataRegionGroupNum() <= minDataRegionGroupNum) {
                TSStatus result = new TSStatus(TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode());
                result.setMessage(String.format("Failed to alter database. The DataRegionGroupNum could only be increased. Current DataRegionGroupNum: %d, Alter DataRegionGroupNum: %d", minDataRegionGroupNum, databaseSchema.getMinDataRegionGroupNum()));
                return result;
            }
        }
        try {
            TSStatus result = this.getConsensusManager().write(isGeneratedByPipe ? new PipeEnrichedPlan(databaseSchemaPlan) : databaseSchemaPlan);
            PartitionMetrics.bindDatabaseReplicationFactorMetricsWhenUpdate((AbstractMetricService)MetricService.getInstance(), databaseSchemaPlan.getSchema().getName(), databaseSchemaPlan.getSchema().getDataReplicationFactor(), databaseSchemaPlan.getSchema().getSchemaReplicationFactor());
            return result;
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            TSStatus result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
            return result;
        }
    }

    public TSStatus deleteDatabase(DeleteDatabasePlan deleteDatabasePlan, boolean isGeneratedByPipe) {
        TSStatus result;
        try {
            result = this.getConsensusManager().write(isGeneratedByPipe ? new PipeEnrichedPlan(deleteDatabasePlan) : deleteDatabasePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
        }
        if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.adjustMaxRegionGroupNum();
        }
        return result;
    }

    public CountDatabaseResp countMatchedDatabases(CountDatabasePlan countDatabasePlan) {
        try {
            return (CountDatabaseResp)this.getConsensusManager().read(countDatabasePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            CountDatabaseResp response = new CountDatabaseResp();
            response.setStatus(res);
            return response;
        }
    }

    public DatabaseSchemaResp getMatchedDatabaseSchema(GetDatabasePlan getDatabasePlan) {
        DatabaseSchemaResp resp;
        try {
            resp = (DatabaseSchemaResp)this.getConsensusManager().read(getDatabasePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            resp = new DatabaseSchemaResp();
            resp.setStatus(res);
        }
        ArrayList<String> preDeletedDatabaseList = new ArrayList<String>();
        for (String database : resp.getSchemaMap().keySet()) {
            if (!this.getPartitionManager().isDatabasePreDeleted(database)) continue;
            preDeletedDatabaseList.add(database);
        }
        for (String preDeletedDatabase : preDeletedDatabaseList) {
            resp.getSchemaMap().remove(preDeletedDatabase);
        }
        return resp;
    }

    public TShowDatabaseResp showDatabase(GetDatabasePlan getDatabasePlan) {
        DatabaseSchemaResp databaseSchemaResp;
        try {
            databaseSchemaResp = (DatabaseSchemaResp)this.getConsensusManager().read(getDatabasePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            databaseSchemaResp = new DatabaseSchemaResp();
            databaseSchemaResp.setStatus(res);
        }
        if (databaseSchemaResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return new TShowDatabaseResp().setStatus(databaseSchemaResp.getStatus());
        }
        ConcurrentHashMap<String, TDatabaseInfo> infoMap = new ConcurrentHashMap<String, TDatabaseInfo>();
        for (TDatabaseSchema databaseSchema : databaseSchemaResp.getSchemaMap().values()) {
            String database = databaseSchema.getName();
            TDatabaseInfo databaseInfo = new TDatabaseInfo();
            databaseInfo.setName(database);
            databaseInfo.setTTL(databaseSchema.isSetTTL() ? databaseSchema.getTTL() : Long.MAX_VALUE);
            databaseInfo.setSchemaReplicationFactor(databaseSchema.getSchemaReplicationFactor());
            databaseInfo.setDataReplicationFactor(databaseSchema.getDataReplicationFactor());
            databaseInfo.setTimePartitionOrigin(databaseSchema.getTimePartitionOrigin());
            databaseInfo.setTimePartitionInterval(databaseSchema.getTimePartitionInterval());
            databaseInfo.setMinSchemaRegionNum(this.getMinRegionGroupNum(database, TConsensusGroupType.SchemaRegion));
            databaseInfo.setMaxSchemaRegionNum(this.getMaxRegionGroupNum(database, TConsensusGroupType.SchemaRegion));
            databaseInfo.setMinDataRegionNum(this.getMinRegionGroupNum(database, TConsensusGroupType.DataRegion));
            databaseInfo.setMaxDataRegionNum(this.getMaxRegionGroupNum(database, TConsensusGroupType.DataRegion));
            try {
                databaseInfo.setSchemaRegionNum(this.getPartitionManager().getRegionGroupCount(database, TConsensusGroupType.SchemaRegion));
                databaseInfo.setDataRegionNum(this.getPartitionManager().getRegionGroupCount(database, TConsensusGroupType.DataRegion));
            }
            catch (DatabaseNotExistsException e) {
                LOGGER.warn("The Database: {} doesn't exist. Maybe it has been pre-deleted.", (Object)databaseSchema.getName());
                continue;
            }
            infoMap.put(database, databaseInfo);
        }
        return new TShowDatabaseResp().setDatabaseInfoMap(infoMap).setStatus(StatusUtils.OK);
    }

    public Map<String, Long> getTTLInfoForUpgrading() {
        List<String> databases = this.getDatabaseNames(false);
        ConcurrentHashMap<String, Long> infoMap = new ConcurrentHashMap<String, Long>();
        for (String database : databases) {
            try {
                TDatabaseSchema databaseSchema = this.getDatabaseSchemaByName(database);
                long ttl = databaseSchema.isSetTTL() ? databaseSchema.getTTL() : -1L;
                if (ttl < 0L || ttl == Long.MAX_VALUE) continue;
                infoMap.put(database, ttl);
            }
            catch (DatabaseNotExistsException e) {
                LOGGER.warn("Database: {} doesn't exist", databases, (Object)e);
            }
        }
        return infoMap;
    }

    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorPlan setSchemaReplicationFactorPlan) {
        try {
            return this.getConsensusManager().write(setSchemaReplicationFactorPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            TSStatus result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
            return result;
        }
    }

    public TSStatus setDataReplicationFactor(SetDataReplicationFactorPlan setDataReplicationFactorPlan) {
        try {
            return this.getConsensusManager().write(setDataReplicationFactorPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            TSStatus result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
            return result;
        }
    }

    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalPlan setTimePartitionIntervalPlan) {
        try {
            return this.getConsensusManager().write(setTimePartitionIntervalPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            TSStatus result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
            return result;
        }
    }

    public synchronized void adjustMaxRegionGroupNum() {
        Map<String, TDatabaseSchema> databaseSchemaMap = this.getMatchedDatabaseSchemasByName(this.getDatabaseNames(null), null);
        if (databaseSchemaMap.isEmpty()) {
            return;
        }
        int dataNodeNum = this.getNodeManager().getRegisteredDataNodeCount();
        int totalCpuCoreNum = this.getNodeManager().getDataNodeCpuCoreCount();
        int databaseNum = databaseSchemaMap.size();
        for (TDatabaseSchema tDatabaseSchema : databaseSchemaMap.values()) {
            if (this.isDatabaseExist(tDatabaseSchema.getName()) && !tDatabaseSchema.getName().equals("root.__system")) continue;
            --databaseNum;
        }
        AdjustMaxRegionGroupNumPlan adjustMaxRegionGroupNumPlan = new AdjustMaxRegionGroupNumPlan();
        for (TDatabaseSchema databaseSchema : databaseSchemaMap.values()) {
            int allocatedDataRegionGroupCount;
            int allocatedSchemaRegionGroupCount;
            if (databaseSchema.getName().equals("root.__system")) continue;
            try {
                allocatedSchemaRegionGroupCount = this.getPartitionManager().getRegionGroupCount(databaseSchema.getName(), TConsensusGroupType.SchemaRegion);
            }
            catch (DatabaseNotExistsException e) {
                continue;
            }
            int maxSchemaRegionGroupNum = ClusterSchemaManager.calcMaxRegionGroupNum(databaseSchema.getMinSchemaRegionGroupNum(), SCHEMA_REGION_PER_DATA_NODE, dataNodeNum, databaseNum, databaseSchema.getSchemaReplicationFactor(), allocatedSchemaRegionGroupCount);
            LOGGER.info("[AdjustRegionGroupNum] The maximum number of SchemaRegionGroups for Database: {} is adjusted to: {}", (Object)databaseSchema.getName(), (Object)maxSchemaRegionGroupNum);
            try {
                allocatedDataRegionGroupCount = this.getPartitionManager().getRegionGroupCount(databaseSchema.getName(), TConsensusGroupType.DataRegion);
            }
            catch (DatabaseNotExistsException e) {
                continue;
            }
            int maxDataRegionGroupNum = ClusterSchemaManager.calcMaxRegionGroupNum(databaseSchema.getMinDataRegionGroupNum(), DATA_REGION_PER_DATA_NODE == 0 ? CONF.getDataRegionPerDataNodeProportion() : (double)DATA_REGION_PER_DATA_NODE, DATA_REGION_PER_DATA_NODE == 0 ? totalCpuCoreNum : dataNodeNum, databaseNum, databaseSchema.getDataReplicationFactor(), allocatedDataRegionGroupCount);
            LOGGER.info("[AdjustRegionGroupNum] The maximum number of DataRegionGroups for Database: {} is adjusted to: {}", (Object)databaseSchema.getName(), (Object)maxDataRegionGroupNum);
            adjustMaxRegionGroupNumPlan.putEntry(databaseSchema.getName(), (Pair<Integer, Integer>)new Pair((Object)maxSchemaRegionGroupNum, (Object)maxDataRegionGroupNum));
        }
        try {
            this.getConsensusManager().write(adjustMaxRegionGroupNumPlan);
        }
        catch (ConsensusException consensusException) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)consensusException);
        }
    }

    public static int calcMaxRegionGroupNum(int minRegionGroupNum, double resourceWeight, int resource, int databaseNum, int replicationFactor, int allocatedRegionGroupCount) {
        return Math.max(minRegionGroupNum, Math.max((int)Math.ceil(resourceWeight * (double)resource / (double)(databaseNum * replicationFactor)), allocatedRegionGroupCount));
    }

    public boolean isDatabaseExist(String database) {
        return this.getPartitionManager().isDatabaseExist(database);
    }

    public List<String> getDatabaseNames(Boolean isTableModel) {
        return this.clusterSchemaInfo.getDatabaseNames(isTableModel).stream().filter(this::isDatabaseExist).collect(Collectors.toList());
    }

    public TDatabaseSchema getDatabaseSchemaByName(String database) throws DatabaseNotExistsException {
        if (!this.isDatabaseExist(database)) {
            throw new DatabaseNotExistsException(database);
        }
        return this.clusterSchemaInfo.getMatchedDatabaseSchemaByName(database);
    }

    public String getDatabaseNameByDevice(IDeviceID deviceID) {
        List<String> databases = this.getDatabaseNames(null);
        for (String database : databases) {
            if (!PathUtils.isStartWith((IDeviceID)deviceID, (String)database)) continue;
            return database;
        }
        return "";
    }

    public Map<String, TDatabaseSchema> getMatchedDatabaseSchemasByName(List<String> rawPathList, Boolean isTableModel) {
        ConcurrentHashMap<String, TDatabaseSchema> result = new ConcurrentHashMap<String, TDatabaseSchema>();
        this.clusterSchemaInfo.getMatchedDatabaseSchemasByName(rawPathList, isTableModel).forEach((database, databaseSchema) -> {
            if (this.isDatabaseExist(databaseSchema.getName())) {
                result.put((String)database, (TDatabaseSchema)databaseSchema);
            }
        });
        return result;
    }

    public Map<String, TDatabaseSchema> getMatchedDatabaseSchemasByPrefix(PartialPath prefix) {
        ConcurrentHashMap<String, TDatabaseSchema> result = new ConcurrentHashMap<String, TDatabaseSchema>();
        this.clusterSchemaInfo.getMatchedDatabaseSchemasByPrefix(prefix).forEach((database, databaseSchema) -> {
            if (this.isDatabaseExist((String)database)) {
                result.put((String)database, (TDatabaseSchema)databaseSchema);
            }
        });
        return result;
    }

    public int getReplicationFactor(String database, TConsensusGroupType consensusGroupType) throws DatabaseNotExistsException {
        TDatabaseSchema databaseSchema = this.getDatabaseSchemaByName(database);
        return TConsensusGroupType.SchemaRegion.equals((Object)consensusGroupType) ? databaseSchema.getSchemaReplicationFactor() : databaseSchema.getDataReplicationFactor();
    }

    public int getMinRegionGroupNum(String database, TConsensusGroupType consensusGroupType) {
        return this.clusterSchemaInfo.getMinRegionGroupNum(database, consensusGroupType);
    }

    public int getMaxRegionGroupNum(String database, TConsensusGroupType consensusGroupType) {
        return this.clusterSchemaInfo.getMaxRegionGroupNum(database, consensusGroupType);
    }

    public TSStatus createTemplate(CreateSchemaTemplatePlan createSchemaTemplatePlan) {
        try {
            return this.getConsensusManager().write(createSchemaTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return res;
        }
    }

    public TGetAllTemplatesResp getAllTemplates() {
        TemplateInfoResp templateResp;
        GetAllSchemaTemplatePlan getAllSchemaTemplatePlan = new GetAllSchemaTemplatePlan();
        try {
            templateResp = (TemplateInfoResp)this.getConsensusManager().read(getAllSchemaTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            templateResp = new TemplateInfoResp();
            templateResp.setStatus(res);
        }
        TGetAllTemplatesResp resp = new TGetAllTemplatesResp();
        resp.setStatus(templateResp.getStatus());
        if (resp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && templateResp.getTemplateList() != null) {
            ArrayList list = new ArrayList();
            templateResp.getTemplateList().forEach(template -> list.add(template.serialize()));
            resp.setTemplateList(list);
        }
        return resp;
    }

    public TGetTemplateResp getTemplate(String req) {
        TemplateInfoResp templateResp;
        GetSchemaTemplatePlan getSchemaTemplatePlan = new GetSchemaTemplatePlan(req);
        try {
            templateResp = (TemplateInfoResp)this.getConsensusManager().read(getSchemaTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            templateResp = new TemplateInfoResp();
            templateResp.setStatus(res);
        }
        TGetTemplateResp resp = new TGetTemplateResp();
        if (templateResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() && templateResp.getTemplateList() != null && !templateResp.getTemplateList().isEmpty()) {
            ByteBuffer byteBuffer = templateResp.getTemplateList().get(0).serialize();
            resp.setTemplate(byteBuffer);
        }
        resp.setStatus(templateResp.getStatus());
        return resp;
    }

    public Template getTemplate(int id) throws MetadataException {
        return this.clusterSchemaInfo.getTemplate(id);
    }

    public TGetPathsSetTemplatesResp getPathsSetTemplate(String templateName, PathPatternTree scope) {
        PathInfoResp pathInfoResp;
        GetPathsSetTemplatePlan getPathsSetTemplatePlan = new GetPathsSetTemplatePlan(templateName, scope);
        try {
            pathInfoResp = (PathInfoResp)this.getConsensusManager().read(getPathsSetTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            pathInfoResp = new PathInfoResp();
            pathInfoResp.setStatus(res);
        }
        if (pathInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            TGetPathsSetTemplatesResp resp = new TGetPathsSetTemplatesResp();
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            resp.setPathList(pathInfoResp.getPathList());
            return resp;
        }
        return new TGetPathsSetTemplatesResp(pathInfoResp.getStatus());
    }

    public byte[] getAllTemplateSetInfo() {
        try {
            AllTemplateSetInfoResp resp = (AllTemplateSetInfoResp)this.getConsensusManager().read(new GetAllTemplateSetInfoPlan());
            return resp.getTemplateInfo();
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            return new byte[0];
        }
    }

    public TemplateSetInfoResp getTemplateSetInfo(List<PartialPath> patternList) {
        try {
            return (TemplateSetInfoResp)this.getConsensusManager().read(new GetTemplateSetInfoPlan(patternList));
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            TemplateSetInfoResp response = new TemplateSetInfoResp();
            response.setStatus(res);
            return response;
        }
    }

    public Pair<TSStatus, Template> checkIsTemplateSetOnPath(String templateName, String path) {
        PathInfoResp pathInfoResp;
        TemplateInfoResp templateResp;
        GetSchemaTemplatePlan getSchemaTemplatePlan = new GetSchemaTemplatePlan(templateName);
        try {
            templateResp = (TemplateInfoResp)this.getConsensusManager().read(getSchemaTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            templateResp = new TemplateInfoResp();
            templateResp.setStatus(res);
        }
        if (templateResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            if (templateResp.getTemplateList() == null || templateResp.getTemplateList().isEmpty()) {
                return new Pair((Object)RpcUtils.getStatus((int)TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode(), (String)String.format("Undefined template name: %s", templateName)), null);
            }
        } else {
            return new Pair((Object)templateResp.getStatus(), null);
        }
        GetPathsSetTemplatePlan getPathsSetTemplatePlan = new GetPathsSetTemplatePlan(templateName, SchemaConstant.ALL_MATCH_SCOPE);
        try {
            pathInfoResp = (PathInfoResp)this.getConsensusManager().read(getPathsSetTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            pathInfoResp = new PathInfoResp();
            pathInfoResp.setStatus(res);
        }
        if (pathInfoResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            List<String> templateSetPathList = pathInfoResp.getPathList();
            if (templateSetPathList == null || templateSetPathList.isEmpty() || !pathInfoResp.getPathList().contains(path)) {
                return new Pair((Object)RpcUtils.getStatus((int)TSStatusCode.TEMPLATE_NOT_SET.getStatusCode(), (String)String.format("No template on %s", path)), null);
            }
            return new Pair((Object)templateResp.getStatus(), (Object)templateResp.getTemplateList().get(0));
        }
        return new Pair((Object)pathInfoResp.getStatus(), null);
    }

    public TSStatus preUnsetSchemaTemplate(int templateId, PartialPath path) {
        try {
            return this.getConsensusManager().write(new PreUnsetSchemaTemplatePlan(templateId, path));
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            TSStatus result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
            return result;
        }
    }

    public TSStatus rollbackPreUnsetSchemaTemplate(int templateId, PartialPath path) {
        try {
            return this.getConsensusManager().write(new RollbackPreUnsetSchemaTemplatePlan(templateId, path));
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            TSStatus result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
            return result;
        }
    }

    public TSStatus unsetSchemaTemplateInBlackList(int templateId, PartialPath path, boolean isGeneratedByPipe) {
        try {
            return this.getConsensusManager().write(isGeneratedByPipe ? new PipeEnrichedPlan(new UnsetSchemaTemplatePlan(templateId, path)) : new UnsetSchemaTemplatePlan(templateId, path));
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            TSStatus result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
            return result;
        }
    }

    public synchronized TSStatus dropSchemaTemplate(String templateName) {
        PathInfoResp pathInfoResp;
        TemplateInfoResp templateInfoResp;
        GetSchemaTemplatePlan getSchemaTemplatePlan = new GetSchemaTemplatePlan(templateName);
        try {
            templateInfoResp = (TemplateInfoResp)this.getConsensusManager().read(getSchemaTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            templateInfoResp = new TemplateInfoResp();
            templateInfoResp.setStatus(res);
        }
        if (templateInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return templateInfoResp.getStatus();
        }
        if (templateInfoResp.getTemplateList() == null || templateInfoResp.getTemplateList().isEmpty()) {
            return RpcUtils.getStatus((int)TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode(), (String)String.format("Undefined template name: %s", templateName));
        }
        GetPathsSetTemplatePlan getPathsSetTemplatePlan = new GetPathsSetTemplatePlan(templateName, SchemaConstant.ALL_MATCH_SCOPE);
        try {
            pathInfoResp = (PathInfoResp)this.getConsensusManager().read(getPathsSetTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            pathInfoResp = new PathInfoResp();
            pathInfoResp.setStatus(res);
        }
        if (pathInfoResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return pathInfoResp.getStatus();
        }
        if (pathInfoResp.getPathList() != null && !pathInfoResp.getPathList().isEmpty()) {
            return RpcUtils.getStatus((int)TSStatusCode.METADATA_ERROR.getStatusCode(), (String)String.format("Template [%s] has been set on MTree, cannot be dropped now.", templateName));
        }
        try {
            return this.getConsensusManager().write(new DropSchemaTemplatePlan(templateName));
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            TSStatus result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
            return result;
        }
    }

    public synchronized TSStatus extendSchemaTemplate(TemplateExtendInfo templateExtendInfo, boolean isGeneratedByPipe) {
        TSStatus status;
        TemplateInfoResp resp;
        if (templateExtendInfo.getEncodings() != null) {
            for (int i = 0; i < templateExtendInfo.getDataTypes().size(); ++i) {
                try {
                    SchemaUtils.checkDataTypeWithEncoding((TSDataType)((TSDataType)templateExtendInfo.getDataTypes().get(i)), (TSEncoding)((TSEncoding)templateExtendInfo.getEncodings().get(i)));
                    continue;
                }
                catch (MetadataException e) {
                    return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
                }
            }
        }
        if ((resp = this.clusterSchemaInfo.getTemplate(new GetSchemaTemplatePlan(templateExtendInfo.getTemplateName()))).getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return resp.getStatus();
        }
        Template template = resp.getTemplateList().get(0);
        List intersectionMeasurements = templateExtendInfo.updateAsDifferenceAndGetIntersection(template.getSchemaMap().keySet());
        if (templateExtendInfo.isEmpty()) {
            if (intersectionMeasurements.isEmpty()) {
                return RpcUtils.SUCCESS_STATUS;
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.MEASUREMENT_ALREADY_EXISTS_IN_TEMPLATE, (String)String.format("Measurement %s already exist in schemaengine template %s", intersectionMeasurements, template.getName()));
        }
        ExtendSchemaTemplatePlan extendSchemaTemplatePlan = new ExtendSchemaTemplatePlan(templateExtendInfo);
        try {
            status = this.getConsensusManager().write(isGeneratedByPipe ? new PipeEnrichedPlan(extendSchemaTemplatePlan) : extendSchemaTemplatePlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            status = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            status.setMessage(e.getMessage());
        }
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        template = this.clusterSchemaInfo.getTemplate(new GetSchemaTemplatePlan(templateExtendInfo.getTemplateName())).getTemplateList().get(0);
        TUpdateTemplateReq updateTemplateReq = new TUpdateTemplateReq();
        updateTemplateReq.setType(TemplateInternalRPCUpdateType.UPDATE_TEMPLATE_INFO.toByte());
        updateTemplateReq.setTemplateInfo(TemplateInternalRPCUtil.generateUpdateTemplateInfoBytes((Template)template));
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = this.configManager.getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.UPDATE_TEMPLATE, updateTemplateReq, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (Map.Entry entry : statusMap.entrySet()) {
            if (((TSStatus)entry.getValue()).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.warn("Failed to sync template {} extension info to DataNode {}", (Object)template.getName(), (Object)dataNodeLocationMap.get(entry.getKey()));
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)String.format("Failed to sync template %s extension info to DataNode %s", template.getName(), dataNodeLocationMap.get(entry.getKey())));
        }
        if (intersectionMeasurements.isEmpty()) {
            return RpcUtils.SUCCESS_STATUS;
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.MEASUREMENT_ALREADY_EXISTS_IN_TEMPLATE, (String)String.format("Measurement %s already exist in schemaengine template %s", intersectionMeasurements, template.getName()));
    }

    public TShowTableResp showTables(String database, boolean isDetails) {
        try {
            return ((ShowTableResp)this.configManager.getConsensusManager().read(new ShowTablePlan(database, isDetails))).convertToTShowTableResp();
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new TShowTableResp(res);
        }
    }

    public TShowTable4InformationSchemaResp showTables4InformationSchema() {
        try {
            return ((ShowTable4InformationSchemaResp)this.configManager.getConsensusManager().read(new ShowTable4InformationSchemaPlan())).convertToTShowTable4InformationSchemaResp();
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new TShowTable4InformationSchemaResp(res);
        }
    }

    public TDescTableResp describeTable(String database, String tableName, boolean isDetails) {
        try {
            return ((DescTableResp)this.configManager.getConsensusManager().read(new DescTablePlan(database, tableName, isDetails))).convertToTDescTableResp();
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new TDescTableResp(res);
        }
    }

    public TDescTable4InformationSchemaResp describeTables4InformationSchema() {
        try {
            return ((DescTable4InformationSchemaResp)this.configManager.getConsensusManager().read(new DescTable4InformationSchemaPlan())).convertToTDescTable4InformationSchemaResp();
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new TDescTable4InformationSchemaResp(res);
        }
    }

    public TFetchTableResp fetchTables(Map<String, Set<String>> fetchTableMap) {
        try {
            return ((FetchTableResp)this.configManager.getConsensusManager().read(new FetchTablePlan(fetchTableMap))).convertToTFetchTableResp();
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_READ_ERROR, (Throwable)e);
            TSStatus res = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            res.setMessage(e.getMessage());
            return new TFetchTableResp(res);
        }
    }

    public byte[] getAllTableInfoForDataNodeActivation() {
        return TsTableInternalRPCUtil.serializeTableInitializationInfo(this.clusterSchemaInfo.getAllUsingTables(), this.clusterSchemaInfo.getAllPreCreateTables());
    }

    public Pair<Long, Long> getSchemaQuotaRemain() {
        boolean isSeriesLimit;
        boolean isDeviceLimit = this.schemaQuotaStatistics.getDeviceThreshold() != -1L;
        boolean bl = isSeriesLimit = this.schemaQuotaStatistics.getSeriesThreshold() != -1L;
        if (isSeriesLimit || isDeviceLimit) {
            Set<Integer> schemaPartitionSet = this.getPartitionManager().getAllSchemaPartition();
            return new Pair((Object)(isSeriesLimit ? this.schemaQuotaStatistics.getSeriesQuotaRemain(schemaPartitionSet) : -1L), (Object)(isDeviceLimit ? this.schemaQuotaStatistics.getDeviceQuotaRemain(schemaPartitionSet) : -1L));
        }
        return new Pair((Object)-1L, (Object)-1L);
    }

    public void updateTimeSeriesUsage(Map<Integer, Long> seriesUsage) {
        this.schemaQuotaStatistics.updateTimeSeriesUsage(seriesUsage);
    }

    public void updateDeviceUsage(Map<Integer, Long> deviceUsage) {
        this.schemaQuotaStatistics.updateDeviceUsage(deviceUsage);
    }

    public void updateSchemaQuotaConfiguration(long seriesThreshold, long deviceThreshold) {
        this.schemaQuotaStatistics.setDeviceThreshold(deviceThreshold);
        this.schemaQuotaStatistics.setSeriesThreshold(seriesThreshold);
    }

    public Optional<TsTable> getTableIfExists(String database, String tableName) throws MetadataException {
        return this.clusterSchemaInfo.getTsTableIfExists(database, tableName);
    }

    public synchronized Pair<TSStatus, TsTable> tableColumnCheckForColumnExtension(String database, String tableName, List<TsTableColumnSchema> columnSchemaList) throws MetadataException {
        TsTable originalTable = this.getTableIfExists(database, tableName).orElse(null);
        if (Objects.isNull(originalTable)) {
            return new Pair((Object)RpcUtils.getStatus((TSStatusCode)TSStatusCode.TABLE_NOT_EXISTS, (String)String.format("Table '%s.%s' does not exist", database, tableName)), null);
        }
        TsTable expandedTable = TsTable.deserialize((ByteBuffer)ByteBuffer.wrap(originalTable.serialize()));
        String errorMsg = String.format("Column '%s' already exist", columnSchemaList.stream().map(TsTableColumnSchema::getColumnName).collect(Collectors.joining(", ")));
        columnSchemaList.removeIf(columnSchema -> {
            if (Objects.isNull(originalTable.getColumnSchema(columnSchema.getColumnName()))) {
                expandedTable.addColumnSchema(columnSchema);
                return false;
            }
            return true;
        });
        if (columnSchemaList.isEmpty()) {
            return new Pair((Object)RpcUtils.getStatus((TSStatusCode)TSStatusCode.COLUMN_ALREADY_EXISTS, (String)errorMsg), null);
        }
        return new Pair((Object)RpcUtils.SUCCESS_STATUS, (Object)expandedTable);
    }

    public synchronized Pair<TSStatus, TsTable> tableColumnCheckForColumnRenaming(String database, String tableName, String oldName, String newName) throws MetadataException {
        TsTable originalTable = this.getTableIfExists(database, tableName).orElse(null);
        if (Objects.isNull(originalTable)) {
            return new Pair((Object)RpcUtils.getStatus((TSStatusCode)TSStatusCode.TABLE_NOT_EXISTS, (String)String.format("Table '%s.%s' does not exist", database, tableName)), null);
        }
        TsTable expandedTable = TsTable.deserialize((ByteBuffer)ByteBuffer.wrap(originalTable.serialize()));
        TsTableColumnSchema schema = originalTable.getColumnSchema(oldName);
        if (Objects.isNull(schema)) {
            return new Pair((Object)RpcUtils.getStatus((TSStatusCode)TSStatusCode.COLUMN_NOT_EXISTS, (String)String.format("Column '%s' does not exist", oldName)), null);
        }
        if (schema.getColumnCategory() != TsTableColumnCategory.ATTRIBUTE) {
            return new Pair((Object)RpcUtils.getStatus((TSStatusCode)TSStatusCode.COLUMN_CATEGORY_MISMATCH, (String)("Currently we only support renaming for attribute columns, current category is " + schema.getColumnCategory())), null);
        }
        expandedTable.renameColumnSchema(oldName, newName);
        return new Pair((Object)RpcUtils.SUCCESS_STATUS, (Object)expandedTable);
    }

    public synchronized TSStatus addTableColumn(String database, String tableName, List<TsTableColumnSchema> columnSchemaList) {
        AddTableColumnPlan addTableColumnPlan = new AddTableColumnPlan(database, tableName, columnSchemaList, false);
        try {
            return this.getConsensusManager().write(addTableColumnPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    public synchronized TSStatus rollbackAddTableColumn(String database, String tableName, List<TsTableColumnSchema> columnSchemaList) {
        AddTableColumnPlan addTableColumnPlan = new AddTableColumnPlan(database, tableName, columnSchemaList, true);
        try {
            return this.getConsensusManager().write(addTableColumnPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    public synchronized TSStatus renameTableColumn(String database, String tableName, String oldName, String newName) {
        RenameTableColumnPlan renameTableColumnPlan = new RenameTableColumnPlan(database, tableName, oldName, newName);
        try {
            return this.getConsensusManager().write(renameTableColumnPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    public synchronized TSStatus setTableProperties(String database, String tableName, Map<String, String> properties) {
        SetTablePropertiesPlan setTablePropertiesPlan = new SetTablePropertiesPlan(database, tableName, properties);
        try {
            return this.getConsensusManager().write(setTablePropertiesPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    public synchronized Pair<TSStatus, TsTable> updateTableProperties(String database, String tableName, Map<String, String> originalProperties, Map<String, String> updatedProperties) throws MetadataException {
        TsTable originalTable = this.getTableIfExists(database, tableName).orElse(null);
        if (Objects.isNull(originalTable)) {
            return new Pair((Object)RpcUtils.getStatus((TSStatusCode)TSStatusCode.TABLE_NOT_EXISTS, (String)String.format("Table '%s.%s' does not exist", database, tableName)), null);
        }
        updatedProperties.keySet().removeIf(key -> Objects.equals(updatedProperties.get(key), originalTable.getPropValue(key).orElse(null)));
        if (updatedProperties.isEmpty()) {
            return new Pair((Object)RpcUtils.SUCCESS_STATUS, null);
        }
        TsTable updatedTable = TsTable.deserialize((ByteBuffer)ByteBuffer.wrap(originalTable.serialize()));
        updatedProperties.forEach((k, v) -> {
            originalProperties.put((String)k, originalTable.getPropValue(k).orElse(null));
            if (Objects.nonNull(v)) {
                updatedTable.addProp(k, v);
            } else {
                updatedTable.removeProp(k);
            }
        });
        return new Pair((Object)RpcUtils.SUCCESS_STATUS, (Object)updatedTable);
    }

    public void clearSchemaQuotaCache() {
        this.schemaQuotaStatistics.clear();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }
}

