/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TAINodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.NodeType;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupCache;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.consensus.ConsensusGroupStatistics;
import org.apache.iotdb.confignode.manager.load.cache.node.AINodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.cache.node.BaseNodeCache;
import org.apache.iotdb.confignode.manager.load.cache.node.ConfigNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.cache.node.DataNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionGroupCache;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionGroupStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionStatistics;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadCache.class);
    private static final long WAIT_LEADER_INTERVAL = 10L;
    private static final long LEADER_ELECTION_WAITING_TIMEOUT = Math.max(ProcedureManager.PROCEDURE_WAIT_TIME_OUT - TimeUnit.SECONDS.toMillis(2L), TimeUnit.SECONDS.toMillis(10L));
    private final Map<Integer, AtomicBoolean> heartbeatProcessingMap;
    private final Map<Integer, BaseNodeCache> nodeCacheMap = new ConcurrentHashMap<Integer, BaseNodeCache>();
    private final Map<TConsensusGroupId, RegionGroupCache> regionGroupCacheMap;
    private final Map<Integer, Map<Integer, Long>> regionSizeMap;
    private final Map<TConsensusGroupId, ConsensusGroupCache> consensusGroupCacheMap;
    private final Map<Integer, Set<TEndPoint>> confirmedConfigNodeMap;

    public LoadCache() {
        this.heartbeatProcessingMap = new ConcurrentHashMap<Integer, AtomicBoolean>();
        this.regionGroupCacheMap = new ConcurrentHashMap<TConsensusGroupId, RegionGroupCache>();
        this.regionSizeMap = new ConcurrentHashMap<Integer, Map<Integer, Long>>();
        this.consensusGroupCacheMap = new ConcurrentHashMap<TConsensusGroupId, ConsensusGroupCache>();
        this.confirmedConfigNodeMap = new ConcurrentHashMap<Integer, Set<TEndPoint>>();
    }

    public void initHeartbeatCache(IManager configManager) {
        this.initNodeHeartbeatCache(configManager.getNodeManager().getRegisteredConfigNodes(), configManager.getNodeManager().getRegisteredDataNodes(), configManager.getNodeManager().getRegisteredAINodes());
        this.initRegionGroupHeartbeatCache(configManager.getClusterSchemaManager().getDatabaseNames(null).stream().collect(Collectors.toMap(database -> database, database -> configManager.getPartitionManager().getAllReplicaSets((String)database))));
    }

    private void initNodeHeartbeatCache(List<TConfigNodeLocation> registeredConfigNodes, List<TDataNodeConfiguration> registeredDataNodes, List<TAINodeConfiguration> registeredAINodes) {
        int CURRENT_NODE_ID = ConfigNodeHeartbeatCache.CURRENT_NODE_ID;
        this.nodeCacheMap.clear();
        this.heartbeatProcessingMap.clear();
        registeredConfigNodes.forEach(configNodeLocation -> {
            int configNodeId = configNodeLocation.getConfigNodeId();
            if (configNodeId != CURRENT_NODE_ID) {
                this.createNodeHeartbeatCache(NodeType.ConfigNode, configNodeId);
            }
        });
        this.nodeCacheMap.put(ConfigNodeHeartbeatCache.CURRENT_NODE_ID, new ConfigNodeHeartbeatCache(CURRENT_NODE_ID, ConfigNodeHeartbeatCache.CURRENT_NODE_STATISTICS));
        registeredDataNodes.forEach(dataNodeConfiguration -> {
            int dataNodeId = dataNodeConfiguration.getLocation().getDataNodeId();
            this.createNodeHeartbeatCache(NodeType.DataNode, dataNodeId);
        });
        registeredAINodes.forEach(aiNodeConfiguration -> {
            int aiNodeId = aiNodeConfiguration.getLocation().getAiNodeId();
            this.createNodeHeartbeatCache(NodeType.AINode, aiNodeId);
        });
    }

    private void initRegionGroupHeartbeatCache(Map<String, List<TRegionReplicaSet>> regionReplicaMap) {
        this.regionGroupCacheMap.clear();
        this.consensusGroupCacheMap.clear();
        regionReplicaMap.forEach((database, regionReplicaSets) -> regionReplicaSets.forEach(regionReplicaSet -> {
            TConsensusGroupId regionGroupId = regionReplicaSet.getRegionId();
            this.regionGroupCacheMap.put(regionGroupId, new RegionGroupCache((String)database, regionReplicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet())));
            this.consensusGroupCacheMap.put(regionGroupId, new ConsensusGroupCache());
        }));
    }

    public void clearHeartbeatCache() {
        this.heartbeatProcessingMap.clear();
        this.nodeCacheMap.clear();
        this.regionGroupCacheMap.clear();
        this.consensusGroupCacheMap.clear();
    }

    public boolean checkAndSetHeartbeatProcessing(int nodeId) {
        return this.heartbeatProcessingMap.computeIfAbsent(nodeId, empty -> new AtomicBoolean(false)).getAndSet(true);
    }

    public void createNodeHeartbeatCache(NodeType nodeType, int nodeId) {
        switch (nodeType) {
            case ConfigNode: {
                this.nodeCacheMap.put(nodeId, new ConfigNodeHeartbeatCache(nodeId));
                break;
            }
            case DataNode: {
                this.nodeCacheMap.put(nodeId, new DataNodeHeartbeatCache(nodeId));
                break;
            }
            case AINode: {
                this.nodeCacheMap.put(nodeId, new AINodeHeartbeatCache(nodeId));
            }
        }
        this.heartbeatProcessingMap.put(nodeId, new AtomicBoolean(false));
    }

    public void cacheConfigNodeHeartbeatSample(int nodeId, NodeHeartbeatSample sample) {
        Optional.ofNullable(this.nodeCacheMap.get(nodeId)).ifPresent(node -> node.cacheHeartbeatSample(sample));
        Optional.ofNullable(this.heartbeatProcessingMap.get(nodeId)).ifPresent(node -> node.set(false));
    }

    public void cacheDataNodeHeartbeatSample(int nodeId, NodeHeartbeatSample sample) {
        Optional.ofNullable(this.nodeCacheMap.get(nodeId)).ifPresent(node -> node.cacheHeartbeatSample(sample));
        Optional.ofNullable(this.heartbeatProcessingMap.get(nodeId)).ifPresent(node -> node.set(false));
    }

    public void cacheAINodeHeartbeatSample(int nodeId, NodeHeartbeatSample sample) {
        this.nodeCacheMap.computeIfAbsent(nodeId, empty -> new AINodeHeartbeatCache(nodeId)).cacheHeartbeatSample(sample);
        Optional.ofNullable(this.heartbeatProcessingMap.get(nodeId)).ifPresent(node -> node.set(false));
    }

    public void resetHeartbeatProcessing(int nodeId) {
        Optional.ofNullable(this.heartbeatProcessingMap.get(nodeId)).ifPresent(node -> node.set(false));
    }

    public void removeNodeCache(int nodeId) {
        this.nodeCacheMap.remove(nodeId);
        this.heartbeatProcessingMap.remove(nodeId);
    }

    public void createRegionGroupHeartbeatCache(String database, TConsensusGroupId regionGroupId, Set<Integer> dataNodeIds) {
        this.regionGroupCacheMap.put(regionGroupId, new RegionGroupCache(database, dataNodeIds));
        this.consensusGroupCacheMap.put(regionGroupId, new ConsensusGroupCache());
    }

    public void createRegionCache(TConsensusGroupId regionGroupId, int dataNodeId) {
        Optional.ofNullable(this.regionGroupCacheMap.get(regionGroupId)).ifPresent(cache -> cache.createRegionCache(dataNodeId));
    }

    public void cacheRegionHeartbeatSample(TConsensusGroupId regionGroupId, int nodeId, RegionHeartbeatSample sample, boolean overwrite) {
        Optional.ofNullable(this.regionGroupCacheMap.get(regionGroupId)).ifPresent(group -> group.cacheHeartbeatSample(nodeId, sample, overwrite));
    }

    public RegionStatus getRegionCacheLastSampleStatus(TConsensusGroupId regionGroupId, int nodeId) {
        return Optional.ofNullable(this.regionGroupCacheMap.get(regionGroupId)).map(regionGroupCache -> regionGroupCache.getRegionCache(nodeId)).map(regionCache -> (RegionHeartbeatSample)regionCache.getLastSample()).map(RegionHeartbeatSample::getStatus).orElse(RegionStatus.Unknown);
    }

    public void removeRegionCache(TConsensusGroupId regionGroupId, int dataNodeId) {
        Optional.ofNullable(this.regionGroupCacheMap.get(regionGroupId)).ifPresent(cache -> cache.removeRegionCache(dataNodeId));
    }

    public void cacheConsensusSample(TConsensusGroupId regionGroupId, ConsensusGroupHeartbeatSample sample) {
        Optional.ofNullable(this.consensusGroupCacheMap.get(regionGroupId)).ifPresent(group -> group.cacheHeartbeatSample(sample));
    }

    public void updateNodeStatistics(boolean forceUpdate) {
        this.nodeCacheMap.values().forEach(baseNodeCache -> baseNodeCache.updateCurrentStatistics(forceUpdate));
    }

    public void updateRegionGroupStatistics() {
        this.regionGroupCacheMap.values().forEach(RegionGroupCache::updateCurrentStatistics);
    }

    public void updateConsensusGroupStatistics() {
        this.consensusGroupCacheMap.values().forEach(consensusGroupCache -> consensusGroupCache.updateCurrentStatistics(false));
    }

    public Map<Integer, NodeStatistics> getCurrentNodeStatisticsMap() {
        TreeMap<Integer, NodeStatistics> nodeStatisticsMap = new TreeMap<Integer, NodeStatistics>();
        this.nodeCacheMap.forEach((nodeId, nodeCache) -> nodeStatisticsMap.put((Integer)nodeId, (NodeStatistics)nodeCache.getCurrentStatistics()));
        return nodeStatisticsMap;
    }

    public Map<Integer, NodeStatistics> getCurrentDataNodeStatisticsMap() {
        TreeMap<Integer, NodeStatistics> dataNodeStatisticsMap = new TreeMap<Integer, NodeStatistics>();
        this.nodeCacheMap.forEach((nodeId, nodeCache) -> {
            if (nodeCache instanceof DataNodeHeartbeatCache) {
                dataNodeStatisticsMap.put((Integer)nodeId, (NodeStatistics)nodeCache.getCurrentStatistics());
            }
        });
        return dataNodeStatisticsMap;
    }

    public Map<String, List<TConsensusGroupId>> getCurrentDatabaseRegionGroupMap(TConsensusGroupType type) {
        TreeMap<String, List<TConsensusGroupId>> databaseRegionGroupMap = new TreeMap<String, List<TConsensusGroupId>>();
        this.regionGroupCacheMap.forEach((regionGroupId, regionGroupCache) -> {
            if (type.equals((Object)regionGroupId.getType())) {
                databaseRegionGroupMap.computeIfAbsent(regionGroupCache.getDatabase(), empty -> new ArrayList()).add(regionGroupId);
            }
        });
        return databaseRegionGroupMap;
    }

    public Map<TConsensusGroupId, Set<Integer>> getCurrentRegionLocationMap(TConsensusGroupType type) {
        TreeMap<TConsensusGroupId, Set<Integer>> regionGroupIdsMap = new TreeMap<TConsensusGroupId, Set<Integer>>();
        this.regionGroupCacheMap.forEach((regionGroupId, regionGroupCache) -> {
            if (type.equals((Object)regionGroupId.getType())) {
                regionGroupIdsMap.put((TConsensusGroupId)regionGroupId, regionGroupCache.getRegionLocations());
            }
        });
        return regionGroupIdsMap;
    }

    public Map<TConsensusGroupId, RegionGroupStatistics> getCurrentRegionGroupStatisticsMap() {
        TreeMap<TConsensusGroupId, RegionGroupStatistics> regionGroupStatisticsMap = new TreeMap<TConsensusGroupId, RegionGroupStatistics>();
        this.regionGroupCacheMap.forEach((regionGroupId, regionGroupCache) -> regionGroupStatisticsMap.put((TConsensusGroupId)regionGroupId, regionGroupCache.getCurrentStatistics()));
        return regionGroupStatisticsMap;
    }

    public Map<TConsensusGroupId, Map<Integer, RegionStatistics>> getCurrentRegionStatisticsMap(TConsensusGroupType type) {
        TreeMap<TConsensusGroupId, Map<Integer, RegionStatistics>> regionStatisticsMap = new TreeMap<TConsensusGroupId, Map<Integer, RegionStatistics>>();
        this.regionGroupCacheMap.forEach((regionGroupId, regionGroupCache) -> {
            if (type.equals((Object)regionGroupId.getType())) {
                regionStatisticsMap.put((TConsensusGroupId)regionGroupId, regionGroupCache.getCurrentStatistics().getRegionStatisticsMap());
            }
        });
        return regionStatisticsMap;
    }

    public Map<TConsensusGroupId, ConsensusGroupStatistics> getCurrentConsensusGroupStatisticsMap() {
        TreeMap<TConsensusGroupId, ConsensusGroupStatistics> consensusGroupStatisticsMap = new TreeMap<TConsensusGroupId, ConsensusGroupStatistics>();
        this.consensusGroupCacheMap.forEach((regionGroupId, consensusGroupCache) -> consensusGroupStatisticsMap.put((TConsensusGroupId)regionGroupId, consensusGroupCache.getCurrentStatistics()));
        return consensusGroupStatisticsMap;
    }

    public NodeStatus getNodeStatus(int nodeId) {
        return Optional.ofNullable(this.nodeCacheMap.get(nodeId)).map(BaseNodeCache::getNodeStatus).orElse(NodeStatus.Unknown);
    }

    public String getNodeStatusWithReason(int nodeId) {
        return Optional.ofNullable(this.nodeCacheMap.get(nodeId)).map(BaseNodeCache::getNodeStatusWithReason).orElseGet(() -> NodeStatus.Unknown.getStatus() + "(NoHeartbeat)");
    }

    public Map<Integer, String> getNodeStatusWithReason() {
        return this.nodeCacheMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((BaseNodeCache)e.getValue()).getNodeStatusWithReason()));
    }

    public List<Integer> filterConfigNodeThroughStatus(NodeStatus ... status) {
        return this.nodeCacheMap.entrySet().stream().filter(nodeCacheEntry -> nodeCacheEntry.getValue() instanceof ConfigNodeHeartbeatCache && Arrays.stream(status).anyMatch(s -> s.equals((Object)((BaseNodeCache)nodeCacheEntry.getValue()).getNodeStatus()))).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<Integer> filterDataNodeThroughStatus(NodeStatus ... status) {
        return this.nodeCacheMap.entrySet().stream().filter(nodeCacheEntry -> nodeCacheEntry.getValue() instanceof DataNodeHeartbeatCache && Arrays.stream(status).anyMatch(s -> s.equals((Object)((BaseNodeCache)nodeCacheEntry.getValue()).getNodeStatus()))).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<Integer> filterDataNodeThroughStatus(Function<NodeStatus, Boolean> statusPredicate) {
        return this.nodeCacheMap.entrySet().stream().filter(nodeCacheEntry -> nodeCacheEntry.getValue() instanceof DataNodeHeartbeatCache && (Boolean)statusPredicate.apply(((BaseNodeCache)nodeCacheEntry.getValue()).getNodeStatus()) != false).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public double getFreeDiskSpace(int dataNodeId) {
        return Optional.ofNullable((DataNodeHeartbeatCache)this.nodeCacheMap.get(dataNodeId)).map(DataNodeHeartbeatCache::getFreeDiskSpace).orElse(0.0);
    }

    public int getLowestLoadDataNode() {
        return this.nodeCacheMap.entrySet().stream().filter(nodeCacheEntry -> nodeCacheEntry.getValue() instanceof DataNodeHeartbeatCache).min(Comparator.comparingLong(nodeCacheEntry -> ((BaseNodeCache)nodeCacheEntry.getValue()).getLoadScore())).map(Map.Entry::getKey).orElse(-1);
    }

    public int getLowestLoadDataNode(List<Integer> dataNodeIds) {
        return dataNodeIds.stream().map(this.nodeCacheMap::get).filter(Objects::nonNull).min(Comparator.comparingLong(BaseNodeCache::getLoadScore)).map(BaseNodeCache::getNodeId).orElse(-1);
    }

    public RegionStatus getRegionStatus(TConsensusGroupId consensusGroupId, int dataNodeId) {
        return Optional.ofNullable(this.regionGroupCacheMap.get(consensusGroupId)).map(x -> x.getCurrentStatistics().getRegionStatus(dataNodeId)).orElse(RegionStatus.Unknown);
    }

    public RegionGroupStatus getRegionGroupStatus(TConsensusGroupId consensusGroupId) {
        return Optional.ofNullable(this.regionGroupCacheMap.get(consensusGroupId)).map(x -> x.getCurrentStatistics().getRegionGroupStatus()).orElse(RegionGroupStatus.Disabled);
    }

    public Map<TConsensusGroupId, RegionGroupStatus> getRegionGroupStatus(List<TConsensusGroupId> consensusGroupIds) {
        TreeMap<TConsensusGroupId, RegionGroupStatus> regionGroupStatusMap = new TreeMap<TConsensusGroupId, RegionGroupStatus>();
        for (TConsensusGroupId consensusGroupId : consensusGroupIds) {
            regionGroupStatusMap.put(consensusGroupId, this.getRegionGroupStatus(consensusGroupId));
        }
        return regionGroupStatusMap;
    }

    public List<TConsensusGroupId> filterRegionGroupThroughStatus(RegionGroupStatus ... status) {
        return this.regionGroupCacheMap.entrySet().stream().filter(regionGroupCacheEntry -> Arrays.stream(status).anyMatch(s -> s.equals((Object)((RegionGroupCache)regionGroupCacheEntry.getValue()).getCurrentStatistics().getRegionGroupStatus()))).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public int countRegionWithSpecifiedStatus(TConsensusGroupType type, RegionStatus ... status) {
        AtomicInteger result = new AtomicInteger(0);
        this.regionGroupCacheMap.forEach((regionGroupId, regionGroupCache) -> {
            if (type.equals((Object)regionGroupId.getType())) {
                regionGroupCache.getCurrentStatistics().getRegionStatisticsMap().values().forEach(regionStatistics -> {
                    if (Arrays.stream(status).anyMatch(s -> s.equals((Object)regionStatistics.getRegionStatus()))) {
                        result.getAndIncrement();
                    }
                });
            }
        });
        return result.get();
    }

    public void removeRegionGroupCache(TConsensusGroupId consensusGroupId) {
        this.regionGroupCacheMap.remove(consensusGroupId);
        this.consensusGroupCacheMap.remove(consensusGroupId);
    }

    public Map<TConsensusGroupId, Integer> getRegionLeaderMap() {
        ConcurrentHashMap<TConsensusGroupId, Integer> regionLeaderMap = new ConcurrentHashMap<TConsensusGroupId, Integer>();
        this.consensusGroupCacheMap.forEach((regionGroupId, consensusGroupCache) -> regionLeaderMap.put((TConsensusGroupId)regionGroupId, consensusGroupCache.getLeaderId()));
        return regionLeaderMap;
    }

    public Map<TConsensusGroupId, Integer> getRegionLeaderMap(TConsensusGroupType consensusGroupType) {
        ConcurrentHashMap<TConsensusGroupId, Integer> regionLeaderMap = new ConcurrentHashMap<TConsensusGroupId, Integer>();
        this.consensusGroupCacheMap.forEach((regionGroupId, consensusGroupCache) -> {
            if (regionGroupId.getType().equals((Object)consensusGroupType)) {
                regionLeaderMap.put((TConsensusGroupId)regionGroupId, consensusGroupCache.getLeaderId());
            }
        });
        return regionLeaderMap;
    }

    public void waitForLeaderElection(List<TConsensusGroupId> regionGroupIds) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("[RegionElection] Wait for leader election of RegionGroups: {}", regionGroupIds);
        while (System.currentTimeMillis() - startTime <= LEADER_ELECTION_WAITING_TIMEOUT) {
            AtomicBoolean allRegionLeaderElected = new AtomicBoolean(true);
            regionGroupIds.forEach(regionGroupId -> {
                if (!this.consensusGroupCacheMap.containsKey(regionGroupId) || this.consensusGroupCacheMap.get(regionGroupId).isLeaderUnSelected()) {
                    allRegionLeaderElected.set(false);
                }
            });
            if (allRegionLeaderElected.get()) {
                LOGGER.info("[RegionElection] The leader of RegionGroups: {} is elected.", regionGroupIds);
                return;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Interrupt when wait for leader election", (Throwable)e);
                return;
            }
        }
        LOGGER.warn("[RegionElection] The leader of RegionGroups: {} is not determined after 10 heartbeat interval. Some function might fail.", regionGroupIds);
    }

    public void updateConfirmedConfigNodeEndPoints(int dataNodeId, Set<TEndPoint> configNodeEndPoints) {
        this.confirmedConfigNodeMap.put(dataNodeId, configNodeEndPoints);
    }

    public Set<TEndPoint> getConfirmedConfigNodeEndPoints(int dataNodeId) {
        return this.confirmedConfigNodeMap.get(dataNodeId);
    }

    public void updateRegionSizeMap(int dataNodeId, Map<Integer, Long> regionSizeMap) {
        this.regionSizeMap.put(dataNodeId, regionSizeMap);
    }

    public Map<Integer, Map<Integer, Long>> getRegionSizeMap() {
        return this.regionSizeMap;
    }
}

