/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.pipe.config.constant.PipeConnectorConstant;
import org.apache.iotdb.commons.pipe.connector.compressor.PipeCompressor;
import org.apache.iotdb.commons.pipe.connector.compressor.PipeCompressorConfig;
import org.apache.iotdb.commons.pipe.connector.compressor.PipeCompressorFactory;
import org.apache.iotdb.commons.pipe.connector.limiter.GlobalRateLimiter;
import org.apache.iotdb.commons.pipe.connector.limiter.PipeEndPointRateLimiter;
import org.apache.iotdb.commons.pipe.connector.payload.thrift.request.PipeTransferCompressedReq;
import org.apache.iotdb.commons.pipe.receiver.PipeReceiverStatusHandler;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBConnector
implements PipeConnector {
    private static final String PARSE_URL_ERROR_FORMATTER = "Exception occurred while parsing node urls from target servers: {}";
    private static final String PARSE_URL_ERROR_MESSAGE = "Error occurred while parsing node urls from target servers, please check the specified 'host':'port' or 'node-urls'";
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBConnector.class);
    protected final List<TEndPoint> nodeUrls = new ArrayList<TEndPoint>();
    protected String username = "root";
    protected String password = "root";
    protected String loadBalanceStrategy;
    protected String loadTsFileStrategy;
    private boolean isRpcCompressionEnabled;
    private final List<PipeCompressor> compressors = new ArrayList<PipeCompressor>();
    private static final Map<Pair<String, Long>, PipeEndPointRateLimiter> PIPE_END_POINT_RATE_LIMITER_MAP = new ConcurrentHashMap<Pair<String, Long>, PipeEndPointRateLimiter>();
    private double endPointRateLimitBytesPerSecond = -1.0;
    private static final GlobalRateLimiter GLOBAL_RATE_LIMITER = new GlobalRateLimiter();
    protected boolean isTabletBatchModeEnabled = true;
    protected PipeReceiverStatusHandler receiverStatusHandler;
    protected boolean shouldReceiverConvertOnTypeMismatch = true;

    public void validate(PipeParameterValidator validator) throws Exception {
        PipeParameters parameters = validator.getParameters();
        validator.validate(args -> (Boolean)args[0] != false || ((Boolean)args[1] != false || (Boolean)args[2] != false) && (Boolean)args[3] != false || (Boolean)args[4] != false || ((Boolean)args[5] != false || (Boolean)args[6] != false) && (Boolean)args[7] != false, String.format("One of %s, %s:%s, %s, %s:%s must be specified", "connector.node-urls", "connector.host", "connector.port", "sink.node-urls", "sink.host", "sink.port"), new Object[]{parameters.hasAttribute("connector.node-urls"), parameters.hasAttribute("connector.ip"), parameters.hasAttribute("connector.host"), parameters.hasAttribute("connector.port"), parameters.hasAttribute("sink.node-urls"), parameters.hasAttribute("sink.ip"), parameters.hasAttribute("sink.host"), parameters.hasAttribute("sink.port")});
        validator.validate(requestMaxBatchSizeInBytes -> (Long)requestMaxBatchSizeInBytes > 0L, String.format("%s must be > 0, but got %s", "sink.batch.size-bytes", parameters.getLongOrDefault(Arrays.asList("connector.batch.size-bytes", "sink.batch.size-bytes"), 0x1000000L)), (Object)parameters.getLongOrDefault(Arrays.asList("connector.batch.size-bytes", "sink.batch.size-bytes"), 0x1000000L));
        validator.validateSynonymAttributes(Arrays.asList("connector.user", "sink.user"), Arrays.asList("connector.username", "sink.username"), false);
        this.username = parameters.getStringOrDefault(Arrays.asList("connector.user", "sink.user", "connector.username", "sink.username"), "root");
        this.password = parameters.getStringOrDefault(Arrays.asList("connector.password", "sink.password"), "root");
        this.loadBalanceStrategy = parameters.getStringOrDefault(Arrays.asList("connector.load-balance-strategy", "sink.load-balance-strategy"), "round-robin").trim().toLowerCase();
        validator.validate(arg -> PipeConnectorConstant.CONNECTOR_LOAD_BALANCE_STRATEGY_SET.contains(this.loadBalanceStrategy), String.format("Load balance strategy should be one of %s, but got %s.", PipeConnectorConstant.CONNECTOR_LOAD_BALANCE_STRATEGY_SET, this.loadBalanceStrategy), (Object)this.loadBalanceStrategy);
        this.loadTsFileStrategy = parameters.getStringOrDefault(Arrays.asList("connector.load-tsfile-strategy", "sink.load-tsfile-strategy"), "sync").trim().toLowerCase();
        validator.validate(arg -> PipeConnectorConstant.CONNECTOR_LOAD_TSFILE_STRATEGY_SET.contains(this.loadTsFileStrategy), String.format("Load tsfile strategy should be one of %s, but got %s.", PipeConnectorConstant.CONNECTOR_LOAD_TSFILE_STRATEGY_SET, this.loadTsFileStrategy), (Object)this.loadTsFileStrategy);
        int zstdCompressionLevel = parameters.getIntOrDefault(Arrays.asList("connector.compressor.zstd.level", "sink.compressor.zstd.level"), PipeConnectorConstant.CONNECTOR_COMPRESSOR_ZSTD_LEVEL_DEFAULT_VALUE);
        validator.validate(arg -> (Integer)arg >= PipeConnectorConstant.CONNECTOR_COMPRESSOR_ZSTD_LEVEL_MIN_VALUE && (Integer)arg <= PipeConnectorConstant.CONNECTOR_COMPRESSOR_ZSTD_LEVEL_MAX_VALUE, String.format("Zstd compression level should be in the range [%d, %d], but got %d.", PipeConnectorConstant.CONNECTOR_COMPRESSOR_ZSTD_LEVEL_MIN_VALUE, PipeConnectorConstant.CONNECTOR_COMPRESSOR_ZSTD_LEVEL_MAX_VALUE, zstdCompressionLevel), (Object)zstdCompressionLevel);
        String compressionTypes = parameters.getStringOrDefault(Arrays.asList("connector.compressor", "sink.compressor"), "").toLowerCase();
        if (!compressionTypes.isEmpty()) {
            for (String compressionType : compressionTypes.split(",")) {
                String trimmedCompressionType = compressionType.trim();
                if (trimmedCompressionType.isEmpty()) continue;
                validator.validate(arg -> PipeConnectorConstant.CONNECTOR_COMPRESSOR_SET.contains(trimmedCompressionType), String.format("Compressor should be one of %s, but got %s.", PipeConnectorConstant.CONNECTOR_COMPRESSOR_SET, trimmedCompressionType), (Object)trimmedCompressionType);
                this.compressors.add(PipeCompressorFactory.getCompressor(new PipeCompressorConfig(trimmedCompressionType, zstdCompressionLevel)));
            }
        }
        validator.validate(arg -> this.compressors.size() <= 127, String.format("The number of compressors should be less than or equal to %d, but got %d.", (byte)127, this.compressors.size()), (Object)this.compressors.size());
        this.isRpcCompressionEnabled = !this.compressors.isEmpty();
        this.endPointRateLimitBytesPerSecond = parameters.getDoubleOrDefault(Arrays.asList("connector.rate-limit-bytes-per-second", "sink.rate-limit-bytes-per-second"), -1.0);
        validator.validate(arg -> this.endPointRateLimitBytesPerSecond <= Double.MAX_VALUE, String.format("Rate limit should be in the range (0, %f], but got %f.", Double.MAX_VALUE, this.endPointRateLimitBytesPerSecond), (Object)this.endPointRateLimitBytesPerSecond);
        validator.validate(arg -> arg.equals("retry") || arg.equals("ignore"), String.format("The value of key %s or %s must be either 'retry' or 'ignore'.", "connector.exception.conflict.resolve-strategy", "sink.exception.conflict.resolve-strategy"), (Object)parameters.getStringOrDefault(Arrays.asList("connector.exception.conflict.resolve-strategy", "sink.exception.conflict.resolve-strategy"), "retry").trim().toLowerCase());
        validator.validateAttributeValueRange(validator.getParameters().hasAttribute("connector.format") ? "connector.format" : "sink.format", true, new String[]{"tablet", "hybrid", "tsfile"});
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        this.nodeUrls.clear();
        this.nodeUrls.addAll(this.parseNodeUrls(parameters));
        LOGGER.info("IoTDBConnector nodeUrls: {}", this.nodeUrls);
        this.isTabletBatchModeEnabled = parameters.getBooleanOrDefault(Arrays.asList("connector.batch.enable", "sink.batch.enable"), true) || parameters.getStringOrDefault(Arrays.asList("connector.format", "sink.format"), "hybrid").equals("tsfile");
        LOGGER.info("IoTDBConnector isTabletBatchModeEnabled: {}", (Object)this.isTabletBatchModeEnabled);
        this.receiverStatusHandler = new PipeReceiverStatusHandler(parameters.getStringOrDefault(Arrays.asList("connector.exception.conflict.resolve-strategy", "sink.exception.conflict.resolve-strategy"), "retry").trim().equalsIgnoreCase("retry"), parameters.getLongOrDefault(Arrays.asList("connector.exception.conflict.retry-max-time-seconds", "sink.exception.conflict.retry-max-time-seconds"), 60L), parameters.getBooleanOrDefault(Arrays.asList("connector.exception.conflict.record-ignored-data", "sink.exception.conflict.record-ignored-data"), true), parameters.getLongOrDefault(Arrays.asList("connector.exception.others.retry-max-time-seconds", "sink.exception.others.retry-max-time-seconds"), -1L), parameters.getBooleanOrDefault(Arrays.asList("connector.exception.others.record-ignored-data", "sink.exception.others.record-ignored-data"), true));
        this.shouldReceiverConvertOnTypeMismatch = parameters.getBooleanOrDefault(Arrays.asList("connector.exception.data.convert-on-type-mismatch", "sink.exception.data.convert-on-type-mismatch"), true);
        LOGGER.info("IoTDBConnector {} = {}", (Object)"connector.exception.data.convert-on-type-mismatch", (Object)this.shouldReceiverConvertOnTypeMismatch);
    }

    protected LinkedHashSet<TEndPoint> parseNodeUrls(PipeParameters parameters) throws PipeParameterNotValidException {
        LinkedHashSet<TEndPoint> givenNodeUrls = new LinkedHashSet<TEndPoint>(this.nodeUrls);
        try {
            if (parameters.hasAttribute("connector.ip") && parameters.hasAttribute("connector.port")) {
                givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"connector.ip"}), parameters.getIntByKeys(new String[]{"connector.port"}).intValue()));
            }
            if (parameters.hasAttribute("sink.ip") && parameters.hasAttribute("sink.port")) {
                givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"sink.ip"}), parameters.getIntByKeys(new String[]{"sink.port"}).intValue()));
            }
            if (parameters.hasAttribute("connector.host") && parameters.hasAttribute("connector.port")) {
                givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"connector.host"}), parameters.getIntByKeys(new String[]{"connector.port"}).intValue()));
            }
            if (parameters.hasAttribute("sink.host") && parameters.hasAttribute("sink.port")) {
                givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"sink.host"}), parameters.getIntByKeys(new String[]{"sink.port"}).intValue()));
            }
            if (parameters.hasAttribute("connector.node-urls")) {
                givenNodeUrls.addAll(NodeUrlUtils.parseTEndPointUrls(Arrays.asList(parameters.getStringByKeys(new String[]{"connector.node-urls"}).replace(" ", "").split(","))));
            }
            if (parameters.hasAttribute("sink.node-urls")) {
                givenNodeUrls.addAll(NodeUrlUtils.parseTEndPointUrls(Arrays.asList(parameters.getStringByKeys(new String[]{"sink.node-urls"}).replace(" ", "").split(","))));
            }
        }
        catch (Exception e) {
            LOGGER.warn(PARSE_URL_ERROR_FORMATTER, (Object)e.toString());
            throw new PipeParameterNotValidException(PARSE_URL_ERROR_MESSAGE);
        }
        this.checkNodeUrls(givenNodeUrls);
        return givenNodeUrls;
    }

    private void checkNodeUrls(Set<TEndPoint> nodeUrls) throws PipeParameterNotValidException {
        for (TEndPoint nodeUrl : nodeUrls) {
            if (Objects.isNull(nodeUrl.ip) || nodeUrl.ip.isEmpty()) {
                LOGGER.warn(PARSE_URL_ERROR_FORMATTER, (Object)"host cannot be empty");
                throw new PipeParameterNotValidException(PARSE_URL_ERROR_MESSAGE);
            }
            if (nodeUrl.port != 0) continue;
            LOGGER.warn(PARSE_URL_ERROR_FORMATTER, (Object)"port cannot be empty");
            throw new PipeParameterNotValidException(PARSE_URL_ERROR_MESSAGE);
        }
    }

    public void close() {
        PIPE_END_POINT_RATE_LIMITER_MAP.clear();
    }

    protected TPipeTransferReq compressIfNeeded(TPipeTransferReq req) throws IOException {
        return this.isRpcCompressionEnabled ? PipeTransferCompressedReq.toTPipeTransferReq(req, this.compressors) : req;
    }

    protected byte[] compressIfNeeded(byte[] reqInBytes) throws IOException {
        return this.isRpcCompressionEnabled ? PipeTransferCompressedReq.toTPipeTransferReqBytes(reqInBytes, this.compressors) : reqInBytes;
    }

    public boolean isRpcCompressionEnabled() {
        return this.isRpcCompressionEnabled;
    }

    public List<PipeCompressor> getCompressors() {
        return this.compressors;
    }

    public void rateLimitIfNeeded(String pipeName, long creationTime, TEndPoint endPoint, long bytesLength) {
        if (pipeName != null && this.endPointRateLimitBytesPerSecond > 0.0) {
            PIPE_END_POINT_RATE_LIMITER_MAP.computeIfAbsent((Pair<String, Long>)new Pair((Object)pipeName, (Object)creationTime), endpoint -> new PipeEndPointRateLimiter(pipeName, creationTime, this.endPointRateLimitBytesPerSecond)).acquire(endPoint, bytesLength);
        }
        GLOBAL_RATE_LIMITER.acquire(bytesLength);
    }

    public synchronized void discardEventsOfPipe(String pipeName, int regionId) {
    }

    public PipeReceiverStatusHandler statusHandler() {
        return this.receiverStatusHandler;
    }
}

