/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.qp.sql.IoTDBSqlParser;
import org.apache.iotdb.db.qp.sql.SqlLexer;
import org.apache.iotdb.db.queryengine.plan.parser.ASTVisitor;
import org.apache.iotdb.db.queryengine.plan.parser.SqlParseError;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.TimeDuration;

public class DateTimeUtils {
    public static final String TIMESTAMP_PRECISION = CommonDescriptor.getInstance().getConfig().getTimestampPrecision();
    private static Function<Long, Long> CAST_TIMESTAMP_TO_MS;
    private static final DateTimeFormatter DATE_FORMATTER;
    public static final DateTimeFormatter ISO_LOCAL_DATE_WIDTH_1_2;
    public static final DateTimeFormatter ISO_LOCAL_DATE_WITH_SLASH;
    public static final DateTimeFormatter ISO_LOCAL_DATE_WITH_DOT;
    public static final DateTimeFormatter ISO_LOCAL_TIME_WITH_MS;
    public static final DateTimeFormatter ISO_LOCAL_TIME_WITH_US;
    public static final DateTimeFormatter ISO_LOCAL_TIME_WITH_NS;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_MS;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_US;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_NS;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH_US;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH_NS;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT_US;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT_NS;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SPACE;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SPACE_US;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SPACE_NS;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE_US;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE_NS;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE_US;
    public static final DateTimeFormatter ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE_NS;
    public static final DateTimeFormatter formatter;
    public static final long MS_TO_MONTH = 2592000000L;

    private DateTimeUtils() {
    }

    public static long correctPrecision(long millis) {
        try {
            switch (TIMESTAMP_PRECISION) {
                case "us": 
                case "microsecond": {
                    return Math.multiplyExact(millis, 1000L);
                }
                case "ns": 
                case "nanosecond": {
                    return Math.multiplyExact(millis, 1000000L);
                }
            }
            return millis;
        }
        catch (ArithmeticException e) {
            throw new IoTDBRuntimeException(String.format("Timestamp overflow, Millisecond: %s , Timestamp precision: %s", millis, TIMESTAMP_PRECISION), TSStatusCode.NUMERIC_VALUE_OUT_OF_RANGE.getStatusCode(), true);
        }
    }

    public static long convertTimestampOrDatetimeStrToLongWithDefaultZone(String timeStr) {
        try {
            return Long.parseLong(timeStr);
        }
        catch (NumberFormatException e) {
            return DateTimeUtils.convertDatetimeStrToLong(timeStr, ZoneId.systemDefault());
        }
    }

    public static long convertDatetimeStrToLong(String str, ZoneId zoneId) {
        return DateTimeUtils.convertDatetimeStrToLong(str, DateTimeUtils.toZoneOffset(zoneId), 0, CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
    }

    public static long convertDatetimeStrToLong(String str, ZoneId zoneId, String timestampPrecision) {
        return DateTimeUtils.convertDatetimeStrToLong(str, DateTimeUtils.toZoneOffset(zoneId), 0, timestampPrecision);
    }

    public static long getInstantWithPrecision(String str, String timestampPrecision) {
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(str, formatter);
            Instant instant = zonedDateTime.toInstant();
            if ("us".equals(timestampPrecision) || "microsecond".equals(timestampPrecision)) {
                if (instant.getEpochSecond() < 0L && instant.getNano() > 0) {
                    long millis = Math.multiplyExact(instant.getEpochSecond() + 1L, 1000000L);
                    long adjustment = (long)(instant.getNano() / 1000) - 1L;
                    return Math.addExact(millis, adjustment);
                }
                long millis = Math.multiplyExact(instant.getEpochSecond(), 1000000L);
                return Math.addExact(millis, (long)(instant.getNano() / 1000));
            }
            if ("ns".equals(timestampPrecision) || "nanosecond".equals(timestampPrecision)) {
                long millis = Math.multiplyExact(instant.getEpochSecond(), 1000000000L);
                return Math.addExact(millis, (long)instant.getNano());
            }
            return instant.toEpochMilli();
        }
        catch (DateTimeParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static long convertDatetimeStrToLong(String str, ZoneOffset offset, int depth, String timestampPrecision) {
        if (depth >= 2) {
            throw new DateTimeException(String.format("Failed to convert %s to millisecond, zone offset is %s, please input like 2011-12-03T10:15:30 or 2011-12-03T10:15:30+01:00", str, offset));
        }
        if (str.contains("Z")) {
            return DateTimeUtils.convertDatetimeStrToLong(str.substring(0, str.indexOf(90)) + "+00:00", offset, depth, timestampPrecision);
        }
        if (str.length() == 10) {
            return DateTimeUtils.convertDatetimeStrToLong(str + "T00:00:00", offset, depth, timestampPrecision);
        }
        if (str.length() - str.lastIndexOf(43) != 6 && str.length() - str.lastIndexOf(45) != 6) {
            return DateTimeUtils.convertDatetimeStrToLong(str + offset, offset, depth + 1, timestampPrecision);
        }
        if (str.contains("[") || str.contains("]")) {
            throw new DateTimeException(String.format("%s with [time-region] at end is not supported now, please input like 2011-12-03T10:15:30 or 2011-12-03T10:15:30+01:00", str));
        }
        return DateTimeUtils.getInstantWithPrecision(str, timestampPrecision);
    }

    public static long convertDurationStrToLong(String duration) {
        return DateTimeUtils.convertDurationStrToLong(-1L, duration, false);
    }

    public static long convertDurationStrToLong(String duration, boolean convertYearToMonth) {
        return DateTimeUtils.convertDurationStrToLong(-1L, duration, convertYearToMonth);
    }

    public static long convertDurationStrToLong(String duration, String timestampPrecision, boolean convertYearToMonth) {
        return DateTimeUtils.convertDurationStrToLong(-1L, duration, timestampPrecision, convertYearToMonth);
    }

    public static long convertDurationStrToLong(long currentTime, String duration, boolean convertYearToMonth) {
        return DateTimeUtils.convertDurationStrToLong(currentTime, duration, CommonDescriptor.getInstance().getConfig().getTimestampPrecision(), convertYearToMonth);
    }

    public static long convertDurationStrToLong(long currentTime, String duration, String timestampPrecision, boolean convertYearToMonth) {
        long total = 0L;
        long temp = 0L;
        for (int i = 0; i < duration.length(); ++i) {
            char ch = duration.charAt(i);
            if (Character.isDigit(ch)) {
                temp *= 10L;
                temp += (long)(ch - 48);
                continue;
            }
            String unit = String.valueOf(duration.charAt(i));
            if (i + 1 < duration.length() && !Character.isDigit(duration.charAt(i + 1))) {
                unit = unit + duration.charAt(++i);
            }
            unit = unit.toLowerCase();
            if (convertYearToMonth && unit.equals("y")) {
                temp *= 12L;
                unit = "mo";
            }
            total += DateTimeUtils.convertDurationStrToLong(currentTime == -1L ? -1L : currentTime + total, temp, unit, timestampPrecision);
            temp = 0L;
        }
        return total;
    }

    @TestOnly
    public static long convertDurationStrToLongForTest(long value, String unit, String timestampPrecision) {
        return DateTimeUtils.convertDurationStrToLong(-1L, value, unit, timestampPrecision);
    }

    public static long convertDurationStrToLong(long currentTime, long value, String unit, String timestampPrecision) {
        DurationUnit durationUnit = DurationUnit.valueOf(unit);
        long res = value;
        switch (durationUnit) {
            case y: 
            case year: {
                res *= 31536000000L;
                break;
            }
            case mo: 
            case month: {
                if (currentTime == -1L) {
                    res *= 2592000000L;
                    break;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeZone(SessionManager.getInstance().getSessionTimeZone());
                calendar.setTimeInMillis(currentTime);
                calendar.add(2, (int)value);
                res = calendar.getTimeInMillis() - currentTime;
                break;
            }
            case w: 
            case week: {
                res *= 604800000L;
                break;
            }
            case d: 
            case day: {
                res *= 86400000L;
                break;
            }
            case h: 
            case hour: {
                res *= 3600000L;
                break;
            }
            case m: 
            case minute: {
                res *= 60000L;
                break;
            }
            case s: 
            case second: {
                res *= 1000L;
                break;
            }
        }
        if ("us".equals(timestampPrecision) || "microsecond".equals(timestampPrecision)) {
            if (unit.equals(DurationUnit.ns.toString()) || unit.equals(DurationUnit.nanosecond.toString())) {
                return value / 1000L;
            }
            if (unit.equals(DurationUnit.us.toString()) || unit.equals(DurationUnit.microsecond.toString())) {
                return value;
            }
            return res * 1000L;
        }
        if ("ns".equals(timestampPrecision) || "nanosecond".equals(timestampPrecision)) {
            if (unit.equals(DurationUnit.ns.toString()) || unit.equals(DurationUnit.nanosecond.toString())) {
                return value;
            }
            if (unit.equals(DurationUnit.us.toString()) || unit.equals(DurationUnit.microsecond.toString())) {
                return value * 1000L;
            }
            return res * 1000000L;
        }
        if (unit.equals(DurationUnit.ns.toString()) || unit.equals(DurationUnit.nanosecond.toString())) {
            return value / 1000000L;
        }
        if (unit.equals(DurationUnit.us.toString()) || unit.equals(DurationUnit.microsecond.toString())) {
            return value / 1000L;
        }
        return res;
    }

    public static TimeUnit timestampPrecisionStringToTimeUnit(String timestampPrecision) {
        if ("us".equals(timestampPrecision) || "microsecond".equals(timestampPrecision)) {
            return TimeUnit.MICROSECONDS;
        }
        if ("ns".equals(timestampPrecision) || "nanosecond".equals(timestampPrecision)) {
            return TimeUnit.NANOSECONDS;
        }
        return TimeUnit.MILLISECONDS;
    }

    public static String convertLongToDate(long timestamp) {
        return DateTimeUtils.convertLongToDate(timestamp, CommonDescriptor.getInstance().getConfig().getTimestampPrecision(), ZoneId.systemDefault());
    }

    public static String convertLongToDate(long timestamp, ZoneId zoneId) {
        return DateTimeUtils.convertLongToDate(timestamp, CommonDescriptor.getInstance().getConfig().getTimestampPrecision(), zoneId);
    }

    public static String convertLongToDate(long timestamp, String sourcePrecision) {
        return DateTimeUtils.convertLongToDate(timestamp, sourcePrecision, ZoneId.systemDefault());
    }

    public static String convertLongToDate(long timestamp, String sourcePrecision, ZoneId zoneId) {
        switch (sourcePrecision) {
            case "ns": 
            case "nanosecond": {
                timestamp /= 1000000L;
                break;
            }
            case "us": 
            case "microsecond": {
                timestamp /= 1000L;
                break;
            }
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId).toString();
    }

    public static LocalDate convertToLocalDate(long timestamp, ZoneId zoneId) {
        timestamp = CAST_TIMESTAMP_TO_MS.apply(timestamp);
        return Instant.ofEpochMilli(timestamp).atZone(zoneId).toLocalDate();
    }

    public static ZonedDateTime convertToZonedDateTime(long timestamp, ZoneId zoneId) {
        timestamp = CAST_TIMESTAMP_TO_MS.apply(timestamp);
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
    }

    public static ZoneOffset toZoneOffset(ZoneId zoneId) {
        return zoneId.getRules().getOffset(Instant.now());
    }

    public static ZonedDateTime convertMillsecondToZonedDateTime(long millisecond) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millisecond), ZoneId.systemDefault());
    }

    public static TimeUnit toTimeUnit(String t) {
        switch (t) {
            case "h": 
            case "hour": {
                return TimeUnit.HOURS;
            }
            case "m": 
            case "minute": {
                return TimeUnit.MINUTES;
            }
            case "s": 
            case "second": {
                return TimeUnit.SECONDS;
            }
            case "ms": 
            case "millisecond": {
                return TimeUnit.MILLISECONDS;
            }
            case "u": 
            case "microsecond": {
                return TimeUnit.MICROSECONDS;
            }
            case "n": 
            case "nanosecond": {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new IllegalArgumentException("time precision must be one of: h,m,s,ms,u,n");
    }

    public static long calcPositiveIntervalByMonth(long startTime, TimeDuration duration, ZoneId zoneId) {
        return TimeDuration.calcPositiveIntervalByMonth((long)startTime, (TimeDuration)duration, (TimeZone)TimeZone.getTimeZone(zoneId), (TimeUnit)TimestampPrecisionUtils.currPrecision);
    }

    public static TimeDuration constructTimeDuration(String duration) {
        duration = duration.toLowerCase();
        String currTimePrecision = CommonDescriptor.getInstance().getConfig().getTimestampPrecision();
        long temp = 0L;
        long monthDuration = 0L;
        long nonMonthDuration = 0L;
        for (int i = 0; i < duration.length(); ++i) {
            char ch = duration.charAt(i);
            if (Character.isDigit(ch)) {
                temp *= 10L;
                temp += (long)(ch - 48);
                continue;
            }
            StringBuilder unit = new StringBuilder(String.valueOf(duration.charAt(i)));
            ++i;
            while (i < duration.length() && !Character.isDigit(duration.charAt(i))) {
                unit.append(duration.charAt(i));
                ++i;
            }
            --i;
            if ("y".contentEquals(unit) || "year".contentEquals(unit)) {
                monthDuration += temp * 12L;
                temp = 0L;
                continue;
            }
            if ("mo".contentEquals(unit) || "month".contentEquals(unit)) {
                monthDuration += temp;
                temp = 0L;
                continue;
            }
            nonMonthDuration += DateTimeUtils.convertDurationStrToLong(-1L, temp, unit.toString(), currTimePrecision);
            temp = 0L;
        }
        return new TimeDuration((int)monthDuration, nonMonthDuration);
    }

    public static Long parseDateTimeExpressionToLong(String dateExpression, ZoneId zoneId) {
        ASTVisitor astVisitor = new ASTVisitor();
        astVisitor.setZoneId(zoneId);
        CodePointCharStream charStream1 = CharStreams.fromString((String)dateExpression);
        SqlLexer lexer1 = new SqlLexer((CharStream)charStream1);
        lexer1.removeErrorListeners();
        lexer1.addErrorListener((ANTLRErrorListener)SqlParseError.INSTANCE);
        CommonTokenStream tokens1 = new CommonTokenStream((TokenSource)lexer1);
        IoTDBSqlParser parser1 = new IoTDBSqlParser((TokenStream)tokens1);
        ((ParserATNSimulator)parser1.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser1.removeErrorListeners();
        parser1.addErrorListener((ANTLRErrorListener)SqlParseError.INSTANCE);
        return astVisitor.parseDateExpression(parser1.dateExpression(), TIMESTAMP_PRECISION);
    }

    public static Integer parseDateExpressionToInt(String dateExpression) {
        return DateUtils.parseDateExpressionToInt((String)dateExpression);
    }

    static {
        switch (CommonDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "us": 
            case "microsecond": {
                CAST_TIMESTAMP_TO_MS = timestamp -> timestamp / 1000L;
                break;
            }
            case "ns": 
            case "nanosecond": {
                CAST_TIMESTAMP_TO_MS = timestamp -> timestamp / 1000000L;
                break;
            }
            default: {
                CAST_TIMESTAMP_TO_MS = timestamp -> timestamp;
            }
        }
        DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        ISO_LOCAL_DATE_WIDTH_1_2 = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 19, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter();
        ISO_LOCAL_DATE_WITH_SLASH = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 19, SignStyle.NEVER).appendLiteral('/').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('/').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter();
        ISO_LOCAL_DATE_WITH_DOT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 19, SignStyle.NEVER).appendLiteral('.').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('.').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).toFormatter();
        ISO_LOCAL_TIME_WITH_MS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 3, true).toFormatter();
        ISO_LOCAL_TIME_WITH_US = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).toFormatter();
        ISO_LOCAL_TIME_WITH_NS = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_MS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WIDTH_1_2).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WIDTH_1_2).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WIDTH_1_2).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_SLASH = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_SLASH_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_SLASH_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_DOT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_DOT_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_DOT_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral('T').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_SPACE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_SPACE_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_SPACE_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_SLASH).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_MS).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE_US = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_US).appendOffsetId().toFormatter();
        ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE_NS = new DateTimeFormatterBuilder().parseCaseInsensitive().append(ISO_LOCAL_DATE_WITH_DOT).appendLiteral(' ').append(ISO_LOCAL_TIME_WITH_NS).appendOffsetId().toFormatter();
        formatter = new DateTimeFormatterBuilder().appendOptional(ISO_OFFSET_DATE_TIME_WITH_MS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_NS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH_NS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT_NS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SPACE).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SPACE_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SPACE_NS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_SLASH_WITH_SPACE_NS).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE_US).appendOptional(ISO_OFFSET_DATE_TIME_WITH_DOT_WITH_SPACE_NS).toFormatter();
    }

    public static enum DurationUnit {
        y,
        year,
        mo,
        month,
        w,
        week,
        d,
        day,
        h,
        hour,
        m,
        minute,
        s,
        second,
        ms,
        millisecond,
        us,
        microsecond,
        ns,
        nanosecond;

    }
}

