/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTaskExecutor;
import org.apache.iotdb.confignode.procedure.impl.schema.SchemaUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAlterOrDropTableProcedure<T>
extends StateMachineProcedure<ConfigNodeProcedureEnv, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAlterOrDropTableProcedure.class);
    protected String database;
    protected String tableName;
    protected String queryId;
    protected TsTable table;

    protected AbstractAlterOrDropTableProcedure() {
    }

    protected AbstractAlterOrDropTableProcedure(String database, String tableName, String queryId) {
        this.database = database;
        this.tableName = tableName;
        this.queryId = queryId;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getQueryId() {
        return this.queryId;
    }

    protected void preRelease(ConfigNodeProcedureEnv env) {
        Map<Integer, TSStatus> failedResults = SchemaUtils.preReleaseTable(this.database, this.table, env.getConfigManager());
        if (!failedResults.isEmpty()) {
            LOGGER.warn("Failed to pre-release {} for table {}.{} to DataNode, failure results: {}", new Object[]{this.getActionMessage(), this.database, this.table.getTableName(), failedResults});
            this.setFailure(new ProcedureException(new MetadataException("Pre-release " + this.getActionMessage() + " failed")));
        }
    }

    protected void commitRelease(ConfigNodeProcedureEnv env) {
        Map<Integer, TSStatus> failedResults = SchemaUtils.commitReleaseTable(this.database, this.table.getTableName(), env.getConfigManager());
        if (!failedResults.isEmpty()) {
            LOGGER.warn("Failed to {} for table {}.{} to DataNode, failure results: {}", new Object[]{this.getActionMessage(), this.database, this.table.getTableName(), failedResults});
        }
    }

    @Override
    protected boolean isRollbackSupported(T state) {
        return true;
    }

    protected void rollbackPreRelease(ConfigNodeProcedureEnv env) {
        Map<Integer, TSStatus> failedResults = SchemaUtils.rollbackPreRelease(this.database, this.table.getTableName(), env.getConfigManager());
        if (!failedResults.isEmpty()) {
            LOGGER.warn("Failed to rollback pre-release {} for table {}.{} info to DataNode, failure results: {}", new Object[]{this.getActionMessage(), this.database, this.table.getTableName(), failedResults});
            this.setFailure(new ProcedureException(new MetadataException("Rollback pre-release " + this.getActionMessage() + " failed")));
        }
    }

    protected abstract String getActionMessage();

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.database, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.tableName, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        if (Objects.nonNull(this.table)) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            this.table.serialize((OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.database = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.tableName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.table = TsTable.deserialize((ByteBuffer)byteBuffer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAlterOrDropTableProcedure that = (AbstractAlterOrDropTableProcedure)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.queryId, that.queryId);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.tableName, this.queryId);
    }

    protected class TableRegionTaskExecutor<Q>
    extends DataNodeRegionTaskExecutor<Q, TSStatus> {
        private final String taskName;

        protected TableRegionTaskExecutor(String taskName, ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetRegionGroup, CnToDnAsyncRequestType dataNodeRequestType, BiFunction<TDataNodeLocation, List<TConsensusGroupId>, Q> dataNodeRequestGenerator) {
            super(env, targetRegionGroup, false, dataNodeRequestType, dataNodeRequestGenerator);
            this.taskName = taskName;
        }

        @Override
        protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TSStatus response) {
            ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
            if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return failedRegionList;
            }
            if (response.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                List subStatus = response.getSubStatus();
                for (int i = 0; i < subStatus.size(); ++i) {
                    if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                    failedRegionList.add(consensusGroupIdList.get(i));
                }
            } else {
                failedRegionList.addAll(consensusGroupIdList);
            }
            return failedRegionList;
        }

        @Override
        protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
            AbstractAlterOrDropTableProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("[%s] for %s.%s failed when [%s] because failed to execute in all replicaset of %s %s. Failure nodes: %s", this.getClass().getSimpleName(), AbstractAlterOrDropTableProcedure.this.database, AbstractAlterOrDropTableProcedure.this.tableName, this.taskName, consensusGroupId.type, consensusGroupId.id, dataNodeLocationSet))));
            this.interruptTask();
        }
    }
}

