/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.region;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.env.RegionMaintainHandler;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.AddRegionPeerProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RemoveRegionPeerProcedure;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.state.RegionTransitionState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionMigrateProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, RegionTransitionState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegionMigrateProcedure.class);
    private TConsensusGroupId consensusGroupId;
    private TDataNodeLocation originalDataNode;
    private TDataNodeLocation destDataNode;
    private TDataNodeLocation coordinatorForAddPeer;
    private TDataNodeLocation coordinatorForRemovePeer;

    public RegionMigrateProcedure() {
    }

    public RegionMigrateProcedure(TConsensusGroupId consensusGroupId, TDataNodeLocation originalDataNode, TDataNodeLocation destDataNode, TDataNodeLocation coordinatorForAddPeer, TDataNodeLocation coordinatorForRemovePeer) {
        this.consensusGroupId = consensusGroupId;
        this.originalDataNode = originalDataNode;
        this.destDataNode = destDataNode;
        this.coordinatorForAddPeer = coordinatorForAddPeer;
        this.coordinatorForRemovePeer = coordinatorForRemovePeer;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, RegionTransitionState state) {
        if (this.consensusGroupId == null) {
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        RegionMaintainHandler handler = env.getRegionMaintainHandler();
        try {
            switch (state) {
                case REGION_MIGRATE_PREPARE: {
                    LOGGER.info("[pid{}][MigrateRegion] started, {} will be migrated from DataNode {} to {}.", new Object[]{this.getProcId(), this.consensusGroupId, handler.simplifiedLocation(this.originalDataNode), handler.simplifiedLocation(this.destDataNode)});
                    this.setNextState(RegionTransitionState.ADD_REGION_PEER);
                    break;
                }
                case ADD_REGION_PEER: {
                    this.addChildProcedure(new AddRegionPeerProcedure(this.consensusGroupId, this.coordinatorForAddPeer, this.destDataNode));
                    this.setNextState(RegionTransitionState.CHECK_ADD_REGION_PEER);
                    break;
                }
                case CHECK_ADD_REGION_PEER: {
                    if (!env.getConfigManager().getPartitionManager().isDataNodeContainsRegion(this.destDataNode.getDataNodeId(), this.consensusGroupId)) {
                        LOGGER.warn("[pid{}][MigrateRegion] sub-procedure AddRegionPeerProcedure fail, RegionMigrateProcedure will not continue", (Object)this.getProcId());
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(RegionTransitionState.REMOVE_REGION_PEER);
                    break;
                }
                case REMOVE_REGION_PEER: {
                    this.addChildProcedure(new RemoveRegionPeerProcedure(this.consensusGroupId, this.coordinatorForRemovePeer, this.originalDataNode));
                    this.setNextState(RegionTransitionState.CHECK_REMOVE_REGION_PEER);
                    break;
                }
                case CHECK_REMOVE_REGION_PEER: {
                    String cleanHint = "";
                    if (env.getConfigManager().getPartitionManager().isDataNodeContainsRegion(this.originalDataNode.getDataNodeId(), this.consensusGroupId)) {
                        cleanHint = "but you may need to restart the related DataNode to make sure everything is cleaned up. ";
                    }
                    LOGGER.info("[pid{}][MigrateRegion] success,{} {} has been migrated from DataNode {} to {}. Procedure took {} (started at {}).", new Object[]{this.getProcId(), cleanHint, this.consensusGroupId, handler.simplifiedLocation(this.originalDataNode), handler.simplifiedLocation(this.destDataNode), CommonDateTimeUtils.convertMillisecondToDurationStr((long)(System.currentTimeMillis() - this.getSubmittedTime())), DateTimeUtils.convertLongToDate((long)this.getSubmittedTime(), (String)"ms")});
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new ProcedureException("Unsupported state: " + state.name());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[pid{}][MigrateRegion] state {} fail", new Object[]{this.getProcId(), state, e});
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        LOGGER.info("[pid{}][MigrateRegion] state {} complete", (Object)this.getProcId(), (Object)state);
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, RegionTransitionState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            if (configNodeProcedureEnv.getRegionMigrateLock().tryLock(this)) {
                LOGGER.info("procedureId {} acquire lock.", (Object)this.getProcId());
                ProcedureLockState procedureLockState = ProcedureLockState.LOCK_ACQUIRED;
                return procedureLockState;
            }
            configNodeProcedureEnv.getRegionMigrateLock().waitProcedure(this);
            LOGGER.info("procedureId {} wait for lock.", (Object)this.getProcId());
            ProcedureLockState procedureLockState = ProcedureLockState.LOCK_EVENT_WAIT;
            return procedureLockState;
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }

    @Override
    protected void releaseLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            LOGGER.info("procedureId {} release lock.", (Object)this.getProcId());
            if (configNodeProcedureEnv.getRegionMigrateLock().releaseLock(this)) {
                configNodeProcedureEnv.getRegionMigrateLock().wakeWaitingProcedures(configNodeProcedureEnv.getScheduler());
            }
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }

    @Override
    protected RegionTransitionState getState(int stateId) {
        return RegionTransitionState.values()[stateId];
    }

    @Override
    protected int getStateId(RegionTransitionState regionTransitionState) {
        return regionTransitionState.ordinal();
    }

    @Override
    protected RegionTransitionState getInitialState() {
        return RegionTransitionState.REGION_MIGRATE_PREPARE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.REGION_MIGRATE_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.originalDataNode, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.destDataNode, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.consensusGroupId, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.coordinatorForAddPeer, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.coordinatorForRemovePeer, (DataOutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.originalDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            this.destDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            this.consensusGroupId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer);
            this.coordinatorForAddPeer = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            this.coordinatorForRemovePeer = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOGGER.warn("Error in deserialize {} (procID {}). This procedure will be ignored. It may belong to old version and cannot be used now.", new Object[]{this.getClass(), this.getProcId(), e});
            throw e;
        }
    }

    public boolean equals(Object that) {
        if (that instanceof RegionMigrateProcedure) {
            RegionMigrateProcedure thatProc = (RegionMigrateProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.originalDataNode.equals(this.originalDataNode) && thatProc.destDataNode.equals(this.destDataNode) && thatProc.consensusGroupId.equals(this.consensusGroupId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.originalDataNode, this.destDataNode, this.consensusGroupId);
    }

    public TConsensusGroupId getConsensusGroupId() {
        return this.consensusGroupId;
    }

    public TDataNodeLocation getDestDataNode() {
        return this.destDataNode;
    }
}

