/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.extractor;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.datastructure.queue.listening.AbstractPipeListeningQueue;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.PipeSnapshotEvent;
import org.apache.iotdb.commons.pipe.event.PipeWritePlanEvent;
import org.apache.iotdb.commons.pipe.extractor.IoTDBNonDataRegionExtractor;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionSnapshotEvent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionWritePlanEvent;
import org.apache.iotdb.confignode.manager.pipe.extractor.ConfigRegionListeningFilter;
import org.apache.iotdb.confignode.manager.pipe.extractor.PipeConfigPhysicalPlanPatternParseVisitor;
import org.apache.iotdb.confignode.manager.pipe.metric.PipeConfigNodeRemainingTimeMetrics;
import org.apache.iotdb.confignode.manager.pipe.metric.PipeConfigRegionExtractorMetrics;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class IoTDBConfigRegionExtractor
extends IoTDBNonDataRegionExtractor {
    public static final PipeConfigPhysicalPlanPatternParseVisitor PATTERN_PARSE_VISITOR = new PipeConfigPhysicalPlanPatternParseVisitor();
    private Set<ConfigPhysicalPlanType> listenedTypeSet = new HashSet<ConfigPhysicalPlanType>();

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        if (ConfigNodeDescriptor.getInstance().getConf().getConfigNodeConsensusProtocolClass().equals("org.apache.iotdb.consensus.simple.SimpleConsensus")) {
            throw new PipeException("IoTDBConfigRegionExtractor does not transferring events under simple consensus");
        }
        super.customize(parameters, configuration);
        this.listenedTypeSet = ConfigRegionListeningFilter.parseListeningPlanTypeSet(parameters);
        PipeConfigRegionExtractorMetrics.getInstance().register(this);
        PipeConfigNodeRemainingTimeMetrics.getInstance().register(this);
    }

    protected AbstractPipeListeningQueue getListeningQueue() {
        return PipeConfigNodeAgent.runtime().listener();
    }

    protected boolean needTransferSnapshot() {
        return PipeConfigRegionSnapshotEvent.needTransferSnapshot(this.listenedTypeSet);
    }

    protected void triggerSnapshot() {
        try {
            ConfigNode.getInstance().getConfigManager().getConsensusManager().getConsensusImpl().triggerSnapshot((ConsensusGroupId)new ConfigRegionId(ConfigNodeDescriptor.getInstance().getConf().getConfigRegionId()), true);
        }
        catch (ConsensusException e) {
            throw new PipeException("Exception encountered when triggering schema region snapshot.", (Throwable)e);
        }
    }

    public synchronized EnrichedEvent supply() throws Exception {
        EnrichedEvent event = super.supply();
        PipeEventCommitManager.getInstance().enrichWithCommitterKeyAndCommitId(event, this.creationTime, this.regionId);
        return event;
    }

    protected long getMaxBlockingTimeMs() {
        return PipeConfig.getInstance().getPipeSubtaskExecutorPendingQueueMaxBlockingTimeMs();
    }

    protected Optional<PipeWritePlanEvent> trimRealtimeEventByPipePattern(PipeWritePlanEvent event) {
        return ((Optional)PATTERN_PARSE_VISITOR.process(((PipeConfigRegionWritePlanEvent)event).getConfigPhysicalPlan(), this.pipePattern)).map(configPhysicalPlan -> new PipeConfigRegionWritePlanEvent((ConfigPhysicalPlan)configPhysicalPlan, event.isGeneratedByPipe()));
    }

    protected boolean isTypeListened(PipeWritePlanEvent event) {
        return this.listenedTypeSet.contains((Object)((PipeConfigRegionWritePlanEvent)event).getConfigPhysicalPlan().getType());
    }

    protected void confineHistoricalEventTransferTypes(PipeSnapshotEvent event) {
        ((PipeConfigRegionSnapshotEvent)event).confineTransferredTypes(this.listenedTypeSet);
    }

    public synchronized void close() throws Exception {
        if (this.hasBeenClosed.get()) {
            return;
        }
        this.hasBeenClosed.set(true);
        if (!this.hasBeenStarted.get()) {
            return;
        }
        super.close();
        if (Objects.nonNull(this.taskID)) {
            PipeConfigRegionExtractorMetrics.getInstance().deregister(this.taskID);
            PipeConfigNodeRemainingTimeMetrics.getInstance().deregister(this.pipeName + "_" + this.creationTime);
        }
    }
}

