/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.node;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.common.rpc.thrift.TLoadSample;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.cache.AbstractStatistics;
import org.apache.iotdb.confignode.manager.load.cache.node.BaseNodeCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;

public class AINodeHeartbeatCache
extends BaseNodeCache {
    private final AtomicReference<TLoadSample> latestLoadSample = new AtomicReference<TLoadSample>(new TLoadSample());

    public AINodeHeartbeatCache(int aiNodeId) {
        super(aiNodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCurrentStatistics(boolean forceUpdate) {
        long lastSendTime;
        NodeHeartbeatSample lastSample = null;
        List list = this.slidingWindow;
        synchronized (list) {
            if (!this.slidingWindow.isEmpty()) {
                lastSample = (NodeHeartbeatSample)this.getLastSample();
            }
        }
        long l = lastSendTime = lastSample == null ? 0L : lastSample.getSampleLogicalTimestamp();
        if (lastSample != null && lastSample.isSetLoadSample()) {
            this.latestLoadSample.set(lastSample.getLoadSample());
        }
        NodeStatus status = null;
        String statusReason = null;
        long currentNanoTime = System.nanoTime();
        if (lastSample != null && NodeStatus.Removing.equals((Object)lastSample.getStatus())) {
            status = NodeStatus.Removing;
        } else if (currentNanoTime - lastSendTime > 20000000000L) {
            status = NodeStatus.Unknown;
        } else if (lastSample != null) {
            status = lastSample.getStatus();
            statusReason = lastSample.getStatusReason();
        }
        long loadScore = NodeStatus.isNormalStatus((NodeStatus)status) ? 0L : Long.MAX_VALUE;
        NodeStatistics newStatistics = new NodeStatistics(currentNanoTime, status, statusReason, loadScore);
        if (!((AbstractStatistics)this.currentStatistics.get()).equals(newStatistics)) {
            this.currentStatistics.set(newStatistics);
        }
    }
}

