/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.encoding.encoder.DeltaBinaryEncoder;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.encoding.encoder.IntRLBE;
import org.apache.tsfile.encoding.encoder.IntRleEncoder;
import org.apache.tsfile.encoding.encoder.LongRLBE;
import org.apache.tsfile.encoding.encoder.LongRleEncoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.encoding.TsFileEncodingException;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;

public class FloatEncoder
extends Encoder {
    private Encoder encoder;
    private int maxPointNumber;
    private double maxPointValue;
    private boolean isMaxPointNumberSaved;
    private final List<Boolean> useMaxPointNumber;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FloatEncoder(TSEncoding encodingType, TSDataType dataType, int maxPointNumber) {
        super(encodingType);
        this.maxPointNumber = maxPointNumber;
        this.calculateMaxPointNum();
        this.isMaxPointNumberSaved = false;
        this.useMaxPointNumber = new ArrayList<Boolean>();
        if (encodingType == TSEncoding.RLE) {
            if (dataType == TSDataType.FLOAT) {
                this.encoder = new IntRleEncoder();
                return;
            } else {
                if (dataType != TSDataType.DOUBLE) throw new TsFileEncodingException(String.format("data type %s is not supported by FloatEncoder", dataType));
                this.encoder = new LongRleEncoder();
            }
            return;
        } else if (encodingType == TSEncoding.TS_2DIFF) {
            if (dataType == TSDataType.FLOAT) {
                this.encoder = new DeltaBinaryEncoder.IntDeltaEncoder();
                return;
            } else {
                if (dataType != TSDataType.DOUBLE) throw new TsFileEncodingException(String.format("data type %s is not supported by FloatEncoder", dataType));
                this.encoder = new DeltaBinaryEncoder.LongDeltaEncoder();
            }
            return;
        } else {
            if (encodingType != TSEncoding.RLBE) throw new TsFileEncodingException(String.format("%s encoding is not supported by FloatEncoder", new Object[]{encodingType}));
            if (dataType == TSDataType.FLOAT) {
                this.encoder = new IntRLBE();
                return;
            } else {
                if (dataType != TSDataType.DOUBLE) throw new TsFileEncodingException(String.format("data type %s is not supported by FloatEncoder", dataType));
                this.encoder = new LongRLBE();
            }
        }
    }

    @Override
    public void encode(float value, ByteArrayOutputStream out) {
        this.saveMaxPointNumber(out);
        int valueInt = this.convertFloatToInt(value);
        this.encoder.encode(valueInt, out);
    }

    @Override
    public void encode(double value, ByteArrayOutputStream out) {
        this.saveMaxPointNumber(out);
        long valueLong = this.convertDoubleToLong(value);
        this.encoder.encode(valueLong, out);
    }

    private void calculateMaxPointNum() {
        if (this.maxPointNumber <= 0) {
            this.maxPointNumber = 0;
            this.maxPointValue = 1.0;
        } else {
            this.maxPointValue = Math.pow(10.0, this.maxPointNumber);
        }
    }

    private int convertFloatToInt(float value) {
        if ((double)value * this.maxPointValue > 2.147483647E9 || (double)value * this.maxPointValue < -2.147483648E9) {
            this.useMaxPointNumber.add(false);
            return Math.round(value);
        }
        this.useMaxPointNumber.add(true);
        return (int)Math.round((double)value * this.maxPointValue);
    }

    private long convertDoubleToLong(double value) {
        if (value * this.maxPointValue > 9.223372036854776E18 || value * this.maxPointValue < -9.223372036854776E18) {
            this.useMaxPointNumber.add(false);
            return Math.round(value);
        }
        this.useMaxPointNumber.add(true);
        return Math.round(value * this.maxPointValue);
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        this.encoder.flush(out);
        if (this.pointsNotUseMaxPointNumber()) {
            byte[] ba = out.toByteArray();
            out.reset();
            ReadWriteForEncodingUtils.writeUnsignedVarInt(Integer.MAX_VALUE, out);
            BitMap bitMap = new BitMap(this.useMaxPointNumber.size());
            for (int i = 0; i < this.useMaxPointNumber.size(); ++i) {
                if (!this.useMaxPointNumber.get(i).booleanValue()) continue;
                bitMap.mark(i);
            }
            ReadWriteForEncodingUtils.writeUnsignedVarInt(this.useMaxPointNumber.size(), out);
            out.write(bitMap.getByteArray());
            out.write(ba);
        }
        this.reset();
    }

    private void reset() {
        this.isMaxPointNumberSaved = false;
        this.useMaxPointNumber.clear();
    }

    private boolean pointsNotUseMaxPointNumber() {
        for (boolean info : this.useMaxPointNumber) {
            if (info) continue;
            return true;
        }
        return false;
    }

    private void saveMaxPointNumber(ByteArrayOutputStream out) {
        if (!this.isMaxPointNumberSaved) {
            ReadWriteForEncodingUtils.writeUnsignedVarInt(this.maxPointNumber, out);
            this.isMaxPointNumberSaved = true;
        }
    }

    @Override
    public int getOneItemMaxSize() {
        return this.encoder.getOneItemMaxSize();
    }

    @Override
    public long getMaxByteSize() {
        return this.encoder.getMaxByteSize();
    }
}

