/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.AlignedPageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.ChunkMetadataElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.AbstractInnerCompactionWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.writer.flushcontroller.AbstractCompactionFlushController;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;

public class FastInnerCompactionWriter
extends AbstractInnerCompactionWriter {
    public FastInnerCompactionWriter(TsFileResource targetFileResource) throws IOException {
        super(targetFileResource);
    }

    public FastInnerCompactionWriter(List<TsFileResource> targetFileResources) throws IOException {
        super(targetFileResources);
    }

    @Override
    public void write(TsBlock tsBlock, int subTaskId) throws IOException {
        throw new RuntimeException("Does not support this method in FastInnerCompactionWriter");
    }

    @Override
    public boolean flushNonAlignedChunk(Chunk chunk, ChunkMetadata chunkMetadata, int subTaskId) throws IOException {
        this.checkPreviousTimestamp(chunkMetadata.getStartTime(), subTaskId);
        if (this.chunkPointNumArray[subTaskId] != 0 && this.chunkWriters[subTaskId].checkIsChunkSizeOverThreshold(this.targetChunkSize, this.targetChunkPointNum, false)) {
            this.sealChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId);
        }
        if (this.chunkPointNumArray[subTaskId] != 0 || !this.checkIsChunkLargeEnough(chunk)) {
            return false;
        }
        this.flushNonAlignedChunkToFileWriter(this.fileWriter, chunk, chunkMetadata, subTaskId);
        this.lastTime[subTaskId] = chunkMetadata.getEndTime();
        return true;
    }

    @Override
    public boolean flushAlignedChunk(ChunkMetadataElement chunkMetadataElement, int subTaskId) throws IOException {
        AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetadataElement.chunkMetadata;
        IChunkMetadata timeChunkMetadata = alignedChunkMetadata.getTimeChunkMetadata();
        List valueChunkMetadatas = alignedChunkMetadata.getValueChunkMetadataList();
        Chunk timeChunk = chunkMetadataElement.chunk;
        List<Chunk> valueChunks = chunkMetadataElement.valueChunks;
        this.checkPreviousTimestamp(timeChunkMetadata.getStartTime(), subTaskId);
        if (this.chunkPointNumArray[subTaskId] != 0 && this.chunkWriters[subTaskId].checkIsChunkSizeOverThreshold(this.targetChunkSize, this.targetChunkPointNum, false)) {
            this.sealChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId);
        }
        if (this.chunkPointNumArray[subTaskId] != 0 || !this.checkIsAlignedChunkLargeEnough(timeChunk, valueChunks)) {
            return false;
        }
        this.flushAlignedChunkToFileWriter(this.fileWriter, timeChunk, timeChunkMetadata, valueChunks, valueChunkMetadatas, subTaskId);
        this.lastTime[subTaskId] = timeChunkMetadata.getEndTime();
        return true;
    }

    @Override
    public boolean flushBatchedValueChunk(ChunkMetadataElement chunkMetadataElement, int subTaskId, AbstractCompactionFlushController flushController) throws IOException {
        AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetadataElement.chunkMetadata;
        IChunkMetadata timeChunkMetadata = alignedChunkMetadata.getTimeChunkMetadata();
        List valueChunkMetadatas = alignedChunkMetadata.getValueChunkMetadataList();
        List<Chunk> valueChunks = chunkMetadataElement.valueChunks;
        this.checkPreviousTimestamp(timeChunkMetadata.getStartTime(), subTaskId);
        if (this.chunkPointNumArray[subTaskId] != 0 && flushController.shouldSealChunkWriter()) {
            this.sealChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId);
        }
        if (this.chunkPointNumArray[subTaskId] != 0) {
            return false;
        }
        if (!flushController.shouldCompactChunkByDirectlyFlush(timeChunkMetadata)) {
            return false;
        }
        this.flushAlignedChunkToFileWriter(this.fileWriter, null, timeChunkMetadata, valueChunks, valueChunkMetadatas, subTaskId);
        this.lastTime[subTaskId] = timeChunkMetadata.getEndTime();
        return true;
    }

    @Override
    public boolean flushAlignedPage(AlignedPageElement alignedPageElement, int subTaskId) throws IOException, PageException {
        PageHeader timePageHeader = alignedPageElement.getTimePageHeader();
        List<PageHeader> valuePageHeaders = alignedPageElement.getValuePageHeaders();
        ByteBuffer compressedTimePageData = alignedPageElement.getTimePageData();
        List<ByteBuffer> compressedValuePageDatas = alignedPageElement.getValuePageDataList();
        this.checkPreviousTimestamp(timePageHeader.getStartTime(), subTaskId);
        boolean isUnsealedPageOverThreshold = this.chunkWriters[subTaskId].checkIsUnsealedPageOverThreshold(this.pageSizeLowerBoundInCompaction, this.pagePointNumLowerBoundInCompaction, true);
        if (!isUnsealedPageOverThreshold || !this.checkIsAlignedPageLargeEnough(timePageHeader, valuePageHeaders)) {
            return false;
        }
        this.flushAlignedPageToChunkWriter((AlignedChunkWriterImpl)this.chunkWriters[subTaskId], compressedTimePageData, timePageHeader, compressedValuePageDatas, valuePageHeaders, subTaskId);
        this.lastTime[subTaskId] = timePageHeader.getEndTime();
        return true;
    }

    @Override
    public boolean flushBatchedValuePage(AlignedPageElement alignedPageElement, int subTaskId, AbstractCompactionFlushController flushController) throws PageException, IOException {
        boolean isUnsealedPageOverThreshold;
        PageHeader timePageHeader = alignedPageElement.getTimePageHeader();
        List<PageHeader> valuePageHeaders = alignedPageElement.getValuePageHeaders();
        ByteBuffer compressedTimePageData = alignedPageElement.getTimePageData();
        List<ByteBuffer> compressedValuePageDatas = alignedPageElement.getValuePageDataList();
        this.checkPreviousTimestamp(timePageHeader.getStartTime(), subTaskId);
        if (flushController.shouldSealChunkWriter()) {
            this.sealChunk(this.fileWriter, this.chunkWriters[subTaskId], subTaskId);
        }
        if (!(isUnsealedPageOverThreshold = this.chunkWriters[subTaskId].checkIsUnsealedPageOverThreshold(this.pageSizeLowerBoundInCompaction, this.pagePointNumLowerBoundInCompaction, true))) {
            return false;
        }
        this.flushAlignedPageToChunkWriter((AlignedChunkWriterImpl)this.chunkWriters[subTaskId], compressedTimePageData, timePageHeader, compressedValuePageDatas, valuePageHeaders, subTaskId);
        this.lastTime[subTaskId] = timePageHeader.getEndTime();
        return true;
    }

    @Override
    public boolean flushNonAlignedPage(ByteBuffer compressedPageData, PageHeader pageHeader, int subTaskId) throws PageException {
        this.checkPreviousTimestamp(pageHeader.getStartTime(), subTaskId);
        boolean isUnsealedPageOverThreshold = this.chunkWriters[subTaskId].checkIsUnsealedPageOverThreshold(this.pageSizeLowerBoundInCompaction, this.pagePointNumLowerBoundInCompaction, true);
        if (!isUnsealedPageOverThreshold || !this.checkIsPageLargeEnough(pageHeader)) {
            return false;
        }
        this.flushNonAlignedPageToChunkWriter((ChunkWriterImpl)this.chunkWriters[subTaskId], compressedPageData, pageHeader, subTaskId);
        this.lastTime[subTaskId] = pageHeader.getEndTime();
        return true;
    }

    private boolean checkIsAlignedChunkLargeEnough(Chunk timeChunk, List<Chunk> valueChunks) {
        if (this.checkIsChunkLargeEnough(timeChunk)) {
            return true;
        }
        for (Chunk valueChunk : valueChunks) {
            if (valueChunk == null || !this.checkIsChunkLargeEnough(valueChunk)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIsChunkLargeEnough(Chunk chunk) {
        return (long)chunk.getChunkStatistic().getCount() >= this.targetChunkPointNum || this.getChunkSize(chunk) >= this.targetChunkSize;
    }

    private boolean checkIsAlignedPageLargeEnough(PageHeader timePageHeader, List<PageHeader> valuePageHeaders) {
        if (this.checkIsPageLargeEnough(timePageHeader)) {
            return true;
        }
        for (PageHeader valuePageHeader : valuePageHeaders) {
            if (valuePageHeader == null || !this.checkIsPageLargeEnough(valuePageHeader)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIsPageLargeEnough(PageHeader pageHeader) {
        return (long)pageHeader.getStatistics().getCount() >= this.pagePointNumLowerBoundInCompaction || (long)pageHeader.getSerializedPageSize() >= this.pageSizeLowerBoundInCompaction;
    }
}

