/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.quota.ExceedQuotaException;
import org.apache.iotdb.db.pipe.consensus.deletion.DeletionResource;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.db.queryengine.common.DeviceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.QueryResourceMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeTTLCache;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.ContinuousSameSearchIndexSeparatorNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableDeviceSchemaCache;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TreeDeviceSchemaCacheManager;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.service.SettleService;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.service.metrics.WritingMetrics;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionInfo;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionMetrics;
import org.apache.iotdb.db.storageengine.dataregion.HashLastFlushTimeMap;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.db.storageengine.dataregion.ILastFlushTimeMap;
import org.apache.iotdb.db.storageengine.dataregion.compaction.constant.CompactionTaskType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.recover.CompactionRecoverManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.RepairUnsortedFileCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduler;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.flush.CloseFileListener;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushListener;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushStatus;
import org.apache.iotdb.db.storageengine.dataregion.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessor;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessorInfo;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.modification.TableDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.TreeDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.v1.ModificationFileV1;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSourceForRegionScan;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IFileScanHandle;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl.ClosedFileScanHandleImpl;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileID;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndexCacheRecorder;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.utils.fileTimeIndexCache.FileTimeIndexCacheReader;
import org.apache.iotdb.db.storageengine.dataregion.utils.validate.TsFileValidator;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.WALRecoverManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.file.SealedTsFileRecoverPerformer;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.file.UnsealedTsFileRecoverPerformer;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALRecoverListener;
import org.apache.iotdb.db.storageengine.load.limiter.LoadTsFileRateLimiter;
import org.apache.iotdb.db.storageengine.rescon.disk.TierManager;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.storageengine.rescon.memory.TimePartitionInfo;
import org.apache.iotdb.db.storageengine.rescon.memory.TimePartitionManager;
import org.apache.iotdb.db.storageengine.rescon.memory.TsFileResourceManager;
import org.apache.iotdb.db.storageengine.rescon.quotas.DataNodeSpaceQuotaManager;
import org.apache.iotdb.db.tools.settle.TsFileAndModSettleTool;
import org.apache.iotdb.db.utils.CommonUtils;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.fileSystem.FSFactoryProducer;
import org.apache.tsfile.fileSystem.FSType;
import org.apache.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.FSUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRegion
implements IDataRegionForQuery {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static final int MERGE_MOD_START_VERSION_NUM = 1;
    private static final Logger logger = LoggerFactory.getLogger(DataRegion.class);
    private final ReadWriteLock insertLock = new ReentrantReadWriteLock();
    private final Condition deletedCondition = this.insertLock.writeLock().newCondition();
    private volatile boolean deleted = false;
    private final Object closeStorageGroupCondition = new Object();
    private final ReadWriteLock closeQueryLock = new ReentrantReadWriteLock();
    private final TreeMap<Long, TsFileProcessor> workSequenceTsFileProcessors = new TreeMap();
    private final TreeMap<Long, TsFileProcessor> workUnsequenceTsFileProcessors = new TreeMap();
    private final Set<TsFileProcessor> closingSequenceTsFileProcessor = ConcurrentHashMap.newKeySet();
    private final Set<TsFileProcessor> closingUnSequenceTsFileProcessor = ConcurrentHashMap.newKeySet();
    private final String dataRegionId;
    private final String databaseName;
    private File dataRegionSysDir;
    private final TsFileManager tsFileManager;
    private final TsFileResourceManager tsFileResourceManager = TsFileResourceManager.getInstance();
    private final FSFactory fsFactory = FSFactoryProducer.getFSFactory();
    private TsFileFlushPolicy fileFlushPolicy;
    private Map<Long, Long> partitionMaxFileVersions = new ConcurrentHashMap<Long, Long>();
    private final DataRegionInfo dataRegionInfo = new DataRegionInfo(this);
    private boolean isReady = false;
    private List<Callable<Void>> asyncTsFileResourceRecoverTaskList;
    private List<CloseFileListener> customCloseFileListeners = Collections.emptyList();
    private List<FlushListener> customFlushListeners = Collections.emptyList();
    private ILastFlushTimeMap lastFlushTimeMap;
    private String insertWriteLockHolder = "";
    private volatile long directBufferMemoryCost = 0L;
    private final AtomicBoolean isCompactionSelecting = new AtomicBoolean(false);
    private static final QueryResourceMetricSet QUERY_RESOURCE_METRIC_SET = QueryResourceMetricSet.getInstance();
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();
    private final ExecutorService upgradeModFileThreadPool;
    private final DataRegionMetrics metrics;

    public DataRegion(String systemDir, String dataRegionId, TsFileFlushPolicy fileFlushPolicy, String databaseName) throws DataRegionException {
        this.dataRegionId = dataRegionId;
        this.databaseName = databaseName;
        this.fileFlushPolicy = fileFlushPolicy;
        this.acquireDirectBufferMemory();
        this.dataRegionSysDir = SystemFileFactory.INSTANCE.getFile(systemDir, dataRegionId);
        this.tsFileManager = new TsFileManager(databaseName, dataRegionId, this.dataRegionSysDir.getPath());
        if (this.dataRegionSysDir.mkdirs()) {
            logger.info("Database system Directory {} doesn't exist, create it", (Object)this.dataRegionSysDir.getPath());
        } else if (!this.dataRegionSysDir.exists()) {
            logger.error("create database system Directory {} failed", (Object)this.dataRegionSysDir.getPath());
        }
        this.lastFlushTimeMap = new HashLastFlushTimeMap();
        this.upgradeModFileThreadPool = IoTDBThreadPoolFactory.newSingleThreadExecutor((String)(databaseName + "-" + dataRegionId + "-UpgradeMod"));
        if (config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && !StorageEngine.getInstance().isReadyForReadAndWrite()) {
            logger.debug("Skip recovering data region {}[{}] when consensus protocol is ratis and storage engine is not ready.", (Object)databaseName, (Object)dataRegionId);
            for (String fileFolder : TierManager.getInstance().getAllFilesFolders()) {
                File dataRegionFolder = this.fsFactory.getFile(fileFolder, databaseName + File.separator + dataRegionId);
                try {
                    this.fsFactory.deleteDirectory(dataRegionFolder.getPath());
                }
                catch (IOException e) {
                    logger.error("Exception occurs when deleting data region folder for {}-{}", new Object[]{databaseName, dataRegionId, e});
                }
                if (FSUtils.getFSType((File)dataRegionFolder) != FSType.LOCAL) continue;
                if (dataRegionFolder.mkdirs()) {
                    logger.info("Data region directory {} doesn't exist, create it", (Object)dataRegionFolder.getPath());
                    continue;
                }
                if (dataRegionFolder.exists()) continue;
                logger.error("create data region directory {} failed", (Object)dataRegionFolder.getPath());
            }
        } else {
            this.asyncTsFileResourceRecoverTaskList = new ArrayList<Callable<Void>>();
            this.recover();
        }
        this.metrics = new DataRegionMetrics(this);
        MetricService.getInstance().addMetricSet((IMetricSet)this.metrics);
    }

    @TestOnly
    public DataRegion(String databaseName, String id) {
        this.databaseName = databaseName;
        this.dataRegionId = id;
        this.tsFileManager = new TsFileManager(databaseName, id, "");
        this.partitionMaxFileVersions = new HashMap<Long, Long>();
        this.partitionMaxFileVersions.put(0L, 0L);
        this.upgradeModFileThreadPool = null;
        this.metrics = new DataRegionMetrics(this);
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public List<Callable<Void>> getAsyncTsFileResourceRecoverTaskList() {
        return this.asyncTsFileResourceRecoverTaskList;
    }

    public void clearAsyncTsFileResourceRecoverTaskList() {
        this.asyncTsFileResourceRecoverTaskList.clear();
    }

    private void recover() throws DataRegionException {
        try {
            this.recoverCompaction();
        }
        catch (Exception e) {
            WALRecoverManager.getInstance().getAllDataRegionScannedLatch().countDownWithException(e.getMessage());
            throw new DataRegionException(e);
        }
        try {
            WALRecoverListener recoverListener;
            Object tsFileResource;
            Map<Long, List<TsFileResource>> partitionTmpSeqTsFiles = this.getAllFiles(TierManager.getInstance().getAllLocalSequenceFileFolders());
            Map<Long, List<TsFileResource>> partitionTmpUnseqTsFiles = this.getAllFiles(TierManager.getInstance().getAllLocalUnSequenceFileFolders());
            DataRegionRecoveryContext dataRegionRecoveryContext = new DataRegionRecoveryContext(partitionTmpSeqTsFiles.values().stream().mapToLong(List::size).sum() + partitionTmpUnseqTsFiles.values().stream().mapToLong(List::size).sum());
            ArrayList<WALRecoverListener> recoverListeners = new ArrayList<WALRecoverListener>();
            for (List<TsFileResource> value : partitionTmpSeqTsFiles.values()) {
                for (TsFileResource resource : value) {
                    if (!resource.resourceFileExists()) continue;
                    FileMetrics.getInstance().addTsFile(resource.getDatabaseName(), resource.getDataRegionId(), resource.getTsFile().length(), true, resource.getTsFile().getName());
                    resource.upgradeModFile(this.upgradeModFileThreadPool);
                }
                while (!value.isEmpty() && !((TsFileResource)(tsFileResource = value.get(value.size() - 1))).resourceFileExists()) {
                    value.remove(value.size() - 1);
                    recoverListener = this.recoverUnsealedTsFile((TsFileResource)tsFileResource, dataRegionRecoveryContext, true);
                    if (recoverListener == null) continue;
                    recoverListeners.add(recoverListener);
                }
            }
            for (List<TsFileResource> value : partitionTmpUnseqTsFiles.values()) {
                tsFileResource = value.iterator();
                while (tsFileResource.hasNext()) {
                    TsFileResource resource;
                    resource = tsFileResource.next();
                    if (resource.resourceFileExists()) {
                        FileMetrics.getInstance().addTsFile(resource.getDatabaseName(), resource.getDataRegionId(), resource.getTsFile().length(), false, resource.getTsFile().getName());
                    }
                    resource.upgradeModFile(this.upgradeModFileThreadPool);
                }
                while (!value.isEmpty() && !((TsFileResource)(tsFileResource = value.get(value.size() - 1))).resourceFileExists()) {
                    value.remove(value.size() - 1);
                    recoverListener = this.recoverUnsealedTsFile((TsFileResource)tsFileResource, dataRegionRecoveryContext, false);
                    if (recoverListener == null) continue;
                    recoverListeners.add(recoverListener);
                }
            }
            WALRecoverManager.getInstance().getAllDataRegionScannedLatch().countDown();
            if (!partitionTmpSeqTsFiles.isEmpty() || !partitionTmpUnseqTsFiles.isEmpty()) {
                Callable<Void> asyncRecoverTask;
                long latestPartitionId = Long.MIN_VALUE;
                if (!partitionTmpSeqTsFiles.isEmpty()) {
                    latestPartitionId = (Long)((TreeMap)partitionTmpSeqTsFiles).lastKey();
                }
                if (!partitionTmpUnseqTsFiles.isEmpty()) {
                    latestPartitionId = Math.max(latestPartitionId, (Long)((TreeMap)partitionTmpUnseqTsFiles).lastKey());
                }
                File logFile = SystemFileFactory.INSTANCE.getFile(this.dataRegionSysDir, "FileTimeIndexCache_0");
                HashMap<TsFileID, FileTimeIndex> fileTimeIndexMap = new HashMap<TsFileID, FileTimeIndex>();
                if (logFile.exists()) {
                    try {
                        FileTimeIndexCacheReader logReader = new FileTimeIndexCacheReader(logFile, this.dataRegionId);
                        logReader.read(fileTimeIndexMap);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                for (Map.Entry<Long, List<TsFileResource>> partitionFiles : partitionTmpSeqTsFiles.entrySet()) {
                    asyncRecoverTask = this.recoverFilesInPartition(partitionFiles.getKey(), dataRegionRecoveryContext, partitionFiles.getValue(), fileTimeIndexMap, true);
                    if (asyncRecoverTask == null) continue;
                    this.asyncTsFileResourceRecoverTaskList.add(asyncRecoverTask);
                }
                for (Map.Entry<Long, List<TsFileResource>> partitionFiles : partitionTmpUnseqTsFiles.entrySet()) {
                    asyncRecoverTask = this.recoverFilesInPartition(partitionFiles.getKey(), dataRegionRecoveryContext, partitionFiles.getValue(), fileTimeIndexMap, false);
                    if (asyncRecoverTask == null) continue;
                    this.asyncTsFileResourceRecoverTaskList.add(asyncRecoverTask);
                }
                if (config.isEnableSeparateData()) {
                    TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), latestPartitionId, false, Long.MAX_VALUE, this.lastFlushTimeMap.getMemSize(latestPartitionId)));
                }
            }
            for (WALRecoverListener recoverListener2 : recoverListeners) {
                if (recoverListener2.waitForResult() == AbstractResultListener.Status.FAILURE) {
                    logger.error("Fail to recover unsealed TsFile {}, skip it.", (Object)recoverListener2.getFilePath(), (Object)recoverListener2.getCause());
                }
                dataRegionRecoveryContext.incrementRecoveredFilesNum();
            }
            dataRegionRecoveryContext.recoverPerformers.sort((p1, p2) -> this.compareFileName(p1.getTsFileResource().getTsFile(), p2.getTsFileResource().getTsFile()));
            for (UnsealedTsFileRecoverPerformer recoverPerformer : dataRegionRecoveryContext.recoverPerformers) {
                this.recoverUnsealedTsFileCallBack(recoverPerformer);
            }
            for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
                long partitionNum = resource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, resource.getVersion());
            }
            for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
                long partitionNum = resource.getTimePartition();
                this.updatePartitionFileVersion(partitionNum, resource.getVersion());
            }
        }
        catch (IOException e) {
            WALRecoverManager.getInstance().getAllDataRegionScannedLatch().countDownWithException(e.getMessage());
            throw new DataRegionException(e);
        }
        if (this.asyncTsFileResourceRecoverTaskList.isEmpty()) {
            this.initCompactionSchedule();
        }
        if (StorageEngine.getInstance().isReadyForReadAndWrite()) {
            logger.info("The data region {}[{}] is created successfully", (Object)this.databaseName, (Object)this.dataRegionId);
        } else {
            logger.info("The data region {}[{}] is recovered successfully", (Object)this.databaseName, (Object)this.dataRegionId);
        }
    }

    private void updatePartitionLastFlushTime(TsFileResource resource) {
        if (config.isEnableSeparateData()) {
            this.lastFlushTimeMap.updatePartitionFlushedTime(resource.getTimePartition(), resource.getTimeIndex().getMaxEndTime());
        }
    }

    protected void updateDeviceLastFlushTime(TsFileResource resource) {
        long timePartitionId = resource.getTimePartition();
        HashMap<IDeviceID, Long> endTimeMap = new HashMap<IDeviceID, Long>();
        for (IDeviceID deviceId : resource.getDevices()) {
            long endTime = resource.getEndTime(deviceId);
            endTimeMap.put(deviceId, endTime);
        }
        if (config.isEnableSeparateData()) {
            this.lastFlushTimeMap.updateMultiDeviceFlushedTime(timePartitionId, endTimeMap);
        }
        if (CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            this.lastFlushTimeMap.updateMultiDeviceGlobalFlushedTime(endTimeMap);
        }
    }

    protected void upgradeAndUpdateDeviceLastFlushTime(long timePartitionId, List<TsFileResource> resources) {
        HashMap<IDeviceID, Long> endTimeMap = new HashMap<IDeviceID, Long>();
        for (TsFileResource resource : resources) {
            for (IDeviceID deviceId : resource.getDevices()) {
                long endTime = resource.getEndTime(deviceId);
                endTimeMap.put(deviceId, endTime);
            }
        }
        if (config.isEnableSeparateData()) {
            this.lastFlushTimeMap.upgradeAndUpdateMultiDeviceFlushedTime(timePartitionId, endTimeMap);
        }
        if (CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            this.lastFlushTimeMap.updateMultiDeviceGlobalFlushedTime(endTimeMap);
        }
    }

    public void initCompactionSchedule() {
        RepairUnsortedFileCompactionTask.recoverAllocatedFileTimestamp(this.tsFileManager.getMaxFileTimestampOfUnSequenceFile());
        CompactionScheduleTaskManager.getInstance().registerDataRegion(this);
    }

    private void recoverCompaction() {
        CompactionRecoverManager compactionRecoverManager = new CompactionRecoverManager(this.tsFileManager, this.databaseName, this.dataRegionId);
        compactionRecoverManager.recoverCompaction();
    }

    public void updatePartitionFileVersion(long partitionNum, long fileVersion) {
        this.partitionMaxFileVersions.compute(partitionNum, (key, oldVersion) -> oldVersion == null || fileVersion > oldVersion ? fileVersion : oldVersion);
    }

    private Map<Long, List<TsFileResource>> getAllFiles(List<String> folders) throws IOException, DataRegionException {
        HashMap<String, File> tsFilePartitionPath2File = new HashMap<String, File>();
        for (String baseDir : folders) {
            File fileFolder = this.fsFactory.getFile(baseDir + File.separator + this.databaseName, this.dataRegionId);
            if (!fileFolder.exists()) continue;
            this.continueFailedRenames(fileFolder, ".temp");
            File[] subFiles = fileFolder.listFiles();
            if (subFiles == null) continue;
            for (File partitionFolder : subFiles) {
                File[] tsFilesInThisFolder;
                if (!partitionFolder.isDirectory()) {
                    logger.warn("{} is not a directory.", (Object)partitionFolder.getAbsolutePath());
                    continue;
                }
                this.continueFailedRenames(partitionFolder, ".temp");
                String partitionName = partitionFolder.getName();
                for (File f : tsFilesInThisFolder = this.fsFactory.listFilesBySuffix(partitionFolder.getAbsolutePath(), ".tsfile")) {
                    String tsFilePartitionPath = partitionName + File.separator + f.getName();
                    tsFilePartitionPath2File.put(tsFilePartitionPath, f);
                }
            }
        }
        ArrayList sortedFiles = new ArrayList(tsFilePartitionPath2File.values());
        sortedFiles.sort(this::compareFileName);
        long currentTime = System.currentTimeMillis();
        TreeMap<Long, List<TsFileResource>> ret = new TreeMap<Long, List<TsFileResource>>();
        for (File f : sortedFiles) {
            this.checkTsFileTime(f, currentTime);
            TsFileResource resource = new TsFileResource(f);
            ret.computeIfAbsent(resource.getTsFileID().timePartitionId, l -> new ArrayList()).add(resource);
        }
        return ret;
    }

    private void continueFailedRenames(File fileFolder, String suffix) throws IOException {
        File[] files = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), suffix);
        if (files != null) {
            for (File tempResource : files) {
                File originResource = this.fsFactory.getFile(tempResource.getPath().replace(suffix, ""));
                if (originResource.exists()) {
                    Files.delete(tempResource.toPath());
                    continue;
                }
                Files.move(tempResource.toPath(), originResource.toPath(), new CopyOption[0]);
            }
        }
    }

    private void checkTsFileTime(File tsFile, long currentTime) throws DataRegionException {
        String[] items = tsFile.getName().replace(".tsfile", "").split("-");
        long fileTime = Long.parseLong(items[0]);
        long version = Long.parseLong(items[1]);
        if (version > 0L && fileTime > currentTime && fileTime < RepairUnsortedFileCompactionTask.getInitialAllocatedFileTimestamp()) {
            throw new DataRegionException(String.format("data region %s[%s] is down, because the time of tsfile %s is larger than system current time, file time is %d while system current time is %d, please check it.", this.databaseName, this.dataRegionId, tsFile.getAbsolutePath(), fileTime, currentTime));
        }
    }

    private WALRecoverListener recoverUnsealedTsFile(TsFileResource unsealedTsFile, DataRegionRecoveryContext context, boolean isSeq) {
        UnsealedTsFileRecoverPerformer recoverPerformer = new UnsealedTsFileRecoverPerformer(unsealedTsFile, isSeq, context.recoverPerformers::add);
        return WALRecoverManager.getInstance().addRecoverPerformer(recoverPerformer);
    }

    private void recoverUnsealedTsFileCallBack(UnsealedTsFileRecoverPerformer recoverPerformer) {
        try {
            TsFileResource tsFileResource = recoverPerformer.getTsFileResource();
            boolean isSeq = recoverPerformer.isSequence();
            if (!recoverPerformer.canWrite()) {
                try {
                    tsFileResource.close();
                }
                catch (IOException e) {
                    logger.error("Fail to close TsFile {} when recovering", (Object)tsFileResource.getTsFile(), (Object)e);
                }
                if (!TsFileValidator.getInstance().validateTsFile(tsFileResource)) {
                    tsFileResource.remove();
                    return;
                }
                this.updateDeviceLastFlushTime(tsFileResource);
                this.tsFileResourceManager.registerSealedTsFileResource(tsFileResource);
                FileMetrics.getInstance().addTsFile(tsFileResource.getDatabaseName(), tsFileResource.getDataRegionId(), tsFileResource.getTsFile().length(), recoverPerformer.isSequence(), tsFileResource.getTsFile().getName());
            } else {
                RestorableTsFileIOWriter writer = recoverPerformer.getWriter();
                long timePartitionId = tsFileResource.getTimePartition();
                TimePartitionManager.getInstance().updateAfterOpeningTsFileProcessor(new DataRegionId(Integer.parseInt(this.dataRegionId)), timePartitionId);
                TsFileProcessor tsFileProcessor = new TsFileProcessor(this.dataRegionId, this.dataRegionInfo, tsFileResource, this::closeUnsealedTsFileProcessorCallBack, this::flushCallback, isSeq, writer);
                if (this.workSequenceTsFileProcessors.get(tsFileProcessor.getTimeRangeId()) == null && this.workUnsequenceTsFileProcessors.get(tsFileProcessor.getTimeRangeId()) == null) {
                    WritingMetrics.getInstance().recordActiveTimePartitionCount(1);
                }
                if (isSeq) {
                    this.workSequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                } else {
                    this.workUnsequenceTsFileProcessors.put(timePartitionId, tsFileProcessor);
                }
                tsFileResource.setProcessor(tsFileProcessor);
                tsFileResource.removeResourceFile();
                tsFileProcessor.setTimeRangeId(timePartitionId);
                writer.makeMetadataVisible();
                TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.dataRegionInfo);
                tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
                this.dataRegionInfo.initTsFileProcessorInfo(tsFileProcessor);
                long chunkMetadataSize = 0L;
                for (Map metaMap : writer.getMetadatasForQuery().values()) {
                    for (List metadataList : metaMap.values()) {
                        for (ChunkMetadata chunkMetadata : metadataList) {
                            chunkMetadataSize += chunkMetadata.getRetainedSizeInBytes();
                        }
                    }
                }
                tsFileProcessorInfo.addTSPMemCost(chunkMetadataSize);
            }
            this.tsFileManager.add(tsFileResource, recoverPerformer.isSequence());
        }
        catch (Throwable e) {
            logger.error("Fail to recover unsealed TsFile {}, skip it.", (Object)recoverPerformer.getTsFileAbsolutePath(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverSealedTsFiles(TsFileResource sealedTsFile, DataRegionRecoveryContext context) {
        try (SealedTsFileRecoverPerformer recoverPerformer = new SealedTsFileRecoverPerformer(sealedTsFile);){
            recoverPerformer.recover();
            sealedTsFile.close();
            this.tsFileResourceManager.registerSealedTsFileResource(sealedTsFile);
        }
        catch (Throwable e) {
            logger.error("Fail to recover sealed TsFile {}, skip it.", (Object)sealedTsFile.getTsFilePath(), (Object)e);
        }
        finally {
            context.incrementRecoveredFilesNum();
        }
    }

    private Callable<Void> recoverFilesInPartition(long partitionId, DataRegionRecoveryContext context, List<TsFileResource> resourceList, Map<TsFileID, FileTimeIndex> fileTimeIndexMap, boolean isSeq) {
        ArrayList<TsFileResource> resourceListForAsyncRecover = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> resourceListForSyncRecover = new ArrayList<TsFileResource>();
        Callable<Void> asyncRecoverTask = null;
        for (TsFileResource tsFileResource : resourceList) {
            this.tsFileManager.add(tsFileResource, isSeq);
            if (fileTimeIndexMap.containsKey(tsFileResource.getTsFileID()) && tsFileResource.resourceFileExists()) {
                tsFileResource.setTimeIndex(fileTimeIndexMap.get(tsFileResource.getTsFileID()));
                tsFileResource.setStatus(TsFileResourceStatus.NORMAL);
                resourceListForAsyncRecover.add(tsFileResource);
                continue;
            }
            resourceListForSyncRecover.add(tsFileResource);
        }
        if (!resourceListForAsyncRecover.isEmpty()) {
            asyncRecoverTask = this.asyncRecoverFilesInPartition(partitionId, context, resourceListForAsyncRecover);
        }
        if (!resourceListForSyncRecover.isEmpty()) {
            this.syncRecoverFilesInPartition(partitionId, context, resourceListForSyncRecover);
        }
        return asyncRecoverTask;
    }

    private Callable<Void> asyncRecoverFilesInPartition(long partitionId, DataRegionRecoveryContext context, List<TsFileResource> resourceList) {
        if (config.isEnableSeparateData()) {
            if (!this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(partitionId, false)) {
                TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), partitionId, false, Long.MAX_VALUE, this.lastFlushTimeMap.getMemSize(partitionId)));
            }
            for (TsFileResource tsFileResource : resourceList) {
                this.updatePartitionLastFlushTime(tsFileResource);
            }
            TimePartitionManager.getInstance().updateAfterFlushing(new DataRegionId(Integer.parseInt(this.dataRegionId)), partitionId, System.currentTimeMillis(), this.lastFlushTimeMap.getMemSize(partitionId), false);
        }
        for (TsFileResource tsFileResource : resourceList) {
            if (!tsFileResource.isUseSharedModFile()) continue;
            tsFileResource.setSharedModFilePathFuture(new CompletableFuture<String>());
        }
        return () -> {
            for (TsFileResource tsFileResource : resourceList) {
                try (SealedTsFileRecoverPerformer recoverPerformer = new SealedTsFileRecoverPerformer(tsFileResource);){
                    recoverPerformer.recover();
                    this.tsFileResourceManager.registerSealedTsFileResource(tsFileResource);
                }
                catch (Throwable e) {
                    logger.error("Fail to recover sealed TsFile {}, skip it.", (Object)tsFileResource.getTsFilePath(), (Object)e);
                }
                finally {
                    context.incrementRecoveredFilesNum();
                }
            }
            if (config.isEnableSeparateData()) {
                this.upgradeAndUpdateDeviceLastFlushTime(partitionId, resourceList);
            }
            return null;
        };
    }

    private void syncRecoverFilesInPartition(long partitionId, DataRegionRecoveryContext context, List<TsFileResource> resourceList) {
        for (TsFileResource tsFileResource : resourceList) {
            this.recoverSealedTsFiles(tsFileResource, context);
        }
        FileTimeIndexCacheRecorder.getInstance().logFileTimeIndex(resourceList.toArray(new TsFileResource[0]));
        if (config.isEnableSeparateData()) {
            if (!this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(partitionId, true)) {
                TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), partitionId, false, Long.MAX_VALUE, this.lastFlushTimeMap.getMemSize(partitionId)));
            }
            for (TsFileResource tsFileResource : resourceList) {
                this.updateDeviceLastFlushTime(tsFileResource);
            }
            TimePartitionManager.getInstance().updateAfterFlushing(new DataRegionId(Integer.parseInt(this.dataRegionId)), partitionId, System.currentTimeMillis(), this.lastFlushTimeMap.getMemSize(partitionId), false);
        }
    }

    private int compareFileName(File o1, File o2) {
        long ver2;
        String[] items1 = o1.getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            return Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
        }
        return cmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRowNode insertRowNode) throws WriteProcessException {
        long ttl = this.getTTL(insertRowNode);
        if (!CommonUtils.isAlive(insertRowNode.getTime(), ttl)) {
            throw new OutOfTTLException(insertRowNode.getTime(), CommonDateTimeUtils.currentTime() - ttl);
        }
        StorageEngine.blockInsertionIfReject();
        long startTime = System.nanoTime();
        this.writeLock("InsertRow");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            if (this.deleted) {
                return;
            }
            long timePartitionId = TimePartitionUtils.getTimePartitionId((long)insertRowNode.getTime());
            this.initFlushTimeMap(timePartitionId);
            boolean isSequence = config.isEnableSeparateData() && insertRowNode.getTime() > this.lastFlushTimeMap.getFlushedTime(timePartitionId, insertRowNode.getDeviceID());
            TsFileProcessor tsFileProcessor = this.insertToTsFileProcessor(insertRowNode, isSequence, timePartitionId);
            if (tsFileProcessor != null && tsFileProcessor.shouldFlush()) {
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
            if (CommonDescriptor.getInstance().getConfig().isLastCacheEnable() && !insertRowNode.isGeneratedByRemoteConsensusLeader()) {
                startTime = System.nanoTime();
                this.tryToUpdateInsertRowLastCache(insertRowNode);
                PERFORMANCE_OVERVIEW_METRICS.recordScheduleUpdateLastCacheCost(System.nanoTime() - startTime);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private long getLastFlushTime(long timePartitionID, IDeviceID deviceID) {
        return config.isEnableSeparateData() ? this.lastFlushTimeMap.getFlushedTime(timePartitionID, deviceID) : Long.MAX_VALUE;
    }

    private void split(InsertTabletNode insertTabletNode, int loc, int endOffset, Map<Long, List<int[]>[]> splitInfo) {
        int before = loc;
        long beforeTime = insertTabletNode.getTimes()[before];
        long beforeTimePartition = TimePartitionUtils.getTimePartitionId((long)beforeTime);
        this.initFlushTimeMap(beforeTimePartition);
        boolean isSequence = false;
        while (loc < endOffset) {
            long lastFlushTime;
            long time = insertTabletNode.getTimes()[loc];
            long timePartitionId = TimePartitionUtils.getTimePartitionId((long)time);
            if (timePartitionId != beforeTimePartition) {
                this.initFlushTimeMap(timePartitionId);
                lastFlushTime = this.getLastFlushTime(timePartitionId, insertTabletNode.getDeviceID(loc));
                this.updateSplitInfo(splitInfo, beforeTimePartition, isSequence, new int[]{before, loc});
                before = loc;
                beforeTimePartition = timePartitionId;
                isSequence = time > lastFlushTime;
            } else if (!isSequence && time > (lastFlushTime = this.getLastFlushTime(timePartitionId, insertTabletNode.getDeviceID(loc)))) {
                this.updateSplitInfo(splitInfo, beforeTimePartition, false, new int[]{before, loc});
                before = loc;
                isSequence = true;
            }
            ++loc;
        }
        if (before < loc) {
            this.updateSplitInfo(splitInfo, beforeTimePartition, isSequence, new int[]{before, loc});
        }
    }

    private void updateSplitInfo(Map<Long, List<int[]>[]> splitInfo, long partitionId, boolean isSequence, int[] newRange) {
        int[] lastRange;
        if (newRange[0] >= newRange[1]) {
            return;
        }
        List[] rangeLists = splitInfo.computeIfAbsent(partitionId, k -> new List[2]);
        ArrayList<int[]> rangeList = rangeLists[isSequence ? 1 : 0];
        if (rangeList == null) {
            rangeList = new ArrayList<int[]>();
            rangeLists[isSequence ? 1 : 0] = rangeList;
        }
        if (!rangeList.isEmpty() && (lastRange = (int[])rangeList.get(rangeList.size() - 1))[1] == newRange[0]) {
            lastRange[1] = newRange[1];
            return;
        }
        rangeList.add(newRange);
    }

    private boolean doInsert(InsertTabletNode insertTabletNode, Map<Long, List<int[]>[]> splitMap, TSStatus[] results, long[] infoForMetrics) {
        boolean noFailure = true;
        for (Map.Entry<Long, List<int[]>[]> entry : splitMap.entrySet()) {
            List<int[]> unSequenceRangeList;
            long timePartitionId = entry.getKey();
            List<int[]>[] rangeLists = entry.getValue();
            List<int[]> sequenceRangeList = rangeLists[1];
            if (sequenceRangeList != null) {
                boolean bl = noFailure = this.insertTabletToTsFileProcessor(insertTabletNode, sequenceRangeList, true, results, timePartitionId, noFailure, infoForMetrics) && noFailure;
            }
            if ((unSequenceRangeList = rangeLists[0]) == null) continue;
            noFailure = this.insertTabletToTsFileProcessor(insertTabletNode, unSequenceRangeList, false, results, timePartitionId, noFailure, infoForMetrics) && noFailure;
        }
        return noFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTablet(InsertTabletNode insertTabletNode) throws BatchProcessException, WriteProcessException {
        StorageEngine.blockInsertionIfReject();
        long startTime = System.nanoTime();
        this.writeLock("insertTablet");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            if (this.deleted) {
                logger.info("Won't insert tablet {}, because region is deleted", (Object)insertTabletNode.getSearchIndex());
                return;
            }
            Object[] results = new TSStatus[insertTabletNode.getRowCount()];
            Arrays.fill(results, RpcUtils.SUCCESS_STATUS);
            long[] infoForMetrics = new long[5];
            boolean noFailure = this.executeInsertTablet(insertTabletNode, (TSStatus[])results, infoForMetrics);
            this.updateTsFileProcessorMetric(insertTabletNode, infoForMetrics);
            if (!noFailure) {
                throw new BatchProcessException((TSStatus[])results);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean executeInsertTablet(InsertTabletNode insertTabletNode, TSStatus[] results, long[] infoForMetrics) throws OutOfTTLException {
        int loc = insertTabletNode.checkTTL(results, this.getTTL(insertTabletNode));
        boolean noFailure = loc == 0;
        List<Pair<IDeviceID, Integer>> deviceEndOffsetPairs = insertTabletNode.splitByDevice(loc, insertTabletNode.getRowCount());
        int start = loc;
        HashMap<Long, List<int[]>[]> splitInfo = new HashMap<Long, List<int[]>[]>();
        for (Pair<IDeviceID, Integer> deviceEndOffsetPair : deviceEndOffsetPairs) {
            int end = (Integer)deviceEndOffsetPair.getRight();
            this.split(insertTabletNode, start, end, splitInfo);
            start = end;
        }
        boolean bl = noFailure = this.doInsert(insertTabletNode, splitInfo, results, infoForMetrics) && noFailure;
        if (CommonDescriptor.getInstance().getConfig().isLastCacheEnable() && !insertTabletNode.isGeneratedByRemoteConsensusLeader()) {
            long startTime = System.nanoTime();
            this.tryToUpdateInsertTabletLastCache(insertTabletNode);
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleUpdateLastCacheCost(System.nanoTime() - startTime);
        }
        return noFailure;
    }

    private void initFlushTimeMap(long timePartitionId) {
        if (config.isEnableSeparateData() && !this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(timePartitionId, true)) {
            TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), timePartitionId, true, Long.MAX_VALUE, 0L));
        }
    }

    private boolean insertTabletToTsFileProcessor(InsertTabletNode insertTabletNode, List<int[]> rangeList, boolean sequence, TSStatus[] results, long timePartitionId, boolean noFailure, long[] infoForMetrics) {
        if (insertTabletNode.allMeasurementFailed()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Won't insert tablet {}, because {}", (Object)insertTabletNode.getSearchIndex(), (Object)"insertTabletNode allMeasurementFailed");
            }
            return true;
        }
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null) {
            for (int[] rangePair : rangeList) {
                int start = rangePair[0];
                int end = rangePair[1];
                for (int i = start; i < end; ++i) {
                    results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("can not create TsFileProcessor, timePartitionId: " + timePartitionId));
                }
            }
            return false;
        }
        this.registerToTsFile(insertTabletNode, tsFileProcessor);
        try {
            tsFileProcessor.insertTablet(insertTabletNode, rangeList, results, noFailure, infoForMetrics);
        }
        catch (WriteProcessRejectException e) {
            logger.warn("insert to TsFileProcessor rejected, {}", (Object)e.getMessage());
            return false;
        }
        catch (WriteProcessException e) {
            logger.error("insert to TsFileProcessor error ", (Throwable)((Object)e));
            return false;
        }
        if (tsFileProcessor.shouldFlush()) {
            this.fileFlushPolicy.apply(this, tsFileProcessor, sequence);
        }
        return true;
    }

    private void registerToTsFile(InsertNode node, TsFileProcessor tsFileProcessor) {
        String tableName = node.getTableName();
        if (tableName != null) {
            tsFileProcessor.registerToTsFile(tableName, (String t) -> TableSchema.of(DataNodeTableCache.getInstance().getTable(this.getDatabaseName(), (String)t)).toTsFileTableSchemaNoAttribute());
        }
    }

    private void tryToUpdateInsertTabletLastCache(InsertTabletNode node) {
        node.updateLastCache(this.getDatabaseName());
    }

    private TsFileProcessor insertToTsFileProcessor(InsertRowNode insertRowNode, boolean sequence, long timePartitionId) throws WriteProcessException {
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, sequence);
        if (tsFileProcessor == null || insertRowNode.allMeasurementFailed()) {
            return null;
        }
        long[] infoForMetrics = new long[5];
        tsFileProcessor.insert(insertRowNode, infoForMetrics);
        this.updateTsFileProcessorMetric(insertRowNode, infoForMetrics);
        this.registerToTsFile(insertRowNode, tsFileProcessor);
        return tsFileProcessor;
    }

    private void tryToUpdateInsertRowLastCache(InsertRowNode node) {
        node.updateLastCache(this.databaseName);
    }

    private List<InsertRowNode> insertToTsFileProcessors(InsertRowsNode insertRowsNode, boolean[] areSequence, long[] timePartitionIds, long[] infoForMetrics) {
        HashMap<TsFileProcessor, InsertRowsNode> tsFileProcessorMap = new HashMap<TsFileProcessor, InsertRowsNode>();
        for (int i = 0; i < areSequence.length; ++i) {
            TsFileProcessor tsFileProcessor;
            InsertRowNode insertRowNode = insertRowsNode.getInsertRowNodeList().get(i);
            if (insertRowNode.allMeasurementFailed() || (tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionIds[i], areSequence[i])) == null) continue;
            int finalI = i;
            tsFileProcessorMap.compute(tsFileProcessor, (k, v) -> {
                if (v == null) {
                    v = insertRowsNode.emptyClone();
                    v.setSearchIndex(insertRowNode.getSearchIndex());
                    v.setAligned(insertRowNode.isAligned());
                    if (insertRowNode.isGeneratedByPipe()) {
                        v.markAsGeneratedByPipe();
                    }
                    if (insertRowNode.isGeneratedByRemoteConsensusLeader()) {
                        v.markAsGeneratedByRemoteConsensusLeader();
                    }
                }
                if (v.isAligned() != insertRowNode.isAligned()) {
                    v.setMixingAlignment(true);
                }
                v.addOneInsertRowNode(insertRowNode, finalI);
                v.updateProgressIndex(insertRowNode.getProgressIndex());
                return v;
            });
        }
        ArrayList<InsertRowNode> executedInsertRowNodeList = new ArrayList<InsertRowNode>();
        for (Map.Entry entry : tsFileProcessorMap.entrySet()) {
            TsFileProcessor tsFileProcessor = (TsFileProcessor)entry.getKey();
            InsertRowsNode subInsertRowsNode = (InsertRowsNode)entry.getValue();
            try {
                tsFileProcessor.insertRows(subInsertRowsNode, infoForMetrics);
            }
            catch (WriteProcessException e) {
                insertRowsNode.getResults().put(subInsertRowsNode.getInsertRowNodeIndexList().get(0), RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
            }
            executedInsertRowNodeList.addAll(subInsertRowsNode.getInsertRowNodeList());
            this.registerToTsFile(subInsertRowsNode, tsFileProcessor);
            if (!((TsFileProcessor)entry.getKey()).shouldFlush()) continue;
            this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
        }
        return executedInsertRowNodeList;
    }

    private void tryToUpdateInsertRowsLastCache(List<InsertRowNode> nodeList) {
        for (InsertRowNode node : nodeList) {
            node.updateLastCache(this.databaseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submitAFlushTask(long timeRangeId, boolean sequence, IMemTable memTable) {
        this.writeLock("submitAFlushTask");
        try {
            boolean shouldSubmit;
            if (memTable.getFlushStatus() != FlushStatus.WORKING) {
                boolean bl = false;
                return bl;
            }
            TsFileProcessor tsFileProcessor = sequence ? this.workSequenceTsFileProcessors.get(timeRangeId) : this.workUnsequenceTsFileProcessors.get(timeRangeId);
            boolean bl = shouldSubmit = tsFileProcessor != null && tsFileProcessor.getWorkMemTable() == memTable;
            if (shouldSubmit) {
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
            boolean bl2 = shouldSubmit;
            return bl2;
        }
        finally {
            this.writeUnlock();
        }
    }

    public void submitAFlushTaskWhenShouldFlush(TsFileProcessor tsFileProcessor) {
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor) || this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor) || tsFileProcessor.alreadyMarkedClosing()) {
            return;
        }
        this.writeLock("submitAFlushTaskWhenShouldFlush");
        try {
            if (tsFileProcessor.shouldFlush()) {
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private TsFileProcessor getOrCreateTsFileProcessor(long timeRangeId, boolean sequence) {
        TsFileProcessor tsFileProcessor = null;
        int retryCnt = 0;
        do {
            try {
                if (IoTDBDescriptor.getInstance().getConfig().isQuotaEnable() && !DataNodeSpaceQuotaManager.getInstance().checkRegionDisk(this.databaseName)) {
                    throw new ExceedQuotaException("Unable to continue writing data, because the space allocated to the database " + this.databaseName + " has already used the upper limit", TSStatusCode.SPACE_QUOTA_EXCEEDED.getStatusCode());
                }
                if (sequence) {
                    tsFileProcessor = this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workSequenceTsFileProcessors, true);
                    continue;
                }
                tsFileProcessor = this.getOrCreateTsFileProcessorIntern(timeRangeId, this.workUnsequenceTsFileProcessors, false);
            }
            catch (DiskSpaceInsufficientException e) {
                logger.error("disk space is insufficient when creating TsFile processor, change system mode to read-only", (Throwable)((Object)e));
                CommonDescriptor.getInstance().getConfig().setNodeStatus(NodeStatus.ReadOnly);
                break;
            }
            catch (IOException e) {
                if (retryCnt < 3) {
                    logger.warn("meet IOException when creating TsFileProcessor, retry it again", (Throwable)e);
                    ++retryCnt;
                    continue;
                }
                logger.error("meet IOException when creating TsFileProcessor, change system mode to error", (Throwable)e);
                CommonDescriptor.getInstance().getConfig().handleUnrecoverableError();
                break;
            }
            catch (ExceedQuotaException e) {
                logger.error(e.getMessage());
                break;
            }
        } while (tsFileProcessor == null);
        return tsFileProcessor;
    }

    private TsFileProcessor getOrCreateTsFileProcessorIntern(long timeRangeId, TreeMap<Long, TsFileProcessor> tsFileProcessorTreeMap, boolean sequence) throws IOException, DiskSpaceInsufficientException {
        TsFileProcessor res = tsFileProcessorTreeMap.get(timeRangeId);
        if (null == res) {
            TimePartitionManager.getInstance().updateAfterOpeningTsFileProcessor(new DataRegionId(Integer.parseInt(this.dataRegionId)), timeRangeId);
            res = this.newTsFileProcessor(sequence, timeRangeId);
            if (this.workSequenceTsFileProcessors.get(timeRangeId) == null && this.workUnsequenceTsFileProcessors.get(timeRangeId) == null) {
                WritingMetrics.getInstance().recordActiveTimePartitionCount(1);
            }
            tsFileProcessorTreeMap.put(timeRangeId, res);
            this.tsFileManager.add(res.getTsFileResource(), sequence);
        }
        return res;
    }

    private TsFileProcessor newTsFileProcessor(boolean sequence, long timePartitionId) throws IOException, DiskSpaceInsufficientException {
        long version = this.partitionMaxFileVersions.compute(timePartitionId, (key, oldVersion) -> oldVersion == null ? 1L : oldVersion + 1L);
        String filePath = TsFileNameGenerator.generateNewTsFilePathWithMkdir(sequence, this.databaseName, this.dataRegionId, timePartitionId, System.currentTimeMillis(), version, 0, 0);
        return this.getTsFileProcessor(sequence, filePath, timePartitionId);
    }

    private TsFileProcessor getTsFileProcessor(boolean sequence, String filePath, long timePartitionId) throws IOException {
        TsFileProcessor tsFileProcessor = new TsFileProcessor(this.databaseName + "-" + this.dataRegionId, this.fsFactory.getFileWithParent(filePath), this.dataRegionInfo, this::closeUnsealedTsFileProcessorCallBack, this::flushCallback, sequence);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.dataRegionInfo);
        tsFileProcessor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.dataRegionInfo.initTsFileProcessorInfo(tsFileProcessor);
        tsFileProcessor.addCloseFileListeners(this.customCloseFileListeners);
        tsFileProcessor.addFlushListeners(this.customFlushListeners);
        tsFileProcessor.setTimeRangeId(timePartitionId);
        return tsFileProcessor;
    }

    private String getNewTsFileName(long time, long version, int mergeCnt, int unseqCompactionCnt) {
        return TsFileNameGenerator.generateNewTsFileName(time, version, mergeCnt, unseqCompactionCnt);
    }

    public Future<?> asyncCloseOneTsFileProcessor(boolean sequence, TsFileProcessor tsFileProcessor) {
        Future<?> future;
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor) || this.closingUnSequenceTsFileProcessor.contains(tsFileProcessor) || tsFileProcessor.alreadyMarkedClosing()) {
            return CompletableFuture.completedFuture(null);
        }
        if (sequence) {
            this.closingSequenceTsFileProcessor.add(tsFileProcessor);
            future = tsFileProcessor.asyncClose();
            if (future.isDone()) {
                this.closingSequenceTsFileProcessor.remove(tsFileProcessor);
            }
            this.workSequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
        } else {
            this.closingUnSequenceTsFileProcessor.add(tsFileProcessor);
            future = tsFileProcessor.asyncClose();
            if (future.isDone()) {
                this.closingUnSequenceTsFileProcessor.remove(tsFileProcessor);
            }
            this.workUnsequenceTsFileProcessors.remove(tsFileProcessor.getTimeRangeId());
        }
        TsFileResource resource = tsFileProcessor.getTsFileResource();
        logger.info("Async close tsfile: {}, file start time: {}, file end time: {}", new Object[]{resource.getTsFile().getAbsolutePath(), resource.getFileStartTime(), resource.getFileEndTime()});
        if (this.workSequenceTsFileProcessors.get(tsFileProcessor.getTimeRangeId()) == null && this.workUnsequenceTsFileProcessors.get(tsFileProcessor.getTimeRangeId()) == null) {
            WritingMetrics.getInstance().recordActiveTimePartitionCount(-1);
        }
        return future;
    }

    public void deleteFolder(String systemDir) {
        logger.info("{} will close all files for deleting data folder {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)systemDir);
        FileTimeIndexCacheRecorder.getInstance().removeFileTimeIndexCache(Integer.parseInt(this.dataRegionId));
        this.writeLock("deleteFolder");
        try {
            File dataRegionSystemFolder = SystemFileFactory.INSTANCE.getFile(systemDir + File.separator + this.databaseName, this.dataRegionId);
            org.apache.iotdb.commons.utils.FileUtils.deleteDirectoryAndEmptyParent((File)dataRegionSystemFolder);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void closeAllResources() {
        for (TsFileResource tsFileResource : this.tsFileManager.getTsFileList(false)) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
        for (TsFileResource tsFileResource : this.tsFileManager.getTsFileList(true)) {
            try {
                tsFileResource.close();
            }
            catch (IOException e) {
                logger.error("Cannot close a TsFileResource {}", (Object)tsFileResource, (Object)e);
            }
        }
    }

    public void syncDeleteDataFiles() throws TsFileProcessorException {
        logger.info("{} will close all files for deleting data files", (Object)(this.databaseName + "-" + this.dataRegionId));
        this.writeLock("syncDeleteDataFiles");
        try {
            this.forceCloseAllWorkingTsFileProcessors();
            this.waitClosingTsFileProcessorFinished();
            this.closeAllResources();
            List<TsFileResource> tsFileResourceList = this.tsFileManager.getTsFileList(true);
            tsFileResourceList.addAll(this.tsFileManager.getTsFileList(false));
            tsFileResourceList.forEach(x -> {
                FileMetrics.getInstance().deleteTsFile(x.isSeq(), Collections.singletonList(x));
                try {
                    x.removeModFile();
                }
                catch (IOException e) {
                    logger.warn("Cannot remove mod file {}", x, (Object)e);
                }
            });
            this.deleteAllSGFolders(TierManager.getInstance().getAllFilesFolders());
            this.workSequenceTsFileProcessors.clear();
            this.workUnsequenceTsFileProcessors.clear();
            this.tsFileManager.clear();
            this.lastFlushTimeMap.clearFlushedTime();
            this.lastFlushTimeMap.clearGlobalFlushedTime();
            TimePartitionManager.getInstance().removeTimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)));
        }
        catch (InterruptedException e) {
            logger.error("CloseFileNodeCondition error occurs while waiting for closing the storage group {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void deleteAllSGFolders(List<String> folder) {
        for (String tsfilePath : folder) {
            File dataRegionDataFolder = this.fsFactory.getFile(tsfilePath, this.databaseName + File.separator + this.dataRegionId);
            if (FSUtils.getFSType((File)dataRegionDataFolder) != FSType.LOCAL) {
                try {
                    this.fsFactory.deleteDirectory(dataRegionDataFolder.getPath());
                }
                catch (IOException e) {
                    logger.error("Fail to delete data region folder {}", (Object)dataRegionDataFolder);
                }
                continue;
            }
            if (!dataRegionDataFolder.exists()) continue;
            org.apache.iotdb.commons.utils.FileUtils.deleteDirectoryAndEmptyParent((File)dataRegionDataFolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedFlushSeqMemTable() {
        int count = 0;
        this.writeLock("timedFlushSeqMemTable");
        try {
            ArrayList<TsFileProcessor> tsFileProcessors = new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values());
            long timeLowerBound = System.currentTimeMillis() - config.getSeqMemtableFlushInterval();
            for (TsFileProcessor tsFileProcessor : tsFileProcessors) {
                if (tsFileProcessor.getWorkMemTableUpdateTime() >= timeLowerBound) continue;
                logger.info("Exceed sequence memtable flush interval, so flush working memtable of time partition {} in database {}[{}]", new Object[]{tsFileProcessor.getTimeRangeId(), this.databaseName, this.dataRegionId});
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
                ++count;
            }
        }
        finally {
            this.writeUnlock();
        }
        WritingMetrics.getInstance().recordTimedFlushMemTableCount(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedFlushUnseqMemTable() {
        int count = 0;
        this.writeLock("timedFlushUnseqMemTable");
        try {
            ArrayList<TsFileProcessor> tsFileProcessors = new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values());
            long timeLowerBound = System.currentTimeMillis() - config.getUnseqMemtableFlushInterval();
            for (TsFileProcessor tsFileProcessor : tsFileProcessors) {
                if (tsFileProcessor.getWorkMemTableUpdateTime() >= timeLowerBound) continue;
                logger.info("Exceed unsequence memtable flush interval, so flush working memtable of time partition {} in database {}[{}]", new Object[]{tsFileProcessor.getTimeRangeId(), this.databaseName, this.dataRegionId});
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
                ++count;
            }
        }
        finally {
            this.writeUnlock();
        }
        WritingMetrics.getInstance().recordTimedFlushMemTableCount(count);
    }

    public void syncCloseAllWorkingTsFileProcessors() {
        try {
            List<Future<?>> tsFileProcessorsClosingFutures = this.asyncCloseAllWorkingTsFileProcessors();
            for (Future<?> f : tsFileProcessorsClosingFutures) {
                if (f == null) continue;
                f.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("CloseFileNodeCondition error occurs while waiting for closing tsfile processors of {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCloseWorkingTsFileProcessors(boolean sequence) {
        try {
            this.writeLock("syncCloseWorkingTsFileProcessors");
            ArrayList tsFileProcessorsClosingFutures = new ArrayList();
            int count = 0;
            try {
                for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(sequence ? this.workSequenceTsFileProcessors.values() : this.workUnsequenceTsFileProcessors.values())) {
                    tsFileProcessorsClosingFutures.add(this.asyncCloseOneTsFileProcessor(sequence, tsFileProcessor));
                    ++count;
                }
            }
            finally {
                this.writeUnlock();
            }
            WritingMetrics.getInstance().recordManualFlushMemTableCount(count);
            for (Future future : tsFileProcessorsClosingFutures) {
                if (future == null) continue;
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("CloseFileNodeCondition error occurs while waiting for closing tsfile processors of {}", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitClosingTsFileProcessorFinished() throws InterruptedException {
        long startTime = System.currentTimeMillis();
        while (!this.closingSequenceTsFileProcessor.isEmpty() || !this.closingUnSequenceTsFileProcessor.isEmpty()) {
            Object object = this.closeStorageGroupCondition;
            synchronized (object) {
                if (!this.closingSequenceTsFileProcessor.isEmpty() || !this.closingUnSequenceTsFileProcessor.isEmpty()) {
                    this.closeStorageGroupCondition.wait(60000L);
                }
            }
            if (System.currentTimeMillis() - startTime <= 60000L) continue;
            logger.warn("{} has spent {}s to wait for closing all TsFiles.", (Object)(this.databaseName + "-" + this.dataRegionId), (Object)((System.currentTimeMillis() - startTime) / 1000L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Future<?>> asyncCloseAllWorkingTsFileProcessors() {
        this.writeLock("asyncCloseAllWorkingTsFileProcessors");
        ArrayList futures = new ArrayList();
        int count = 0;
        try {
            logger.info("async force close all files in database: {}", (Object)(this.databaseName + "-" + this.dataRegionId));
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values())) {
                futures.add(this.asyncCloseOneTsFileProcessor(true, tsFileProcessor));
                ++count;
            }
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values())) {
                futures.add(this.asyncCloseOneTsFileProcessor(false, tsFileProcessor));
                ++count;
            }
        }
        finally {
            this.writeUnlock();
        }
        WritingMetrics.getInstance().recordManualFlushMemTableCount(count);
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceCloseAllWorkingTsFileProcessors() throws TsFileProcessorException {
        this.writeLock("forceCloseAllWorkingTsFileProcessors");
        try {
            logger.info("force close all processors in database: {}", (Object)(this.databaseName + "-" + this.dataRegionId));
            ArrayList<TsFileResource> closedTsFileResources = new ArrayList<TsFileResource>();
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workSequenceTsFileProcessors.values())) {
                tsFileProcessor.putMemTableBackAndClose();
                closedTsFileResources.add(tsFileProcessor.getTsFileResource());
            }
            for (TsFileProcessor tsFileProcessor : new ArrayList<TsFileProcessor>(this.workUnsequenceTsFileProcessors.values())) {
                tsFileProcessor.putMemTableBackAndClose();
                closedTsFileResources.add(tsFileProcessor.getTsFileResource());
            }
            for (TsFileResource resource : closedTsFileResources) {
                FileMetrics.getInstance().addTsFile(resource.getDatabaseName(), resource.getDataRegionId(), resource.getTsFileSize(), resource.isSeq(), resource.getTsFile().getName());
            }
            WritingMetrics.getInstance().recordActiveTimePartitionCount(-1);
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public QueryDataSource query(List<IFullPath> pathList, IDeviceID singleDeviceId, QueryContext context, Filter globalTimeFilter, List<Long> timePartitions) throws QueryProcessException {
        try {
            List<TsFileResource> seqResources = this.getFileResourceListForQuery(this.tsFileManager.getTsFileList(true, timePartitions, globalTimeFilter), pathList, singleDeviceId, context, globalTimeFilter, true);
            List<TsFileResource> unseqResources = this.getFileResourceListForQuery(this.tsFileManager.getTsFileList(false, timePartitions, globalTimeFilter), pathList, singleDeviceId, context, globalTimeFilter, false);
            QUERY_RESOURCE_METRIC_SET.recordQueryResourceNum("sequence_tsfile", seqResources.size());
            QUERY_RESOURCE_METRIC_SET.recordQueryResourceNum("unsequence_tsfile", unseqResources.size());
            return new QueryDataSource(seqResources, unseqResources, this.databaseName);
        }
        catch (MetadataException e) {
            throw new QueryProcessException((IoTDBException)((Object)e));
        }
    }

    @Override
    public IQueryDataSource queryForSeriesRegionScan(List<IFullPath> pathList, QueryContext queryContext, Filter globalTimeFilter, List<Long> timePartitions) throws QueryProcessException {
        try {
            List<IFileScanHandle> seqFileScanHandles = this.getFileHandleListForQuery(this.tsFileManager.getTsFileList(true, timePartitions, globalTimeFilter), pathList, queryContext, globalTimeFilter, true);
            List<IFileScanHandle> unseqFileScanHandles = this.getFileHandleListForQuery(this.tsFileManager.getTsFileList(false, timePartitions, globalTimeFilter), pathList, queryContext, globalTimeFilter, false);
            QUERY_RESOURCE_METRIC_SET.recordQueryResourceNum("sequence_tsfile", seqFileScanHandles.size());
            QUERY_RESOURCE_METRIC_SET.recordQueryResourceNum("unsequence_tsfile", unseqFileScanHandles.size());
            return new QueryDataSourceForRegionScan(seqFileScanHandles, unseqFileScanHandles);
        }
        catch (MetadataException e) {
            throw new QueryProcessException((IoTDBException)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IFileScanHandle> getFileHandleListForQuery(Collection<TsFileResource> tsFileResources, List<IFullPath> partialPaths, QueryContext context, Filter globalTimeFilter, boolean isSeq) throws MetadataException {
        ArrayList<IFileScanHandle> fileScanHandles = new ArrayList<IFileScanHandle>();
        for (TsFileResource tsFileResource : tsFileResources) {
            if (!tsFileResource.isSatisfied(null, globalTimeFilter, isSeq, context.isDebug())) continue;
            this.closeQueryLock.readLock().lock();
            try {
                if (tsFileResource.isClosed()) {
                    fileScanHandles.add(new ClosedFileScanHandleImpl(tsFileResource, context));
                    continue;
                }
                tsFileResource.getProcessor().queryForSeriesRegionScan(partialPaths, context, fileScanHandles);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        return fileScanHandles;
    }

    @Override
    public IQueryDataSource queryForDeviceRegionScan(Map<IDeviceID, DeviceContext> devicePathToAligned, QueryContext queryContext, Filter globalTimeFilter, List<Long> timePartitions) throws QueryProcessException {
        try {
            List<IFileScanHandle> seqFileScanHandles = this.getFileHandleListForQuery(this.tsFileManager.getTsFileList(true, timePartitions, globalTimeFilter), devicePathToAligned, queryContext, globalTimeFilter, true);
            List<IFileScanHandle> unseqFileScanHandles = this.getFileHandleListForQuery(this.tsFileManager.getTsFileList(false, timePartitions, globalTimeFilter), devicePathToAligned, queryContext, globalTimeFilter, false);
            QUERY_RESOURCE_METRIC_SET.recordQueryResourceNum("sequence_tsfile", seqFileScanHandles.size());
            QUERY_RESOURCE_METRIC_SET.recordQueryResourceNum("unsequence_tsfile", unseqFileScanHandles.size());
            return new QueryDataSourceForRegionScan(seqFileScanHandles, unseqFileScanHandles);
        }
        catch (MetadataException e) {
            throw new QueryProcessException((IoTDBException)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IFileScanHandle> getFileHandleListForQuery(Collection<TsFileResource> tsFileResources, Map<IDeviceID, DeviceContext> devicePathsToContext, QueryContext context, Filter globalTimeFilter, boolean isSeq) throws MetadataException {
        ArrayList<IFileScanHandle> fileScanHandles = new ArrayList<IFileScanHandle>();
        for (TsFileResource tsFileResource : tsFileResources) {
            if (!tsFileResource.isSatisfied(null, globalTimeFilter, isSeq, context.isDebug())) continue;
            this.closeQueryLock.readLock().lock();
            try {
                if (tsFileResource.isClosed()) {
                    fileScanHandles.add(new ClosedFileScanHandleImpl(tsFileResource, context));
                    continue;
                }
                tsFileResource.getProcessor().queryForDeviceRegionScan(devicePathsToContext, context, fileScanHandles);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        return fileScanHandles;
    }

    @Override
    public void readLock() {
        this.insertLock.readLock().lock();
        this.tsFileManager.readLock();
    }

    @Override
    public void readUnlock() {
        this.tsFileManager.readUnlock();
        this.insertLock.readLock().unlock();
    }

    public void writeLock(String holder) {
        this.insertLock.writeLock().lock();
        this.insertWriteLockHolder = holder;
    }

    public void writeUnlock() {
        this.insertWriteLockHolder = "";
        this.insertLock.writeLock().unlock();
    }

    private List<TsFileResource> getFileResourceListForQuery(Collection<TsFileResource> tsFileResources, List<IFullPath> pathList, IDeviceID singleDeviceId, QueryContext context, Filter globalTimeFilter, boolean isSeq) throws MetadataException {
        if (context.isDebug()) {
            DEBUG_LOGGER.info("Path: {}, get tsfile list: {} isSeq: {} time filter: {}", new Object[]{pathList, tsFileResources, isSeq, globalTimeFilter == null ? "null" : globalTimeFilter});
        }
        ArrayList<TsFileResource> tsfileResourcesForQuery = new ArrayList<TsFileResource>();
        for (TsFileResource tsFileResource : tsFileResources) {
            if (!tsFileResource.isSatisfied(singleDeviceId, globalTimeFilter, isSeq, context.isDebug())) continue;
            this.closeQueryLock.readLock().lock();
            try {
                if (tsFileResource.isClosed()) {
                    tsfileResourcesForQuery.add(tsFileResource);
                    continue;
                }
                tsFileResource.getProcessor().query(pathList, context, tsfileResourcesForQuery);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        return tsfileResourcesForQuery;
    }

    private void getTwoKindsOfTsFiles(List<TsFileResource> sealedResource, List<TsFileResource> unsealedResource, long startTime, long endTime) {
        List<TsFileResource> tsFileResources = this.tsFileManager.getTsFileList(true, startTime, endTime);
        tsFileResources.addAll(this.tsFileManager.getTsFileList(false, startTime, endTime));
        tsFileResources.stream().filter(TsFileResource::isClosed).forEach(sealedResource::add);
        tsFileResources.stream().filter(resource -> !resource.isClosed()).forEach(unsealedResource::add);
    }

    public void deleteByDevice(MeasurementPath pattern, DeleteDataNode node) throws IOException {
        if (SettleService.getINSTANCE().getFilesToBeSettledCount().get() != 0) {
            throw new IOException("Delete failed. Please do not delete until the old files settled.");
        }
        long startTime = node.getDeleteStartTime();
        long endTime = node.getDeleteEndTime();
        long searchIndex = node.getSearchIndex();
        this.writeLock("delete");
        boolean hasReleasedLock = false;
        try {
            if (this.deleted) {
                return;
            }
            TreeDeviceSchemaCacheManager.getInstance().invalidateLastCache(pattern);
            List<WALFlushListener> walListeners = this.logDeletionInWAL(startTime, endTime, searchIndex, pattern);
            for (WALFlushListener walFlushListener : walListeners) {
                if (walFlushListener.waitForResult() != AbstractResultListener.Status.FAILURE) continue;
                logger.error("Fail to log delete to wal.", (Throwable)walFlushListener.getCause());
                throw walFlushListener.getCause();
            }
            TreeDeletionEntry deletion = new TreeDeletionEntry(pattern, startTime, endTime);
            ArrayList<TsFileResource> sealedTsFileResource = new ArrayList<TsFileResource>();
            ArrayList<TsFileResource> unsealedTsFileResource = new ArrayList<TsFileResource>();
            this.getTwoKindsOfTsFiles(sealedTsFileResource, unsealedTsFileResource, startTime, endTime);
            this.deleteDataInUnsealedFiles(unsealedTsFileResource, deletion, sealedTsFileResource);
            DeletionResource deletionResource = PipeInsertionDataNodeListener.getInstance().listenToDeleteData(this.dataRegionId, node);
            if (deletionResource != null && deletionResource.waitForResult() == DeletionResource.Status.FAILURE) {
                throw deletionResource.getCause();
            }
            this.writeUnlock();
            hasReleasedLock = true;
            this.deleteDataInSealedFiles(sealedTsFileResource, deletion);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (!hasReleasedLock) {
                this.writeUnlock();
            }
        }
    }

    public void deleteByTable(RelationalDeleteDataNode node) throws IOException {
        if (node.getDatabaseName() != null && !node.getDatabaseName().equals(this.databaseName)) {
            return;
        }
        if (SettleService.getINSTANCE().getFilesToBeSettledCount().get() != 0) {
            throw new IOException("Delete failed. Please do not delete until the old files settled.");
        }
        List<TableDeletionEntry> modEntries = node.getModEntries();
        logger.info("[Deletion] Executing table deletion {}", (Object)node);
        this.writeLock("delete");
        boolean hasReleasedLock = false;
        try {
            if (this.deleted) {
                return;
            }
            TableDeviceSchemaCache.getInstance().invalidateLastCache(this.getDatabaseName(), modEntries.get(0).getTableName());
            List<WALFlushListener> walListeners = this.logDeletionInWAL(node);
            for (WALFlushListener wALFlushListener : walListeners) {
                if (wALFlushListener.waitForResult() != AbstractResultListener.Status.FAILURE) continue;
                logger.error("Fail to log delete to wal.", (Throwable)wALFlushListener.getCause());
                throw wALFlushListener.getCause();
            }
            ArrayList<ArrayList<TsFileResource>> sealedTsFileResourceLists = new ArrayList<ArrayList<TsFileResource>>(modEntries.size());
            for (TableDeletionEntry modEntry : modEntries) {
                ArrayList<TsFileResource> sealedTsFileResource = new ArrayList<TsFileResource>();
                ArrayList<TsFileResource> unsealedTsFileResource = new ArrayList<TsFileResource>();
                this.getTwoKindsOfTsFiles(sealedTsFileResource, unsealedTsFileResource, modEntry.getStartTime(), modEntry.getEndTime());
                logger.debug("[Deletion] unsealed files for {}: {}", (Object)modEntry, unsealedTsFileResource);
                this.deleteDataInUnsealedFiles(unsealedTsFileResource, modEntry, sealedTsFileResource);
                logger.debug("[Deletion] sealed files for {}: {}", (Object)modEntry, sealedTsFileResource);
                sealedTsFileResourceLists.add(sealedTsFileResource);
            }
            DeletionResource deletionResource = PipeInsertionDataNodeListener.getInstance().listenToDeleteData(this.dataRegionId, node);
            if (deletionResource != null && deletionResource.waitForResult() == DeletionResource.Status.FAILURE) {
                throw deletionResource.getCause();
            }
            this.writeUnlock();
            hasReleasedLock = true;
            for (int i = 0; i < modEntries.size(); ++i) {
                this.deleteDataInSealedFiles((Collection)sealedTsFileResourceLists.get(i), modEntries.get(i));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (!hasReleasedLock) {
                this.writeUnlock();
            }
        }
    }

    public void deleteDataDirectly(MeasurementPath pathToDelete, DeleteDataNode node) throws IOException {
        long startTime = node.getDeleteStartTime();
        long endTime = node.getDeleteEndTime();
        long searchIndex = node.getSearchIndex();
        logger.info("{} will delete data files directly for deleting data between {} and {}", new Object[]{this.databaseName + "-" + this.dataRegionId, startTime, endTime});
        this.writeLock("deleteDataDirect");
        boolean releasedLock = false;
        try {
            if (this.deleted) {
                return;
            }
            TreeDeviceSchemaCacheManager.getInstance().invalidateDatabaseLastCache(this.getDatabaseName());
            List<WALFlushListener> walListeners = this.logDeletionInWAL(startTime, endTime, searchIndex, pathToDelete);
            for (WALFlushListener walFlushListener : walListeners) {
                if (walFlushListener.waitForResult() != AbstractResultListener.Status.FAILURE) continue;
                logger.error("Fail to log delete to wal.", (Throwable)walFlushListener.getCause());
                throw walFlushListener.getCause();
            }
            TreeDeletionEntry deletion = new TreeDeletionEntry(pathToDelete, startTime, endTime);
            ArrayList<TsFileResource> sealedTsFileResource = new ArrayList<TsFileResource>();
            ArrayList<TsFileResource> unsealedTsFileResource = new ArrayList<TsFileResource>();
            this.getTwoKindsOfTsFiles(sealedTsFileResource, unsealedTsFileResource, startTime, endTime);
            this.deleteDataDirectlyInFile(unsealedTsFileResource, deletion);
            DeletionResource deletionResource = PipeInsertionDataNodeListener.getInstance().listenToDeleteData(this.dataRegionId, node);
            if (deletionResource != null && deletionResource.waitForResult() == DeletionResource.Status.FAILURE) {
                throw deletionResource.getCause();
            }
            this.writeUnlock();
            releasedLock = true;
            this.deleteDataDirectlyInFile(sealedTsFileResource, deletion);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            if (!releasedLock) {
                this.writeUnlock();
            }
        }
    }

    private List<WALFlushListener> logDeletionInWAL(RelationalDeleteDataNode deleteDataNode) {
        if (config.getWalMode() == WALMode.DISABLE) {
            return Collections.emptyList();
        }
        ArrayList<WALFlushListener> walFlushListeners = new ArrayList<WALFlushListener>();
        HashSet<TsFileProcessor> involvedProcessors = new HashSet<TsFileProcessor>();
        for (TableDeletionEntry modEntry : deleteDataNode.getModEntries()) {
            long startTime = modEntry.getStartTime();
            long endTime = modEntry.getEndTime();
            for (Map.Entry<Long, TsFileProcessor> entry : this.workSequenceTsFileProcessors.entrySet()) {
                if (!TimePartitionUtils.satisfyPartitionId((long)startTime, (long)endTime, (long)entry.getKey())) continue;
                involvedProcessors.add(entry.getValue());
            }
            for (Map.Entry<Long, TsFileProcessor> entry : this.workUnsequenceTsFileProcessors.entrySet()) {
                if (!TimePartitionUtils.satisfyPartitionId((long)startTime, (long)endTime, (long)entry.getKey())) continue;
                involvedProcessors.add(entry.getValue());
            }
        }
        for (TsFileProcessor involvedProcessor : involvedProcessors) {
            WALFlushListener walFlushListener = involvedProcessor.logDeleteDataNodeInWAL(deleteDataNode);
            walFlushListeners.add(walFlushListener);
        }
        return walFlushListeners;
    }

    private List<WALFlushListener> logDeletionInWAL(long startTime, long endTime, long searchIndex, MeasurementPath path) {
        WALFlushListener walFlushListener;
        if (config.getWalMode() == WALMode.DISABLE) {
            return Collections.emptyList();
        }
        ArrayList<WALFlushListener> walFlushListeners = new ArrayList<WALFlushListener>();
        DeleteDataNode deleteDataNode = new DeleteDataNode(new PlanNodeId(""), Collections.singletonList(path), startTime, endTime);
        deleteDataNode.setSearchIndex(searchIndex);
        for (Map.Entry<Long, TsFileProcessor> entry : this.workSequenceTsFileProcessors.entrySet()) {
            if (!TimePartitionUtils.satisfyPartitionId((long)startTime, (long)endTime, (long)entry.getKey())) continue;
            walFlushListener = entry.getValue().logDeleteDataNodeInWAL(deleteDataNode);
            walFlushListeners.add(walFlushListener);
        }
        for (Map.Entry<Long, TsFileProcessor> entry : this.workUnsequenceTsFileProcessors.entrySet()) {
            if (!TimePartitionUtils.satisfyPartitionId((long)startTime, (long)endTime, (long)entry.getKey())) continue;
            walFlushListener = entry.getValue().logDeleteDataNodeInWAL(deleteDataNode);
            walFlushListeners.add(walFlushListener);
        }
        if (walFlushListeners.isEmpty()) {
            this.getWALNode().ifPresent(walNode -> walFlushListeners.add(walNode.log(-1L, deleteDataNode)));
        }
        return walFlushListeners;
    }

    public void insertSeparatorToWAL() {
        this.writeLock("insertSeparatorToWAL");
        try {
            if (this.deleted) {
                return;
            }
            this.getWALNode().ifPresent(walNode -> walNode.log(-1L, new ContinuousSameSearchIndexSeparatorNode()));
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean canSkipDelete(TsFileResource tsFileResource, ModEntry deletion) {
        long fileEndTime;
        long fileStartTime = tsFileResource.getTimeIndex().getMinStartTime();
        long l = fileEndTime = tsFileResource.isClosed() || !tsFileResource.isSeq() ? tsFileResource.getTimeIndex().getMaxEndTime() : Long.MAX_VALUE;
        if (!ModificationUtils.overlap(deletion.getStartTime(), deletion.getEndTime(), fileStartTime, fileEndTime)) {
            logger.debug("[Deletion] {} skipped {}, file time [{}, {}]", new Object[]{deletion, tsFileResource, fileStartTime, fileEndTime});
            return true;
        }
        ITimeIndex timeIndex = tsFileResource.getTimeIndex();
        if (timeIndex.getTimeIndexType() == 2) {
            return false;
        }
        for (IDeviceID device : tsFileResource.getDevices()) {
            long endTime;
            long startTime;
            if (!deletion.affects(device, startTime = tsFileResource.getTimeIndex().getStartTime(device), endTime = tsFileResource.isClosed() ? tsFileResource.getTimeIndex().getEndTime(device) : Long.MAX_VALUE)) continue;
            return false;
        }
        logger.debug("[Deletion] {} skipped {}, file time {}", new Object[]{deletion, tsFileResource, timeIndex});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDataInUnsealedFiles(Collection<TsFileResource> unsealedTsFiles, ModEntry deletion, Collection<TsFileResource> sealedTsFiles) {
        for (TsFileResource tsFileResource : unsealedTsFiles) {
            if (this.canSkipDelete(tsFileResource, deletion)) continue;
            if (tsFileResource.isClosed()) {
                sealedTsFiles.add(tsFileResource);
                continue;
            }
            TsFileProcessor tsFileProcessor = tsFileResource.getProcessor();
            if (tsFileProcessor == null) {
                sealedTsFiles.add(tsFileResource);
                continue;
            }
            tsFileProcessor.getFlushQueryLock().writeLock().lock();
            if (tsFileResource.isClosed()) {
                sealedTsFiles.add(tsFileResource);
                tsFileProcessor.getFlushQueryLock().writeLock().unlock();
                continue;
            }
            try {
                if (tsFileProcessor.deleteDataInMemory(deletion)) continue;
                sealedTsFiles.add(tsFileResource);
            }
            finally {
                tsFileProcessor.getFlushQueryLock().writeLock().unlock();
            }
        }
    }

    private void deleteDataInSealedFiles(Collection<TsFileResource> sealedTsFiles, ModEntry deletion) throws IOException {
        HashSet<ModificationFile> involvedModificationFiles = new HashSet<ModificationFile>();
        for (TsFileResource sealedTsFile : sealedTsFiles) {
            if (this.canSkipDelete(sealedTsFile, deletion)) continue;
            if (sealedTsFile.isCompacting()) {
                involvedModificationFiles.add(sealedTsFile.getCompactionModFile());
            }
            involvedModificationFiles.add(sealedTsFile.getModFileForWrite());
        }
        if (involvedModificationFiles.isEmpty()) {
            logger.info("[Deletion] Deletion {} does not involve any file", (Object)deletion);
            return;
        }
        List<Exception> exceptions = involvedModificationFiles.parallelStream().map(modFile -> {
            try {
                modFile.write(deletion);
                modFile.close();
            }
            catch (Exception e) {
                return e;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw new IOException((Throwable)exceptions.get(0));
            }
            exceptions.forEach(e -> logger.error("Fail to write modEntry {} to files", (Object)deletion, e));
            throw new IOException("Multiple errors occurred while writing mod files, see logs for details.");
        }
        logger.info("[Deletion] Deletion {} is written into {} mod files", (Object)deletion, (Object)involvedModificationFiles.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDataDirectlyInFile(List<TsFileResource> tsfileResourceList, ModEntry modEntry) throws IOException {
        ArrayList<TsFileResource> deletedByMods = new ArrayList<TsFileResource>();
        ArrayList<TsFileResource> deletedByFiles = new ArrayList<TsFileResource>();
        this.separateTsFileToDelete(modEntry, tsfileResourceList, deletedByMods, deletedByFiles);
        HashSet<ModificationFile> involvedModificationFiles = new HashSet<ModificationFile>();
        for (TsFileResource tsFileResource : deletedByMods) {
            if (!tsFileResource.isClosed() && tsFileResource.getProcessor().deleteDataInMemory(modEntry)) continue;
            if (tsFileResource.isCompacting()) {
                involvedModificationFiles.add(tsFileResource.getCompactionModFile());
            }
            involvedModificationFiles.add(tsFileResource.getModFileForWrite());
        }
        for (ModificationFile involvedModificationFile : involvedModificationFiles) {
            involvedModificationFile.write(modEntry);
            involvedModificationFile.close();
            logger.debug("[Deletion] Deletion {} written into mods file:{}.", (Object)modEntry, (Object)involvedModificationFile);
        }
        for (TsFileResource tsFileResource : deletedByFiles) {
            this.tsFileManager.remove(tsFileResource, tsFileResource.isSeq());
            tsFileResource.writeLock();
            try {
                FileMetrics.getInstance().deleteTsFile(tsFileResource.isSeq(), Collections.singletonList(tsFileResource));
                tsFileResource.remove();
                logger.info("Remove tsfile {} directly when delete data", (Object)tsFileResource.getTsFilePath());
            }
            finally {
                tsFileResource.writeUnlock();
            }
        }
    }

    private void separateTsFileToDelete(ModEntry modEntry, List<TsFileResource> tsFileResourceList, List<TsFileResource> deletedByMods, List<TsFileResource> deletedByFiles) {
        long startTime = modEntry.getStartTime();
        long endTime = modEntry.getEndTime();
        for (TsFileResource file : tsFileResourceList) {
            long fileStartTime = file.getTimeIndex().getMinStartTime();
            long fileEndTime = file.getTimeIndex().getMaxEndTime();
            if (this.canSkipDelete(file, modEntry)) continue;
            if (startTime <= fileStartTime && endTime >= fileEndTime && file.isClosed() && file.setStatus(TsFileResourceStatus.DELETED)) {
                deletedByFiles.add(file);
                continue;
            }
            deletedByMods.add(file);
        }
    }

    private void flushCallback(TsFileProcessor processor, Map<IDeviceID, Long> updateMap, long systemFlushTime) {
        if (config.isEnableSeparateData() && CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            this.lastFlushTimeMap.updateLatestFlushTime(processor.getTimeRangeId(), updateMap);
        } else {
            this.lastFlushTimeMap.updateMultiDeviceFlushedTime(processor.getTimeRangeId(), updateMap);
        }
        if (config.isEnableSeparateData()) {
            TimePartitionManager.getInstance().updateAfterFlushing(new DataRegionId(Integer.parseInt(this.dataRegionId)), processor.getTimeRangeId(), systemFlushTime, this.lastFlushTimeMap.getMemSize(processor.getTimeRangeId()), this.workSequenceTsFileProcessors.get(processor.getTimeRangeId()) != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnsealedTsFileProcessorCallBack(TsFileProcessor tsFileProcessor) throws TsFileProcessorException {
        Object tsFilePath;
        boolean isEmptyFile = tsFileProcessor.isEmpty() || tsFileProcessor.getTsFileResource().isEmpty();
        boolean isValidateTsFileFailed = false;
        if (!isEmptyFile) {
            isValidateTsFileFailed = !TsFileValidator.getInstance().validateTsFile(tsFileProcessor.getTsFileResource());
        }
        this.closeQueryLock.writeLock().lock();
        try {
            tsFileProcessor.close();
            if (isEmptyFile) {
                tsFileProcessor.getTsFileResource().remove();
            } else if (isValidateTsFileFailed) {
                tsFilePath = tsFileProcessor.getTsFileResource().getTsFile().getAbsolutePath();
                this.renameAndHandleError((String)tsFilePath, (String)tsFilePath + ".broken");
                this.renameAndHandleError((String)tsFilePath + ".resource", (String)tsFilePath + ".resource" + ".broken");
            } else {
                this.tsFileResourceManager.registerSealedTsFileResource(tsFileProcessor.getTsFileResource());
            }
        }
        finally {
            this.closeQueryLock.writeLock().unlock();
        }
        if (isEmptyFile || isValidateTsFileFailed) {
            this.tsFileManager.remove(tsFileProcessor.getTsFileResource(), tsFileProcessor.isSequence());
        }
        tsFilePath = this.closeStorageGroupCondition;
        synchronized (tsFilePath) {
            if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor)) {
                this.closingSequenceTsFileProcessor.remove(tsFileProcessor);
            } else {
                this.closingUnSequenceTsFileProcessor.remove(tsFileProcessor);
            }
            this.closeStorageGroupCondition.notifyAll();
        }
        if (!isValidateTsFileFailed) {
            TsFileResource tsFileResource = tsFileProcessor.getTsFileResource();
            FileMetrics.getInstance().addTsFile(tsFileResource.getDatabaseName(), tsFileResource.getDataRegionId(), tsFileResource.getTsFileSize(), tsFileProcessor.isSequence(), tsFileResource.getTsFile().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCompaction() throws InterruptedException {
        if (!this.isCompactionSelecting.compareAndSet(false, true)) {
            return 0;
        }
        CompactionScheduleContext context = new CompactionScheduleContext();
        try {
            ArrayList<Long> timePartitions = new ArrayList<Long>(this.tsFileManager.getTimePartitions());
            timePartitions.sort(Comparator.reverseOrder());
            int[] submitCountOfTimePartitions = this.executeInsertionCompaction(timePartitions, context);
            for (int i = 0; i < timePartitions.size(); ++i) {
                boolean skipOtherCompactionSchedule;
                boolean bl = skipOtherCompactionSchedule = submitCountOfTimePartitions[i] > 0 && !config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensusV2");
                if (skipOtherCompactionSchedule) continue;
                long timePartition = (Long)timePartitions.get(i);
                CompactionScheduler.sharedLockCompactionSelection();
                try {
                    CompactionScheduler.scheduleCompaction(this.tsFileManager, timePartition, context);
                    continue;
                }
                finally {
                    context.clearTimePartitionDeviceInfoCache();
                    CompactionScheduler.sharedUnlockCompactionSelection();
                }
            }
            if (context.hasSubmitTask()) {
                CompactionMetrics.getInstance().updateCompactionTaskSelectionNum(context);
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Meet error in compaction schedule.", e);
        }
        finally {
            this.isCompactionSelecting.set(false);
        }
        return context.getSubmitCompactionTaskNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeTTLCheck() throws InterruptedException {
        while (!this.isCompactionSelecting.compareAndSet(false, true)) {
            Thread.sleep(500L);
        }
        logger.info("[TTL] {}-{} Start ttl checking.", (Object)this.databaseName, (Object)this.dataRegionId);
        int trySubmitCount = 0;
        try {
            CompactionScheduleContext context = new CompactionScheduleContext();
            ArrayList<Long> timePartitions = new ArrayList<Long>(this.tsFileManager.getTimePartitions());
            Collections.sort(timePartitions);
            Iterator iterator = timePartitions.iterator();
            while (iterator.hasNext()) {
                long timePartition = (Long)iterator.next();
                CompactionScheduler.sharedLockCompactionSelection();
                try {
                    trySubmitCount += CompactionScheduler.tryToSubmitSettleCompactionTask(this.tsFileManager, timePartition, context, true);
                }
                finally {
                    context.clearTimePartitionDeviceInfoCache();
                    CompactionScheduler.sharedUnlockCompactionSelection();
                }
            }
            if (context.hasSubmitTask()) {
                CompactionMetrics.getInstance().updateCompactionTaskSelectionNum(context);
            }
            logger.info("[TTL] {}-{} Totally select {} all-outdated files and {} partial-outdated files.", new Object[]{this.databaseName, this.dataRegionId, context.getFullyDirtyFileNum(), context.getPartiallyDirtyFileNum()});
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Meet error in ttl check.", e);
        }
        finally {
            this.isCompactionSelecting.set(false);
        }
        return trySubmitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] executeInsertionCompaction(List<Long> timePartitions, CompactionScheduleContext context) throws InterruptedException {
        int[] trySubmitCountOfTimePartitions = new int[timePartitions.size()];
        CompactionScheduler.sharedLockCompactionSelection();
        try {
            while (true) {
                int currentSubmitCount = 0;
                int i = 0;
                while (i < timePartitions.size()) {
                    long timePartition = timePartitions.get(i);
                    int selectedTaskNum = CompactionScheduler.scheduleInsertionCompaction(this.tsFileManager, timePartition, context);
                    currentSubmitCount += selectedTaskNum;
                    int n = i++;
                    trySubmitCountOfTimePartitions[n] = trySubmitCountOfTimePartitions[n] + selectedTaskNum;
                    context.clearTimePartitionDeviceInfoCache();
                }
                if (currentSubmitCount <= 0) {
                    break;
                }
                context.incrementSubmitTaskNum(CompactionTaskType.INSERTION, currentSubmitCount);
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Meet error in insertion compaction schedule.", e);
        }
        finally {
            context.clearTimePartitionDeviceInfoCache();
            CompactionScheduler.sharedUnlockCompactionSelection();
        }
        return trySubmitCountOfTimePartitions;
    }

    private void settleTsFileCallBack(TsFileResource oldTsFileResource, List<TsFileResource> newTsFileResources) throws WriteProcessException {
        oldTsFileResource.readUnlock();
        oldTsFileResource.writeLock();
        try {
            TsFileAndModSettleTool.moveNewTsFile(oldTsFileResource, newTsFileResources);
            if (!TsFileAndModSettleTool.getInstance().recoverSettleFileMap.isEmpty()) {
                TsFileAndModSettleTool.getInstance().recoverSettleFileMap.remove(oldTsFileResource.getTsFile().getAbsolutePath());
            }
            DataRegion.operateClearCache();
            if (!oldTsFileResource.getTsFile().exists()) {
                this.tsFileManager.remove(oldTsFileResource, oldTsFileResource.isSeq());
            }
            FileReaderManager.getInstance().closeFileAndRemoveReader(oldTsFileResource.getTsFilePath());
            oldTsFileResource.setSettleTsFileCallBack(null);
            SettleService.getINSTANCE().getFilesToBeSettledCount().addAndGet(-1);
        }
        catch (IOException e) {
            logger.error("Exception to move new tsfile in settling", (Throwable)e);
            throw new WriteProcessException("Meet error when settling file: " + oldTsFileResource.getTsFile().getAbsolutePath(), e);
        }
        finally {
            oldTsFileResource.writeUnlock();
        }
    }

    public static void operateClearCache() {
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        BloomFilterCache.getInstance().clear();
    }

    public static Optional<String> getNonSystemDatabaseName(String databaseName) {
        if (databaseName.startsWith("root.__system")) {
            return Optional.empty();
        }
        int lastIndex = databaseName.lastIndexOf("-");
        if (lastIndex == -1) {
            lastIndex = databaseName.length();
        }
        return Optional.of(databaseName.substring(0, lastIndex));
    }

    public Optional<String> getNonSystemDatabaseName() {
        return DataRegion.getNonSystemDatabaseName(this.databaseName);
    }

    public int compact() {
        this.writeLock("merge");
        CompactionScheduler.exclusiveLockCompactionSelection();
        try {
            int n = this.executeCompaction();
            return n;
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            int n = 0;
            return n;
        }
        finally {
            CompactionScheduler.exclusiveUnlockCompactionSelection();
            this.writeUnlock();
        }
    }

    public void loadNewTsFile(TsFileResource newTsFileResource, boolean deleteOriginFile, boolean isGeneratedByPipe) throws LoadFileException {
        File tsfileToBeInserted = newTsFileResource.getTsFile();
        long newFilePartitionId = newTsFileResource.getTimePartitionWithCheck();
        if (!TsFileValidator.getInstance().validateTsFile(newTsFileResource)) {
            throw new LoadFileException("tsfile validate failed, " + newTsFileResource.getTsFile().getName());
        }
        this.writeLock("loadNewTsFile");
        try {
            newTsFileResource.setSeq(false);
            String newFileName = this.getNewTsFileName(System.currentTimeMillis(), this.getAndSetNewVersion(newFilePartitionId, newTsFileResource), 0, 0);
            if (!newFileName.equals(tsfileToBeInserted.getName())) {
                logger.info("TsFile {} must be renamed to {} for loading into the unsequence list.", (Object)tsfileToBeInserted.getName(), (Object)newFileName);
                newTsFileResource.setFile(this.fsFactory.getFile(tsfileToBeInserted.getParentFile(), newFileName));
            }
            this.loadTsFileToUnSequence(tsfileToBeInserted, newTsFileResource, newFilePartitionId, deleteOriginFile, isGeneratedByPipe);
            FileMetrics.getInstance().addTsFile(newTsFileResource.getDatabaseName(), newTsFileResource.getDataRegionId(), newTsFileResource.getTsFile().length(), false, newTsFileResource.getTsFile().getName());
            if (config.isEnableSeparateData()) {
                DataRegionId dataRegionId = new DataRegionId(Integer.parseInt(this.dataRegionId));
                long timePartitionId = newTsFileResource.getTimePartition();
                if (!this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(timePartitionId, true)) {
                    TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(dataRegionId, timePartitionId, false, Long.MAX_VALUE, this.lastFlushTimeMap.getMemSize(timePartitionId)));
                }
                this.updateDeviceLastFlushTime(newTsFileResource);
                TimePartitionManager.getInstance().updateAfterFlushing(dataRegionId, timePartitionId, System.currentTimeMillis(), this.lastFlushTimeMap.getMemSize(timePartitionId), false);
            }
            logger.info("TsFile {} is successfully loaded in unsequence list.", (Object)newFileName);
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("Failed to append the tsfile {} to database processor {} because the disk space is insufficient.", (Object)tsfileToBeInserted.getAbsolutePath(), (Object)tsfileToBeInserted.getParentFile().getName());
            throw new LoadFileException((Exception)((Object)e));
        }
        finally {
            this.writeUnlock();
            TreeDeviceSchemaCacheManager.getInstance().cleanUp();
        }
    }

    private long getAndSetNewVersion(long timePartitionId, TsFileResource tsFileResource) {
        long version = this.partitionMaxFileVersions.compute(timePartitionId, (key, oldVersion) -> oldVersion == null ? 1L : oldVersion + 1L);
        tsFileResource.setVersion(version);
        return version;
    }

    private boolean loadTsFileToUnSequence(File tsFileToLoad, TsFileResource tsFileResource, long filePartitionId, boolean deleteOriginFile, boolean isGeneratedByPipe) throws LoadFileException, DiskSpaceInsufficientException {
        File targetFile = this.fsFactory.getFile(TierManager.getInstance().getNextFolderForTsFile(0, false), this.databaseName + File.separatorChar + this.dataRegionId + File.separatorChar + filePartitionId + File.separator + tsFileResource.getTsFile().getName());
        tsFileResource.setFile(targetFile);
        if (this.tsFileManager.contains(tsFileResource, false)) {
            logger.warn("The file {} has already been loaded in unsequence list", (Object)tsFileResource);
            return false;
        }
        logger.info("Load tsfile in unsequence list, move file from {} to {}", (Object)tsFileToLoad.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
        LoadTsFileRateLimiter.getInstance().acquire(tsFileResource.getTsFile().length());
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        try {
            if (deleteOriginFile) {
                RetryUtils.retryOnException(() -> {
                    FileUtils.moveFile((File)tsFileToLoad, (File)targetFile);
                    return null;
                });
            } else {
                RetryUtils.retryOnException(() -> {
                    Files.copy(tsFileToLoad.toPath(), targetFile.toPath(), new CopyOption[0]);
                    return null;
                });
            }
        }
        catch (IOException e) {
            logger.warn("File renaming failed when loading tsfile. Origin: {}, Target: {}", new Object[]{tsFileToLoad.getAbsolutePath(), targetFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading tsfile. Origin: %s, Target: %s, because %s", tsFileToLoad.getAbsolutePath(), targetFile.getAbsolutePath(), e.getMessage()));
        }
        File resourceFileToLoad = this.fsFactory.getFile(tsFileToLoad.getAbsolutePath() + ".resource");
        File targetResourceFile = this.fsFactory.getFile(targetFile.getAbsolutePath() + ".resource");
        try {
            if (deleteOriginFile) {
                RetryUtils.retryOnException(() -> {
                    FileUtils.moveFile((File)resourceFileToLoad, (File)targetResourceFile);
                    return null;
                });
            } else {
                RetryUtils.retryOnException(() -> {
                    Files.copy(resourceFileToLoad.toPath(), targetResourceFile.toPath(), new CopyOption[0]);
                    return null;
                });
            }
        }
        catch (IOException e) {
            logger.warn("File renaming failed when loading .resource file. Origin: {}, Target: {}", new Object[]{resourceFileToLoad.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e});
            throw new LoadFileException(String.format("File renaming failed when loading .resource file. Origin: %s, Target: %s, because %s", resourceFileToLoad.getAbsolutePath(), targetResourceFile.getAbsolutePath(), e.getMessage()));
        }
        this.loadModFile(tsFileToLoad, targetFile, deleteOriginFile, tsFileResource);
        PipeInsertionDataNodeListener.getInstance().listenToTsFile(this.dataRegionId, this.databaseName, tsFileResource, true, isGeneratedByPipe);
        this.tsFileManager.add(tsFileResource, false);
        return true;
    }

    private void loadModFile(File tsFileToLoad, File targetTsFile, boolean deleteOriginFile, TsFileResource tsFileResource) throws LoadFileException {
        File oldModFileToLoad = ModificationFileV1.getNormalMods(tsFileToLoad);
        File newModFileToLoad = ModificationFile.getExclusiveMods(tsFileToLoad);
        if (oldModFileToLoad.exists()) {
            File oldTargetModFile = ModificationFileV1.getNormalMods(targetTsFile);
            this.moveModFile(oldModFileToLoad, oldTargetModFile, deleteOriginFile);
            try {
                tsFileResource.upgradeModFile(this.upgradeModFileThreadPool);
            }
            catch (IOException e) {
                throw new LoadFileException(e);
            }
        } else if (newModFileToLoad.exists()) {
            File newTargetModFile = ModificationFile.getExclusiveMods(targetTsFile);
            this.moveModFile(newModFileToLoad, newTargetModFile, deleteOriginFile);
        }
        tsFileResource.getExclusiveModFile();
    }

    private void moveModFile(File modFileToLoad, File targetModFile, boolean deleteOriginFile) throws LoadFileException {
        if (modFileToLoad.exists()) {
            try {
                RetryUtils.retryOnException(() -> {
                    Files.deleteIfExists(targetModFile.toPath());
                    return null;
                });
            }
            catch (IOException e) {
                logger.warn("Cannot delete localModFile {}", (Object)targetModFile, (Object)e);
            }
            try {
                if (deleteOriginFile) {
                    RetryUtils.retryOnException(() -> {
                        FileUtils.moveFile((File)modFileToLoad, (File)targetModFile);
                        return null;
                    });
                } else {
                    RetryUtils.retryOnException(() -> {
                        Files.copy(modFileToLoad.toPath(), targetModFile.toPath(), new CopyOption[0]);
                        return null;
                    });
                }
            }
            catch (IOException e) {
                logger.warn("File renaming failed when loading .mod file. Origin: {}, Target: {}", new Object[]{modFileToLoad.getAbsolutePath(), targetModFile.getAbsolutePath(), e});
                throw new LoadFileException(String.format("File renaming failed when loading .mod file. Origin: %s, Target: %s, because %s", modFileToLoad.getAbsolutePath(), targetModFile.getAbsolutePath(), e.getMessage()));
            }
        }
    }

    public Collection<TsFileProcessor> getWorkSequenceTsFileProcessors() {
        return this.workSequenceTsFileProcessors.values();
    }

    public boolean removeTsFile(File fileToBeRemoved) {
        TsFileResource tsFileResourceToBeRemoved = this.unloadTsFileInside(fileToBeRemoved);
        if (tsFileResourceToBeRemoved == null) {
            return false;
        }
        tsFileResourceToBeRemoved.writeLock();
        try {
            tsFileResourceToBeRemoved.remove();
            logger.info("Remove tsfile {} successfully.", (Object)tsFileResourceToBeRemoved.getTsFile());
        }
        finally {
            tsFileResourceToBeRemoved.writeUnlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unloadTsfile(File fileToBeUnloaded, File targetDir) throws IOException {
        TsFileResource tsFileResourceToBeMoved = this.unloadTsFileInside(fileToBeUnloaded);
        if (tsFileResourceToBeMoved == null) {
            return false;
        }
        tsFileResourceToBeMoved.writeLock();
        try {
            tsFileResourceToBeMoved.moveTo(targetDir);
            logger.info("Move tsfile {} to target dir {} successfully.", (Object)tsFileResourceToBeMoved.getTsFile(), (Object)targetDir.getPath());
        }
        finally {
            tsFileResourceToBeMoved.writeUnlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TsFileResource unloadTsFileInside(File fileToBeUnloaded) {
        TsFileResource unloadedTsFileResource;
        block5: {
            this.writeLock("unloadTsFileInside");
            unloadedTsFileResource = null;
            try {
                Iterator<TsFileResource> sequenceIterator = this.tsFileManager.getIterator(true);
                while (sequenceIterator.hasNext()) {
                    TsFileResource sequenceResource = sequenceIterator.next();
                    if (!sequenceResource.getTsFile().getName().equals(fileToBeUnloaded.getName())) continue;
                    unloadedTsFileResource = sequenceResource;
                    this.tsFileManager.remove(unloadedTsFileResource, true);
                    FileMetrics.getInstance().deleteTsFile(true, Collections.singletonList(unloadedTsFileResource));
                    break;
                }
                if (unloadedTsFileResource != null) break block5;
                Iterator<TsFileResource> unsequenceIterator = this.tsFileManager.getIterator(false);
                while (unsequenceIterator.hasNext()) {
                    TsFileResource unsequenceResource = unsequenceIterator.next();
                    if (!unsequenceResource.getTsFile().getName().equals(fileToBeUnloaded.getName())) continue;
                    unloadedTsFileResource = unsequenceResource;
                    this.tsFileManager.remove(unloadedTsFileResource, false);
                    FileMetrics.getInstance().deleteTsFile(false, Collections.singletonList(unloadedTsFileResource));
                    break;
                }
            }
            finally {
                this.writeUnlock();
            }
        }
        return unloadedTsFileResource;
    }

    public Collection<TsFileProcessor> getWorkUnsequenceTsFileProcessors() {
        return this.workUnsequenceTsFileProcessors.values();
    }

    public List<TsFileResource> getSequenceFileList() {
        return this.tsFileManager.getTsFileList(true);
    }

    public List<TsFileResource> getUnSequenceFileList() {
        return this.tsFileManager.getTsFileList(false);
    }

    public String getDataRegionId() {
        return this.dataRegionId;
    }

    public String getStorageGroupPath() {
        return this.databaseName + File.separator + this.dataRegionId;
    }

    public void abortCompaction() {
        this.tsFileManager.setAllowCompaction(false);
        CompactionScheduleTaskManager.getInstance().unregisterDataRegion(this);
        List<AbstractCompactionTask> runningTasks = CompactionTaskManager.getInstance().abortCompaction(this.databaseName + "-" + this.dataRegionId);
        while (CompactionTaskManager.getInstance().isAnyTaskInListStillRunning(runningTasks)) {
            try {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            catch (InterruptedException e) {
                logger.error("Thread get interrupted when waiting compaction to finish", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        this.isCompactionSelecting.set(false);
    }

    public TsFileManager getTsFileResourceManager() {
        return this.tsFileManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRowsOfOneDeviceNode insertRowsOfOneDeviceNode) throws WriteProcessException, BatchProcessException {
        StorageEngine.blockInsertionIfReject();
        long startTime = System.nanoTime();
        this.writeLock("InsertRowsOfOneDevice");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            if (this.deleted) {
                return;
            }
            long ttl = this.getTTL(insertRowsOfOneDeviceNode);
            HashMap<TsFileProcessor, InsertRowsNode> tsFileProcessorMap = new HashMap<TsFileProcessor, InsertRowsNode>();
            for (int i = 0; i < insertRowsOfOneDeviceNode.getInsertRowNodeList().size(); ++i) {
                boolean isSequence;
                TsFileProcessor tsFileProcessor;
                InsertRowNode insertRowNode = insertRowsOfOneDeviceNode.getInsertRowNodeList().get(i);
                if (!CommonUtils.isAlive(insertRowNode.getTime(), ttl)) {
                    insertRowsOfOneDeviceNode.getResults().put(i, RpcUtils.getStatus((int)TSStatusCode.OUT_OF_TTL.getStatusCode(), (String)String.format("Insertion time [%s] is less than ttl time bound [%s]", DateTimeUtils.convertLongToDate(insertRowNode.getTime()), DateTimeUtils.convertLongToDate(CommonDateTimeUtils.currentTime() - ttl))));
                    continue;
                }
                long timePartitionId = TimePartitionUtils.getTimePartitionId((long)insertRowNode.getTime());
                if (config.isEnableSeparateData() && !this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(timePartitionId, true)) {
                    TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), timePartitionId, true, Long.MAX_VALUE, 0L));
                }
                if ((tsFileProcessor = this.getOrCreateTsFileProcessor(timePartitionId, isSequence = config.isEnableSeparateData() && insertRowNode.getTime() > this.lastFlushTimeMap.getFlushedTime(timePartitionId, insertRowNode.getDeviceID()))) == null) continue;
                int finalI = i;
                tsFileProcessorMap.compute(tsFileProcessor, (k, v) -> {
                    if (v == null) {
                        v = new InsertRowsNode(insertRowsOfOneDeviceNode.getPlanNodeId());
                        v.setSearchIndex(insertRowNode.getSearchIndex());
                        v.setAligned(insertRowNode.isAligned());
                        if (insertRowNode.isGeneratedByPipe()) {
                            v.markAsGeneratedByPipe();
                        }
                        if (insertRowNode.isGeneratedByRemoteConsensusLeader()) {
                            v.markAsGeneratedByRemoteConsensusLeader();
                        }
                    }
                    v.addOneInsertRowNode(insertRowNode, finalI);
                    v.updateProgressIndex(insertRowNode.getProgressIndex());
                    return v;
                });
            }
            ArrayList<InsertRowNode> executedInsertRowNodeList = new ArrayList<InsertRowNode>();
            long[] infoForMetrics = new long[5];
            for (Map.Entry entry : tsFileProcessorMap.entrySet()) {
                TsFileProcessor tsFileProcessor = (TsFileProcessor)entry.getKey();
                InsertRowsNode subInsertRowsNode = (InsertRowsNode)entry.getValue();
                try {
                    tsFileProcessor.insertRows(subInsertRowsNode, infoForMetrics);
                }
                catch (WriteProcessException e) {
                    insertRowsOfOneDeviceNode.getResults().put(subInsertRowsNode.getInsertRowNodeIndexList().get(0), RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                }
                executedInsertRowNodeList.addAll(subInsertRowsNode.getInsertRowNodeList());
                if (!tsFileProcessor.shouldFlush()) continue;
                this.fileFlushPolicy.apply(this, tsFileProcessor, tsFileProcessor.isSequence());
            }
            this.updateTsFileProcessorMetric(insertRowsOfOneDeviceNode, infoForMetrics);
            if (CommonDescriptor.getInstance().getConfig().isLastCacheEnable() && !insertRowsOfOneDeviceNode.isGeneratedByRemoteConsensusLeader()) {
                startTime = System.nanoTime();
                this.tryToUpdateInsertRowsLastCache(executedInsertRowNodeList);
                PERFORMANCE_OVERVIEW_METRICS.recordScheduleUpdateLastCacheCost(System.nanoTime() - startTime);
            }
        }
        finally {
            this.writeUnlock();
        }
        if (!insertRowsOfOneDeviceNode.getResults().isEmpty()) {
            throw new BatchProcessException("Partial failed inserting rows of one device");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(InsertRowsNode insertRowsNode) throws BatchProcessException, WriteProcessRejectException {
        StorageEngine.blockInsertionIfReject();
        long startTime = System.nanoTime();
        this.writeLock("InsertRows");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            if (this.deleted) {
                return;
            }
            boolean[] areSequence = new boolean[insertRowsNode.getInsertRowNodeList().size()];
            long[] timePartitionIds = new long[insertRowsNode.getInsertRowNodeList().size()];
            for (int i = 0; i < insertRowsNode.getInsertRowNodeList().size(); ++i) {
                InsertRowNode insertRowNode = insertRowsNode.getInsertRowNodeList().get(i);
                long ttl = this.getTTL(insertRowNode);
                if (!CommonUtils.isAlive(insertRowNode.getTime(), ttl)) {
                    insertRowsNode.getResults().put(i, RpcUtils.getStatus((int)TSStatusCode.OUT_OF_TTL.getStatusCode(), (String)String.format("Insertion time [%s] is less than ttl time bound [%s]", DateTimeUtils.convertLongToDate(insertRowNode.getTime()), DateTimeUtils.convertLongToDate(CommonDateTimeUtils.currentTime() - ttl))));
                    insertRowNode.setFailedMeasurementNumber(insertRowNode.getMeasurements().length);
                    continue;
                }
                timePartitionIds[i] = TimePartitionUtils.getTimePartitionId((long)insertRowNode.getTime());
                if (config.isEnableSeparateData() && !this.lastFlushTimeMap.checkAndCreateFlushedTimePartition(timePartitionIds[i], true)) {
                    TimePartitionManager.getInstance().registerTimePartitionInfo(new TimePartitionInfo(new DataRegionId(Integer.parseInt(this.dataRegionId)), timePartitionIds[i], true, Long.MAX_VALUE, 0L));
                }
                areSequence[i] = config.isEnableSeparateData() && insertRowNode.getTime() > this.lastFlushTimeMap.getFlushedTime(timePartitionIds[i], insertRowNode.getDeviceID());
            }
            long[] infoForMetrics = new long[5];
            List<InsertRowNode> executedInsertRowNodeList = this.insertToTsFileProcessors(insertRowsNode, areSequence, timePartitionIds, infoForMetrics);
            this.updateTsFileProcessorMetric(insertRowsNode, infoForMetrics);
            if (CommonDescriptor.getInstance().getConfig().isLastCacheEnable() && !insertRowsNode.isGeneratedByRemoteConsensusLeader()) {
                startTime = System.nanoTime();
                this.tryToUpdateInsertRowsLastCache(executedInsertRowNodeList);
                PERFORMANCE_OVERVIEW_METRICS.recordScheduleUpdateLastCacheCost(System.nanoTime() - startTime);
            }
            if (!insertRowsNode.getResults().isEmpty()) {
                throw new BatchProcessException("Partial failed inserting rows");
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTablets(InsertMultiTabletsNode insertMultiTabletsNode) throws BatchProcessException, WriteProcessRejectException {
        StorageEngine.blockInsertionIfReject();
        long startTime = System.nanoTime();
        this.writeLock("insertTablets");
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleLockCost(System.nanoTime() - startTime);
        try {
            if (this.deleted) {
                logger.info("Won't insert tablets {}, because region is deleted", (Object)insertMultiTabletsNode.getSearchIndex());
                return;
            }
            long[] infoForMetrics = new long[5];
            for (int i = 0; i < insertMultiTabletsNode.getInsertTabletNodeList().size(); ++i) {
                InsertTabletNode insertTabletNode = insertMultiTabletsNode.getInsertTabletNodeList().get(i);
                Object[] results = new TSStatus[insertTabletNode.getRowCount()];
                Arrays.fill(results, RpcUtils.SUCCESS_STATUS);
                boolean noFailure = false;
                try {
                    noFailure = this.executeInsertTablet(insertTabletNode, (TSStatus[])results, infoForMetrics);
                }
                catch (WriteProcessException e) {
                    insertMultiTabletsNode.getResults().put(i, RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage()));
                }
                if (noFailure) continue;
                Object firstStatus = null;
                for (Object status : results) {
                    if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                        firstStatus = status;
                    }
                    if (status.getCode() != TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode()) continue;
                    insertMultiTabletsNode.getResults().put(i, (TSStatus)status);
                    throw new BatchProcessException("Rejected inserting multi tablets");
                }
                insertMultiTabletsNode.getResults().put(i, (TSStatus)firstStatus);
            }
            this.updateTsFileProcessorMetric(insertMultiTabletsNode, infoForMetrics);
        }
        finally {
            this.writeUnlock();
        }
        if (!insertMultiTabletsNode.getResults().isEmpty()) {
            throw new BatchProcessException("Partial failed inserting multi tablets");
        }
    }

    private void updateTsFileProcessorMetric(InsertNode insertNode, long[] infoForMetrics) {
        PERFORMANCE_OVERVIEW_METRICS.recordCreateMemtableBlockCost(infoForMetrics[0]);
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleMemoryBlockCost(infoForMetrics[1]);
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleWalCost(infoForMetrics[2]);
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleMemTableCost(infoForMetrics[3]);
        MetricService.getInstance().count(infoForMetrics[4], Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), Metric.POINTS_IN.toString(), Tag.DATABASE.toString(), this.databaseName, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
        if (!insertNode.isGeneratedByRemoteConsensusLeader()) {
            MetricService.getInstance().count(infoForMetrics[4], Metric.LEADER_QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), Metric.POINTS_IN.toString(), Tag.DATABASE.toString(), this.databaseName, Tag.REGION.toString(), this.dataRegionId, Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
        }
    }

    public long countRegionDiskSize() {
        AtomicLong diskSize = new AtomicLong(0L);
        TierManager.getInstance().getAllLocalFilesFolders().forEach(folder -> {
            folder = folder + File.separator + this.databaseName + File.separator + this.dataRegionId;
            this.countFolderDiskSize((String)folder, diskSize);
        });
        return diskSize.get() / 1024L / 1024L;
    }

    private void countFolderDiskSize(String folder, AtomicLong diskSize) {
        File file = FSFactoryProducer.getFSFactory().getFile(folder);
        File[] allFile = file.listFiles();
        if (allFile == null) {
            return;
        }
        for (File f : allFile) {
            if (f.isFile()) {
                diskSize.addAndGet(f.length());
                continue;
            }
            if (!f.isDirectory()) continue;
            this.countFolderDiskSize(f.getAbsolutePath(), diskSize);
        }
    }

    public void addSettleFilesToList(List<TsFileResource> seqResourcesToBeSettled, List<TsFileResource> unseqResourcesToBeSettled, List<String> tsFilePaths) {
        if (tsFilePaths.isEmpty()) {
            for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
                if (!resource.isClosed()) continue;
                resource.setSettleTsFileCallBack(this::settleTsFileCallBack);
                seqResourcesToBeSettled.add(resource);
            }
            for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
                if (!resource.isClosed()) continue;
                resource.setSettleTsFileCallBack(this::settleTsFileCallBack);
                unseqResourcesToBeSettled.add(resource);
            }
        } else {
            block2: for (String tsFilePath : tsFilePaths) {
                File fileToBeSettled = new File(tsFilePath);
                if ("sequence".equals(fileToBeSettled.getParentFile().getParentFile().getParentFile().getParentFile().getName())) {
                    for (TsFileResource resource : this.tsFileManager.getTsFileList(true)) {
                        if (!resource.getTsFile().getAbsolutePath().equals(tsFilePath)) continue;
                        resource.setSettleTsFileCallBack(this::settleTsFileCallBack);
                        seqResourcesToBeSettled.add(resource);
                        continue block2;
                    }
                    continue;
                }
                for (TsFileResource resource : this.tsFileManager.getTsFileList(false)) {
                    if (!resource.getTsFile().getAbsolutePath().equals(tsFilePath)) continue;
                    unseqResourcesToBeSettled.add(resource);
                    continue block2;
                }
            }
        }
    }

    public void setCustomCloseFileListeners(List<CloseFileListener> customCloseFileListeners) {
        this.customCloseFileListeners = customCloseFileListeners;
    }

    public void setCustomFlushListeners(List<FlushListener> customFlushListeners) {
        this.customFlushListeners = customFlushListeners;
    }

    public void setAllowCompaction(boolean allowCompaction) {
        this.tsFileManager.setAllowCompaction(allowCompaction);
    }

    public List<Long> getTimePartitions() {
        return new ArrayList<Long>(this.partitionMaxFileVersions.keySet());
    }

    public Long getLatestTimePartition() {
        return this.getTimePartitions().stream().max(Long::compareTo).orElse(0L);
    }

    public String getInsertWriteLockHolder() {
        return this.insertWriteLockHolder;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Optional<IWALNode> getWALNode() {
        if (!config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus")) {
            return Optional.empty();
        }
        return Optional.of(WALManager.getInstance().applyForWALNode(this.databaseName + "-" + this.dataRegionId));
    }

    public void waitForDeleted() {
        this.writeLock("waitForDeleted");
        try {
            if (!this.deleted) {
                this.deletedCondition.await();
            }
        }
        catch (InterruptedException e) {
            logger.error("Interrupted When waiting for data region deleted.");
            Thread.currentThread().interrupt();
        }
        finally {
            this.writeUnlock();
        }
    }

    public void markDeleted() {
        this.writeLock("markDeleted");
        try {
            this.deleted = true;
            this.releaseDirectBufferMemory();
            MetricService.getInstance().removeMetricSet((IMetricSet)this.metrics);
            this.deletedCondition.signalAll();
        }
        finally {
            this.writeUnlock();
        }
    }

    private void acquireDirectBufferMemory() throws DataRegionException {
        long acquireDirectBufferMemCost = DataRegion.getAcquireDirectBufferMemCost();
        if (!SystemInfo.getInstance().addDirectBufferMemoryCost(acquireDirectBufferMemCost)) {
            throw new DataRegionException("Total allocated memory for direct buffer will be " + (SystemInfo.getInstance().getDirectBufferMemoryCost() + acquireDirectBufferMemCost) + ", which is greater than limit mem cost: " + SystemInfo.getInstance().getTotalDirectBufferMemorySizeLimit());
        }
        this.directBufferMemoryCost = acquireDirectBufferMemCost;
    }

    private static long getAcquireDirectBufferMemCost() {
        long acquireDirectBufferMemCost = 0L;
        if (config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus") || config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensusV2")) {
            acquireDirectBufferMemCost = config.getWalBufferSize();
        } else if (config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            acquireDirectBufferMemCost = config.getDataRatisConsensusLogAppenderBufferSizeMax();
        }
        return acquireDirectBufferMemCost;
    }

    private void releaseDirectBufferMemory() {
        SystemInfo.getInstance().decreaseDirectBufferMemoryCost(this.directBufferMemoryCost);
        this.directBufferMemoryCost = 0L;
    }

    public void degradeFlushTimeMap(long timePartitionId) {
        this.lastFlushTimeMap.degradeLastFlushTime(timePartitionId);
    }

    public long getMemCost() {
        return this.dataRegionInfo.getMemCost();
    }

    private void renameAndHandleError(String originFileName, String newFileName) {
        try {
            File originFile = new File(originFileName);
            if (originFile.exists()) {
                Files.move(originFile.toPath(), Paths.get(newFileName, new String[0]), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            logger.error("Failed to rename {} to {},", new Object[]{originFileName, newFileName, e});
        }
    }

    public void compactFileTimeIndexCache() {
        this.tsFileManager.compactFileTimeIndexCache();
    }

    @TestOnly
    public ILastFlushTimeMap getLastFlushTimeMap() {
        return this.lastFlushTimeMap;
    }

    public TsFileManager getTsFileManager() {
        return this.tsFileManager;
    }

    private long getTTL(InsertNode insertNode) {
        if (insertNode.getTableName() == null) {
            return DataNodeTTLCache.getInstance().getTTLForTree(insertNode.getTargetPath().getNodes());
        }
        return DataNodeTTLCache.getInstance().getTTLForTable(this.databaseName, insertNode.getTableName());
    }

    private class DataRegionRecoveryContext {
        private final long numOfFilesToRecover;
        private long recoveredFilesNum;
        private long lastLogTime;
        private final List<UnsealedTsFileRecoverPerformer> recoverPerformers = new ArrayList<UnsealedTsFileRecoverPerformer>();

        public DataRegionRecoveryContext(long numOfFilesToRecover) {
            this.numOfFilesToRecover = numOfFilesToRecover;
            this.recoveredFilesNum = 0L;
            this.lastLogTime = System.currentTimeMillis();
        }

        public void incrementRecoveredFilesNum() {
            ++this.recoveredFilesNum;
            if (this.recoveredFilesNum < this.numOfFilesToRecover) {
                if (System.currentTimeMillis() - this.lastLogTime > config.getRecoveryLogIntervalInMs()) {
                    logger.info("The TsFiles of data region {}[{}] has recovered {}/{}.", new Object[]{DataRegion.this.databaseName, DataRegion.this.dataRegionId, this.recoveredFilesNum, this.numOfFilesToRecover});
                    this.lastLogTime = System.currentTimeMillis();
                }
            } else {
                logger.info("The TsFiles of data region {}[{}] has recovered completely {}/{}.", new Object[]{DataRegion.this.databaseName, DataRegion.this.dataRegionId, this.numOfFilesToRecover, this.numOfFilesToRecover});
            }
        }
    }

    @FunctionalInterface
    public static interface UpdateEndTimeCallBack {
        public void call(TsFileProcessor var1, Map<IDeviceID, Long> var2, long var3);
    }

    @FunctionalInterface
    public static interface SettleTsFileCallBack {
        public void call(TsFileResource var1, List<TsFileResource> var2) throws WriteProcessException;
    }
}

