/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.subscription;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;

public class CreateTopicStatement
extends Statement
implements IConfigStatement {
    private String topicName;
    private boolean ifNotExistsCondition;
    private Map<String, String> topicAttributes;

    public CreateTopicStatement() {
        this.statementType = StatementType.CREATE_TOPIC;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public boolean hasIfNotExistsCondition() {
        return this.ifNotExistsCondition;
    }

    public Map<String, String> getTopicAttributes() {
        return this.topicAttributes;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public void setIfNotExists(boolean ifNotExistsCondition) {
        this.ifNotExistsCondition = ifNotExistsCondition;
    }

    public void setTopicAttributes(Map<String, String> topicAttributes) {
        this.topicAttributes = topicAttributes;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.USE_PIPE.ordinal()), PrivilegeType.USE_PIPE);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTopic(this, context);
    }
}

