/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.rpc.TSStatusCode;

public class AlterTimeSeriesStatement
extends Statement {
    private MeasurementPath path;
    private AlterType alterType;
    private Map<String, String> alterMap;
    private String alias;
    private Map<String, String> tagsMap;
    private Map<String, String> attributesMap;
    private final boolean isAlterView;

    public AlterTimeSeriesStatement() {
        this.isAlterView = false;
        this.statementType = StatementType.ALTER_TIME_SERIES;
    }

    public AlterTimeSeriesStatement(boolean isAlterView) {
        this.isAlterView = isAlterView;
        this.statementType = isAlterView ? StatementType.ALTER_LOGICAL_VIEW : StatementType.ALTER_TIME_SERIES;
    }

    public List<PartialPath> getPaths() {
        return Collections.singletonList(this.path);
    }

    public MeasurementPath getPath() {
        return this.path;
    }

    public void setPath(MeasurementPath path) {
        this.path = path;
    }

    public AlterType getAlterType() {
        return this.alterType;
    }

    public void setAlterType(AlterType alterType) {
        this.alterType = alterType;
    }

    public Map<String, String> getAlterMap() {
        return this.alterMap;
    }

    public void setAlterMap(Map<String, String> alterMap) {
        this.alterMap = alterMap;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Map<String, String> getTagsMap() {
        return this.tagsMap;
    }

    public void setTagsMap(Map<String, String> tagsMap) {
        this.tagsMap = tagsMap;
    }

    public Map<String, String> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttributesMap(Map<String, String> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public boolean isAlterView() {
        return this.isAlterView;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkFullPathPermission(userName, (PartialPath)this.path, PrivilegeType.WRITE_SCHEMA.ordinal()), PrivilegeType.WRITE_SCHEMA);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitAlterTimeSeries(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AlterTimeSeriesStatement that = (AlterTimeSeriesStatement)obj;
        return Objects.equals(this.path, that.path) && Objects.equals((Object)this.alterType, (Object)that.alterType) && Objects.equals(this.alterMap, that.alterMap) && Objects.equals(this.alias, that.alias) && Objects.equals(this.tagsMap, that.tagsMap) && Objects.equals(this.attributesMap, that.attributesMap) && Objects.equals(this.isAlterView, that.isAlterView);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.path, this.alterType, this.alterMap, this.alias, this.tagsMap, this.attributesMap, this.isAlterView});
    }

    public static enum AlterType {
        RENAME,
        SET,
        DROP,
        ADD_TAGS,
        ADD_ATTRIBUTES,
        UPSERT;

    }
}

