/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AddColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AliasedRelation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AllColumns;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AlterPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ColumnDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreatePipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreatePipePlugin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateTopic;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Delete;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropFunction;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropPipePlugin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DropTopic;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Except;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Explain;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExplainAnalyze;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Fill;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Insert;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Intersect;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Join;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinCriteria;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinOn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.JoinUsing;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Limit;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NaturalJoin;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Offset;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Property;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuerySpecification;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Relation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RenameColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RenameTable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Row;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Select;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SelectItem;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SetProperties;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowClusterId;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentDatabase;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentSqlDialect;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentTimestamp;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowCurrentUser;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowFunctions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowPipePlugins;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowPipes;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowSubscriptions;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowTables;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowTopics;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowVariables;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ShowVersion;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SingleColumn;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StartPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StopPipe;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableSubquery;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Union;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Update;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.UpdateAssignment;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Values;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WithQuery;
import org.apache.iotdb.db.queryengine.plan.relational.sql.util.ExpressionFormatter;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillPolicy;

public final class SqlFormatter {
    private static final String INDENT = "   ";

    private SqlFormatter() {
    }

    public static String formatSql(Node root) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder).process(root, 0);
        return builder.toString();
    }

    private static String formatName(Identifier identifier) {
        return ExpressionFormatter.formatExpression(identifier);
    }

    public static String formatName(QualifiedName name) {
        return name.getOriginalParts().stream().map(SqlFormatter::formatName).collect(Collectors.joining("."));
    }

    private static String formatExpression(Expression expression) {
        return ExpressionFormatter.formatExpression(expression);
    }

    private static class Formatter
    extends AstVisitor<Void, Integer> {
        private final SqlBuilder builder;

        public Formatter(StringBuilder builder) {
            this.builder = new SqlBuilder(builder);
        }

        @Override
        protected Void visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        protected Void visitExpression(Expression node, Integer indent) {
            Preconditions.checkArgument((indent == 0 ? 1 : 0) != 0, (Object)"visitExpression should only be called at root");
            this.builder.append(SqlFormatter.formatExpression(node));
            return null;
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            node.getWith().ifPresent(with -> {
                this.append(indent, "WITH");
                if (with.isRecursive()) {
                    this.builder.append(" RECURSIVE");
                }
                this.builder.append("\n  ");
                Iterator<WithQuery> queries = with.getQueries().iterator();
                while (queries.hasNext()) {
                    WithQuery query = queries.next();
                    this.append(indent, SqlFormatter.formatName(query.getName()));
                    query.getColumnNames().ifPresent(columnNames -> this.appendAliasColumns(this.builder, (List<Identifier>)columnNames));
                    this.builder.append(" AS ");
                    this.process(new TableSubquery(query.getQuery()), indent);
                    this.builder.append('\n');
                    if (!queries.hasNext()) continue;
                    this.builder.append(", ");
                }
            });
            this.processRelation(node.getQueryBody(), indent);
            node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, indent));
            node.getOffset().ifPresent(offset -> this.process((Node)offset, indent));
            node.getLimit().ifPresent(limit -> this.process((Node)limit, indent));
            return null;
        }

        @Override
        protected Void visitQuerySpecification(QuerySpecification node, Integer indent) {
            this.process(node.getSelect(), indent);
            node.getFrom().ifPresent(from -> {
                this.append(indent, "FROM");
                this.builder.append('\n');
                this.append(indent, "  ");
                this.process((Node)from, indent);
            });
            this.builder.append('\n');
            node.getWhere().ifPresent(where -> this.append(indent, "WHERE " + SqlFormatter.formatExpression(where)).append('\n'));
            node.getGroupBy().ifPresent(groupBy -> this.append(indent, "GROUP BY " + (groupBy.isDistinct() ? " DISTINCT " : "") + ExpressionFormatter.formatGroupBy(groupBy.getGroupingElements())).append('\n'));
            node.getHaving().ifPresent(having -> this.append(indent, "HAVING " + SqlFormatter.formatExpression(having)).append('\n'));
            node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, indent));
            node.getOffset().ifPresent(offset -> this.process((Node)offset, indent));
            node.getLimit().ifPresent(limit -> this.process((Node)limit, indent));
            return null;
        }

        @Override
        protected Void visitFill(Fill node, Integer indent) {
            this.append(indent, "FILL METHOD ").append(node.getFillMethod().name());
            if (node.getFillMethod() == FillPolicy.CONSTANT) {
                this.builder.append(SqlFormatter.formatExpression(node.getFillValue().get()));
            } else if (node.getFillMethod() == FillPolicy.LINEAR) {
                node.getTimeColumnIndex().ifPresent(index -> this.builder.append(" TIME_COLUMN ").append(String.valueOf(index)));
                node.getFillGroupingElements().ifPresent(elements -> this.builder.append(" FILL_GROUP ").append(elements.stream().map(x$0 -> SqlFormatter.formatExpression(x$0)).collect(Collectors.joining(", "))));
            } else if (node.getFillMethod() == FillPolicy.PREVIOUS) {
                node.getTimeBound().ifPresent(timeBound -> this.builder.append(" TIME_BOUND ").append(timeBound.toString()));
                node.getTimeColumnIndex().ifPresent(index -> this.builder.append(" TIME_COLUMN ").append(String.valueOf(index)));
                node.getFillGroupingElements().ifPresent(elements -> this.builder.append(" FILL_GROUP ").append(elements.stream().map(x$0 -> SqlFormatter.formatExpression(x$0)).collect(Collectors.joining(", "))));
            } else {
                throw new IllegalArgumentException("Unknown fill method: " + (Object)((Object)node.getFillMethod()));
            }
            return null;
        }

        @Override
        protected Void visitOrderBy(OrderBy node, Integer indent) {
            this.append(indent, ExpressionFormatter.formatOrderBy(node)).append('\n');
            return null;
        }

        @Override
        protected Void visitOffset(Offset node, Integer indent) {
            this.append(indent, "OFFSET ").append(SqlFormatter.formatExpression(node.getRowCount())).append(" ROWS\n");
            return null;
        }

        @Override
        protected Void visitLimit(Limit node, Integer indent) {
            this.append(indent, "LIMIT ").append(SqlFormatter.formatExpression(node.getRowCount())).append('\n');
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            if (node.isDistinct()) {
                this.builder.append(" DISTINCT");
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                    this.process(item, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                this.process((Node)Iterables.getOnlyElement(node.getSelectItems()), indent);
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(SqlFormatter.formatExpression(node.getExpression()));
            node.getAlias().ifPresent(alias -> this.builder.append(' ').append(SqlFormatter.formatName(alias)));
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer indent) {
            node.getTarget().ifPresent(value -> this.builder.append(SqlFormatter.formatExpression(value)).append("."));
            this.builder.append("*");
            if (!node.getAliases().isEmpty()) {
                this.builder.append(" AS (").append(Joiner.on((String)", ").join((Iterable)node.getAliases().stream().map(x$0 -> SqlFormatter.formatName(x$0)).collect(ImmutableList.toImmutableList()))).append(")");
            }
            return null;
        }

        @Override
        protected Void visitTable(Table node, Integer indent) {
            this.builder.append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitJoin(Join node, Integer indent) {
            JoinCriteria criteria = node.getCriteria().orElse(null);
            String type = node.getType().toString();
            if (criteria instanceof NaturalJoin) {
                type = "NATURAL " + type;
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append('(');
            }
            this.process(node.getLeft(), indent);
            this.builder.append('\n');
            if (node.getType() == Join.Type.IMPLICIT) {
                this.append(indent, ", ");
            } else {
                this.append(indent, type).append(" JOIN ");
            }
            this.process(node.getRight(), indent);
            if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                if (criteria instanceof JoinUsing) {
                    JoinUsing using = (JoinUsing)criteria;
                    this.builder.append(" USING (").append(Joiner.on((String)", ").join(using.getColumns())).append(")");
                } else if (criteria instanceof JoinOn) {
                    JoinOn on = (JoinOn)criteria;
                    this.builder.append(" ON ").append(SqlFormatter.formatExpression(on.getExpression()));
                } else if (!(criteria instanceof NaturalJoin)) {
                    throw new UnsupportedOperationException("unknown join criteria: " + criteria);
                }
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append(")");
            }
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            this.builder.append("( ");
            this.process(node, indent + 1);
            this.append(indent, ")");
            this.builder.append(' ').append(SqlFormatter.formatName(node.getAlias()));
            this.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }

        @Override
        protected Void visitValues(Values node, Integer indent) {
            this.builder.append(" VALUES ");
            boolean first = true;
            for (Expression row : node.getRows()) {
                this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                this.builder.append(SqlFormatter.formatExpression(row));
                first = false;
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitTableSubquery(TableSubquery node, Integer indent) {
            this.builder.append('(').append('\n');
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ") ");
            return null;
        }

        @Override
        protected Void visitUnion(Union node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("UNION ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        @Override
        protected Void visitExcept(Except node, Integer indent) {
            this.processRelation(node.getLeft(), indent);
            this.builder.append("EXCEPT ");
            if (!node.isDistinct()) {
                this.builder.append("ALL ");
            }
            this.processRelation(node.getRight(), indent);
            return null;
        }

        @Override
        protected Void visitIntersect(Intersect node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("INTERSECT ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.builder.append("EXPLAIN ");
            this.builder.append("\n");
            this.process(node.getStatement(), indent);
            return null;
        }

        @Override
        protected Void visitExplainAnalyze(ExplainAnalyze node, Integer indent) {
            this.builder.append("EXPLAIN ANALYZE");
            if (node.isVerbose()) {
                this.builder.append(" VERBOSE");
            }
            this.builder.append("\n");
            this.process(node.getStatement(), indent);
            return null;
        }

        @Override
        protected Void visitShowDB(ShowDB node, Integer indent) {
            this.builder.append("SHOW DATABASE");
            return null;
        }

        @Override
        protected Void visitShowTables(ShowTables node, Integer indent) {
            this.builder.append("SHOW TABLES");
            if (node.isDetails()) {
                this.builder.append(" DETAILS");
            }
            node.getDbName().ifPresent(db -> this.builder.append(" FROM ").append(SqlFormatter.formatName(db)));
            return null;
        }

        @Override
        protected Void visitShowFunctions(ShowFunctions node, Integer indent) {
            this.builder.append("SHOW FUNCTIONS");
            return null;
        }

        @Override
        protected Void visitShowCurrentSqlDialect(ShowCurrentSqlDialect node, Integer context) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitShowCurrentDatabase(ShowCurrentDatabase node, Integer context) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitShowCurrentUser(ShowCurrentUser node, Integer context) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitShowVersion(ShowVersion node, Integer context) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitShowVariables(ShowVariables node, Integer context) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitShowClusterId(ShowClusterId node, Integer context) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitShowCurrentTimestamp(ShowCurrentTimestamp node, Integer context) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        protected Void visitDelete(Delete node, Integer indent) {
            this.builder.append("DELETE FROM ").append(SqlFormatter.formatName(node.getTable().getName()));
            node.getWhere().ifPresent(where -> this.builder.append(" WHERE ").append(SqlFormatter.formatExpression(where)));
            return null;
        }

        @Override
        protected Void visitCreateDB(CreateDB node, Integer indent) {
            this.builder.append("CREATE DATABASE ");
            if (node.exists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(node.getDbName()).append(" ");
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        @Override
        protected Void visitAlterDB(AlterDB node, Integer indent) {
            this.builder.append("ALTER DATABASE ");
            if (node.exists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getDbName()).append(" ");
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        @Override
        protected Void visitDropDB(DropDB node, Integer indent) {
            this.builder.append("DROP DATABASE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getDbName()));
            return null;
        }

        @Override
        protected Void visitCreateTable(CreateTable node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isIfNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            String tableName = SqlFormatter.formatName(node.getName());
            this.builder.append(tableName).append(" (\n");
            String elementIndent = Formatter.indentString(indent + 1);
            String columnList = node.getElements().stream().map(element -> {
                if (element != null) {
                    return elementIndent + this.formatColumnDefinition((ColumnDefinition)element);
                }
                throw new UnsupportedOperationException("unknown table element: " + element);
            }).collect(Collectors.joining(",\n"));
            this.builder.append(columnList);
            this.builder.append("\n").append(")");
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        private String formatPropertiesMultiLine(List<Property> properties) {
            if (properties.isEmpty()) {
                return "";
            }
            String propertyList = properties.stream().map(element -> SqlFormatter.INDENT + SqlFormatter.formatName(element.getName()) + " = " + (element.isSetToDefault() ? "DEFAULT" : SqlFormatter.formatExpression(element.getNonDefaultValue()))).collect(Collectors.joining(",\n"));
            return "\nWITH (\n" + propertyList + "\n)";
        }

        private String formatPropertiesSingleLine(List<Property> properties) {
            if (properties.isEmpty()) {
                return "";
            }
            return " WITH ( " + this.joinProperties(properties) + " )";
        }

        private String formatColumnDefinition(ColumnDefinition column) {
            StringBuilder stringBuilder = new StringBuilder().append(SqlFormatter.formatName(column.getName())).append(" ").append(column.getType()).append(" ").append(column.getColumnCategory());
            column.getCharsetName().ifPresent(charset -> stringBuilder.append(" CHARSET ").append((String)charset));
            return stringBuilder.toString();
        }

        @Override
        protected Void visitDropTable(DropTable node, Integer indent) {
            this.builder.append("DROP TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTableName()));
            return null;
        }

        @Override
        protected Void visitRenameTable(RenameTable node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.tableIfExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getSource())).append(" RENAME TO ").append(SqlFormatter.formatName(node.getTarget()));
            return null;
        }

        @Override
        protected Void visitSetProperties(SetProperties node, Integer context) {
            SetProperties.Type type = node.getType();
            this.builder.append("ALTER ");
            switch (type) {
                case TABLE: {
                    this.builder.append("TABLE ");
                }
                case MATERIALIZED_VIEW: {
                    this.builder.append("MATERIALIZED VIEW ");
                }
            }
            if (node.ifExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName())).append(" SET PROPERTIES ").append(this.joinProperties(node.getProperties()));
            return null;
        }

        private String joinProperties(List<Property> properties) {
            return properties.stream().map(element -> SqlFormatter.formatName(element.getName()) + " = " + (element.isSetToDefault() ? "DEFAULT" : SqlFormatter.formatExpression(element.getNonDefaultValue()))).collect(Collectors.joining(", "));
        }

        @Override
        protected Void visitRenameColumn(RenameColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.tableIfExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTable())).append(" RENAME COLUMN ");
            if (node.columnIfExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getSource())).append(" TO ").append(SqlFormatter.formatName(node.getTarget()));
            return null;
        }

        @Override
        protected Void visitDropColumn(DropColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.tableIfExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTable())).append(" DROP COLUMN ");
            if (node.columnIfExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getField()));
            return null;
        }

        @Override
        protected Void visitAddColumn(AddColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.tableIfExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTableName())).append(" ADD COLUMN ");
            if (node.columnIfNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(this.formatColumnDefinition(node.getColumn()));
            return null;
        }

        @Override
        protected Void visitInsert(Insert node, Integer indent) {
            this.builder.append("INSERT INTO ").append(SqlFormatter.formatName(node.getTarget()));
            node.getColumns().ifPresent(columns -> this.builder.append(" (").append(Joiner.on((String)", ").join((Iterable)columns)).append(")"));
            this.builder.append("\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitUpdate(Update node, Integer indent) {
            this.builder.append("UPDATE ").append(SqlFormatter.formatName(node.getTable().getName())).append(" SET");
            int setCounter = node.getAssignments().size() - 1;
            for (UpdateAssignment assignment : node.getAssignments()) {
                this.builder.append("\n").append(Formatter.indentString(indent + 1)).append(((Identifier)assignment.getName()).getValue()).append(" = ").append(SqlFormatter.formatExpression(assignment.getValue()));
                if (setCounter > 0) {
                    this.builder.append(",");
                }
                --setCounter;
            }
            node.getWhere().ifPresent(where -> this.builder.append("\n").append(Formatter.indentString(indent)).append("WHERE ").append(SqlFormatter.formatExpression(where)));
            return null;
        }

        @Override
        protected Void visitRow(Row node, Integer indent) {
            this.builder.append("ROW(");
            boolean firstItem = true;
            for (Expression item : node.getItems()) {
                if (!firstItem) {
                    this.builder.append(", ");
                }
                this.process(item, indent);
                firstItem = false;
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitCreateFunction(CreateFunction node, Integer indent) {
            this.builder.append("CREATE FUNCTION ").append(node.getUdfName()).append(" AS ").append(node.getClassName());
            node.getUriString().ifPresent(uri -> this.builder.append(" USING URI ").append((CharSequence)uri));
            return null;
        }

        @Override
        protected Void visitDropFunction(DropFunction node, Integer indent) {
            this.builder.append("DROP FUNCTION ");
            this.builder.append(node.getUdfName());
            return null;
        }

        @Override
        protected Void visitLoadTsFile(LoadTsFile node, Integer indent) {
            this.builder.append("LOAD ");
            this.builder.append("\"" + node.getFilePath() + "\"");
            this.builder.append(" \n");
            if (!node.getLoadAttributes().isEmpty()) {
                this.builder.append("WITH (").append("\n").append(node.getLoadAttributes().entrySet().stream().map(entry -> Formatter.indentString(1) + "\"" + (String)entry.getKey() + "\" = \"" + (String)entry.getValue() + "\"").collect(Collectors.joining(", \n"))).append(")\n");
            }
            return null;
        }

        @Override
        protected Void visitCreatePipe(CreatePipe node, Integer context) {
            this.builder.append("CREATE PIPE ");
            if (node.hasIfNotExistsCondition()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(node.getPipeName());
            this.builder.append(" \n");
            if (!node.getExtractorAttributes().isEmpty()) {
                this.builder.append("WITH SOURCE (").append("\n").append(node.getExtractorAttributes().entrySet().stream().map(entry -> Formatter.indentString(1) + "\"" + (String)entry.getKey() + "\" = \"" + (String)entry.getValue() + "\"").collect(Collectors.joining(", \n"))).append(")\n");
            }
            if (!node.getProcessorAttributes().isEmpty()) {
                this.builder.append("WITH PROCESSOR (").append("\n").append(node.getProcessorAttributes().entrySet().stream().map(entry -> Formatter.indentString(1) + "\"" + (String)entry.getKey() + "\" = \"" + (String)entry.getValue() + "\"").collect(Collectors.joining(", \n"))).append(")\n");
            }
            if (!node.getConnectorAttributes().isEmpty()) {
                this.builder.append("WITH SINK (").append("\n").append(node.getConnectorAttributes().entrySet().stream().map(entry -> Formatter.indentString(1) + "\"" + (String)entry.getKey() + "\" = \"" + (String)entry.getValue() + "\"").collect(Collectors.joining(", \n"))).append(")");
            }
            return null;
        }

        @Override
        protected Void visitAlterPipe(AlterPipe node, Integer context) {
            this.builder.append("ALTER PIPE ");
            if (node.hasIfExistsCondition()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getPipeName());
            this.builder.append(" \n");
            this.builder.append(node.isReplaceAllExtractorAttributes() ? "REPLACE" : "MODIFY").append(" SOURCE (").append("\n").append(node.getExtractorAttributes().entrySet().stream().map(entry -> Formatter.indentString(1) + "\"" + (String)entry.getKey() + "\" = \"" + (String)entry.getValue() + "\"").collect(Collectors.joining(", \n"))).append(")\n");
            this.builder.append(node.isReplaceAllProcessorAttributes() ? "REPLACE" : "MODIFY").append(" PROCESSOR (").append("\n").append(node.getProcessorAttributes().entrySet().stream().map(entry -> Formatter.indentString(1) + "\"" + (String)entry.getKey() + "\" = \"" + (String)entry.getValue() + "\"").collect(Collectors.joining(", \n"))).append(")\n");
            this.builder.append(node.isReplaceAllConnectorAttributes() ? "REPLACE" : "MODIFY").append(" SINK (").append("\n").append(node.getConnectorAttributes().entrySet().stream().map(entry -> Formatter.indentString(1) + "\"" + (String)entry.getKey() + "\" = \"" + (String)entry.getValue() + "\"").collect(Collectors.joining(", \n"))).append(")");
            return null;
        }

        @Override
        protected Void visitDropPipe(DropPipe node, Integer context) {
            this.builder.append("DROP PIPE ");
            if (node.hasIfExistsCondition()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getPipeName());
            return null;
        }

        @Override
        protected Void visitStartPipe(StartPipe node, Integer context) {
            this.builder.append("START PIPE ").append(node.getPipeName());
            return null;
        }

        @Override
        protected Void visitStopPipe(StopPipe node, Integer context) {
            this.builder.append("STOP PIPE ").append(node.getPipeName());
            return null;
        }

        @Override
        protected Void visitShowPipes(ShowPipes node, Integer context) {
            this.builder.append("SHOW PIPES");
            return null;
        }

        @Override
        protected Void visitCreatePipePlugin(CreatePipePlugin node, Integer context) {
            this.builder.append("CREATE PIPEPLUGIN ");
            if (node.hasIfNotExistsCondition()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(node.getPluginName());
            this.builder.append("\n");
            this.builder.append("AS \"");
            this.builder.append(node.getClassName());
            this.builder.append("\"\n");
            this.builder.append("USING URI \"");
            this.builder.append(node.getUriString());
            this.builder.append("\"");
            return null;
        }

        @Override
        protected Void visitDropPipePlugin(DropPipePlugin node, Integer context) {
            this.builder.append("DROP PIPEPLUGIN ");
            if (node.hasIfExistsCondition()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getPluginName());
            return null;
        }

        @Override
        protected Void visitShowPipePlugins(ShowPipePlugins node, Integer context) {
            this.builder.append("SHOW PIPEPLUGINS");
            return null;
        }

        @Override
        protected Void visitCreateTopic(CreateTopic node, Integer context) {
            this.builder.append("CREATE TOPIC ");
            if (node.hasIfNotExistsCondition()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(node.getTopicName());
            this.builder.append(" \n");
            if (!node.getTopicAttributes().isEmpty()) {
                this.builder.append("WITH (").append("\n").append(node.getTopicAttributes().entrySet().stream().map(entry -> Formatter.indentString(1) + "\"" + (String)entry.getKey() + "\" = \"" + (String)entry.getValue() + "\"").collect(Collectors.joining(", \n"))).append(")\n");
            }
            return null;
        }

        @Override
        protected Void visitDropTopic(DropTopic node, Integer context) {
            this.builder.append("DROP TOPIC ");
            if (node.hasIfExistsCondition()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getTopicName());
            return null;
        }

        @Override
        protected Void visitShowTopics(ShowTopics node, Integer context) {
            if (Objects.isNull(node.getTopicName())) {
                this.builder.append("SHOW TOPICS");
            } else {
                this.builder.append("SHOW TOPIC ").append(node.getTopicName());
            }
            return null;
        }

        @Override
        protected Void visitShowSubscriptions(ShowSubscriptions node, Integer context) {
            if (Objects.isNull(node.getTopicName())) {
                this.builder.append("SHOW SUBSCRIPTIONS");
            } else {
                this.builder.append("SHOW SUBSCRIPTIONS ON ").append(node.getTopicName());
            }
            return null;
        }

        private void appendBeginLabel(Optional<Identifier> label) {
            label.ifPresent(value -> this.builder.append(SqlFormatter.formatName(value)).append(": "));
        }

        private void processRelation(Relation relation, Integer indent) {
            if (relation instanceof Table) {
                this.builder.append("TABLE ").append(SqlFormatter.formatName(((Table)relation).getName())).append('\n');
            } else {
                this.process(relation, indent);
            }
        }

        private SqlBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return Strings.repeat((String)SqlFormatter.INDENT, (int)indent);
        }

        private void formatDefinitionList(List<String> elements, int indent) {
            if (elements.size() == 1) {
                this.builder.append(" ").append((CharSequence)Iterables.getOnlyElement(elements)).append("\n");
            } else {
                this.builder.append("\n");
                for (int i = 0; i < elements.size() - 1; ++i) {
                    this.append(indent, elements.get(i)).append(",\n");
                }
                this.append(indent, elements.get(elements.size() - 1)).append("\n");
            }
        }

        private void appendAliasColumns(SqlBuilder builder, List<Identifier> columns) {
            if (columns != null && !columns.isEmpty()) {
                String formattedColumns = columns.stream().map(x$0 -> SqlFormatter.formatName(x$0)).collect(Collectors.joining(", "));
                builder.append(" (").append(formattedColumns).append(')');
            }
        }

        private static class SqlBuilder {
            private final StringBuilder builder;

            public SqlBuilder(StringBuilder builder) {
                this.builder = Objects.requireNonNull(builder, "builder is null");
            }

            @CanIgnoreReturnValue
            public SqlBuilder append(CharSequence value) {
                this.builder.append(value);
                return this;
            }

            @CanIgnoreReturnValue
            public SqlBuilder append(char c) {
                this.builder.append(c);
                return this;
            }
        }
    }
}

