/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AbstractTraverseDevice;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Table;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.UpdateAssignment;

public class Update
extends AbstractTraverseDevice {
    private List<UpdateAssignment> assignments;

    public Update(NodeLocation location, Table table, List<UpdateAssignment> assignments, Expression where) {
        super(Objects.requireNonNull(location, "location is null"), table, where);
        this.assignments = Objects.requireNonNull(assignments, "assignments is null");
    }

    public List<UpdateAssignment> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(List<UpdateAssignment> assignments) {
        this.assignments = assignments;
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.assignments);
        if (this.where != null) {
            nodes.add((Object)this.where);
        }
        return nodes.build();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUpdate(this, context);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.assignments.equals(((Update)o).assignments);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.assignments);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("assignments", this.assignments).omitNullValues() + " - " + super.toStringContent();
    }
}

