/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class TimeRange
extends Node {
    private long startTime;
    private long endTime;
    private final boolean leftCRightO;

    public TimeRange(long startTime, long endTime, boolean leftCRightO) {
        super(null);
        this.startTime = startTime;
        this.endTime = endTime;
        this.leftCRightO = leftCRightO;
    }

    public TimeRange(NodeLocation location, long startTime, long endTime, boolean leftCRightO) {
        super(location);
        this.startTime = startTime;
        this.endTime = endTime;
        this.leftCRightO = leftCRightO;
    }

    @Override
    public List<? extends Node> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeRange timeRange = (TimeRange)o;
        return this.startTime == timeRange.startTime && this.endTime == timeRange.endTime && this.leftCRightO == timeRange.leftCRightO;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.leftCRightO);
    }

    @Override
    public String toString() {
        return "TimeRange{startTime=" + this.startTime + ", endTime=" + this.endTime + ", leftCRightO=" + this.leftCRightO + '}';
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public boolean isLeftCRightO() {
        return this.leftCRightO;
    }

    public org.apache.tsfile.read.common.TimeRange toTsFileTimeRange() {
        return new org.apache.tsfile.read.common.TimeRange(this.startTime, this.endTime);
    }
}

