/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ExchangeNode
extends SingleChildProcessNode {
    private TEndPoint upstreamEndpoint;
    private FragmentInstanceId upstreamInstanceId;
    private PlanNodeId upstreamPlanNodeId;
    private List<Symbol> outputSymbols = null;
    private int indexOfUpstreamSinkHandle = 0;

    public ExchangeNode(PlanNodeId id) {
        super(id);
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.TABLE_EXCHANGE_NODE;
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableExchange(this, context);
    }

    @Override
    public PlanNode clone() {
        ExchangeNode node = new ExchangeNode(this.getPlanNodeId());
        node.setOutputSymbols(this.outputSymbols);
        node.setIndexOfUpstreamSinkHandle(this.indexOfUpstreamSinkHandle);
        return node;
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    public void setOutputSymbols(List<Symbol> outputSymbols) {
        this.outputSymbols = outputSymbols;
    }

    public void setUpstream(TEndPoint endPoint, FragmentInstanceId instanceId, PlanNodeId nodeId) {
        this.upstreamEndpoint = endPoint;
        this.upstreamInstanceId = instanceId;
        this.upstreamPlanNodeId = nodeId;
    }

    public static ExchangeNode deserialize(ByteBuffer byteBuffer) {
        TEndPoint endPoint = new TEndPoint(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer), ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
        FragmentInstanceId fragmentInstanceId = FragmentInstanceId.deserialize(byteBuffer);
        PlanNodeId upstreamPlanNodeId = PlanNodeId.deserialize(byteBuffer);
        int index = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        int outputSymbolsSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> outputSymbols = null;
        if (outputSymbolsSize > 0) {
            outputSymbols = new ArrayList<Symbol>(outputSymbolsSize);
            for (int i = 0; i < outputSymbolsSize; ++i) {
                outputSymbols.add(Symbol.deserialize(byteBuffer));
            }
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        ExchangeNode exchangeNode = new ExchangeNode(planNodeId);
        exchangeNode.setUpstream(endPoint, fragmentInstanceId, upstreamPlanNodeId);
        exchangeNode.setIndexOfUpstreamSinkHandle(index);
        exchangeNode.setOutputSymbols(outputSymbols);
        return exchangeNode;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_EXCHANGE_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.upstreamEndpoint.getIp(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.upstreamEndpoint.getPort(), (ByteBuffer)byteBuffer);
        this.upstreamInstanceId.serialize(byteBuffer);
        this.upstreamPlanNodeId.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.indexOfUpstreamSinkHandle, (ByteBuffer)byteBuffer);
        if (this.outputSymbols != null && !this.outputSymbols.isEmpty()) {
            ReadWriteIOUtils.write((int)this.outputSymbols.size(), (ByteBuffer)byteBuffer);
            for (Symbol outputSymbol : this.outputSymbols) {
                Symbol.serialize(outputSymbol, byteBuffer);
            }
        } else {
            ReadWriteIOUtils.write((int)0, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_EXCHANGE_NODE.serialize(stream);
        ReadWriteIOUtils.write((String)this.upstreamEndpoint.getIp(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.upstreamEndpoint.getPort(), (OutputStream)stream);
        this.upstreamInstanceId.serialize(stream);
        this.upstreamPlanNodeId.serialize(stream);
        ReadWriteIOUtils.write((int)this.indexOfUpstreamSinkHandle, (OutputStream)stream);
        if (this.outputSymbols != null && !this.outputSymbols.isEmpty()) {
            ReadWriteIOUtils.write((int)this.outputSymbols.size(), (OutputStream)stream);
            for (Symbol outputSymbol : this.outputSymbols) {
                Symbol.serialize(outputSymbol, stream);
            }
        } else {
            ReadWriteIOUtils.write((int)0, (OutputStream)stream);
        }
    }

    public String toString() {
        return String.format("ExchangeNode-%s: [SourceAddress:%s]", this.getPlanNodeId(), this.getSourceAddress());
    }

    public String getSourceAddress() {
        if (this.getUpstreamEndpoint() == null) {
            return "Not assigned";
        }
        return String.format("%s/%s/%s", this.getUpstreamEndpoint().getIp(), this.getUpstreamInstanceId(), this.getUpstreamPlanNodeId());
    }

    public int getIndexOfUpstreamSinkHandle() {
        return this.indexOfUpstreamSinkHandle;
    }

    public void setIndexOfUpstreamSinkHandle(int indexOfUpstreamSinkHandle) {
        this.indexOfUpstreamSinkHandle = indexOfUpstreamSinkHandle;
    }

    public TEndPoint getUpstreamEndpoint() {
        return this.upstreamEndpoint;
    }

    public FragmentInstanceId getUpstreamInstanceId() {
        return this.upstreamInstanceId;
    }

    public PlanNodeId getUpstreamPlanNodeId() {
        return this.upstreamPlanNodeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExchangeNode that = (ExchangeNode)o;
        return Objects.equals(this.upstreamEndpoint, that.upstreamEndpoint) && Objects.equals(this.upstreamInstanceId, that.upstreamInstanceId) && Objects.equals(this.upstreamPlanNodeId, that.upstreamPlanNodeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.upstreamEndpoint, this.upstreamInstanceId, this.upstreamPlanNodeId);
    }
}

